﻿Copyright (c) (2013) Fluke Corporation.                  All rights reserved.
=============================================================================
INSTRUMENT:            Sub Tek MDO/MSO/DPO Wait for OPC VISA
DATE:                  2013-08-14 15:41:05
AUTHOR:                Fluke Calibration
REVISION:              $Revision: 3810 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       1
NUMBER OF LINES:       106
=============================================================================
#
#  Procedure Author:
#        DAC, CAD
#
#  Models covered:
#        All Tektronix MDO, MSO, and DPO Series UUTs controlled via the
#        VISA FSC.
#
#  Compatibility:
#        MET/CAL version 8.0 or later
#
#  Required Equipment:
#        None
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
#
# Global Variables:
#     Input
#         @Timeout - Timeout in milliseconds (optional, default is 1 minute)
#     Output
#         @Abort   - 0 if success, 1 if error and operator decided to abort
#
#  Example Usage:
#
# 1.001  VISA         ACQ:STATE RUN
# 1.002  CALL         Sub Tek MDO/MSO/DPO Wait for OPC VISA
#
# 1.003  IF           @Abort
# 1.004  END
# 1.005  ENDIF
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  MATH         Error = 0; OPC = 0
  1.002  VISA         *OPC

  1.003  DO

  1.004  IF           ISVAR("@Timeout")
  1.005  MATH         TimeRemaining = @Timeout
  1.006  ELSE
# Default timeout to 1 minute if not specified.
  1.007  MATH         TimeRemaining = 60000
  1.008  ENDIF

# Query the Extended Status Register (ESR) until an error or OPC is set.
  1.009  DO
  1.010  VISA         [D100]*ESR?[I]
  1.011  MATH         TimeRemaining = TimeRemaining - 100
  1.012  MATH         TimedOut = (TimeRemaining <= 0)
  1.013  UNTIL        (MEM > 0) || TimedOut

  1.014  IF           TimedOut
  1.015  MATH         Error = 1
  1.016  MATH         ErrMsg = "Timeout waiting for Operation Complete (OPC)"
  1.017  ELSE

# Note, the following conditions are ignored:
#   Bit 7: Power On
#   Bit 6: User Request
#   Bit 1: Request Control

  1.018  IF           BIT(5, MEM)
  1.019  MATH         Error = 1; ErrMsg = "Command Error"
  1.020  ELSEIF       BIT(4, MEM)
  1.021  MATH         Error = 1; ErrMsg = "Execution Error"
  1.022  ELSEIF       BIT(3, MEM)
  1.023  MATH         Error = 1; ErrMsg = "Device Dependent Error"
  1.024  ELSEIF       BIT(2, MEM)
  1.025  MATH         Error = 1; ErrMsg = "Query Error"
  1.026  ELSEIF       BIT(0, MEM)
  1.027  MATH         OPC = 1
  1.028  ENDIF

  1.029  ENDIF        ; TimedOut

  1.030  UNTIL        OPC || Error

  1.031  IF           Error
# Remove a SINGLE event code from the Event Queue that is associated with
# the results of the last *ESR? read and returns the event code along with
# an explanatory message.  Additional errors from the queue will not be
# displayed.
  1.032  VISA         EVMSG?[I$]
  1.033  OPBR         -z [V ErrMsg]:
  1.033  OPBR
  1.033  OPBR         [MEM2]
  1.033  OPBR
  1.033  OPBR         Do you wish to continue?
  1.034  MATH         @Abort = NOT(MEM1)
  1.035  ELSE
  1.036  MATH         @Abort = 0
  1.037  ENDIF

  1.038  END
