﻿Copyright (c) (2013) Fluke Corporation.                  All rights reserved.
=============================================================================
INSTRUMENT:            Sub Tek MSO/DPO2000 (1 yr) DC Balance VER VISA
DATE:                  2013-08-26 12:53:30
AUTHOR:                Fluke
REVISION:              $Revision: 3815 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       3
NUMBER OF LINES:       99
=============================================================================
#
#  Procedure Author:
#        ZY, DAC, GMO
#
#  Models Covered:
#        MSO2002B, MSO2004B, MSO2012, MSO2014, MSO2024, MSO2012B,
#        MSO2014B, MSO2024B
#        DPO2002B, DPO2004B, DPO2012, DPO2014, DPO2024, DPO2012B,
#        DPO2014B, DPO2024B
#
#  Source:
#        MSO2000 and DPO2000 Series Oscilloscopes
#        Specification and Performance Verification Technical Reference
#        PN 077-0096-00
#
#        MSO2000B and DPO2000B Series Oscilloscopes
#        Specification and Performance Verification Technical Reference
#        PN 077-0735-00
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  CALL         Sub Tek MDO/MSO/DPO Select Channel VISA
  1.002  CALL         Sub Tek MDO/MSO/DPO Clear Menu VISA

  1.003  IF           @Chan == 1
  1.004  RSLT         =
  1.005  RSLT         =DC BALANCE
  1.006  ENDIF

  1.007  RSLT         =
  1.008  HEAD         DC BALANCE: {Channel [V @Chan]}
  1.009  HEAD         -2 DC Coupling
  1.010  TARGET       -p

  1.011  IF           @Chan == 1

  1.012  IF           @NumChan == 2
  1.013  DISP         Attach a 50 ohm terminator to UUT CH1 and CH2.
  1.013  DISP
  1.013  DISP         Leave all terminations in place until instructed to
  1.013  DISP         remove them.
  1.014  ELSE
  1.015  DISP         Attach a 50 ohm terminator to UUT CH1, CH2, CH3, and CH4
  1.015  DISP
  1.015  DISP         Leave all terminations in place until instructed to
  1.015  DISP         remove them.
  1.016  ENDIF

  1.017  ENDIF

  1.018  TSET         TDESC = DC Coupling
  1.019  VISA         ACQ:MODE AVE;NUMAV 16
  1.020  VISA         TRIG:A:MOD NORM;TYPE EDGE
  1.021  VISA         TRIG:A:EDGE:SOU LINE
  1.022  VISA         CH[V @Chan]:SCA 200E-3;COUP DC
  1.023  VISA         HOR:SCA 1E-3
  1.024  VISA         MEASU:MEAS1:SOU CH[V @Chan];TYPE MEAN;STATE ON
  1.025  WAIT         -t 2 Settling...
  1.026  TARGET       -m
  1.027  VISA         MEASU:MEAS1:VAL?[I]
  1.028  MATH         MEM = MEM / 1E-3
  1.029  MEMCX        0mV            21U

  2.001  HEAD         -2 GND Coupling
  2.002  TARGET       -p
  2.003  TSET         TDESC = GND Coupling
  2.004  VISA         CH[V @Chan]:COUP GND
  2.005  WAIT         -t 2 Settling...
  2.006  TARGET       -m
  2.007  VISA         MEASU:MEAS1:VAL?[I]
  2.008  MATH         MEM = MEM / 1E-3
  2.009  MEMCX        0mV            21U

  3.001  HEAD         -2
  3.002  HEAD
  3.003  END
