﻿Copyright (c) (2013) Fluke Corporation.                  All rights reserved.
=============================================================================
INSTRUMENT:            Sub Tek MSO/DPO2000 (1 yr) DCV Gain VER VISA /O_CAL
INSTRUMENT:            Sub Tek MSO/DPO2000 (1 yr) BW VER VISA /O_CAL
INSTRUMENT:            Sub Tek MSO/DPO2000 (1 yr) Vert Pos VER VISA /O_CAL
DATE:                  2013-09-26 10:17:23
AUTHOR:                Fluke
REVISION:              $Revision: 4508 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       12
NUMBER OF LINES:       317
CONFIGURATION:         Fluke Ocal
=============================================================================
#
#  Procedure Author:
#        ZY, DAC, VY, GMO
#
#  Models covered:
#        DPO2012, DPO2014, DPO2024
#        MSO2012, MSO2014, MSO2024
#        DPO2002B, DPO2004B, DPO2012B, DPO2014B, DPO2022B, DPO2024B
#        MSO2002B, MSO2004B, MSO2012B, MSO2014B, MSO2022B, MSO2024B
#
#  Source:
#        MSO2000 and DPO2000 Series Oscilloscopes
#        Specification and Performance Verification Technical Reference
#        PN 077-0096-00
#
#        MSO2000B and DPO2000B Series Oscilloscopes
#        Specification and Performance Verification Technical Reference
#        PN 077-0735-00
#
#  Required Variables:
#        @Chan = UUT channel under test
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  CALL         Sub Tek MDO/MSO/DPO Select Channel VISA
  1.002  CALL         Sub Tek MDO/MSO/DPO Clear Menu VISA
  1.003  JMPL         DCV_GAIN_ACC                 PSUBI("DCV Gain")
  1.004  JMPL         BANDWIDTH                    PSUBI("BW VER")
  1.005  JMPL         VERTICAL_POSITION            PSUBI("Vert Pos")
  1.006  DISP         Subprocedure not found!
  1.007  END

  1.008  EVAL   Increment test number

# =====  Sub Tek MSO/DPO2000 (1 yr) DCV Gain VER VISA /O_CAL  ================

# Required Variables:
# @CalChan = Output channel of the reference standard

  2.001  LABEL        DCV_GAIN_ACC
  2.002  MATH         Conf = CONF(@CalDev)

  2.003  IF           @Chan == 1
  2.004  RSLT         =
  2.005  RSLT         =DCV GAIN ACCURACY
  2.006  ENDIF

  2.007  RSLT         =
  2.008  HEAD         DCV GAIN ACCURACY: {Channel [V @Chan]}

  2.009  IF           @Chan == 1
  2.010  DISP         Remove all 50 Ohm feedthrough terminations from the UUT.
  2.011  ENDIF

  2.012  TARGET       -p
  2.013  CALL         Sub Scope Connection /O_CAL
  2.014  TSET         TDESC = 5 mV/div
  2.015  VISA         CH[V @Chan]:PRO:GAIN 1
  2.016  VISA         CH[V @Chan]:SCA 5E-3
  2.017  VISA         TRIG:A:MOD NORM;TYPE EDGE;EDGE:SOU LINE
  2.018  VISA         MEASU:IMMED:SOU CH[V @Chan];TYPE MEAN
  2.019  VISA         ACQ:STATE STOP;MODE AVE;NUMAV 16;STOPAFTER SEQ
  2.020  CALL         Sub Tek MDO/MSO/DPO Wait for OPC VISA
  2.021  JMPL         END_DCV_GAIN_ACC             @Abort
  2.022  TARGET       -m
  2.023  O_CAL        Mode = Voltage; Channel = [V @CalChan]
  2.023  O_CAL        +Voltage = +17.5 mV; OutputImpedance = 1 MOhm
  2.024  MATH         PosAcc = REFACC()
  2.025  VISA         MEASU:STATI RESET;:ACQ:STATE RUN
  2.026  CALL         Sub Tek MDO/MSO/DPO Wait for OPC VISA
  2.027  JMPL         END_DCV_GAIN_ACC             @Abort
  2.028  VISA         MEASU:IMM:VAL?[I]
  2.029  MATH         PosValue = MEM
  2.030  O_CAL        Mode = Voltage; Channel = [V @CalChan]
  2.030  O_CAL        +Voltage = -17.5 mV; OutputImpedance = 1 MOhm
  2.031  MATH         NegAcc = REFACC()
  2.032  VISA         MEASU:STATI RESET;:ACQ:STATE RUN
  2.033  CALL         Sub Tek MDO/MSO/DPO Wait for OPC VISA
  2.034  JMPL         END_DCV_GAIN_ACC             @Abort
  2.035  VISA         MEASU:IMM:VAL?[I]
  2.036  MATH         NegValue = MEM
  2.037  MATH         L[1] = RSS2(PosAcc, NegAcc) / Conf * 2 / 1E-3
  2.038  ACC          35.0mV         L1U
  2.039  MATH         MEM = (PosValue - NegValue) / 1E-3
  2.040  MEMCX        35.0mV         4.0%

  3.001  TARGET       -p
  3.002  TSET         TDESC = 200 mV/div
  3.003  VISA         CH[V @Chan]:PRO:GAIN 1
  3.004  VISA         CH[V @Chan]:SCA 200E-3
  3.005  CALL         Sub Tek MDO/MSO/DPO Wait for OPC VISA
  3.006  JMPL         END_DCV_GAIN_ACC             @Abort
  3.007  TARGET       -m
  3.008  O_CAL        Mode = Voltage; Channel = [V @CalChan]
  3.008  O_CAL        +Voltage = +700 mV; OutputImpedance = 1 MOhm
  3.009  MATH         PosAcc = REFACC()
  3.010  VISA         MEASU:STATI RESET;:ACQ:STATE RUN
  3.011  CALL         Sub Tek MDO/MSO/DPO Wait for OPC VISA
  3.012  JMPL         END_DCV_GAIN_ACC             @Abort
  3.013  VISA         MEASU:IMM:VAL?[I]
  3.014  MATH         PosValue = MEM
  3.015  O_CAL        Mode = Voltage; Channel = [V @CalChan]
  3.015  O_CAL        +Voltage = -700 mV; OutputImpedance = 1 MOhm
  3.016  MATH         NegAcc = REFACC()
  3.017  VISA         MEASU:STATI RESET;:ACQ:STATE RUN
  3.018  CALL         Sub Tek MDO/MSO/DPO Wait for OPC VISA
  3.019  JMPL         END_DCV_GAIN_ACC             @Abort
  3.020  VISA         MEASU:IMM:VAL?[I]
  3.021  MATH         NegValue = MEM
  3.022  MATH         L[1] = RSS2(PosAcc, NegAcc) / Conf * 2 / 1E-3
  3.023  ACC          1400mV         L1U
  3.024  MATH         MEM = (PosValue - NegValue) / 1E-3
  3.025  MEMCX        mV             3%

  4.001  TARGET       -p
  4.002  TSET         TDESC = 2 V/div
  4.003  VISA         CH[V @Chan]:PRO:GAIN 1
  4.004  VISA         CH[V @Chan]:SCA 2
  4.005  CALL         Sub Tek MDO/MSO/DPO Wait for OPC VISA
  4.006  JMPL         END_DCV_GAIN_ACC             @Abort
  4.007  TARGET       -m
  4.008  O_CAL        Mode = Voltage; Channel = [V @CalChan]
  4.008  O_CAL        +Voltage = +7 V; OutputImpedance = 1 MOhm
  4.009  MATH         PosAcc = REFACC()
  4.010  VISA         MEASU:STATI RESET;:ACQ:STATE RUN
  4.011  CALL         Sub Tek MDO/MSO/DPO Wait for OPC VISA
  4.012  JMPL         END_DCV_GAIN_ACC             @Abort
  4.013  VISA         MEASU:IMM:VAL?[I]
  4.014  MATH         PosValue = MEM
  4.015  O_CAL        Mode = Voltage; Channel = [V @CalChan]
  4.015  O_CAL        +Voltage = -7 V; OutputImpedance = 1 MOhm
  4.016  MATH         NegAcc = REFACC()
  4.017  VISA         MEASU:STATI RESET;:ACQ:STATE RUN
  4.018  CALL         Sub Tek MDO/MSO/DPO Wait for OPC VISA
  4.019  JMPL         END_DCV_GAIN_ACC             @Abort
  4.020  VISA         MEASU:IMM:VAL?[I]
  4.021  MATH         NegValue = MEM
  4.022  MATH         L[1] = RSS2(PosAcc, NegAcc) / Conf * 2
  4.023  ACC          14.00V         L1U
  4.024  MATH         MEM = PosValue - NegValue
  4.025  MEMCX        V              3.00%

  5.001  LABEL        END_DCV_GAIN_ACC
  5.002  O_CAL        Standby
  5.003  HEAD
  5.004  END

  5.005  EVAL   Increment test number

# =====  Sub Tek MSO/DPO2000 (1 yr) BW VER VISA /O_CAL  ======================

# Required Variables:
# @Bandwidth = UUT bandwidth

  6.001  LABEL        BANDWIDTH

  6.002  IF           @Chan == 1
  6.003  RSLT         =
  6.004  RSLT         =ANALOG BANDWIDTH
  6.005  RSLT         =Limit: >= 2.12 Vpp, Reference = 3 Vpp @ 50 kHz
  6.006  ENDIF

  6.007  RSLT         =
  6.008  HEAD         ANALOG BANDWIDTH
  6.009  HEAD         -2 {Channel [V @Chan]}
  6.010  TARGET       -p

# Channel 1 connections are in the Sample Rate sub.
  6.011  IF           NOT(@Chan == 1)
  6.012  CALL         Sub Scope Connection (50 Ω feedthrough) /O_CAL
  6.013  ENDIF

  6.014  VISA         CH[V @Chan]:PRO:GAIN 1
  6.015  VISA         CH[V @Chan]:SCA 500E-3
  6.016  VISA         HOR:SCA 400E-6
  6.017  VISA         TRIG:A:MOD NORM;TYPE EDGE
  6.018  VISA         TRIG:A:EDGE:SOU CH[V @Chan];COUP NOISE
  6.019  VISA         MEASU:IMMED:SOU CH[V @Chan];TYP PK2P
  6.020  VISA         ACQ:STATE STOP;STOPAFTER SEQ
  6.021  CALL         Sub Tek MDO/MSO/DPO Wait for OPC VISA
  6.022  JMPL         END_BANDWIDTH                @Abort

# Set the output of the calibrator so the peak-to-peak measurement is
# between 2.98 V and 3.02 V.
  6.023  MATH         MEM = 3; MEM1 = MEM

  6.024  DO
  6.025  MATH         MEM = MEM1 + (3 - MEM) / 2

# Set the output trap in order to avoid the calculated output beyond the
# calibrator maximum or minimum output at this frequency because of unstable
# reading.
  6.026  IF           (MEM > 5.5) || (MEM < 0.00444)
  6.027  MATH         MEM = 3
  6.028  ENDIF

# For 55xx with SC600 Scope Option and 58xx, the Level Sine frequency is from
# 50 kHz to 600 MHz. Therefore a 50 kHz reference frequency in lieu of 1 kHz.
  6.029  O_CAL        Mode = LevSine; Channel = [V @CalChan]
  6.029  O_CAL        +Voltage = [MEM] Vpp; @Frequency = 50 kHz
  6.030  VISA         ACQ:STATE RUN
  6.031  CALL         Sub Tek MDO/MSO/DPO Wait for OPC VISA
  6.032  JMPL         END_BANDWIDTH                @Abort

  6.033  VISA         MEASU:IMM:VAL?[I]
  6.034  UNTIL        (MEM >= 2.98) && (MEM <= 3.02)

  6.035  VISA         HOR:SCA 10E-9
  6.036  CALL         Sub Tek MDO/MSO/DPO Wait for OPC VISA
  6.037  JMPL         END_BANDWIDTH                @Abort
# Last calibrator amplitude setting is in MEM1.
  6.038  MATH         MEM = MEM1
  6.039  O_CAL        Mode = LevSine; Channel = [V @CalChan]
  6.039  O_CAL        +Voltage = [MEM] Vpp; @Frequency = [V @Bandwidth]
  6.040  VISA         ACQ:STATE RUN
  6.041  CALL         Sub Tek MDO/MSO/DPO Wait for OPC VISA
  6.042  JMPL         END_BANDWIDTH                @Abort
  6.043  VISA         MEASU:IMM:VAL?[I]
  6.044  MATH         MEM = FMT(MEM, "%4.2f")
  6.045  EVAL   -e (MEM >= 2.12) : [MEM] Vpp @ [V @Bandwidth], 500 mv/div

  7.001  O_CAL        Standby

  7.002  LABEL        END_BANDWIDTH
  7.003  HEAD         -2
  7.004  HEAD
  7.005  END

  7.006  EVAL   Increment test number

# =====  Sub Tek MSO/DPO2000 (1 yr) Vert Pos VER VISA /O_CAL  ================

# Required Variables:
# @CalChan = Output channel of the reference standard

  8.001  LABEL        VERTICAL_POSITION

  8.002  IF           @Chan == 1
  8.003  RSLT         =
  8.004  RSLT         =VERTICAL POSITION
  8.005  RSLT         =(Test Limit = ±0.2 div)
  8.006  ENDIF

  8.007  RSLT         =
  8.008  HEAD         VERTICAL POSITION: {Channel [V @Chan]}
  8.009  HEAD         -2 {200 mV/div}
  8.010  MESS         Is the vertical trace within 0.2
  8.010  MESS         divisions of the Zero volt line?
  8.011  TARGET
  8.012  VISA         CH[V @Chan]:PRO:GAIN 1
  8.013  VISA         CH[V @Chan]:SCA 200E-3;POS -4;OFFS 1
  8.014  CALL         Sub Tek MDO/MSO/DPO Wait for OPC VISA
  8.015  JMPL         END_VERTICAL_POS             @Abort
  8.016  O_CAL        Mode = Voltage; Channel = [V @CalChan]
  8.016  O_CAL        +Voltage = 1.8 V; OutputImpedance = 1 MOhm
  8.017  EVAL   -s "+1 V offset, +1.8 DCV source" :

  9.001  VISA         CH[V @Chan]:POS 4;OFFS -1
  9.002  CALL         Sub Tek MDO/MSO/DPO Wait for OPC VISA
  9.003  JMPL         END_VERTICAL_POS             @Abort
  9.004  O_CAL        Mode = Voltage; Channel = [V @CalChan]
  9.004  O_CAL        +Voltage = -1.8 V; OutputImpedance = 1 MOhm
  9.005  EVAL   -s "-1 V offset, -1.8 DCV source" :

# The applied voltage and offset settings for the 5 V/div test differ from the
# Performance Verification manual.  These changes were made with the consent
# of the device manufacturer.

 10.001  RSLT         =
 10.002  HEAD         -2 {5 V/div}
 10.003  TARGET
 10.004  VISA         CH[V @Chan]:SCA 5;POS -4;OFFS 10
 10.005  CALL         Sub Tek MDO/MSO/DPO Wait for OPC VISA
 10.006  JMPL         END_VERTICAL_POS             @Abort
 10.007  O_CAL        Mode = Voltage; Channel = [V @CalChan]
 10.007  O_CAL        +Voltage = 30 V; OutputImpedance = 1 MOhm
 10.008  EVAL   -s  "+10 V offset, +30 DCV source" :

 11.001  VISA         CH[V @Chan]:POS 4;OFFS -10
 11.002  CALL         Sub Tek MDO/MSO/DPO Wait for OPC VISA
 11.003  JMPL         END_VERTICAL_POS             @Abort
 11.004  O_CAL        Mode = Voltage; Channel = [V @CalChan]
 11.004  O_CAL        +Voltage = -30 V; OutputImpedance = 1 MOhm
 11.005  EVAL   -s "-10 V offset, -30 DCV source" :

 12.001  LABEL        END_VERTICAL_POS
 12.002  HEAD         -2
 12.003  MESS
 12.004  O_CAL        Standby
 12.005  HEAD
 12.006  END
