﻿Copyright (c) (2016) Fluke Corporation                      MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Tek MSO/DPO2000 (1 yr) Sample Rate VER VISA /O_CAL
DATE:                  2016-06-29 08:22:04
AUTHOR:                Fluke
REVISION:              $Revision: 4508 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       2
NUMBER OF LINES:       103
CONFIGURATION:         Fluke Ocal
=============================================================================
#
#  Procedure Author:
#        ZY, DAC, VY, GMO
#
#  Models covered:
#        DPO2012, DPO2014, DPO2024
#        MSO2012, MSO2014, MSO2024
#        DPO2002B, DPO2004B, DPO2012B, DPO2014B, DPO2022B, DPO2024B
#        MSO2002B, MSO2004B, MSO2012B, MSO2014B, MSO2022B, MSO2024B
#
#  Source:
#        MSO2000 and DPO2000 Series Oscilloscopes
#        Specification and Performance Verification Technical Reference
#        PN 077-0096-00
#
#        MSO2000B and DPO2000B Series Oscilloscopes
#        Specification and Performance Verification Technical Reference
#        PN 077-0735-00
#
#  Required Variables:
#        @Chan = UUT channel under test
#
#  This procedure is intended for use with all Fluke 55XX calibrators
#  except the Fluke 5080A+SC.
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  RSLT         =
  1.002  HEAD         {SAMPLE RATE AND DELAY TIME ACCURACY}
  1.003  TARGET       -p
  1.004  CALL         Sub Tek MDO/MSO/DPO Select Channel VISA
  1.005  CALL         Sub Scope Connection (50 Ω feedthrough) /O_CAL
  1.006  VISA         HOR:SCA 1E-3
  1.007  VISA         CH[V @Chan]:PRO:GAIN 1
  1.008  VISA         CH[V @Chan]:SCA 500E-3;POS 1
  1.009  CALL         Sub Tek MDO/MSO/DPO Wait for OPC VISA
  1.010  JMPL         END_SAMPLE_RATE              @Abort
  1.011  O_CAL        Mode = Edge; Chan = [V @CalChan]
  1.011  O_CAL        +Period = 1 ms; Voltage = 1 Vpp
  1.012  VISA         HOR:DEL:MOD ON;TIM 1E-3
  1.013  VISA         HOR:SCA 10E-9; POS 1E-3
  1.014  CALL         Sub Tek MDO/MSO/DPO Wait for OPC VISA
  1.015  JMPL         END_SAMPLE_RATE              @Abort
  1.016  DISP         Adjust the Trigger LEVEL knob as necessary for a
  1.016  DISP         triggered display.
  1.016  DISP
  1.016  DISP         Adjust the Vertical POSITION knob to center the time
  1.016  DISP         mark signal on the screen.
  1.017  VISA         ACQ:STATE STOP;STOPAFTER SEQ
  1.018  VISA         CURS:FUNC WAVEFORM;MODE IND;:CURS:VBARS:UNITS SEC
  1.019  VISA         CURS:VBARS:POSITION1 1E-3;POSITION2 1E-3
  1.020  CALL         Sub Tek MDO/MSO/DPO Wait for OPC VISA
  1.021  JMPL         END_SAMPLE_RATE              @Abort
  1.022  TARGET       -m
  1.023  VISA         ACQ:STATE RUN
  1.024  CALL         Sub Tek MDO/MSO/DPO Wait for OPC VISA
  1.025  JMPL         END_SAMPLE_RATE              @Abort
  1.026  DISP         Use the UUT's Multipurpose "b" knob to align cursor "b"
  1.026  DISP         with the rising edge of the displayed waveform where the
  1.026  DISP         waveform intercepts the horizontal axis.
  1.027  VISA         CURS:VBARS:HPOS2?[I]

# Determine if cursor "b" is left or right of vertical center.
  1.028  IF           MEM < 1.0
  1.029  MATH         L[2] = -1.0
  1.030  ELSE
  1.031  MATH         L[2] = +1.0
  1.032  ENDIF

# Ensure cursor "a" is still at the 1 ms position before querying delta.
  1.033  VISA         CURS:VBARS:POSITION1 1E-3;:CURS:VBARS:DELTA?[I]
# Compute UUT Indicated in milliseconds.
  1.034  MATH         MEM = 1 + L[2] * MEM / 1E-3
  1.035  MEMCX        1.000000ms     25P%

  2.001  LABEL        END_SAMPLE_RATE
  2.002  O_CAL        Standby
  2.003  HEAD
  2.004  END
