﻿Copyright (c) (2013) Fluke Corporation.                  All rights reserved.
=============================================================================
INSTRUMENT:            Sub Tek MSO/DPO 2000 (1 yr) VER VISA /O_CAL
DATE:                  2013-10-02 11:11:35
AUTHOR:                Fluke
REVISION:              $Revision: 4652 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       1
NUMBER OF LINES:       203
CONFIGURATION:         Fluke Ocal
=============================================================================
#
#  Procedure Author:
#        GMO
#
#  Models Covered:
#        MSO2002B, MSO2004B, MSO2012, MSO2014, MSO2024, MSO2012B,
#        MSO2014B, MSO2024B
#        DPO2002B, DPO2004B, DPO2012, DPO2014, DPO2024, DPO2012B,
#        DPO2014B, DPO2024B
#
#  Source:
#        MSO2000 and DPO2000 Series Oscilloscopes
#        Specification and Performance Verification Technical Reference
#        PN 077-0096-00
#
#        MSO2000B and DPO2000B Series Oscilloscopes
#        Specification and Performance Verification Technical Reference
#        PN 077-0735-00
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  IF           0
  1.002  O_CAL        Standby
  1.003  ENDIF

  1.004  ASK-   R   Q N              P                            A        V

  1.005  IF           NOT(VERSIONCHECK("8.1.4"))
  1.006  END
  1.007  ENDIF

  1.008  CALL         Sub Display Copyright
  1.009  CALL         Sub Tek MSO/DPO2000 Remote Interface Connection
  1.010  VISA         *RST;*OPC?[I!]
  1.011  HEAD         REMOTE INTERFACE CONNECTION
  1.012  CALL         Sub IEEE-488.2 Identification Query VISA
  1.013  MATH         @UUT_Manufacturer = "Tektronix"
  1.014  CALL         Sub IEEE-488.2 Identification Query Check Response

  1.015  IF           @Abort
  1.016  END
  1.017  ENDIF

  1.018  CALL         Sub Tek MSO/DPO2000 Check Firmware Version

  1.019  IF           @Abort
  1.020  END
  1.021  ENDIF

  1.022  CALL         Sub High Voltage Safety Warning
  1.023  CALL         Sub Select Failed Test Mode
  1.024  CALL         Sub Select Verification Method (No NTHROW)

  1.025  HEAD         EQUIPMENT REQUIREMENTS

  1.026  IF           FIND(@ModelNum, "MSO", 1)
  1.027  DISP         - Cables, 50 Ohm, BNC(m)-(m), Pomona 2249-C-36
  1.027  DISP         - 50 Ohm terminator, one set
  1.027  DISP         - Tektronix P6316 digital probe
  1.027  DISP         - BNC-to-0.1 inch pin adapter
  1.028  ELSE
  1.029  DISP         - Cables, 50 Ohm, BNC(m)-(m), Pomona 2249-C-36
  1.029  DISP         - 50 Ohm terminator, one set
  1.030  ENDIF

  1.031  HEAD         PRELIMINARY INSTRUCTIONS
  1.032  TARGET
  1.033  DISP         Ensure a minimum UUT warm-up time of at least
  1.033  DISP         20 minutes has been allowed to elapse, prior
  1.033  DISP         to beginning verification.

# NOTE: Throughout this procedure, JMPL/LABEL statements are used to
# minimize connection changes during execution. Test results, however,
# are reported in test number sequence.
# Reference to CH3 and CH4 apply to 4 Channel instruments only.
#
#  Order  Results                            Run Time (Execution)
#  -----  -------------------------------    --------------------------------
#    1.   SELF TEST                          SELF TEST
#    2.   SIGNAL PATH COMPENSATION           SIGNAL PATH COMPENSATION
#    3.   DC BALANCE(CH1)                    DC BALANCE(CH1)
#    4.   DC BALANCE(CH2)                    DC BALANCE(CH2)
#    5.   DC BALANCE(CH3)                    DC BALANCE(CH3)
#    6.   DC BALANCE(CH4)                    DC BALANCE(CH4)
#    7.   DC GAIN(CH1)                       SAMPLE RATE
#    8.   DC GAIN(CH2)                       BANDWIDTH(CH1)
#    9.   DC GAIN(CH3)                       DC GAIN(CH1)
#    10.  DC GAIN(CH4)                       VERTICAL POSITION(CH1)
#    11.  BANDWIDTH(CH1)                     DC GAIN(CH2)
#    12.  BANDWIDTH(CH2)                     VERTICAL POSITION(CH2)
#    13.  BANDWIDTH(CH3)                     BANDWIDTH(CH2)
#    14.  BANDWIDTH(CH4)                     DC GAIN(CH3)
#    15.  VERTICAL POSITION(CH1)             VERTICAL POSITION(CH3)
#    16.  VERTICAL POSITION(CH2)             BANDWIDTH(CH3)
#    17.  VERTICAL POSITION(CH3)             DC GAIN(CH4)
#    18.  VERTICAL POSITION(CH4)             VERTICAL POSITION(CH4)
#    19.  SAMPLE RATE                        BANDWIDTH(CH4)

  1.034  CALL         Sub Tek MDO/MSO/DPO Self-Test VISA

  1.035  IF           @Abort
  1.036  END
  1.037  ENDIF

  1.038  CALL         Sub Tek MDO/MSO/DPO Signal Path Comp Cal VISA

  1.039  IF           @Abort
  1.040  END
  1.041  ENDIF

  1.042  MATH         @CalMultiChan = 0

  1.043  MATH         @Chan = 1
  1.044  CALL         Sub Tek MSO/DPO2000 (1 yr) DC Balance VER VISA
  1.045  MATH         @Chan = 2
  1.046  CALL         Sub Tek MSO/DPO2000 (1 yr) DC Balance VER VISA
  1.047  JMPL         SAMPLE_RATE                  @NumChan == 2
  1.048  MATH         @Chan = 3
  1.049  CALL         Sub Tek MSO/DPO2000 (1 yr) DC Balance VER VISA
  1.050  MATH         @Chan = 4
  1.051  CALL         Sub Tek MSO/DPO2000 (1 yr) DC Balance VER VISA
  1.052  JMPL         SAMPLE_RATE

  1.053  LABEL        DCV_GAIN_CH1
  1.054  MATH         @Chan = 1
  1.055  CALL         Sub Tek MSO/DPO2000 (1 yr) DCV Gain VER VISA /O_CAL
  1.056  JMPL         VER_POS_CH1

  1.057  LABEL        DCV_GAIN_CH2
  1.058  MATH         @Chan = 2
  1.059  CALL         Sub Tek MSO/DPO2000 (1 yr) DCV Gain VER VISA /O_CAL
  1.060  JMPL         VER_POS_CH2

  1.061  LABEL        DCV_GAIN_CH3
  1.062  MATH         @Chan = 3
  1.063  CALL         Sub Tek MSO/DPO2000 (1 yr) DCV Gain VER VISA /O_CAL
  1.064  JMPL         VER_POS_CH3

  1.065  LABEL        DCV_GAIN_CH4
  1.066  MATH         @Chan = 4
  1.067  CALL         Sub Tek MSO/DPO2000 (1 yr) DCV Gain VER VISA /O_CAL
  1.068  JMPL         VER_POS_CH4

  1.069  LABEL        BW_CH1
  1.070  MATH         @Chan = 1
  1.071  CALL         Sub Tek MSO/DPO2000 (1 yr) BW VER VISA /O_CAL
  1.072  MATH         @Chan = 2
  1.073  CALL         Sub Tek MSO/DPO2000 (1 yr) BW VER VISA /O_CAL
  1.074  JMPL         DCV_GAIN_CH1                 @NumChan == 2
  1.075  MATH         @Chan = 3
  1.076  CALL         Sub Tek MSO/DPO2000 (1 yr) BW VER VISA /O_CAL
  1.077  MATH         @Chan = 4
  1.078  CALL         Sub Tek MSO/DPO2000 (1 yr) BW VER VISA /O_CAL
  1.079  JMPL         DCV_GAIN_CH1

  1.080  LABEL        VER_POS_CH1
  1.081  CALL         Sub Tek MSO/DPO2000 (1 yr) Vert Pos VER VISA /O_CAL
  1.082  JMPL         DCV_GAIN_CH2

  1.083  LABEL        VER_POS_CH2
  1.084  CALL         Sub Tek MSO/DPO2000 (1 yr) Vert Pos VER VISA /O_CAL
  1.085  JMPL         END                          @NumChan == 2
  1.086  JMPL         DCV_GAIN_CH3

  1.087  LABEL        VER_POS_CH3
  1.088  CALL         Sub Tek MSO/DPO2000 (1 yr) Vert Pos VER VISA /O_CAL
  1.089  JMPL         DCV_GAIN_CH4

  1.090  LABEL        VER_POS_CH4
  1.091  CALL         Sub Tek MSO/DPO2000 (1 yr) Vert Pos VER VISA /O_CAL
  1.092  JMPL         END

  1.093  LABEL        SAMPLE_RATE
  1.094  MATH         @Chan = 1
  1.095  CALL         Sub Tek MSO/DPO2000 (1 yr) Sample Rate VER VISA /O_CAL
  1.096  JMPL         BW_CH1

  1.097  LABEL        END
  1.098  END
