﻿Copyright (c) (2013) Fluke Corporation.                  All rights reserved.
=============================================================================
INSTRUMENT:            Sub Tek MSO/DPO2000 Check Firmware Version
DATE:                  2013-08-29 08:56:54
AUTHOR:                Fluke
REVISION:              $Revision: 4146 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       1
NUMBER OF LINES:       68
=============================================================================
#
#  Procedure Author:
#        ZY, DAC
#
#  Models Covered:
#        MSO2012, MSO2014, MSO2024
#        DPO2012, DPO2014, DPO2024
#
#  Compatibility:
#        MET/CAL 7.20 (7.20x) or later
#
#  Subprocedures:
#        None
#
#  Required Files:
#        None
#
#  Additional Equipment Required:
#        None
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
# *IDN? response firmware revision substring has the form:
#
#   "CF:91.1CT FV:vX.XX"...
#
# where X.XX is the Firmware Version.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  IF           FINDI (@ModelNum,"B",1)
  1.002  MATH         ReqFirmwareRev = 1.52
  1.003  ELSE
  1.004  MATH         ReqFirmwareRev = 1.02
  1.005  ENDIF

  1.006  MATH         VerNum = SUB(FLD(@FirmwareRev, 2, " "), 5, 4)
  1.007  MATH         @Abort = (VerNum < ReqFirmwareRev)

  1.008  IF           @Abort
  1.009  DISP         This procedure requires firmware version
  1.009  DISP         [V ReqFirmwareRev] or later.
  1.009  DISP
  1.009  DISP         Go to tektronix.com to obtain updated firmware.
  1.010  ENDIF

  1.011  END
