﻿Copyright (c) (2015) Fluke Corporation                      MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Fluke 1520 (1 year) Discharge Circuit VER /DMM
DATE:                  2016-06-27 14:16:44
AUTHOR:                Fluke
REVISION:              $Revision: 16346 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       5
NUMBER OF LINES:       94
CONFIGURATION:         Digital Multimeter
=============================================================================
#
#  Procedure Author:
#        DAC, VY
#
#  Source:
#        Fluke 1520 MegOhmMeter Calibration Manual
#        PN 1592594, November 2000
#
#        Fluke 1520 Calibration Manual Supplement
#        Supplement Issue: 4, Issue Date: 10/02
#
#  Compatibility:
#        MET/CAL 8.0 or later
#
#  Additional Equipment Required:
#        None
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  IF           0
  1.002  IEEE         [@DMM]
  1.003  ENDIF

  1.004  RSLT         =
  1.005  HEAD         {DISCHARGE CIRCUIT TEST}
  1.006  MATH         @DMM_Func = "Resistance2W"
  1.007  CALL         Sub Reset /DMM
  1.008  TARGET
  1.009  DISP         The following Discharge Circuit Test is a safety
  1.009  DISP         related test that verifies input jack wiring to the PCA,
  1.009  DISP         the RSOB contacts, RSOB pads on the PCA, and other
  1.009  DISP         active components on the PCA.
  1.010  DISP         [32]                     CAUTION!
  1.010  DISP
  1.010  DISP         DO NOT push the UUT TEST button during the following
  1.010  DISP         test.

  1.011  DISP         Connect the  UUT to the [V @DMM_DevName] as follows:
  1.011  DISP         [32] UUT           [V @DMM_DevName]
  1.011  DISP         [32] V-Ω <=======> [V @DMM_InputHi]
  1.011  DISP         [32] COM <=======> [V @DMM_InputLo]

  1.012  HEAD         -2 250 V
  1.013  TARGET
  1.014  DISP         Turn the UUT Rotary switch to MΩ, 250V.
  1.015  CALL         Sub Measure /DMM
  1.016  EVAL   -e  (MEM >= 1600) && (MEM <= 3600) : [32][MEM] Ω, 250 V

  2.001  HEAD         -2 500 V
  2.002  TARGET
  2.003  DISP         Turn the UUT Rotary switch to MΩ, 500V.
  2.004  CALL         Sub Measure /DMM
  2.005  EVAL   -e  (MEM >= 1600) && (MEM <= 3600) : [32][MEM] Ω, 500 V

  3.001  HEAD         -2 1000 V
  3.002  TARGET
  3.003  DISP         Turn the UUT Rotary switch to MΩ, 1000V.
  3.004  CALL         Sub Measure /DMM
  3.005  EVAL   -e  (MEM >= 1600) && (MEM <= 3600) : [32][MEM] Ω, 1000 V

  4.001  HEAD         -2 LoΩ
  4.002  TARGET
  4.003  DISP         Turn the UUT Rotary switch to LoΩ.
  4.004  CALL         Sub Measure /DMM
  4.005  EVAL   -e  (MEM >= 1600) && (MEM <= 3600) : [32][MEM] Ω, LoΩ

  5.001  HEAD         -2
  5.002  HEAD
  5.003  DISP         Remove all connections.
  5.004  END
