﻿Copyright (c) (2015) Fluke Corporation                      MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Fluke 1520 (1 year) Continuity VER /5320
INSTRUMENT:            Sub Fluke 1520 (1 year) Low Ohms VER /5320
INSTRUMENT:            Sub Fluke 1520 (1 year) Ohms VER /5320
INSTRUMENT:            Sub Fluke 1520 (1 year) Megohm VER /5320
DATE:                  2016-06-27 14:16:27
AUTHOR:                Fluke
REVISION:              $Revision: 16346 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       30
NUMBER OF LINES:       392
CONFIGURATION:         Fluke 5320A
=============================================================================
#
#  Procedure Author:
#        DAC, VY
#
#  Source:
#        Fluke 1520 MegOhmMeter Calibration Manual
#        PN 1592594, November 2000
#
#  Compatibility:
#        MET/CAL 8.0 or later
#
#  Additional Equipment Required:
#        None
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  JMPL         CONTINUITY                   PSUBI("Continuity")
  1.002  JMPL         LO_OHMS_MEASUREMENT_ACCURACY PSUBI("Low Ohms")
  1.003  JMPL         OHMS_MEASUREMENT_ACCURACY    PSUBI("Ohms")
  1.004  JMPL         MEG_OHM_MEASUREMENT_ACCURACY PSUBI("Megohm")
  1.005  DISP         Subprocedure not found!
  1.006  END

  1.007  EVAL   Increment step number

# ======= Sub Fluke 1520 (1 year) Continuity VER /5320 ======================

  2.001  LABEL        CONTINUITY
  2.002  RSLT         =
  2.003  HEAD         {CONTINUITY}
  2.004  TARGET       -p
  2.005  5320         Mode = LR; +Resistance = 27 Ohms; Sense = 4W
  2.006  EVAL   -s " Beeper On" : Is beeper on?

  3.001  5320         Reset
  3.002  END

  3.003  EVAL   Increment step number

# ======= Sub Fluke 1520 (1 year) Continuity VER /5320 ======================

  4.001  LABEL        LO_OHMS_MEASUREMENT_ACCURACY
  4.002  RSLT         =
  4.003  HEAD         {LO OHMS MEASUREMENT ACCURACY}
  4.004  TARGET       -p
  4.005  DISP         Turn the UUT Rotary Switch to LO Ohms.
  4.006  5320         Mode = LR; +Resistance = 0.00 Ohms; Short
  4.007  DISP         Zero the LO ohms function (press and release the TEST
  4.007  DISP         button and then press and hold the ZERO button until
  4.007  DISP         the UUT beeps).
  4.008  5320         Mode = LR; +Resistance = 2.00 Ohms; Sense = 4W
  4.009  TARGET       -m
  4.010  DISP         Press and hold the TEST button until the UUT beeps.
  4.011  MEMI         Enter UUT reading in ohms.
  4.012  MEMCX  40    2.00Z          0.06U
#! WARNING: Test Tol 0.06, Sys Tol 0.016 Ohms, TUR 3.7500 (< 4.00).

  5.001  5320         Mode = LR; +Resistance = 20.00 Ohms; Sense = 4W
  5.002  TARGET       -m
  5.003  DISP         Press and hold the TEST button until the UUT beeps.
  5.004  MEMI         Enter UUT reading in ohms.
  5.005  MEMCX  40    20.00Z         0.42U

  6.001  HEAD
  6.002  5320         Reset
  6.003  END

  6.004  EVAL   Increment step number

# ======= Sub Fluke 1520 (1 year) Low Ohms VER /5320 ========================

  7.001  LABEL        OHMS_MEASUREMENT_ACCURACY
  7.002  RSLT         =
  7.003  HEAD         {OHMS MEASUREMENT ACCURACY}
  7.004  TARGET       -p
  7.005  DISP         Connect the 5320A to the UUT as follows:
  7.005  DISP
  7.005  DISP         [32] 5320A                       UUT
  7.005  DISP         [32] OUTPUT LoΩ HI <===========> V-Ω
  7.005  DISP         [32] OUTPUT LoΩ LO <===========> COM
  7.005  DISP         [32] OUTPUT LoΩ-SENSE HI <=====> V-Ω
  7.005  DISP         [32] OUTPUT LoΩ-SENSE LO <=====> COM
  7.006  DISP         Turn the UUT Rotary Switch to Ω/Continuity.
  7.007  5320         Mode = LR; +Resistance = 0 Ohms; Short
  7.008  TARGET       -m
  7.009  MEMI         Enter UUT reading in ohms:
  7.010  MEMCX  4000  0Z             2U

  8.001  5320         Mode = LR; +Resistance = 1200 Ohms; Sense = 4W
  8.002  TARGET       -m
  8.003  MEMI         Enter UUT reading in ohms:
  8.004  MEMCX  4000  1200Z          26U

  9.001  5320         Mode = LR; +Resistance = 3600 Ohms; Sense = 4W
  9.002  TARGET       -m
  9.003  MEMI         Enter UUT reading in ohms:
  9.004  MEMCX  4000  3600Z          74U

 10.001  EVAL   -s " Open" : Is UUT displaying ">4000" ?

 11.001  HEAD
 11.002  5320         Reset
 11.003  END

 11.004  EVAL   Increment step number

# ======= Sub Fluke 1520 (1 year) Megohm VER /5320 ==========================

 12.001  LABEL        MEG_OHM_MEASUREMENT_ACCURACY
 12.002  RSLT         =
 12.003  RSLT         =MEG OHM MEASUREMENT ACCURACY
 12.004  RSLT         =
 12.005  HEAD         MEG OHM MEASUREMENT ACCURACY: 250 V, 250 kOhm
 12.006  DISP         [32]                     WARNING!
 12.006  DISP
 12.006  DISP         Pushing the TEST button produces a potentially dangerous
 12.006  DISP         voltage at the UUT output terminals when the UUT is in
 12.006  DISP         the MOhm function.
 12.007  TARGET       -p
 12.008  DISP         Turn the UUT Rotary switch to MΩ, 250V.
 12.009  5320         Mode = HR; +Resistance = 0.250 MOhm; TestVoltage = 250 V
 12.010  TARGET       -m
 12.011  MATH         SAFEON("UUT", "250 V", "")
 12.012  DISP         Press and hold the TEST button until the UUT beeps and
 12.012  DISP         reading settles.
 12.013  MATH         SAFEOFF("UUT")
 12.014  MEMI         Enter UUT reading in megaohms:
 12.015  MEMCX  4     0.250MZ        0.007U        250V
 13.001  JMPL         MEG_OHM_MEASUREMENT_ACCURACY_250_V_500_kOhm

 13.002  LABEL        MEG_OHM_MEASUREMENT_ACCURACY_500_V_250_kOhm
 13.003  HEAD         MEG OHM MEASUREMENT ACCURACY: 500 V, 250 kOhm
 13.004  TARGET       -p
 13.005  DISP         Turn the UUT Rotary switch to MΩ, 500V.
 13.006  5320         Mode = HR; +Resistance = 0.250 MOhm; TestVoltage = 500 V
 13.007  TARGET       -m
 13.008  MATH         SAFEON("UUT", "500 V", "")
 13.009  DISP         Press and hold the TEST button until the UUT beeps and
 13.009  DISP         reading settles.
 13.010  MATH         SAFEOFF("UUT")
 13.011  MEMI         Enter UUT reading in megaohms:
 13.012  MEMCX  4     0.250MZ        0.007U        500V
 14.001  JMPL         MEG_OHM_MEASUREMENT_ACCURACY_500_V_500_kOhm

 14.002  LABEL        MEG_OHM_MEASUREMENT_ACCURACY_1000_V_250_kOhm
 14.003  HEAD         MEG OHM MEASUREMENT ACCURACY: 1000 V, 250 kOhm
 14.004  TARGET       -p
 14.005  DISP         Turn the UUT Rotary switch to MΩ, 1000V.
 14.006  5320         Mode = HR; +Resistance = 0.250 MOhm; TestVoltage = 1 kV
 14.007  TARGET       -m
 14.008  MATH         SAFEON("UUT", "1000 V", "")
 14.009  DISP         Press and hold the TEST button until the UUT beeps and
 14.009  DISP         reading settles.
 14.010  MATH         SAFEOFF("UUT")
 14.011  MEMI         Enter UUT reading in megaohms:
 14.012  MEMCX  4     0.250MZ        0.007U        1000V
 15.001  JMPL         MEG_OHM_MEASUREMENT_ACCURACY_1000_V_500_kOhm

 15.002  LABEL        MEG_OHM_MEASUREMENT_ACCURACY_250_V_500_kOhm
 15.003  HEAD         MEG OHM MEASUREMENT ACCURACY: 250 V, 500 kOhm
 15.004  TARGET       -p
 15.005  5320         Mode = HR; +Resistance = 0.500 MOhm; TestVoltage = 250 V
 15.006  TARGET       -m
 15.007  MATH         SAFEON("UUT", "250 V", "")
 15.008  DISP         Press and hold the TEST button until the UUT beeps and
 15.008  DISP         reading settles.
 15.009  MATH         SAFEOFF("UUT")
 15.010  MEMI         Enter UUT reading in megaohms:
 15.011  MEMCX  4     0.500MZ        0.012U        250V
 16.001  JMPL         MEG_OHM_MEASUREMENT_ACCURACY_250_V_1_MOhm

 16.002  LABEL        MEG_OHM_MEASUREMENT_ACCURACY_500_V_500_kOhm
 16.003  HEAD         MEG OHM MEASUREMENT ACCURACY: 500 V, 500 kOhm
 16.004  TARGET       -p
 16.005  5320         Mode = HR; +Resistance = 0.500 MOhm; TestVoltage = 500 V
 16.006  TARGET       -m
 16.007  MATH         SAFEON("UUT", "500 V", "")
 16.008  DISP         Press and hold the TEST button until the UUT beeps and
 16.008  DISP         UUT settles.
 16.009  MATH         SAFEOFF("UUT")
 16.010  MEMI         Enter UUT reading in megaohms:
 16.011  MEMCX  4     0.500MZ        0.012U        500V
 17.001  JMPL         MEG_OHM_MEASUREMENT_ACCURACY_500_V_1_MOhm

 17.002  LABEL        MEG_OHM_MEASUREMENT_ACCURACY_1000_V_500_kOhm
 17.003  HEAD         MEG OHM MEASUREMENT ACCURACY: 1000 V, 500 kOhm
 17.004  TARGET       -p
 17.005  5320         Mode = HR; +Resistance = 0.500 MOhm; TestVoltage = 1 kV
 17.006  TARGET       -m
 17.007  MATH         SAFEON("UUT", "1000 V", "")
 17.008  DISP         Press and hold the TEST button until the UUT beeps and
 17.008  DISP         UUT settles.
 17.009  MATH         SAFEOFF("UUT")
 17.010  MEMI         Enter UUT reading in megaohms:
 17.011  MEMCX  4     0.500MZ        0.012U        1000V
 18.001  JMPL         MEG_OHM_MEASUREMENT_ACCURACY_1000_V_1_MOhm

 18.002  LABEL        MEG_OHM_MEASUREMENT_ACCURACY_250_V_1_MOhm
 18.003  HEAD         MEG OHM MEASUREMENT ACCURACY: 250 V, 1 MOhm
 18.004  TARGET       -p
 18.005  5320         Mode = HR; +Resistance = 1.000 MOhm; TestVoltage = 250 V
 18.006  TARGET       -m
 18.007  MATH         SAFEON("UUT", "250 V", "")
 18.008  DISP         Press and hold the TEST button until the UUT beeps and
 18.008  DISP         UUT settles.
 18.009  MATH         SAFEOFF("UUT")
 18.010  MEMI         Enter UUT reading in megaohms:
 18.011  MEMCX  4     1.000MZ        0.022U        250V
 19.001  JMPL         MEG_OHM_MEASUREMENT_ACCURACY_250_V_80_MOhm

 19.002  LABEL        MEG_OHM_MEASUREMENT_ACCURACY_500_V_1_MOhm
 19.003  HEAD         MEG OHM MEASUREMENT ACCURACY: 500 V, 1 MOhm
 19.004  TARGET       -p
 19.005  5320         Mode = HR; +Resistance = 1.000 MOhm; TestVoltage = 500 V
 19.006  TARGET       -m
 19.007  MATH         SAFEON("UUT", "500 V", "")
 19.008  DISP         Press and hold the TEST button until the UUT beeps and
 19.008  DISP         reading settles.
 19.009  MATH         SAFEOFF("UUT")
 19.010  MEMI         Enter UUT reading in megaohms:
 19.011  MEMCX  4     1.000MZ        0.022U        500V
 20.001  JMPL         MEG_OHM_MEASUREMENT_ACCURACY_500_V_80_MOhm

 20.002  LABEL        MEG_OHM_MEASUREMENT_ACCURACY_1000_V_1_MOhm
 20.003  HEAD         MEG OHM MEASUREMENT ACCURACY: 1000 V, 1 MOhm
 20.004  TARGET       -p
 20.005  5320         Mode = HR; +Resistance = 1.000 MOhm; TestVoltage = 1 kV
 20.006  TARGET       -m
 20.007  MATH         SAFEON("UUT", "1000 V", "")
 20.008  DISP         Press and hold the TEST button until the UUT beeps and
 20.008  DISP         reading settles.
 20.009  MATH         SAFEOFF("UUT")
 20.010  MEMI         Enter UUT reading in megaohms:
 20.011  MEMCX  4     1.000MZ        0.022U        1000V
#! WARNING: Test Tol 22000, Sys Tol 6000 Ohms, TUR 3.6667 (< 4.00).
 21.001  JMPL         MEG_OHM_MEASUREMENT_ACCURACY_1000_V_80_MOhm

 21.002  LABEL        MEG_OHM_MEASUREMENT_ACCURACY_250_V_80_MOhm
 21.003  HEAD         MEG OHM MEASUREMENT ACCURACY: 250 V, 80 MOhm
 21.004  TARGET       -p
 21.005  5320         Mode = HR; +Resistance = 80.0 MOhm; TestVoltage = 250 V
 21.006  TARGET       -m
 21.007  MATH         SAFEON("UUT", "250 V", "")
 21.008  DISP         Press and hold the TEST button until the UUT beeps and
 21.008  DISP         reading settles.
 21.009  MATH         SAFEOFF("UUT")
 21.010  MEMI         Enter UUT reading in megaohms:
 21.011  MEMCX  400   80.0MZ         1.8U          250V
 22.001  JMPL         MEG_OHM_MEASUREMENT_ACCURACY_250_V_OPEN

 22.002  LABEL        MEG_OHM_MEASUREMENT_ACCURACY_500_V_80_MOhm
 22.003  HEAD         MEG OHM MEASUREMENT ACCURACY: 500 V, 80 MOhm
 22.004  TARGET       -p
 22.005  5320         Mode = HR; +Resistance = 80.0 MOhm; TestVoltage = 500 V
 22.006  TARGET       -m
 22.007  MATH         SAFEON("UUT", "500 V", "")
 22.008  DISP         Press and hold the TEST button until the UUT beeps and
 22.008  DISP         reading settles.
 22.009  MATH         SAFEOFF("UUT")
 22.010  MEMI         Enter UUT reading in megaohms:
 22.011  MEMCX  400   80.0MZ         1.8U          500V
 23.001  JMPL         MEG_OHM_MEASUREMENT_ACCURACY_500_V_OPEN

 23.002  LABEL        MEG_OHM_MEASUREMENT_ACCURACY_1000_V_80_MOhm
 23.003  HEAD         MEG OHM MEASUREMENT ACCURACY: 1000 V, 80 MOhm
 23.004  TARGET       -p
 23.005  5320         Mode = HR; +Resistance = 80.0 MOhm; TestVoltage = 1 kV
 23.006  TARGET       -m
 23.007  MATH         SAFEON("UUT", "1000 V", "")
 23.008  DISP         Press and hold the TEST button until the UUT beeps and
 23.008  DISP         reading settles.
 23.009  MATH         SAFEOFF("UUT")
 23.010  MEMI         Enter UUT reading in megaohms:
 23.011  MEMCX  400   80.0MZ         1.8U          1000V
#! WARNING: Test Tol 1.8e+006, Sys Tol 6.4e+005 Ohms, TUR 2.8125 (< 4.00).
 24.001  JMPL         MEG_OHM_MEASUREMENT_ACCURACY_1000_V_OPEN

 24.002  LABEL        MEG_OHM_MEASUREMENT_ACCURACY_250_V_OPEN
 24.003  HEAD         MEG OHM MEASUREMENT ACCURACY: 250 V, Open
 24.004  TARGET       -p
 24.005  MATH         SAFEON("UUT", "250 V", "")
 24.006  MESS         Press and hold the TEST button.
 24.006  MESS
 24.007  EVAL   -s "Open" : Is UUT displaying ">1000" ?
 25.001  MESS
 25.002  DISP         Release the TEST button.
 25.003  MATH         SAFEOFF("UUT")
 25.004  JMPL         MEG_OHM_VOLTAGE_SOURCE_ACCURACY_250_V

 25.005  LABEL        MEG_OHM_MEASUREMENT_ACCURACY_500_V_OPEN
 25.006  HEAD         MEG OHM MEASUREMENT ACCURACY: 500 V, Open
 25.007  TARGET       -p
 25.008  MATH         SAFEON("UUT", "500 V", "")
 25.009  MESS         Press and hold the TEST button.
 25.009  MESS
 25.010  EVAL   -s "Open" : Is UUT displaying ">2000" ?
 26.001  MESS
 26.002  DISP         Release the TEST button.
 26.003  MATH         SAFEOFF("UUT")
 26.004  JMPL         MEG_OHM_VOLTAGE_SOURCE_ACCURACY_500_V

 26.005  LABEL        MEG_OHM_MEASUREMENT_ACCURACY_1000_V_OPEN
 26.006  HEAD         MEG OHM MEASUREMENT ACCURACY: 1000 V, Open
 26.007  TARGET
 26.008  MATH         SAFEON("UUT", "1000 V", "")
 26.009  MESS         Press and hold the TEST button.
 26.009  MESS
 26.010  EVAL   -s "Open" : Is UUT displaying ">4000" ?
 27.001  MESS
 27.002  DISP         Release the TEST button.
 27.003  MATH         SAFEOFF("UUT")
 27.004  JMPL         MEG_OHM_VOLTAGE_SOURCE_ACCURACY_1000_V

 27.005  LABEL        MEG_OHM_VOLTAGE_SOURCE_ACCURACY_250_V
 27.006  RSLT         =
 27.007  RSLT         =MEG OHM VOLTAGE SOURCE ACCURACY
 27.008  RSLT         =
 27.009  HEAD         MEG OHM VOLTAGE SOURCE ACCURACY: 250 V
 27.010  TARGET
 27.011  5320         Mode = HR; Resistance = 1 MOhm
 27.011  5320         +TestVoltage = 250 V; Setup
 27.012  5320         Mode = HR; Resistance = 1 MOhm
 27.012  5320         +TestVoltage = 250 V; Operate
 27.013  MATH         SAFEON("UUT", "250 V", "")
 27.014  DISP         Press and hold UUT TEST button.
 27.015  5320         Mode = HR; Resistance = 1 MOhm
 27.015  5320         +TestVoltage = 250 V; Read
 27.016  DISP         Release the TEST button.
 27.017  MATH         SAFEOFF("UUT")
 27.018  EVAL   -e  (MEM >= 250) && (MEM <= 300) : [32][MEM] V
 28.001  JMPL         MEG_OHM_MEASUREMENT_ACCURACY_500_V_250_kOhm

 28.002  LABEL        MEG_OHM_VOLTAGE_SOURCE_ACCURACY_500_V
 28.003  TARGET
 28.004  5320         Mode = HR; Resistance = 1 MOhm
 28.004  5320         +TestVoltage = 500 V; Setup
 28.005  5320         Mode = HR; Resistance = 1 MOhm
 28.005  5320         +TestVoltage = 500 V; Operate
 28.006  MATH         SAFEON("UUT", "500 V", "")
 28.007  DISP         Press and hold UUT TEST button.
 28.008  5320         Mode = HR; Resistance = 1 MOhm
 28.008  5320         +TestVoltage = 500 V; Read
 28.009  DISP         Release the TEST button.
 28.010  MATH         SAFEOFF("UUT")
 28.011  EVAL   -e  (MEM >= 500) && (MEM <= 600) : [32][MEM] V
 29.001  JMPL         MEG_OHM_MEASUREMENT_ACCURACY_1000_V_250_kOhm

 29.002  LABEL        MEG_OHM_VOLTAGE_SOURCE_ACCURACY_1000_V
 29.003  TARGET
 29.004  5320         Mode = HR; Resistance = 1 MOhm
 29.004  5320         +TestVoltage = 1000 V; Setup
 29.005  5320         Mode = HR; Resistance = 1 MOhm
 29.005  5320         +TestVoltage = 1000 V; Operate
 29.006  MATH         SAFEON("UUT", "1000 V", "")
 29.007  DISP         Press and hold UUT TEST button.
 29.008  5320         Mode = HR; Resistance = 1 MOhm
 29.008  5320         +TestVoltage = 1000 V; Read
 29.009  DISP         Release the TEST button.
 29.010  MATH         SAFEOFF("UUT")
 29.011  EVAL   -e  (MEM >= 1000) && (MEM <= 1200) : [32][MEM] V

 30.001  HEAD
 30.002  5320         Reset
 30.003  DISP         Remove all connections.
 30.004  END
