﻿Copyright (c) (2014) Fluke Corporation.                  All rights reserved.
=============================================================================
INSTRUMENT:            Sub Fluke 714B (1 yr) mA Measure VER /8508,7526A,742A-1
DATE:                  2014-09-29 09:36:03
AUTHOR:                Fluke
REVISION:              $Revision: 9061 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       3
NUMBER OF LINES:       132
CONFIGURATION:         Fluke 8508A
CONFIGURATION:         Fluke 7526A
STANDARD:              Fluke 742A-1
=============================================================================
#
#  Procedure Author:
#        GMO
#
#  Model(s) Covered:
#        714B, 714C
#
#  Compatibility:
#        MET/CAL 8.1.4  or later
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  RSLT         =
  1.002  HEAD         {mA MEASUREMENT}
  1.003  RSLT         =
  1.004  HEAD         -2{24 mA Range}
  1.005  TARGET       -p
  1.006  DISP         Connect the UUT to the 8508A as follows:
  1.006  DISP
  1.006  DISP         [32] UUT                               8508A
  1.006  DISP         [32] MEASURE mA Black terminal ------> INPUT A
  1.006  DISP
  1.006  DISP         Connect the 7526A to the 8508A as follows:
  1.006  DISP
  1.006  DISP         [32] 7526A                             8508A
  1.006  DISP         [32] mA LO                     ------> INPUT LO
  1.006  DISP
  1.006  DISP         Connect the 7526A to the UUT as follows:
  1.006  DISP
  1.006  DISP         [32] UUT                               7526A
  1.006  DISP         [32] MEASURE mA Red terminal   ------> mA 100mA MAX
  1.007  TARGET       -m
# Setup meter to prevent 7526A compliance voltage error.
  1.008  8508         mA                                                N  2W
  1.009  7526A        +Current = 0.100 mA
  1.010  8508         0.100mA                                           N  2W
  1.011  MATH         M[1] = MEM
  1.012  MEMI         Enter UUT reading in milliamps.
  1.013  MATH         MEM1 = M[1]; M[1] = FMT( M[1], "%.3f")
  1.014  7526A        Standby
  1.015  MEMCX  24    mA             0.01% 0.002U

  2.001  DISP         Connect the [V @UutModel] to the 7526A as follows:
  2.001  DISP
  2.001  DISP         [32] [V @UutModel]                        7526A
  2.001  DISP         [32] MEASURE/LOOP COM terminal ------> mA LO
  2.001  DISP
  2.001  DISP         Connect the 8508A to the 742A-1 as follows:
  2.001  DISP
  2.001  DISP         [32] 8508A                             742A-1
  2.001  DISP         [32] INPUT HI                  ------> SENSE HI
  2.001  DISP         [32] INPUT LO                  ------> SENSE LO
  2.001  DISP
  2.001  DISP         Connect the 7526A to the 742A-1 as follows:
  2.001  DISP
  2.001  DISP         [32] 7526A                             742A-1
  2.001  DISP         [32] mA 100mA MAX              ------> CURRENT HI
  2.001  DISP
  2.001  DISP         Connect the [V @UutModel] to the 742A-1 as follows:
  2.001  DISP
  2.001  DISP         [32] [V @UutModel]                        742A-1
  2.001  DISP         [32] MEASURE/LOOP mA terminal  ------> CURRENT LO

  2.002  STD          Fluke 742A-1

  2.003  MATH         @ModelNum = "742A-1"; @ResStd = "Fluke 742A-1"
  2.004  MATH         Conf = CONF("Fluke 8508A")
  2.005  CALL         Sub Fluke 742A Check Ini File

  2.006  IF           @Error
  2.007  END
  2.008  ENDIF

  2.009  CALL         Sub Fluke 742A Check Cal Date

  2.010  IF           @Error
  2.011  END
  2.012  ENDIF

  2.013  CALL         Sub Fluke 742A Get Certified Value

  2.014  IF           @Error
  2.015  END
  2.016  ENDIF

  2.017  MATH         Resistance = BASE(@CertVal)

  2.018  M8508  RNGLK 200mV
  2.019  7526A        +Current = 20.00 mA
  2.020  8508         20.000mV                                          N  2W
  2.021  MATH         L[1] = REFACC() / Conf * 1E3 ; M[1] = MEM
# Accuracy of 8508A in ppm.
  2.022  MATH         L[1] = ((L[1] / MEM) * 1E6) * 2
# Accuracy of 742A-1 in ppm.
  2.023  MATH         L[2] = ACCV(@ResStd,"Stability",1) / @CertVal * 1E6
  2.024  MATH         L[3] = RSS_L(1,2)
  2.025  ACC    24    20.000mA       L3P%
  2.026  TARGET       -m
  2.027  MATH         MEM1 = M[1] / Resistance; MEM1 = FMT( MEM1, "%.3f")
  2.028  MEMI         Enter UUT reading in milliamps.
  2.029  7526A        Standby
  2.030  MEMCX  24    mA             0.01% 0.002U

  3.001  HEAD         -2
  3.002  HEAD
  3.003  8508         *                                                 S
  3.004  DISP         Remove all connections.
  3.005  END
