﻿Copyright (c) (2014) Fluke Corporation.                  All rights reserved.
=============================================================================
INSTRUMENT:            Sub Fluke 714B (1 yr) Type K Meas VER /7526
INSTRUMENT:            Sub Fluke 714B (1 yr) mV Meas VER /7526
INSTRUMENT:            Sub Fluke 714B (1 yr) Type K Src VER /7526
INSTRUMENT:            Sub Fluke 714B (1 yr) mV Src VER /7526
DATE:                  2014-09-29 16:17:59
AUTHOR:                Fluke
REVISION:              $Revision: 9064 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       19
NUMBER OF LINES:       228
CONFIGURATION:         Fluke 7526A
=============================================================================
#
#  Procedure Author(s):
#        GMO
#
#  Model(s) Covered:
#        714B, 714C
#
#  This procedure contains tests whose Test Uncertainty Ratios are less
#  than 4:1, based on 7526A (1 year) specifications.
#
#          THERMOCOUPLE MEASURE:
#                  0 °C;           TUR 3.0000
#
#          THERMOCOUPLE SOURCE:
#               -200 °C;           TUR 2.5000
#                  0 °C;           TUR 3.0000
#               1370 °C;           TUR 2.3100
#
#  Compatibility:
#        MET/CAL 8.1.2 or later
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  JMPL         TYPE_K_MEASURE               PSUBI("Type K Meas")
  1.002  JMPL         mV_MEASURE                   PSUBI("mV Meas")
  1.003  JMPL         TYPE_K_SOURCE                PSUBI("Type K Src")
  1.004  JMPL         mV_SOURCE                    PSUBI("mV Src")
  1.005  DISP         Subprocedure not found!
  1.006  END

  1.007  EVAL   Increment test number

# =====  Sub Fluke 714B (1 yr) Type K Meas VER /7526  ===========

  2.001  LABEL        TYPE_K_MEASURE
  2.002  RSLT         =
  2.003  HEAD         {THERMOCOUPLE MEASURE}
  2.004  RSLT         =
  2.005  HEAD         -2{Type K}
  2.006  TARGET       -p
  2.007  DISP         Connect [V @CalDev] TC terminals to the UUT using a
  2.007  DISP         Type K extension cable.
  2.008  DISP         Press UUT TC TYPE pusbutton to select TC TYPE
  2.008  DISP         Press UUT UP/DOWN keys until "TYPE K" is shown
  2.008  DISP         then press the UUT TC TYPE key again.
  2.009  DISP         Press the MEASURE/SOURCE key to select MEASURE.

  2.010  7526A        +Temperature = -180.0 degC; TC_Type = K; Apply
  2.011  TARGET       -m
  2.012  MEMI         Enter UUT reading in degrees Celsius:
  2.013  MEMCX  1370  -180.0degC     0.7U

  3.001  7526A        +Temperature = 0.0 degC; TC_Type = K; Apply
  3.002  TARGET       -m
  3.003  MEMI         Enter UUT reading in degrees Celsius:
  3.004  MEMCX  1370  0.0degC        0.3U

  4.001  7526A        +Temperature = 1300.0 degC; TC_Type = K; Apply
  4.002  TARGET       -m
  4.003  MEMI         Enter UUT reading in degrees Celsius:
  4.004  MEMCX  1370  1300.0degC     0.7U

  5.001  HEAD         -2
  5.002  HEAD
  5.003  7526A        Reset
  5.004  END

  5.005  EVAL   Increment test number

# =====  Sub Fluke 714B (1 yr) mV Meas VER /7526  ===============

  6.001  LABEL        mV_MEASURE
  6.002  RSLT         =
  6.003  HEAD         {THERMOCOUPLE MEASURE}
  6.004  RSLT         =
  6.005  HEAD         -2{mV Mode}
  6.006  TARGET       -p
  6.007  DISP         Press the MEASURE/SOURCE key to select MEASURE.
  6.008  TARGET       -m
  6.009  7526A        +Voltage = -9.500 mV; TC_Type = _1mVdegC; Apply
  6.010  TARGET       -m
  6.011  MEMI         Enter UUT reading in millivolts:
  6.012  MEMCX  75    -9.500mV       0.015% 0.010U

  7.001  7526A        +Voltage =  10.000 mV; TC_Type = _1mVdegC; Apply
  7.002  TARGET       -m
  7.003  MEMI         Enter UUT reading in millivolts:
  7.004  MEMCX  75    10.000mV       0.015% 0.010U

  8.001  7526A        +Voltage =  40.000 mV; TC_Type = _1mVdegC; Apply
  8.002  TARGET       -m
  8.003  MEMI         Enter UUT reading in millivolts:
  8.004  MEMCX  75    40.000mV       0.015% 0.010U

  9.001  7526A        +Voltage =  70.000 mV; TC_Type = _1mVdegC; Apply
  9.002  TARGET       -m
  9.003  MEMI         Enter UUT reading in millivolts:
  9.004  MEMCX  75    70.000mV       0.015% 0.010U

 10.001  HEAD         -2
 10.002  HEAD
 10.003  7526A        Reset
 10.004  END

 10.005  EVAL   Increment test number

# =====  Sub Fluke 714B (1 yr) Type K Src VER /7526  ============

 11.001  LABEL        TYPE_K_SOURCE
 11.002  RSLT         =
 11.003  HEAD         {THERMOCOUPLE SOURCE}
 11.004  RSLT         =
 11.005  HEAD         -2{Type K}
 11.006  MATH         NThrow = VGET("NTHROW")
 11.007  VSET         NTHROW = 1
 11.008  TARGET       -p
 11.009  DISP         Press the MEASURE/SOURCE key to select SOURCE.
 11.010  DISP         Use scroll keys to select -200.0 °C.
 11.011  7526A        Mode = TC_In
 11.011  7526A        +Temperature = -200.0 degC; TC_Type = K; Measure
 11.012  TARGET       -m
 11.013  7526A        Mode = TC_In
 11.013  7526A        +Temperature = -200.0 degC; TC_Type = K; Read
 11.014  MEMC   1370  -200.0degC     0.4U

 12.001  DISP         Use scroll keys to select 0 °C.
 12.002  7526A        Mode = TC_In
 12.002  7526A        +Temperature =    0.0 degC; TC_Type = K; Measure
 12.003  TARGET       -m
 12.004  7526A        Mode = TC_In
 12.004  7526A        +Temperature =    0.0 degC; TC_Type = K; Read
 12.005  MEMC   1370  0.0degC        0.3U

 13.001  DISP         Use scroll keys to select 1370 °C.
 13.002  7526A        Mode = TC_In
 13.002  7526A        +Temperature = 1370.0 degC; TC_Type = K; Measure
 13.003  TARGET       -m
 13.004  7526A        Mode = TC_In
 13.004  7526A        +Temperature = 1370.0 degC; TC_Type = K; Read
 13.005  MEMC   1370  1370.0degC     0.3U

 14.001  HEAD         -2
 14.002  HEAD
 14.003  7526A        Reset
 14.004  VSET         NTHROW = [V NThrow]
 14.005  END

 14.006  EVAL   Increment test number

# =====  Sub Fluke 714B (1 yr) mV Src VER /7526  ================

 15.001  LABEL        mV_SOURCE
 15.002  HEAD         {THERMOCOUPLE SOURCE}
 15.003  RSLT         =
 15.004  HEAD         -2{mV Mode}
 15.005  MATH         NThrow = VGET("NTHROW")
 15.006  VSET         NTHROW = 1
 15.007  TARGET       -p
 15.008  DISP         Connect [V @CalDev] TC terminals to the UUT using
 15.008  DISP         a copper extension cable.
 15.009  DISP         Press UUT TC TYPE pusbutton to select TC TYPE
 15.009  DISP         Press UUT UP/DOWN keys until "mV" is shown.
 15.009  DISP         then press the UUT TC TYPE key again.
 15.010  DISP         Press the MEASURE/SOURCE key to select SOURCE.
 15.011  DISP         Use scroll keys to select -9.500 mV.
 15.012  7526A        Mode = TC_In
 15.012  7526A        +Voltage = -9.500 mV; TC_Type = _1mVdegC; Measure
 15.013  TARGET       -m
 15.014  7526A        Mode = TC_In
 15.014  7526A        +Voltage = -9.500 mV; TC_Type = _1mVdegC; Read
 15.015  MEMC   75    -9.500mV       0.015% 0.010U

 16.001  DISP         Use scroll keys to select 10.00 mV.
 16.002  7526A        Mode = TC_In
 16.002  7526A        +Voltage =  10.000 mV; TC_Type = _1mVdegC; Measure
 16.003  TARGET       -m
 16.004  7526A        Mode = TC_In
 16.004  7526A        +Voltage =  10.000 mV; TC_Type = _1mVdegC; Read
 16.005  MEMC   75    10.000mV       0.015% 0.010U

 17.001  DISP         Use scroll keys to select 40.00 mV.
 17.002  7526A        Mode = TC_In
 17.002  7526A        +Voltage =  40.000 mV; TC_Type = _1mVdegC; Measure
 17.003  TARGET       -m
 17.004  7526A        Mode = TC_In
 17.004  7526A        +Voltage =  40.000 mV; TC_Type = _1mVdegC; Read
 17.005  MEMC   75    40.000mV       0.015% 0.010U

 18.001  DISP         Use scroll keys to select 70.00 mV.
 18.002  7526A        Mode = TC_In
 18.002  7526A        +Voltage =  70.000 mV; TC_Type = _1mVdegC; Measure
 18.003  TARGET       -m
 18.004  7526A        Mode = TC_In
 18.004  7526A        +Voltage =  70.000 mV; TC_Type = _1mVdegC; Read
 18.005  MEMC   75    70.000mV       0.015% 0.010U

 19.001  HEAD         -2
 19.002  HEAD
 19.003  7526A        Reset
 19.004  VSET         NTHROW = [V NThrow]
 19.005  END
