﻿Copyright (c) (2015) Fluke Corporation                      MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Fluke 742A Check Ini File
INSTRUMENT:            Sub Fluke 742A Check Cal Date
INSTRUMENT:            Sub Fluke 742A Get Certified Value
INSTRUMENT:            Sub Fluke 742A Get Accuracy in ppm @ 2 Sigma
DATE:                  2015-04-10 09:15:06
AUTHOR:                Fluke
REVISION:              $Revision: 10759 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       5
NUMBER OF LINES:       296
=============================================================================
#
#  Procedure Author:
#        DAC
#
#  Model(s) Covered:
#        742A Series Precision Resistors
#
#  Compatibility:
#        MET/CAL 7.20 SP1 (7.20x) or later
#
#  Subprocedures:
#        Sub RIF/WIF Directory
#        Sub RIF Error
#
#  Required Files:
#        None
#
#  Additional Equipment Required:
#        None
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  .ini File Name:
#        File Name must be of the form <model number>_<asset_number>.ini
#
#        Example:  742A-10M_9207.ini
#
#  .ini File Format:
#        File must have the following form:
#
#    [Date]
#    Cal = <yyyy>-<mm>-<dd>
#
#    [Ohms]
#    <model suffix> = <characterized value>
#
#  Example:
#    [Date]
#    Cal = 2007-05-22
#
#    [Ohms]
#    10M = 10.00008924 MOhm
#
#  Named variables
#    Input:
#      @ModelNum - 742A model number
#    Output:
#      @CertVal  - Certified value as a dimensioned string
#                  Use MATH FSC BASE functions to convert to ohms
#      @Error    - Error flag, 1 = Error occurred, 0 = Ok
#
#  Example Usage:
#
# 1.001  STD          Fluke 742A-10M
#
# 1.002  MATH         @ModelNum = "742A-10M"
# 1.003  CALL         Sub Fluke 742A Check Cal Date
#
# 1.004  IF           @Error
# 1.005  END
# 1.006  ENDIF
#
# 1.007  CALL         Sub Fluke 742A Get Certified Value
#
# 1.008  IF           @Error
# 1.009  END
# 1.010  ENDIF
#
# 1.011  MATH         Resistance = BASE(@CertVal)
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  JMPL         GET_ACCURACY                 PSUBI("Get Accuracy")

  1.002  MATH         @Error = 0
  1.003  MATH         AssetNumber = ASSET("Fluke " & @ModelNum)
  1.004  MATH         FileName = @ModelNum & "_" & AssetNumber & ".ini"
  1.005  CALL         Sub RIF/WIF Directory
  1.006  MATH         @IniFile = @RifWifDir & "\\" & FileName

  1.007  JMPL         CHECK_INI_FILE               PSUBI("Check Ini File")
  1.008  JMPL         CHECK_CAL_DATE               PSUBI("Check Cal Date")
  1.009  JMPL         GET_DATA                     PSUBI("Get Certified Val")
  1.010  DISP         Subprocedure not found!
  1.011  END

  1.012  EVAL   Increment step number

# =====  Sub Fluke 742A Check Ini File  ================================

  2.001  LABEL        CHECK_INI_FILE
  2.002  MATH         @Section = "Date"; @Parameter = "Cal"
  2.003  MATH         CalDateFile = RIF(@IniFile, @Section, @Parameter)
  2.004  MATH         CalDateDB   = CAL(AssetNumber, -1, 2301)

# Make sure lookup succeeded.
  2.005  IF           EMPTY(CalDateFile)
  2.006  OPBR         -z "[V FileName]" containing characterized resistance
  2.006  OPBR         does not exist in:
  2.006  OPBR
  2.006  OPBR         [32][V @RifWifDir]
  2.006  OPBR
  2.006  OPBR         Do you wish to create it?

  2.007  IF           NOT(MEM1)
  2.008  MATH         @Error = 1
  2.009  END
  2.010  ENDIF

# If cal date in .ini file matches cal date in database, exit.
  2.011  ELSEIF       ZCMPI(CalDateFile, CalDateDB)
  2.012  END
  2.013  ENDIF        ; EMPTY(CalDateFile)

  2.014  OPBR         -z Cal Date [V CalDateFile] in:
  2.014  OPBR
  2.014  OPBR         File Name:
  2.014  OPBR         [32][V FileName]
  2.014  OPBR
  2.014  OPBR         Located in Directory/Folder:
  2.014  OPBR         [32][V @RifWifDir]
  2.014  OPBR
  2.014  OPBR         is NOT the same as the database cal date
  2.014  OPBR         [V CalDateDB] for [V AssetNumber].
  2.014  OPBR
  2.014  OPBR         Do you wish to update the file?

  2.015  IF           NOT(MEM1)
  2.016  MATH         @Error = 1
  2.017  ENDIF

  2.018  HEAD         [V @ModelNum] CALIBRATION DATE

  2.019  IF           NOT(WIF(@IniFile, "Date", "Cal", CalDateDB))
  2.020  CALL         Sub WIF Error
  2.021  END
  2.022  ENDIF

  2.023  HEAD         [V @ModelNum] CERTIFIED VALUE

  2.024  IF           ZCMPI(@ModelNum, "742A-1")
  2.025  MATH         Nom = 1;      P = "1";    Unit = "ohm";     Sym = "Ohm"
  2.026  ELSEIF       ZCMPI(@ModelNum, "742A-1.9")
  2.027  MATH         Nom = 1.9;    P = "1.9";  Unit = "ohms";    Sym = "Ohm"
  2.028  ELSEIF       ZCMPI(@ModelNum, "742A-10")
  2.029  MATH         Nom = 10;     P = "10";   Unit = "ohms";    Sym = "Ohm"
  2.030  ELSEIF       ZCMPI(@ModelNum, "742A-100")
  2.031  MATH         Nom = 100;    P = "100";  Unit = "ohms";    Sym = "Ohm"
  2.032  ELSEIF       ZCMPI(@ModelNum, "742A-1k")
  2.033  MATH         Nom = 1E+3;   P = "1k";   Unit = "kilohms"; Sym = "kOhm"
  2.034  ELSEIF       ZCMPI(@ModelNum, "742A-10k")
  2.035  MATH         Nom = 10E+3;  P = "10k";  Unit = "kilohms"; Sym = "kOhm"
  2.036  ELSEIF       ZCMPI(@ModelNum, "742A-19k")
  2.037  MATH         Nom = 19E+3;  P = "19k";  Unit = "kilohms"; Sym = "kOhm"
  2.038  ELSEIF       ZCMPI(@ModelNum, "742A-100k")
  2.039  MATH         Nom = 100E+3; P = "100k"; Unit = "kilohms"; Sym = "kOhm"
  2.040  ELSEIF       ZCMPI(@ModelNum, "742A-1M")
  2.041  MATH         Nom = 1E+6;   P = "1M";   Unit = "megohms"; Sym = "MOhm"
  2.042  ELSEIF       ZCMPI(@ModelNum, "742A-10M")
  2.043  MATH         Nom = 10E+6;  P = "10M";  Unit = "megohms"; Sym = "MOhm"
  2.044  ELSEIF       ZCMPI(@ModelNum, "742A-19M")
  2.045  MATH         Nom = 19E+6;  P = "19M";  Unit = "megohms"; Sym = "MOhm"
  2.046  ENDIF

  2.047  MATH         LL = Nom - (Nom *0.10); UL = Nom + (Nom *0.10)

  2.048  DO

  2.049  DO
  2.050  MEMI         Enter certfied value in [V Unit]:
  2.051  MATH         MEM2 = MEM & " " & Sym
  2.052  MATH         MEM = BASE(MEM2)
  2.053  UNTIL        (MEM >= LL) && (MEM <= UL)

  2.054  OPBR         -z Certified Value: [MEM2]
  2.054  OPBR
  2.054  OPBR         Ok?
  2.055  MATH         Done = MEM1
  2.056  UNTIL        Done

  2.057  IF           NOT(WIF(@IniFile, "Ohms", P, MEM2))
  2.058  CALL         Sub WIF Error
  2.059  END
  2.060  ENDIF

  2.061  HEAD
  2.062  END

  2.063  EVAL   Increment step number

# =====  Sub Fluke 742A Check Cal Date  ================================

  3.001  LABEL        CHECK_CAL_DATE
  3.002  MATH         @Section = "Date"; @Parameter = "Cal"
  3.003  MATH         CalDateFile = RIF(@IniFile, @Section, @Parameter)

# Make sure lookup succeeded.
  3.004  IF           EMPTY(CalDateFile)
  3.005  CALL         Sub RIF Error
  3.006  END
  3.007  ENDIF

  3.008  MATH         CalDateDB = CAL(AssetNumber, -1, 2301)

  3.009  IF           NOT(ZCMPI(CalDateFile, CalDateDB))
  3.010  DISP         Cal Date [V CalDateFile] in:
  3.010  DISP
  3.010  DISP         File Name:
  3.010  DISP         [32][V FileName]
  3.010  DISP
  3.010  DISP         Located in Directory/Folder:
  3.010  DISP         [32][V @RifWifDir]
  3.010  DISP
  3.010  DISP         is NOT the same as the database cal date
  3.010  DISP         [V CalDateDB] for [V AssetNumber].
  3.011  MATH         @Error = 1
  3.012  ENDIF

  3.013  END

  3.014  EVAL   Increment step number

# =====  Sub Fluke 742A Get Certified Value  ===========================

  4.001  LABEL        GET_DATA
  4.002  MATH         @Section   = "Ohms"
  4.003  MATH         @Parameter = FLD(@ModelNum, 2, "-")
  4.004  MATH         @CertVal   = RIF(@IniFile, @Section, @Parameter)

# Make sure lookup succeeded.
  4.005  IF           EMPTY(@CertVal)
  4.006  CALL         Sub RIF Error
  4.007  END
  4.008  ENDIF

# Display the data to the operator if the validate flag is true.
  4.009  IF           ISVAR("@Validate")

  4.010  IF           @Validate
  4.011  OPBR         -z Certified value for Fluke [V @ModelNum]
  4.011  OPBR         [32]Asset: "[V AssetNumber]"
  4.011  OPBR
  4.011  OPBR         [32][V @CertVal]
  4.011  OPBR
  4.011  OPBR         Is this correct?

  4.012  IF           NOT(MEM1)
  4.013  DISP         Contact the MET/CAL Administrator to update:
  4.013  DISP         [V FileName].
  4.014  MATH         @Error = 1
  4.015  END
  4.016  ENDIF

  4.017  ENDIF        ; @Validate

  4.018  ENDIF        ; ISVAR(@Validate)

  4.019  END

  4.020  EVAL   Increment step number

# =====  Sub Fluke 742A Get Accuracy in ppm @ 2 Sigma  =================

  5.001  LABEL        GET_ACCURACY
  5.002  MATH         L[1] = BASE(@CertVal)
  5.003  MATH         L[2] = ACCV(@ModelNum, "UCal",      L[1]) / L[1] * 1E-6
  5.004  MATH         L[3] = ACCV(@ModelNum, "Stability", L[1]) / L[1] * 1E-6
  5.005  MATH         L[2] = L[2] / CONF(@ModelNum)
  5.006  MATH         L[3] = L[3] / SQRT(3)
  5.007  MATH         @742AccPPM2sigma = RSS_L(2, 3) * 2

  5.008  END
