﻿Copyright (c) (2014) Fluke Corporation.                  All rights reserved.
=============================================================================
INSTRUMENT:            Fluke 54 II B: (1 year) CAL VER /7526
DATE:                  2014-04-30 08:21:22
AUTHOR:                Fluke Corporation
REVISION:              $Revision: 8204 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       1
NUMBER OF LINES:       134
CONFIGURATION:         Fluke 7526A
=============================================================================
#
#  Procedure Author:
#        DAC
#
#  This procedure contains tests whose Test Uncertainty Ratios are less
#  than 4:1, based on 7526A 1 year specifications.
#
#           0 °C;           TUR 3.0000
#          23 °C;           TUR 3.1150
#
#  Source:
#        51, 52, 53, 54, Series II Thermometer Service Manual
#        PN 1276123 October 1999
#
#  Compatibility:
#        MET/CAL 8.0 or later
#
#  Additional Equipment Required:
#        Type K extension cable (1)
#        IR Interface Adapter, Fluke 53,54 only (2)
#        IR Cable Adapter Connector, Fluke 53,54 only (2)
#
#        1. Included in 5500A/LEADS, Lead Set
#        2. Only necessary if IR Communication Port is tested.
#           Included in MET/CAL-SERIAL, Closed Loop Procedure
#           Serial Connectivity Kit.
#
#  The Procedure was tested using:
#
#        Model No.    :
#        Serial No.   :
#        Options      :
#        Firmware Rev.:
#
#  The average run time during testing was 4 minutes.
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Precision Measurement.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  IF           0
  1.002  7526A        Reset
  1.003  ENDIF

  1.004  ASK-   R   Q N              P                                     V

  1.005  IF           NOT(VERSIONCHECK("8.0"))
  1.006  END
  1.007  ENDIF

  1.008  CALL         Sub Display Copyright
  1.009  CALL         Sub Select Failed Test Mode
  1.010  CALL         Sub Select Guardbanding & Ver Method (No NTHROW)

  1.011  OPBR         -z
  1.011  OPBR         Do you wish to include the IR communication port test?
  1.012  MATH         TestIRport = MEM1

  1.013  HEAD         EQUIPMENT REQUIREMENTS
  1.014  OPBR         -z Do you want to review the list of additional
  1.014  OPBR         equipment and/or accessories required?

  1.015  IF           MEM1
  1.016  DISP         The following additional equipment is required:
  1.016  DISP         - Type K extension cable (1)
  1.016  DISP
  1.016  DISP         1. Included in 5500A/LEADS, Lead Set

  1.017  IF           TestIRport
  1.018  DISP         - IR Interface Adapter (2)
  1.018  DISP         - IR Cable Adapter Connector (2)
  1.018  DISP
  1.018  DISP         2. Included in MET/CAL-SERIAL, Closed Loop Procedure,
  1.018  DISP         [32]  Serial Connectivity Kit.
  1.019  ENDIF

  1.020  ENDIF

  1.021  CALL         Sub Fluke 54 II Display Test
  1.022  CALL         Sub Fluke 50 Series II Keypad Test

  1.023  HEAD         TEMPERATURE
  1.024  OPBR         -z Is "TYPE K" displayed in the lower left-hand corner
  1.024  OPBR         of the UUT display?

  1.025  IF           NOT(MEM1)
  1.026  DISP         Press SETUP button.
  1.026  DISP         Press the down arrow button to select TYPE.
  1.026  DISP         Press ENTER button.
  1.026  DISP         Press up or down arrow key until "K" is flashing.
  1.026  DISP         Press ENTER button.
  1.026  DISP         Press SETUP button to exit Setup menu.
  1.027  ENDIF

  1.028  MATH         @ModelNum = 54

  1.029  DISP         Use C/F/K button to select °C if not already selected.
  1.030  MEM2         =T1
  1.031  CALL         Sub Fluke 50 Series II (1 yr) Temperature CAL VER /7526

  1.032  MEM2         =T2
  1.033  CALL         Sub Fluke 50 Series II (1 yr) Temperature CAL VER /7526

  1.034  IF           TestIRport
  1.035  DISP         Disconnect the 7526A from the UUT.
  1.036  CALL         Sub Fluke 53,54 II IR Communication Port Test
  1.037  ELSE
  1.038  RSLT         =
  1.039  RSLT         =IR Communication Port not tested.
  1.040  ENDIF

  1.041  END
