﻿© 2009 Fluke Corporation, All rights reserved               MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Fluke 53,54 II IR Communication Port Test
DATE:                  2009-06-19 14:22:12
AUTHOR:                Fluke Corporation
REVISION:              $Revision: 8204 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       2
NUMBER OF LINES:       75
=============================================================================
#
# Source:
#   51, 52, 53, 54, Series II Thermometer Service Manual
#   PN 1276123 October 1999
#
# Compatibility:
#   5500/CAL or MET/CAL 7.20 SP1 (7.20x) or later
#
# Subprocedures:
#   None
#
# Required Files:
#   None
#
# Special Equipment:
#   IR Interface Adapter (1)
#   IR Cable Adapter Connector (1)
#   DB9 (f) to DB9 (f) null modem and DB9 (m) to DB9 (m) gender changer
#     (only needed if UUT is connected to 5520A UUT Serial Port) (1)
#
#   1. Included in 5500A/LEADS, Lead Set
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON
  1.001  ASK-                        P                            F

  1.002  RSLT         =
  1.003  HEAD         {IR COMMUNICATION}
  1.004  TARGET
  1.005  MATH         MEM2 = INI("startup", "port")

  1.006  IF           ZCMPI(MEM2, "COM5520")
  1.007  DISP         Connect IR Interface Adapter to the port labeled
  1.007  DISP         "Serial 2 to UUT" on rear panel of 5520A, using null
  1.007  DISP         modem adapter, gender changer, and IR Cable Adapter
  1.007  DISP         Connector.
  1.007  DISP
  1.007  DISP         The adapters must be screwed to the 5520A to insure
  1.007  DISP         electrical contact.
  1.008  ELSE
  1.009  DISP         Connect the IR Interface Adapter to [MEM2] using
  1.009  DISP         IR Cable Adapter Connector.
  1.010  ENDIF

  1.011  DO
  1.012  DISP         Press the yellow button <SHIFT> and then RECALL.
  1.013  OPBR         Is the UUT displaying "Ir SEnd"?
  1.014  UNTIL        MEM1 > 0

  1.015  IF           @ModelNum == 53
  1.016  MATH         ExpectedResponse = "FLUKE 53-II"
  1.017  ELSE
  1.018  MATH         ExpectedResponse = "FLUKE 54-II"
  1.019  ENDIF

  1.020  DISP         Position the meter so that the IR Interface Adapter is
  1.020  DISP         directed at the top of the UUT.
  1.021  PORT         [P9600,N,8,1,N][T5000]
  1.021  PORT         ID[13][I!][I$]
  1.022  EVAL   -e FIND(MEM2, ExpectedResponse, 1) : [MEM2]

  2.001  END
