﻿Copyright (c) (2014) Fluke Corporation.                  All rights reserved.
=============================================================================
INSTRUMENT:            Fluke 8845A: (1 yr) VER IEEE /5730,5725,FGEN
DATE:                  2014-03-05 14:19:19
AUTHOR:                Fluke
REVISION:              $Revision: 8204 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       1
NUMBER OF LINES:       176
CONFIGURATION:         Fluke 5730A
CONFIGURATION:         Fluke 5725A
CONFIGURATION:         Function Generator
=============================================================================
#
#  Procedure Author:
#        DAC, DFM, VY
#
#  This procedure contains the following tests whose Test Uncertainty Ratios
#  are less than 4:1.
#
#        AC VOLTAGE
#               - Range 100 mV: 100 mV,  10  Hz; TUR 2.22
#               - Range 1    V:   1  V,  10  Hz; TUR 2.57
#               - Range 10   V:  10  V,  10  Hz; TUR 2.57
#               - Range 750  V: 320  V,  50 kHz; TUR 3.74
#               - Range 750  V: 320  V, 100 kHz; TUR 3.23
#
#  Source:
#        Fluke 8845A/8846A Digital Multimeter Calibration Manual
#        January 2007, Rev. 1, 11/07
#
#        Fluke 8845A/8846A Digital Multimeter Calibration Manual Supplement
#        Revision/Date: 1, 11/07, Supplement Issue: 5, Issue Date: 4/10
#
#  Compatibility:
#        MET/CAL 8.2.3 or later
#
#  Additional Equipment Required:
#        See "Sub Fluke 8845A/46A VER Required Equipment"
#
#  The Procedure was tested using:
#
#        Model No.    : 8845A
#        Serial No.   : 9248040
#        Options      :
#        Firmware Rev.: 09/07/06-13:00
#
#       The average run time during testing was 40 minutes.
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  ASK-   R   Q N              P                            A        V

# The following statements are included to force the main procedure header to
# include CONFIGURATION lines for the references used in the subprocedures.
  1.002  IF           0
  1.003  5730A        +Voltage = 320 V; Frequency = 50 kHz; Boost = On
  1.004  IEEE         [@FGEN]
  1.005  ENDIF

  1.006  IF           NOT(VERSIONCHECK("8.2.3"))
  1.007  END
  1.008  ENDIF

  1.009  CALL         Sub Display Copyright
  1.010  CALL         Sub High Voltage Safety Warning

  1.011  HEAD         PRELIMINARY INSTRUCTIONS
  1.012  DISP         Prior to beginning calibration, a warm-up time of
  1.012  DISP         60 minutes (minimum), in an environment of 23±2 °C
  1.012  DISP         and relative humidity of less than 80 % must
  1.012  DISP         have been allowed to elapse.
  1.012  DISP
  1.012  DISP         Additionally, the UUT must have acclimated to the
  1.012  DISP         ambient conditions of the test environment for at
  1.012  DISP         least two hours.

  1.013  DISP         Ensure sufficient warmup time has elapsed for all
  1.013  DISP         test equipment. Refer to their individual operating
  1.013  DISP         and/or service manuals for warmup specifications.

  1.014  CALL         Sub Select Failed Test Mode
  1.015  CALL         Sub Select Guardbanding & Ver Method

  1.016  HEAD         COMMUNICATION SETUP
  1.017  TARGET
  1.018  CALL         Sub Fluke 8845A/46A Setup IEEE

  1.019  MATH         @UUT_Manufacturer = "Fluke"
  1.020  MATH         @UUT_Model        = "8845A"
  1.021  CALL         Sub Fluke 8845A/46A Chk Identification IEEE
  1.022  JMPL         END                          @Abort

  1.023  CLEAR        -c Sub Fluke 8845A/46A Check/Set Fluke 45 Emulation IEEE

  1.024  HEAD         EQUIPMENT REQUIREMENTS
  1.025  OPBR         -z Do you want to REVIEW the list of additional
  1.025  OPBR         equipment and/or accessories required?

  1.026  IF           MEM1
  1.027  CALL         Sub Fluke 8845A/46A VER Required Equipment
  1.028  ENDIF

  1.029  MATH         @FrontRearSwitch = "Front"
  1.030  CALL         Sub 8845A/DMM4040 (1 yr) DCV VER IEEE /5730
  1.031  JMPL         AC_VOLTS

  1.032  LABEL        DC_RATIO

  1.033  IF           @NewSW
  1.034  CALL         Sub 8845A/DMM4040 (1 yr) DC Ratio VER IEEE /5730
  1.035  ENDIF

  1.036  JMPL         FREQUENCY

  1.037  LABEL        AC_VOLTS
  1.038  CALL         Sub 8845A/46A,DMM4040/4050 (1 yr) ACV VER IEEE/5730,25
  1.039  JMPL         4W_OHMS

  1.040  LABEL        FREQUENCY
  1.041  CALL         Sub Fluke 8845A/46A (1 yr) Frequency VER IEEE /FGEN
  1.042  JMPL         OPTIONAL_TESTS

  1.043  LABEL        4W_OHMS
  1.044  CALL         Sub 8845A/46A,DMM4040/4050 (1 yr) 4W Ohms VER IEEE/5730
  1.045  JMPL         DC_CURRENT

  1.046  LABEL        2W_OHMS
  1.047  CALL         Sub 8845A/46A,DMM4040/4050 (1 yr) 2W Ohms VER IEEE/5730
  1.048  JMPL         DC_RATIO

  1.049  LABEL        OPTIONAL_TESTS
  1.050  OPBR         -z There are two kinds of optional tests in this
  1.050  OPBR         procedure:
  1.050  OPBR
  1.050  OPBR         1. 2X4 Test Lead Verification Steps verifies the UUT
  1.050  OPBR         operation with the TL2X4W-PT 2X4-Wire Test Leads.
  1.050  OPBR
  1.050  OPBR         2. Rear Panel Terminal Verification Steps verifies the
  1.050  OPBR         UUT operation through the rear-panel input terminals.
  1.050  OPBR
  1.050  OPBR         Do you want to perform these OPTIONAL tests?

  1.051  IF           MEM1
  1.052  CALL         Sub 8845A/46A,DMM4040/4050 (1 yr) Opt VER IEEE /5730
  1.053  ENDIF

  1.054  JMPL         END

  1.055  LABEL        DC_CURRENT
  1.056  CALL         Sub 8845A/46A,DMM4040/4050 (1 yr) DCI VER IEEE /5730
  1.057  CALL         Sub 8845A/46A,DMM4040/4050 (1 yr) DCI VER IEEE/5730,25
  1.058  CALL         Sub 8845A/46A,DMM4040/4050 (1 yr) ACI VER IEEE /5730
  1.059  CALL         Sub 8845A/46A,DMM4040/4050 (1 yr) ACI VER IEEE/5730,25
  1.060  JMPL         2W_OHMS

  1.061  LABEL        END

  1.062  IF           @Abort
  1.063  HEAD         V E R I F I C A T I O N   A B O R T E D !
  1.064  ENDIF

  1.065  END
