﻿Copyright (c) (2013) Fluke Corporation.                  All rights reserved.
=============================================================================
INSTRUMENT:            Sub Get Frequency Accuracy /FGEN
INSTRUMENT:            Sub Get DC Amplitude Accuracy /FGEN
INSTRUMENT:            Sub Get AC Amplitude Accuracy /FGEN
INSTRUMENT:            Sub Get Frequency Accuracy (base units) /FGEN
INSTRUMENT:            Sub Get DC Amplitude Accuracy (base units) /FGEN
INSTRUMENT:            Sub Get AC Amplitude Accuracy (base units) /FGEN
DATE:                  2013-09-27 09:18:44
AUTHOR:                Fluke
REVISION:              $Revision: 4480 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       4
NUMBER OF LINES:       362
=============================================================================
#
#  Procedure Author:
#        DAC, DFM
#
#  Compatibility:
#        MET/CAL 7.2 or later
#
#  Subprocedures:
#        None
#
#  Required Files:
#        user_config_instr.ini
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
#  Example Usage:
#    See "sub_driver_fgen.txt".
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  JMPL         GET_FREQ_ACCURACY            PSUBI("Get Frequency")
  1.002  JMPL         GET_DC_AMPL_ACCURACY         PSUBI("Get DC Amplitude")
  1.003  JMPL         GET_AC_AMPL_ACCURACY         PSUBI("Get AC Amplitude")
  1.004  DISP         Subprocedure not found!
  1.005  END

  1.006  EVAL   Increment step number

#======= Sub Get Frequency Accuracy /FGEN ====================================

  2.001  LABEL        GET_FREQ_ACCURACY
  2.002  MATH         FreqBase = BASE(@FGEN_Freq)
  2.003  MATH         AmplBase = BASE(@FGEN_Ampl)
  2.004  MATH         ModeStr  = RINF(@FGEN_DevName, "ModeStringHz")

# If no mode string was found, try adding the waveform mnemonic.
  2.005  IF           EMPTY(ModeStr)

  2.006  IF           ZCMPI(@FGEN_Waveform, "Sine")
  2.007  MATH         Lookup = "ModeStringHzSine"
  2.008  ELSEIF       ZCMPI(@FGEN_Waveform, "Square")
  2.009  MATH         Lookup = "ModeStringHzSquare"
  2.010  ELSEIF       ZCMPI(@FGEN_Waveform, "Triangle")
  2.011  MATH         Lookup = "ModeStringHzTriangle"
  2.012  ELSEIF       ZCMPI(@FGEN_Waveform, "PosRamp")
  2.013  MATH         Lookup = "ModeStringHzRamp"
  2.014  ELSEIF       ZCMPI(@FGEN_Waveform, "NegRamp")
  2.015  MATH         Lookup = "ModeStringHzRamp"
  2.016  ELSEIF       ZCMPI(@FGEN_Waveform, "ExpRise")
  2.017  MATH         Lookup = "ModeStringHzRamp"
  2.018  ELSEIF       ZCMPI(@FGEN_Waveform, "ExpFall")
  2.019  MATH         Lookup = "ModeStringHzExp"
  2.020  ELSEIF       ZCMPI(@FGEN_Waveform, "Cardiac")
  2.021  MATH         Lookup = "ModeStringHzExp"
  2.022  ELSEIF       ZCMPI(@FGEN_Waveform, "Sync")
  2.023  MATH         Lookup = "ModeStringHzSync"
  2.024  ENDIF

  2.025  MATH         ModeStr  = RINFE(@FGEN_DevName, Lookup)
  2.026  ENDIF

  2.027  MATH         Acc = ACCV2(@FGEN_DevName, ModeStr, FreqBase, AmplBase)
  2.028  MATH         Confidence = VGET("CONF")

# VGET query returns empty string if CONF is set to default (2).
  2.029  IF           EMPTY(Confidence)
  2.030  MATH         Confidence = 2
  2.031  ENDIF

  2.032  MATH         @FGEN_Acc = (Acc / CONF(@FGEN_DevName)) * Confidence

# Convert to specified units of ACC nominal, e.g., GHz.
  2.033  IF           NOT(PSUBI("base units"))
  2.034  MATH         @FGEN_Acc = @FGEN_Acc / PSCALE(@FGEN_Freq)
  2.035  ENDIF

  2.036  END

  2.037  EVAL   Increment step number

#======= Sub Get DC Amplitude Accuracy /FGEN =================================

  3.001  LABEL        GET_DC_AMPL_ACCURACY
  3.002  MATH         AmplBase = BASE(@FGEN_Ampl)
  3.003  MATH         ModeStr = RINFE(@FGEN_DevName, "ModeStringVdc")

  3.004  IF           NOT(EMPTY(@FGEN_Imp)) && NOT(ZCMPI(@FGEN_Imp, "OC"))
  3.005  MATH         Imp = BASE(@FGEN_Imp)
  3.006  MATH         Lookup = "ModeStringLoad" & Imp & "Z"
  3.007  MATH         LoadStr = RINFE(@FGEN_DevName, Lookup)
  3.008  MATH         ModeStr = ModeStr & " " & LoadStr
  3.009  ENDIF

  3.010  MATH         Acc = ACCV(@FGEN_DevName, ModeStr, AmplBase)
  3.011  MATH         Confidence = VGET("CONF")

  3.012  IF           EMPTY(Confidence)
  3.013  MATH         Confidence = 2
  3.014  ENDIF

  3.015  MATH         @FGEN_Acc = (Acc / CONF(@FGEN_DevName)) * Confidence

# Convert to specified units of ACC nominal, e.g., mV.
  3.016  IF           NOT(PSUBI("base units"))
  3.017  MATH         @FGEN_Acc = @FGEN_Acc / PSCALE(@FGEN_Ampl)
  3.018  ENDIF

  3.019  END

  3.020  EVAL   Increment step number

#======= Sub Get AC Amplitude Accuracy /FGEN =================================

  4.001  LABEL        GET_AC_AMPL_ACCURACY

  4.002  IF           ZCMPI(@FGEN_Waveform, "Sine")
  4.003  MATH         Waveform = "Sine"
  4.004  ELSEIF       ZCMPI(@FGEN_Waveform, "Square")
  4.005  MATH         Waveform = "Square"
  4.006  ELSEIF       ZCMPI(@FGEN_Waveform, "Triangle")
  4.007  MATH         Waveform = "Triangle"
  4.008  ELSEIF       ZCMPI(@FGEN_Waveform, "PosRamp")
  4.009  MATH         Waveform = "Ramp"
  4.010  ELSEIF       ZCMPI(@FGEN_Waveform, "NegRamp")
  4.011  MATH         Waveform = "Ramp"
  4.012  ELSEIF       ZCMPI(@FGEN_Waveform, "ExpRise")
  4.013  MATH         Waveform = "Exp"
  4.014  ELSEIF       ZCMPI(@FGEN_Waveform, "ExpFall")
  4.015  MATH         Waveform = "Exp"
  4.016  ELSEIF       ZCMPI(@FGEN_Waveform, "Cardiac")
  4.017  MATH         Waveform = "Cardiac"
  4.018  ELSEIF       ZCMPI(@FGEN_Waveform, "Sinc")
  4.019  MATH         Waveform = "Sinc"
  4.020  ELSEIF       ZCMPI(@FGEN_Waveform, "Noise")
  4.021  MATH         Waveform = "Noise"
  4.022  ENDIF

  4.023  MATH         AmplBase  = BASE(@FGEN_Ampl)
  4.024  MATH         ProcUnits = UNIT(@FGEN_Ampl)

  4.025  IF           ZCMPI(ProcUnits, "V")
  4.026  MATH         ProcUnits = "Vrms"
  4.027  ENDIF

# Determine the available amplitude specifications (Vp, Vpp, or Vrms).
  4.028  MATH         LookupStr = "ModeStringVp" & Waveform
  4.029  MATH         ModeStrVp = RINF(@FGEN_DevName, LookupStr)

  4.030  MATH         LookupStr = "ModeStringVpp" & Waveform
  4.031  MATH         ModeStrVpp = RINF(@FGEN_DevName, LookupStr)

  4.032  MATH         LookupStr = "ModeStringVrms" & Waveform
  4.033  MATH         ModeStrVrms = RINF(@FGEN_DevName, LookupStr)

# If FGEN is spec'd in the same units as the procedure, use the specs.
# Otherwise, see if the FGEN is spec'd in units that can be converted to
# the units in the procedure.
  4.034  IF           ZCMPI(ProcUnits, "Vp")

  4.035  IF           NOT(EMPTY(ModeStrVp))
  4.036  MATH         ModeStr = ModeStrVp;   AccUnits = "Vp"
  4.037  ELSEIF       NOT(EMPTY(ModeStrVpp))
  4.038  MATH         ModeStr = ModeStrVpp;  AccUnits = "Vpp"
  4.039  ELSEIF       NOT(EMPTY(ModeStrVrms))
  4.040  MATH         ModeStr = ModeStrVrms; AccUnits = "V"
  4.041  ENDIF

  4.042  ELSEIF       ZCMPI(ProcUnits, "Vpp")

  4.043  IF           NOT(EMPTY(ModeStrVpp))
  4.044  MATH         ModeStr = ModeStrVpp;  AccUnits = "Vpp"
  4.045  ELSEIF       NOT(EMPTY(ModeStrVp))
  4.046  MATH         ModeStr = ModeStrVp;   AccUnits = "Vp"
  4.047  ELSEIF       NOT(EMPTY(ModeStrVrms))
  4.048  MATH         ModeStr = ModeStrVrms; AccUnits = "V"
  4.049  ENDIF

  4.050  ELSEIF       ZCMPI(ProcUnits, "Vrms")

  4.051  IF           NOT(EMPTY(ModeStrVrms))
  4.052  MATH         ModeStr = ModeStrVrms; AccUnits = "V"
  4.053  ELSEIF       NOT(EMPTY(ModeStrVpp))
  4.054  MATH         ModeStr = ModeStrVpp;  AccUnits = "Vpp"
  4.055  ELSEIF       NOT(EMPTY(ModeStrVp))
  4.056  MATH         ModeStr = ModeStrVp;   AccUnits = "Vp"
  4.057  ENDIF

  4.058  ENDIF

# If necessary, convert amplitude to units specified in the accuracy file.
  4.059  IF           NOT(ZCMPI(AccUnits, ProcUnits))
  4.060  MATH         NoConversion = 0

  4.061  IF           ZCMPI(ProcUnits, "Vp")  && ZCMPI(AccUnits, "Vpp")
  4.062  MATH         AmplBase = AmplBase * 2.0
  4.063  ELSEIF       ZCMPI(ProcUnits, "Vpp") && ZCMPI(AccUnits, "Vp")
  4.064  MATH         AmplBase = AmplBase / 2.0
  4.065  ELSEIF       ZCMPI(ProcUnits, "Vp")  && ZCMPI(AccUnits, "Vrms")

  4.066  IF           ZCMPI(Waveform, "Sine")
  4.067  MATH         AmplBase = AmplBase / SQRT(2)
  4.068  ELSEIF       ZCMPI(Waveform, "Square")
#                     1:1
  4.069  ELSEIF       ZCMPI(Waveform, "Triangle") || ZCMPI(Waveform, "Ramp")
  4.070  MATH         AmplBase = AmplBase / 1.73205081
  4.071  ELSE
  4.072  MATH         NoConversion = 1
  4.073  ENDIF        ; ZCMPI(Waveform, "Sine")

  4.074  ELSEIF       ZCMPI(ProcUnits, "Vpp") && ZCMPI(AccUnits, "Vrms")

  4.075  IF           ZCMPI(Waveform, "Sine")
  4.076  MATH         AmplBase = (AmplBase / 2.0) / SQRT(2)
  4.077  ELSEIF       ZCMPI(Waveform, "Square")
  4.078  MATH         AmplBase = (AmplBase / 2.0)
  4.079  ELSEIF       ZCMPI(Waveform, "Triangle") || ZCMPI(Waveform, "Ramp")
  4.080  MATH         AmplBase = (AmplBase / 2.0) / 1.73205081
  4.081  ELSE
  4.082  MATH         NoConversion = 1
  4.083  ENDIF        ; ZCMPI(Waveform, "Sine")

  4.084  ELSEIF       ZCMPI(ProcUnits, "Vrms")  && ZCMPI(AccUnits, "Vp")

  4.085  IF           ZCMPI(Waveform, "Sine")
  4.086  MATH         AmplBase = AmplBase * SQRT(2)
  4.087  ELSEIF       ZCMPI(Waveform, "Square")
#                     1:1
  4.088  ELSEIF       ZCMPI(Waveform, "Triangle") || ZCMPI(Waveform, "Ramp")
  4.089  MATH         AmplBase = AmplBase * 1.73205081
  4.090  ELSE
  4.091  MATH         NoConversion = 1
  4.092  ENDIF        ; ZCMPI(Waveform, "Sine")

  4.093  ELSEIF       ZCMPI(ProcUnits, "Vrms")  && ZCMPI(AccUnits, "Vpp")

  4.094  IF           ZCMPI(Waveform, "Sine")
  4.095  MATH         AmplBase = AmplBase * SQRT(2) * 2.0
  4.096  ELSEIF       ZCMPI(Waveform, "Square")
  4.097  MATH         AmplBase = AmplBase * 2.0
  4.098  ELSEIF       ZCMPI(Waveform, "Triangle") || ZCMPI(Waveform, "Ramp")
  4.099  MATH         AmplBase = AmplBase * 1.73205081 * 2.0
  4.100  ELSE
  4.101  MATH         NoConversion = 1
  4.102  ENDIF        ; ZCMPI(Waveform, "Sine")

  4.103  ENDIF        ; ZCMPI(ProcUnits, "Vpp") && ZCMPI(AccUnits, "Vp")

  4.104  IF           NoConversion
  4.105  HEAD         FGEN ACCURACY ERROR
  4.106  DISP         Flexible Driver "FGEN".
  4.106  DISP
  4.106  DISP         Amplitude units in the procedure are "[V ProcUnits]".
  4.106  DISP         However, the accuracy file for [V @FGEN_DevName]
  4.106  DISP         does not contain amplitude specs in these units, and
  4.106  DISP         there is no conversion for [V @FGEN_Waveform] waveform.
  4.107  END
  4.108  ENDIF

  4.109  ENDIF        ; NOT(ZCMPI(AccUnits, ProcUnits))

# If an output impedance is specified, add "<impedance>Z" to mode string.
  4.110  IF           NOT(EMPTY(@FGEN_Imp)) && NOT(ZCMPI(@FGEN_Imp, "OC"))
  4.111  MATH         Imp = BASE(@FGEN_Imp)
  4.112  MATH         Lookup = "ModeStringLoad" & Imp & "Z"
  4.113  MATH         LoadStr = RINFE(@FGEN_DevName, Lookup)
  4.114  MATH         ModeStr = ModeStr & " " & LoadStr
  4.115  ENDIF

  4.116  IF           ZCMPI(@FGEN_Waveform, "Noise")
  4.117  MATH         Acc = ACCV(@FGEN_DevName, ModeStr, AmplBase)
  4.118  ELSE
  4.119  MATH         FreqBase = BASE(@FGEN_Freq)
  4.120  MATH         Acc = ACCV2(@FGEN_DevName, ModeStr, AmplBase, FreqBase)
  4.121  ENDIF

# If necessary, convert accuarcy to units specified in the procedure.
  4.122  IF           NOT(ZCMPI(AccUnits, ProcUnits))

  4.123  IF           ZCMPI(AccUnits, "Vpp")  && ZCMPI(ProcUnits, "Vp")
  4.124  MATH         Acc = Acc / 2.0
  4.125  ELSEIF       ZCMPI(AccUnits, "Vp")   && ZCMPI(ProcUnits, "Vpp")
  4.126  MATH         Acc = Acc * 2.0
  4.127  ELSEIF       ZCMPI(AccUnits, "Vrms") && ZCMPI(ProcUnits, "Vp")

  4.128  IF           ZCMPI(Waveform, "Sine")
  4.129  MATH         Acc = Acc * SQRT(2)
  4.130  ELSEIF       ZCMPI(Waveform, "Triangle") || ZCMPI(Waveform, "Ramp")
  4.131  MATH         Acc = Acc * 1.73205081
  4.132  ENDIF

  4.133  ELSEIF       ZCMPI(AccUnits, "Vrms") && ZCMPI(ProcUnits, "Vpp")

  4.134  IF           ZCMPI(Waveform, "Sine")
  4.135  MATH         Acc = Acc * SQRT(2)
  4.136  ELSEIF       ZCMPI(Waveform, "Triangle") || ZCMPI(Waveform, "Ramp")
  4.137  MATH         Acc = Acc * 1.73205081
  4.138  ENDIF

  4.139  MATH         Acc = Acc * 2.0

  4.140  ELSEIF       ZCMPI(AccUnits, "Vp")   && ZCMPI(ProcUnits, "Vrms")

  4.141  IF           ZCMPI(Waveform, "Sine")
  4.142  MATH         Acc = Acc / SQRT(2)
  4.143  ELSEIF       ZCMPI(Waveform, "Triangle") || ZCMPI(Waveform, "Ramp")
  4.144  MATH         Acc = Acc / 1.73205081
  4.145  ENDIF        ; ZCMPI(Waveform, "Sine")

  4.146  ELSEIF       ZCMPI(AccUnits, "Vpp")  && ZCMPI(ProcUnits, "Vrms")

  4.147  MATH         Acc = Acc / 2.0

  4.148  IF           ZCMPI(Waveform, "Sine")
  4.149  MATH         Acc = Acc / SQRT(2)
  4.150  ELSEIF       ZCMPI(Waveform, "Triangle") || ZCMPI(Waveform, "Ramp")
  4.151  MATH         Acc = Acc / 1.73205081
  4.152  ENDIF

  4.153  ENDIF        ; ZCMPI(ProcUnits, "Vpp") && ZCMPI(AccUnits, "Vp")

  4.154  ENDIF        ; NOT(ZCMPI(AccUnits, ProcUnits))

  4.155  MATH         Confidence = VGET("CONF")

  4.156  IF           EMPTY(Confidence)
  4.157  MATH         Confidence = 2
  4.158  ENDIF

  4.159  MATH         @FGEN_Acc = (Acc / CONF(@FGEN_DevName)) * Confidence

# Convert to specified units of ACC nominal, e.g., mVpp.
  4.160  IF           NOT(PSUBI("base units"))
  4.161  MATH         @FGEN_Acc = @FGEN_Acc / PSCALE(@FGEN_Ampl)
  4.162  ENDIF

  4.163  END
