﻿Copyright (c) (2013) Fluke Corporation.                  All rights reserved.
=============================================================================
INSTRUMENT:            Sub Initialize /FGEN
INSTRUMENT:            Sub Reset /FGEN
INSTRUMENT:            Sub Output Off /FGEN
INSTRUMENT:            Sub Setup /FGEN
INSTRUMENT:            Sub Apply /FGEN
DATE:                  2013-09-26 07:55:06
AUTHOR:                Fluke
REVISION:              $Revision: 4494 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       5
NUMBER OF LINES:       825
=============================================================================
#
#  Procedure Author:
#        DAC, DFM
#
#  Compatibility:
#        MET/CAL 7.2 or later
#
#  Subprocedures:
#        Sub Send Command /FGEN
#
#  Required Files:
#        user_config_instr.ini
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
#  Parameters        Values
#  ----------------  -------------------------------------------------------
#  @FGEN_Waveform    DC | Sine | Square | Triangle | PosRamp | NegRamp |
#                    ExpRise | ExpFall | Cardiac | Sync | Noise
#
#  @FGEN_Imp         OC | <NR3>[][<prefix>]Ohm
#
#  @FGEN_Polarity    Normal | Inverted
#
#  @FGEN_Freq        <NR3>[][<prefix>]Hz
#
#  @FGEN_Period      <NR3>[][<prefix>]s
#
#  @FGEN_Ampl        <NR3>[][<prefix>]V || <NR3>[][<prefix>]Vp |
#                    <NR3>[][<prefix>]Vpp | <NR3>[]dBm
#
#  @FGEN_DC_Offset   <NR3>[][<prefix>]V
#
#  @FGEN_DutyCycle   <NR3>[][<prefix>]%
#
#  @FGEN_ModFreq     <NR3>[][<prefix>]Hz
#
#  @FGEN_ModSrc      Int | Ext
#
#  @FGEN_ExtCpl      AC | DC
#
#  @FGEN_AM          On | Off
#
#  @FGEN_AM_Depth    <NR3>[]%
#
#  @FGEN_FM          On | Off
#
#  @FGEN_FM_Dev      <NR3>[][<prefix>]Hz
#
#  @FGEN_PM          On | Off
#
#  @FGEN_PM_Dev      <NR3>[][<prefix>]rad
#
#  @FGEN_FSK         On | Off
#
#  @FGEN_FSK_Rate*   <NR3>[][<prefix>]Hz
#
#  @FGEN_Sweep       On | Off
#
#  @FGEN_StartFreq   <NR3>[][<prefix>]Hz
#
#  @FGEN_StopFreq    <NR3>[][<prefix>]Hz
#
#  @FGEN_SweepTime   <NR3>[][<prefix>]s
#
#  @FGEN_SweepMode*  Lin | Log
#
#  @FGEN_SweepStart  Single | Cont
#
#  @FGEN_TrigType*   FreeRun | Line | Ext
#
#   *Optional. If omitted, instrument default used.
#
#  Example Usage
#
#    Initialize Function Generator parameters
#
#      CALL         Sub Initialize /FGEN
#
#  Frequency Evaluation:
#
#      MATH         @FGEN_Waveform = "Sine"
#      MATH         @FGEN_Imp      = "50Ohm"
#      MATH         @FGEN_Ampl     = "1V"
#      MATH         @FGEN_Freq     = "10Hz"
#      TARGET       -p
#      CALL         Sub Reset /FGEN
#      SCPI         FUNC "FREQ";:FREQ:APER 1
#      DISP         Connect [V @FGEN_DevName] [V @FGEN_Output] to the
#      DISP         UUT INPUT HI and LO using a BNC cable, a 50 Ohm feed
#      DISP         through terminator, and a BNC to dual banana adapter.
#      CALL         Sub Apply /FGEN
#      WAIT         -t 5 System settling ...
#      CALL         Sub Get Frequency Accuracy /FGEN
#      MATH         L[1] = @FGEN_Acc
#      ACC          10.00000H      L1U
#      TARGET       -m
#      SCPI         INIT;*TRG;FETCH?[I]
#      MEMCX        10.00000H      0.00300U      1V
#
#      CALL         Sub Output Off /FGEN
#
#  Period Evaluation:
#
#      MATH         @FGEN_Waveform = "Sine"
#      MATH         @FGEN_Imp      = "50Ohm"
#      MATH         @FGEN_Ampl     = "1V"
#  Specify AC component in period for programming FGEN.
#      MATH         @FGEN_Period   = "100ms"
#  Specify AC component in frequency for "Sub Get Frequency Accuracy /FGEN".
#      MATH         @FGEN_Freq     = "10Hz"
#      TARGET       -p
#      CALL         Sub Reset /FGEN
#      SCPI         FUNC "FREQ";:FREQ:APER 1
#      DISP         Connect [V @FGEN_DevName] [V @FGEN_Output] to the
#      DISP         UUT INPUT HI and LO using a BNC cable, a 50 Ohm feed
#      DISP         through terminator, and a BNC to dual banana adapter.
#      CALL         Sub Apply /FGEN
#      WAIT         -t 5 System settling ...
#  Get FGEN accuracy in frequency and convert to percent.
#      CALL         Sub Get Frequency Accuracy (base units) /FGEN
#      MATH         L[1] = @FGEN_Acc / BASE(@FGEN_Freq) * 100
#      ACC          100.0000ms     L1%
#      TARGET       -m
#      SCPI         INIT;*TRG;FETCH?[I]
#      MEMCX        100.0000ms     3.0000U       1V
#
#      CALL         Sub Output Off /FGEN
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  JMPL         INITIALIZE                   PSUBI("Initialize")
  1.002  JMPL         RESET                        PSUBI("Reset")
  1.003  JMPL         OUTPUT_OFF                   PSUBI("Output Off")
  1.004  JMPL         APPLY                        PSUBI("Setup")
  1.005  JMPL         APPLY                        PSUBI("Apply")
  1.006  DISP         Subprocedure not found!
  1.007  END

  1.008  EVAL   Increment step number

# =====  Initialize  ========================================================

  2.001  LABEL        INITIALIZE

# Get and store:
#
#   device name
#   programming section name for looking up programming codes in .ini file.
#   FSC used for IEEE-488 I/O
#   Connection terminal names
  2.002  MATH         @FGEN_DevName = INSTR("FGEN")
  2.003  MATH         @FGEN_ProgSecName = RINFE(@FGEN_DevName, "ProgSecName")
  2.004  MATH         @FGEN_FSC = RINFE(@FGEN_ProgSecName, "FSC")
  2.005  MATH         @FGEN_Output = RINFE(@FGEN_ProgSecName, "Output")

# Initialize parameters to the empty string (unset).
  2.006  MATH         @FGEN_Waveform   = ""
  2.007  MATH         @FGEN_Imp        = ""
  2.008  MATH         @FGEN_Polarity   = ""
  2.009  MATH         @FGEN_Freq       = ""
  2.010  MATH         @FGEN_Period     = ""
  2.011  MATH         @FGEN_Ampl       = ""
  2.012  MATH         @FGEN_DC_Offset  = ""
  2.013  MATH         @FGEN_DutyCycle  = ""
  2.014  MATH         @FGEN_ModFreq    = ""
  2.015  MATH         @FGEN_ModSrc     = ""
  2.016  MATH         @FGEN_ExtCpl     = ""
  2.017  MATH         @FGEN_AM         = ""
  2.018  MATH         @FGEN_AM_Depth   = ""
  2.019  MATH         @FGEN_FM         = ""
  2.020  MATH         @FGEN_FM_Dev     = ""
  2.021  MATH         @FGEN_PM         = ""
  2.022  MATH         @FGEN_PM_Dev     = ""
  2.023  MATH         @FGEN_FSK        = ""
  2.024  MATH         @FGEN_FSK_Rate   = ""
  2.025  MATH         @FGEN_Sweep      = ""
  2.026  MATH         @FGEN_StartFreq  = ""
  2.027  MATH         @FGEN_StopFreq   = ""
  2.028  MATH         @FGEN_SweepTime  = ""
  2.029  MATH         @FGEN_SweepMode  = ""
  2.030  MATH         @FGEN_SweepStart = ""
  2.031  MATH         @FGEN_TrigType   = ""

# Get programming string for RESET FSC.
  2.032  MATH         ResetCmd = RINF(@FGEN_ProgSecName, "ResetFSC")

# If RESET_FSC is defined, establish the RESET FSC.
  2.033  IF           NOT(EMPTY(ResetCmd))

  2.034  IF           ZCMPI(ResetCmd, "[SDC]")
  2.035  RESET        [@FGEN][SDC]
  2.036  ELSE
  2.037  RESET        [@FGEN][V ResetCmd]
  2.038  ENDIF

  2.039  ENDIF

  2.040  END

  2.041  EVAL   Increment step number

# =====  Reset  =============================================================

  3.001  LABEL        RESET
  3.002  MATH         @FGEN_Cmd = RINFE(@FGEN_ProgSecName, "Reset")
  3.003  CALL         Sub Send Command /FGEN
  3.004  END

  3.005  EVAL   Increment step number

# =====  Output_Off  ========================================================

  4.001  LABEL        OUTPUT_OFF
  4.002  MATH         @FGEN_Cmd = RINF(@FGEN_ProgSecName, "OutputOff")

# If "Output_Off" is defined, send the command.
  4.003  IF           NOT(EMPTY(@FGEN_Cmd))
  4.004  CALL         Sub Send Command /FGEN
  4.005  ENDIF

  4.006  END

  4.007  EVAL   Increment step number

# =====  Apply  =============================================================

  5.001  LABEL        APPLY

# -----  Waveform  ------------------

  5.002  MATH         @FGEN_Cmd = RINFE(@FGEN_ProgSecName, @FGEN_Waveform)
  5.003  CALL         Sub Send Command /FGEN

# -----  Output Impedance  ----------

  5.004  IF           NOT(EMPTY(@FGEN_Imp))

# Check if requested impedance is an Open Circuit.
  5.005  IF           ZCMPI(@FGEN_Imp, "OC")
  5.006  MATH         ImpType = "ImpInfinity"

  5.007  ELSE         ; Not Open Circuit.

# Get desired output impedance in base units.
  5.008  MATH         Imp = BASE(@FGEN_Imp)
# Check function generator for fixed output impedance.
  5.009  MATH         FixedImp = RINF(@FGEN_ProgSecName, "ImpFixed")

  5.010  IF           NOT(EMPTY(FixedImp))

# Terminate if the fixed impedance is not the desired impedance.
  5.011  IF           BASE(FixedImp) != Imp
  5.012  DISP         [V @FGEN_DevName] has a [V FixedImp] fixed output
  5.012  DISP         impedance.  The requested output impedance is
  5.012  DISP         [V @FGEN_Imp].
  5.012  DISP
  5.012  DISP         Select "Terminate" to terminate this procedure,
  5.012  DISP         then configure a suitable FGEN model and re-start.
  5.013  END
  5.014  ENDIF        ; Terminate on unmatched fixed impedance.

  5.015  MATH         ImpType = "ImpFixed"
  5.016  ELSE         ; Impedance is not fixed.
  5.017  MATH         ImpType = "Imp"
  5.018  ENDIF

  5.019  ENDIF        ; Fixed output impedance checks.

# If not fixed impedance, get the command and send it to the instrument.
  5.020  IF           NOT(ZCMPI(ImpType, "ImpFixed"))
  5.021  MATH         @FGEN_Cmd = RINFE(@FGEN_ProgSecName, ImpType)

  5.022  IF           ZCMPI(ImpType, "Imp")
  5.023  MATH         @FGEN_Cmd = REPL("<val>", Imp, @FGEN_Cmd)
  5.024  ENDIF

  5.025  CALL         Sub Send Command /FGEN
  5.026  ENDIF        ; Not fixed output impedance

  5.027  ENDIF        ; Output Impedance

# -----  Output Polarity  -----------

  5.028  IF           NOT(EMPTY(@FGEN_Polarity))

  5.029  IF           ZCMPI(@FGEN_Polarity, "Norm")
  5.030  MATH         Polarity = "PolarityNormal"
  5.031  ELSE
  5.032  MATH         Polarity = "PolarityInverted"
  5.033  ENDIF

  5.034  MATH         @FGEN_Cmd = RINFE(@FGEN_ProgSecName, Polarity)
  5.035  CALL         Sub Send Command /FGEN
  5.036  ENDIF        ; Output Polarity

# -----  Amplitude  -----------------

  5.037  MATH         Ampl = BASE(@FGEN_Ampl); Units = UNIT(@FGEN_Ampl)

# -----  DC Signal Amplitude  -------

  5.038  IF           ZCMPI(@FGEN_Waveform, "DC")
# First see if there is a specific DC amplitude command.
  5.039  MATH         AmplCmd = RINF(@FGEN_ProgSecName, "Ampl_VDC")

# If not, see if there is a DC command.
  5.040  IF           EMPTY(AmplCmd)
  5.041  MATH         AmplCmd = RINFE(@FGEN_ProgSecName, "DC_Offset")
  5.042  ENDIF

# -----  AC Signal Amplitude  -------

  5.043  ELSE

  5.044  IF           ZCMPI(Units, "dBm")

# If the amplitude is negative and there is a discrete command for
#    negative dBm and the, use the discrete command.
# Otherwise if the amplitude is positive and there is a discrete
#    command for positive dBm, use the discrete command.
# Otherwise use the general command.
  5.045  IF           Ampl < 0
  5.046  MATH         AmplCmd = RINF(@FGEN_ProgSecName, "Ampl_dBmNeg")
  5.047  MATH         Ampl = ABS(Ampl)
  5.048  ELSE
  5.049  MATH         AmplCmd = RINF(@FGEN_ProgSecName, "Ampl_dBmPos")
  5.050  ENDIF

  5.051  IF           EMPTY(@FGEN_Cmd)
  5.052  MATH         AmplCmd = RINFE(@FGEN_ProgSecName, "Ampl_dBm")
  5.053  ENDIF

  5.054  ELSEIF       ZCMPI(Units, "V")
  5.055  MATH         AmplCmd = RINFE(@FGEN_ProgSecName, "Ampl_Vrms")
  5.056  ELSEIF       ZCMPI(Units, "Vp")
  5.057  MATH         AmplCmd = RINF(@FGEN_ProgSecName, "Ampl_Vp")

# If there is no Vp command see if there is a Vpp command.
  5.058  IF           EMPTY(AmplCmd)
  5.059  MATH         AmplCmd = RINFE(@FGEN_ProgSecName, "Ampl_Vpp")
  5.060  MATH         Sine     = ZCMPI(@FGEN_Waveform, "Sine")
  5.061  MATH         Square   = ZCMPI(@FGEN_Waveform, "Square")
  5.062  MATH         Triangle = ZCMPI(@FGEN_Waveform, "Triangle")

# Convert Vp to Vpp for sine, square, and triangle waveforms.
  5.063  IF           Sine || Square || Triangle
  5.064  MATH         Ampl = Ampl * 2
  5.065  ENDIF

  5.066  ENDIF        ; No Vp command

  5.067  ELSEIF       ZCMPI(Units, "Vpp")
  5.068  MATH         AmplCmd = RINF(@FGEN_ProgSecName, "Ampl_Vpp")

# If there is no Vpp command see if there is a Vp command.
  5.069  IF           EMPTY(AmplCmd)
  5.070  MATH         AmplCmd = RINFE(@FGEN_ProgSecName, "Ampl_Vp")
  5.071  MATH         Sine     = ZCMPI(@FGEN_Waveform, "Sine")
  5.072  MATH         Square   = ZCMPI(@FGEN_Waveform, "Square")
  5.073  MATH         Triangle = ZCMPI(@FGEN_Waveform, "Triangle")

# Convert Vpp to Vp for sine, square, and triangle waveforms.
  5.074  IF           Sine || Square || Triangle
  5.075  MATH         Ampl = Ampl / 2
  5.076  ENDIF

  5.077  ENDIF        ; No Vpp command

  5.078  ENDIF        ; Units = dBm

  5.079  ENDIF        ; IF DC

  5.080  MATH         @FGEN_Cmd = REPL("<val>", Ampl, AmplCmd)
  5.081  CALL         Sub Send Command /FGEN

# If NOT DCV, parameters are applicable.
  5.082  IF           NOT(ZCMPI(@FGEN_Waveform, "DC"))

# -----  DC Offset  -----------------

  5.083  IF           NOT(EMPTY(@FGEN_DC_Offset))
  5.084  MATH         DC_Offset = BASE(@FGEN_DC_Offset)

# If DC offset is not 0 V, there must be a command, therefore use RINFE.
# Otherwise, a DC offset command is optional.  0 V offset is the presumed
# default.

  5.085  IF           DC_Offset != 0.0
  5.086  MATH         DC_OffsetCmd = RINFE(@FGEN_ProgSecName, "DC_Offset")
  5.087  ELSE
  5.088  MATH         DC_OffsetCmd = RINF(@FGEN_ProgSecName, "DC_Offset")
  5.089  ENDIF

  5.090  IF           NOT(EMPTY(DC_OffsetCmd))
  5.091  MATH         @FGEN_Cmd = REPL("<val>", DC_Offset, DC_OffsetCmd)
  5.092  CALL         Sub Send Command /FGEN
  5.093  ENDIF

  5.094  ENDIF        ; IF  DC Offset

# -----  Duty Cycle  ----------------

  5.095  IF           NOT(EMPTY(@FGEN_DutyCycle))
  5.096  MATH         DutyCycle = BASE(@FGEN_DutyCycle)

# If duty cycle is not 50 %, there must be a command, therefore use RINFE.
# Otherwise, a duty cycle command is optional.  50 % duty cycle is the
# presumed default.

  5.097  IF           DutyCycle != 50.0
  5.098  MATH         DutyCycleCmd = RINFE(@FGEN_ProgSecName, "DutyCycle")
  5.099  ELSE
  5.100  MATH         DutyCycleCmd = RINF(@FGEN_ProgSecName, "DutyCycle")
  5.101  ENDIF

  5.102  IF           NOT(EMPTY(DutyCycleCmd))
  5.103  MATH         @FGEN_Cmd = REPL("<val>", DutyCycle, DutyCycleCmd)
  5.104  CALL         Sub Send Command /FGEN
  5.105  ENDIF

  5.106  ENDIF        ; IF  Duty Cycle

# Check for sweep or CW.
  5.107  IF           ZCMP(@FGEN_Sweep, "On")
  5.108  MATH         StartFreq = BASE(@FGEN_StartFreq)
  5.109  MATH         StopFreq  = BASE(@FGEN_StopFreq)

# Check for Center Frequency and Frequency Span or Stop/Stop Frequency.
  5.110  MATH         CenterFreqCmd = RINF(@FGEN_ProgSecName, "CenterFreq")

  5.111  IF           EMPTY(CenterFreqCmd)

# -----  Start/Stop Frequency  ------

  5.112  MATH         StartFreqCmd = RINFE(@FGEN_ProgSecName, "StartFreq")
  5.113  MATH         @FGEN_Cmd = REPL("<val>", StartFreq, StartFreqCmd)
  5.114  CALL         Sub Send Command /FGEN
  5.115  MATH         StopFreqCmd = RINFE(@FGEN_ProgSecName, "StopFreq")
  5.116  MATH         @FGEN_Cmd = REPL("<val>", StopFreq, StopFreqCmd)
  5.117  CALL         Sub Send Command /FGEN
  5.118  ELSE

# -----  Center Frequency & Frequency Span  -------

# Compute center frequency  & frequency span.
  5.119  MATH         FreqSpan = StopFreq - StartFreq
  5.120  MATH         CenterFreq = FreqSpan / 2.0
# Note center frequency command was already retrieved above.
  5.121  MATH         @FGEN_Cmd = REPL("<val>", CenterFreq, CenterFreqCmd)
  5.122  CALL         Sub Send Command /FGEN
  5.123  MATH         FreqSpanCmd = RINFE(@FGEN_ProgSecName, "FreqSpan")
  5.124  MATH         @FGEN_Cmd = REPL("<val>", FreqSpan, FreqSpanCmd)
  5.125  CALL         Sub Send Command /FGEN
  5.126  ENDIF

# -----  Sweep Time  ----------------

# First see if there is a discrete command for the specified sweep time.
  5.127  MATH         SweepTimeCmd = RINF(@FGEN_ProgSecName, "SweepTime")

# If there is a sweep time command, send it now.  If there is no sweep time
# command it is not an error because the sweep time may be part of the sweep
# start command.
  5.128  IF           NOT(EMPTY(SweepTimeCmd))
  5.129  MATH         SweepTime = BASE(@FGEN_SweepTime)
  5.130  MATH         @FGEN_Cmd = REPL("<val>", SweepTime, SweepTimeCmd)
  5.131  CALL         Sub Send Command /FGEN
  5.132  ENDIF

# -----  Sweep Mode  ----------------

# First see if a sweep mode was specified.
  5.133  IF           NOT(EMPTY(@FGEN_SweepMode))

  5.134  IF           ZCMPI(@FGEN_SweepMode, "Log")
  5.135  MATH         SweepMode = "SweepLog"
  5.136  ELSE
  5.137  MATH         SweepMode = "SweepLin"
  5.138  ENDIF

  5.139  MATH         @FGEN_Cmd = RINFE(@FGEN_ProgSecName, SweepMode)
  5.140  CALL         Sub Send Command /FGEN
  5.141  ENDIF

# -----  Trigger Type  --------------

  5.142  IF           NOT(EMPTY(@FGEN_TrigType))

  5.143  IF           ZCMPI(@FGEN_TrigType, "FreeRun")
  5.144  MATH         TrigType = "Trig_reeRun"
  5.145  ELSEIF       ZCMPI(@FGEN_TrigType, "Line")
  5.146  MATH         TrigType = "TrigLine"
  5.147  ELSE
  5.148  MATH         TrigType = "TrigExt"
  5.149  ENDIF

  5.150  MATH         @FGEN_Cmd = RINFE(@FGEN_ProgSecName, TrigType)
  5.151  CALL         Sub Send Command /FGEN
  5.152  ENDIF

# Note Sweep Start is programmed following Output On.

# -----  Period  --------------------

  5.153  ELSEIF       NOT(EMPTY(@FGEN_Period))
  5.154  MATH         Period = BASE(@FGEN_Period);
  5.155  MATH         PeriodCmd = RINF(@FGEN_ProgSecName, "Period")

  5.156  IF           EMPTY(PeriodCmd)
  5.157  MATH         FreqCmd = RINFE(@FGEN_ProgSecName, "Freq")
  5.158  MATH         @FGEN_Cmd = REPL("<val>", (1.0 / Period), FreqCmd)
  5.159  ELSE
  5.160  MATH         @FGEN_Cmd = REPL("<val>", Period, PeriodCmd)
  5.161  ENDIF

  5.162  CALL         Sub Send Command /FGEN

# -----  Frequency  -----------------

  5.163  ELSEIF       NOT(EMPTY(@FGEN_Freq))
# Get the command string.
  5.164  MATH         FreqCmd = RINFE(@FGEN_ProgSecName, "Freq")
# Convert to base units and insert in programming string.
  5.165  MATH         @FGEN_Cmd = REPL("<val>", BASE(@FGEN_Freq), FreqCmd)

  5.166  CALL         Sub Send Command /FGEN
  5.167  ENDIF        ; Swept

# -----  AM  ------------------------

  5.168  IF           NOT(EMPTY(@FGEN_AM))
# Get the modulation source.
  5.169  IF           NOT(EMPTY(@FGEN_ModSrc))

  5.170  IF           ZCMPI(@FGEN_ModSrc, "Int")
  5.171  MATH         ModSrc = "AM_Int"
  5.172  ELSE

  5.173  IF           ZCMP(@FGEN_ExtCpl, "AC")
  5.174  MATH         ModSrc = "AM_ExtAC"
  5.175  ELSEIF       ZCMP(@FGEN_ExtCpl, "DC")
  5.176  MATH         ModSrc = "AM_ExtDC"
  5.177  ELSE
  5.178  MATH         ModSrc = "AM_Ext"
  5.179  ENDIF

  5.180  ENDIF

  5.181  MATH         @FGEN_Cmd = RINFE(@FGEN_ProgSecName, ModSrc)
  5.182  CALL         Sub Send Command /FGEN
  5.183  ENDIF        ; IF Modulation Source

# Get the Modulation Frequency.
  5.184  IF           NOT(EMPTY(@FGEN_ModFreq))
  5.185  MATH         ModFreq = BASE(@FGEN_ModFreq)
  5.186  MATH         @FGEN_Cmd = ""

# If the modulation frequency is 400 Hz and there is a discrete command
#   for 400 Hz, use the discrete command.
# Otherwise if modulation frequency is 1 kHz and there is a discrete
#   command for 1 kHz, use the discrete command.
# Otherwise use the general the command.
  5.187  IF           ModFreq == 400
  5.188  MATH         @FGEN_Cmd = RINF(@FGEN_ProgSecName, "AM_Int400Hz")
  5.189  ELSEIF       ModFreq == 1E+3
  5.190  MATH         @FGEN_Cmd = RINF(@FGEN_ProgSecName, "AM_Int1kHz")
  5.191  ENDIF

  5.192  IF           EMPTY(@FGEN_Cmd)
  5.193  MATH         ModFreqCmd = RINFE(@FGEN_ProgSecName, "AM_ModFreq")
  5.194  MATH         @FGEN_Cmd = REPL("<val>", ModFreq, ModFreqCmd)
  5.195  ENDIF

  5.196  CALL         Sub Send Command /FGEN
  5.197  ENDIF        ; IF Modulation Frequency

# Get the AM Depth.
  5.198  IF           NOT(EMPTY(@FGEN_AM_Depth))
  5.199  MATH         AM_DepthCmd = RINFE(@FGEN_ProgSecName, "AM_Depth")
  5.200  MATH         AM_Depth = BASE(@FGEN_AM_Depth)
  5.201  MATH         @FGEN_Cmd = REPL("<val>", AM_Depth, AM_DepthCmd)
  5.202  CALL         Sub Send Command /FGEN
  5.203  ENDIF        ; IF AM Depth

# Get the AM On programming command string.
  5.204  MATH         @FGEN_Cmd = RINFE(@FGEN_ProgSecName, "AM_ON")
  5.205  CALL         Sub Send Command /FGEN
  5.206  ENDIF        ; IF AM

# -----  FM  ------------------------

  5.207  IF           NOT(EMPTY(@FGEN_FM))
# Get the modulation source.
  5.208  MATH         S[28] = @FGEN_ModSrc

  5.209  IF           NOT(EMPTY(@FGEN_ModSrc))

  5.210  IF           ZCMPI(S[28], "Int")
  5.211  MATH         ModSrc = "FM_Int"
  5.212  ELSE

  5.213  IF           ZCMP(@FGEN_ExtCpl, "AC")
  5.214  MATH         ModSrc = "FM_ExtAC"
  5.215  ELSEIF       ZCMP(@FGEN_ExtCpl, "DC")
  5.216  MATH         ModSrc = "FM_ExtDC"
  5.217  ELSE
  5.218  MATH         ModSrc = "FM_Ext"
  5.219  ENDIF

  5.220  ENDIF

  5.221  MATH         @FGEN_Cmd = RINFE(@FGEN_ProgSecName, ModSrc)
  5.222  CALL         Sub Send Command /FGEN
  5.223  ENDIF        ; IF Modulation Source

# Get the Modulation Frequency.
  5.224  IF           NOT(EMPTY(@FGEN_ModFreq))
  5.225  MATH         ModFreq = BASE(@FGEN_ModFreq)
  5.226  MATH         @FGEN_Cmd = ""

# If the modulation frequency is 400 Hz and there is a discrete command
#   for 400 Hz, use the discrete command.
# Otherwise if modulation frequency is 1 kHz and there is a discrete
#   command for 1 kHz, use the discrete command.
# Otherwise use the general the command.
  5.227  IF           ModFreq == 400
  5.228  MATH         @FGEN_Cmd = RINF(@FGEN_ProgSecName, "FM_Int400Hz")
  5.229  ELSEIF       ModFreq == 1E+3
  5.230  MATH         @FGEN_Cmd = RINF(@FGEN_ProgSecName, "FM_Int1kHz")
  5.231  ENDIF

  5.232  IF           EMPTY(@FGEN_Cmd)
  5.233  MATH         ModFreqCmd = RINFE(@FGEN_ProgSecName, "FM_ModFreq")
  5.234  MATH         @FGEN_Cmd = REPL("<val>", ModFreq, ModFreqCmd)
  5.235  ENDIF

  5.236  CALL         Sub Send Command /FGEN
  5.237  ENDIF        ; IF Modulation Frequency

# Get the FM Deviation.
  5.238  IF           NOT(EMPTY(@FGEN_FM_Dev))
  5.239  MATH         FM_DevCmd = RINFE(@FGEN_ProgSecName, "FM_Dev")
  5.240  MATH         FM_Dev = BASE(@FGEN_FM_Dev)
  5.241  MATH         @FGEN_Cmd = REPL("<val>", FM_Dev, FM_DevCmd)
  5.242  CALL         Sub Send Command /FGEN
  5.243  ENDIF        ; IF FM Deviation

# Get the FM On programming command string.
  5.244  MATH         @FGEN_Cmd = RINFE(@FGEN_ProgSecName, "FM_ON")
  5.245  CALL         Sub Send Command /FGEN
  5.246  ENDIF        ; IF FM

# -----  Phase Modulation  ----------

  5.247  IF           NOT(EMPTY(@FGEN_PM))
# Get the Modulation Source.
  5.248  IF           NOT(EMPTY(@FGEN_ModSrc))

  5.249  IF           ZCMPI(@FGEN_ModSrc, "Int")
  5.250  MATH         ModSrc = "PM_Int"
  5.251  ELSE

  5.252  IF           ZCMP(@FGEN_ExtCpl, "AC")
  5.253  MATH         ModSrc = "PM_ExtAC"
  5.254  ELSEIF       ZCMP(@FGEN_ExtCpl, "DC")
  5.255  MATH         ModSrc = "PM_ExtDC"
  5.256  ELSE
  5.257  MATH         ModSrc = "PM_Ext"
  5.258  ENDIF

  5.259  ENDIF

  5.260  MATH         @FGEN_Cmd = RINFE(@FGEN_ProgSecName, ModSrc)
  5.261  CALL         Sub Send Command /FGEN
  5.262  ENDIF        ; IF Modulation Source

# Get the Modulation Frequency.
  5.263  IF           NOT(EMPTY(@FGEN_ModFreq))
  5.264  MATH         ModFreq = BASE(@FGEN_ModFreq)
  5.265  MATH         @FGEN_Cmd = ""

# If the modulation frequency is 400 Hz and there is a discrete command
#   for 400 Hz, use the discrete command.
# Otherwise if modulation frequency is 1 kHz and there is a discrete
#   command for 1 kHz, use the discrete command.
# Otherwise use the general the command.
  5.266  IF           ModFreq == 400
  5.267  MATH         @FGEN_Cmd = RINF(@FGEN_ProgSecName, "PM_Int400Hz")
  5.268  ELSEIF       ModFreq == 1E+3
  5.269  MATH         @FGEN_Cmd = RINF(@FGEN_ProgSecName, "PM_Int1kHz")
  5.270  ENDIF

  5.271  IF           EMPTY(@FGEN_Cmd)
  5.272  MATH         ModFreqCmd = RINFE(@FGEN_ProgSecName, "PM_ModFreq")
  5.273  MATH         @FGEN_Cmd = REPL("<val>", ModFreq, ModFreqCmd)
  5.274  ENDIF

  5.275  CALL         Sub Send Command /FGEN
  5.276  ENDIF        ; IF Modulation Frequency

# Get the Phase Deviation.
  5.277  IF           NOT(EMPTY(@FGEN_PM_Dev))
  5.278  MATH         PMDevCmd = RINFE(@FGEN_ProgSecName, "PM_Dev")
  5.279  MATH         PM_Dev = BASE(@FGEN_PM_Dev)
  5.280  MATH         @FGEN_Cmd = REPL("<val>", PM_Dev, PM_DevCmd)
  5.281  CALL         Sub Send Command /FGEN
  5.282  ENDIF        ; IF Phase Deviation

# Get the Phase Modulation On programming command string.
  5.283  MATH         @FGEN_Cmd = RINFE(@FGEN_ProgSecName, "PM_ON")
  5.284  CALL         Sub Send Command /FGEN
  5.285  ENDIF        ; IF PM

# -----  FSK Modulation  ------------

  5.286  IF           NOT(EMPTY(@FGEN_FSK))
# Get the Modulation Source.
  5.287  IF           NOT(EMPTY(@FGEN_ModSrc))

  5.288  IF           ZCMPI(@FGEN_ModSrc, "Int")
  5.289  MATH         ModSrc = "FSK_Int"
  5.290  ELSE
  5.291  MATH         ModSrc = "FSK_Ext"
  5.292  ENDIF

  5.293  MATH         @FGEN_Cmd = RINFE(@FGEN_ProgSecName, ModSrc)
  5.294  CALL         Sub Send Command /FGEN
  5.295  ENDIF        ; IF Modulation Source

# Get the Modulation Frequency.
  5.296  IF           NOT(EMPTY(@FGEN_ModFreq))
  5.297  MATH         ModFreq = BASE(@FGEN_ModFreq)
  5.298  MATH         @FGEN_Cmd = ""

# If the modulation frequency is 400 Hz and there is a discrete command
#   for 400 Hz, use the discrete command.
# Otherwise if modulation frequency is 1 kHz and there is a discrete
#   command for 1 kHz, use the discrete command.
# Otherwise use the general the command.
  5.299  IF           ModFreq == 400
  5.300  MATH         @FGEN_Cmd = RINF(@FGEN_ProgSecName, "FSK_Int400Hz")
  5.301  ELSEIF       ModFreq == 1E+3
  5.302  MATH         @FGEN_Cmd = RINF(@FGEN_ProgSecName, "FSK_Int1kHz")
  5.303  ENDIF

  5.304  IF           EMPTY(@FGEN_Cmd)
  5.305  MATH         ModFreqCmd = RINFE(@FGEN_ProgSecName, "FSK_ModFreq")
  5.306  MATH         @FGEN_Cmd = REPL("<val>", ModFreq, ModFreqCmd)
  5.307  ENDIF

  5.308  CALL         Sub Send Command /FGEN
  5.309  ENDIF        ; IF Modulation Frequency

# Get the FSK Rate.
  5.310  IF           NOT(EMPTY(@FGEN_FSK_Rate))
  5.311  MATH         FSK_RateCmd = RINFE(@FGEN_ProgSecName, "FSK_Rate")
  5.312  MATH         FSK_Rate = BASE(@FGEN_FSK_Rate)
  5.313  MATH         @FGEN_Cmd = REPL("<val>", FSK_Rate, FSK_RateCmd)
  5.314  CALL         Sub Send Command /FGEN
  5.315  ENDIF

# Turn FSK On.
  5.316  CALL         Sub Send Command /FGEN
  5.317  ENDIF        ; IF  FSK

  5.318  ENDIF        ; IF  NOT DC

  5.319  IF           PSUBI("Setup")
  5.320  END
  5.321  ENDIF

# -----  Output On  -----------------

# If "Output_On" is defined, send the command.
  5.322  MATH         @FGEN_Cmd = RINF(@FGEN_ProgSecName, "OutputOn")

  5.323  IF           NOT(EMPTY(@FGEN_Cmd))
  5.324  CALL         Sub Send Command /FGEN
  5.325  ENDIF

  5.326  IF           NOT(EMPTY(@FGEN_StartFreq))

# -----  Sweep Start  ---------------

  5.327  IF           NOT(EMPTY(@FGEN_SweepStart))

  5.328  IF           ZCMPI(@FGEN_SweepStart, "Single")
  5.329  MATH         SweepMode = "SweepSingle"
  5.330  ELSE
  5.331  MATH         SweepMode = "SweepCont"
  5.332  ENDIF

  5.333  MATH         @FGEN_Cmd = RINFE(@FGEN_ProgSecName, SweepMode)
  5.334  CALL         Sub Send Command /FGEN
  5.335  ENDIF

  5.336  ENDIF

  5.337  END
