﻿Fluke Calibration                                           MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Fluke 8845A/46A (1 yr) Frequency VER IEEE /FGEN
DATE:                  2014-03-06 09:54:32
AUTHOR:                Fluke
REVISION:              $Revision: 8204 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       5
NUMBER OF LINES:       108
=============================================================================
#
#  Procedure Author:
#        DAC, DFM, VY
#
#  Model(s) Covered:
#        8845A, 8846A, (Tektronix) DMM4040, (Tektronix) DMM4050
#
#  Source:
#        Fluke 8845A/8846A Digital Multimeter Calibration Manual
#        January 2007, Rev. 1, 11/07
#
#        Fluke 8845A/8846A Digital Multimeter Calibration Manual Supplement
#        Revision/Date: 1, 11/07, Supplement Issue: 5, Issue Date: 4/10
#
#  Compatibility:
#        MET/CAL 8.0 or later
#
#  Additional Equipment Required:
#        Cable, 50 Ω, BNC(m)-(m), Pomona 2249-C-36
#        BNC female to dual banana plug, Pomona 1269
#
#  The copyright for this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  CALL         Sub Initialize /FGEN

  1.002  RSLT         =
  1.003  HEAD         {FREQUENCY}
  1.004  RSLT         =
  1.005  HEAD         -2{20 Hz Range}
  1.006  MATH         @FGEN_Waveform = "Sine"
  1.007  MATH         @FGEN_Ampl     = "1V"
  1.008  MATH         @FGEN_Freq     = "10Hz"
  1.009  TARGET       -p
  1.010  CALL         Sub Reset /FGEN
  1.011  DISP         Connect [V @FGEN_DevName] [V @FGEN_Output] to
  1.011  DISP         UUT INPUT HI and LO using a BNC cable and a BNC to
  1.011  DISP         dual banana adapter.
  1.012  SCPI         FUNC "FREQ";:FREQ:APER 1;:VOLT:AC:BAND 3;RES MIN
  1.013  CALL         Sub Apply /FGEN
  1.014  WAIT         -t 3 System settling ...
  1.015  CALL         Sub Get Frequency Accuracy /FGEN
  1.016  MATH         L[1] = @FGEN_Acc
  1.017  ACC          10.00000Hz     L1U
  1.018  TARGET       -m
  1.019  SCPI         INIT;*TRG;FETCH?[I]
  1.020  MEMCX  20    10.00000Hz     0.03%

  2.001  RSLT         =
  2.002  HEAD         -2{200 Hz Range}
  2.003  MATH         @FGEN_Freq = "40Hz"
  2.004  TARGET       -p
  2.005  CALL         Sub Apply /FGEN
  2.006  WAIT         -t 3 System settling ...
  2.007  CALL         Sub Get Frequency Accuracy /FGEN
  2.008  MATH         L[1] = @FGEN_Acc
  2.009  ACC          40.0000Hz      L1U
  2.010  TARGET       -m
  2.011  SCPI         INIT;*TRG;FETCH?[I]
  2.012  MEMCX  200   40.0000Hz      0.01%

  3.001  RSLT         =
  3.002  HEAD         -2{1000 kHz Range}
  3.003  MATH         @FGEN_Freq = "300kHz"
  3.004  TARGET       -p
  3.005  CALL         Sub Apply /FGEN
  3.006  WAIT         -t 3 System settling ...
  3.007  CALL         Sub Get Frequency Accuracy /FGEN
  3.008  MATH         L[1] = @FGEN_Acc
  3.009  ACC          300.000kHz     L1U
  3.010  TARGET       -m
  3.011  SCPI         INIT;*TRG;FETCH?[I]
  3.012  MATH         MEM = MEM / 1E+3
  3.013  MEMCX  1000  300.000kHz     0.01%

  4.001  MATH         F8846A  = ZCMPI(@ModelNum, "8846A")
  4.002  MATH         DMM4040 = ZCMPI(@ModelNum, "DMM4040")
  4.003  MATH         DMM4050 = ZCMPI(@ModelNum, "DMM4050")

  4.004  IF           F8846A || DMM4040 || DMM4050
  4.005  MATH         @FGEN_Freq = "1000kHz"
  4.006  TARGET       -p
  4.007  CALL         Sub Apply /FGEN
  4.008  WAIT         -t 3 System settling ...
  4.009  CALL         Sub Get Frequency Accuracy /FGEN
  4.010  MATH         L[1] = @FGEN_Acc
  4.011  ACC          1000.000kHz    L1U
  4.012  TARGET       -m
  4.013  SCPI         INIT;*TRG;FETCH?[I]
  4.014  MATH         MEM = MEM / 1E+3
  4.015  MEMCX  1000  1000.000kHz    0.01%
  5.001  ENDIF

  5.002  HEAD         -2
  5.003  HEAD
  5.004  CALL         Sub Reset /FGEN
  5.005  END
