﻿Copyright (c) (2015) Fluke Corporation                      MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub 8845A/46A,DMM4040/4050 (1 yr) 4W Ohms VER IEEE/5730
INSTRUMENT:            Sub 8845A/46A,DMM4040/4050 (1 yr) 2W Ohms VER IEEE/5730
INSTRUMENT:            Sub 8845A/46A,DMM4040/4050 (1 yr) Opt VER IEEE /5730
INSTRUMENT:            Sub 8845A/46A,DMM4040/4050 (1 yr) DCI VER IEEE /5730
INSTRUMENT:            Sub 8845A/46A,DMM4040/4050 (1 yr) ACI VER IEEE /5730
DATE:                  2015-06-30 12:22:10
AUTHOR:                Fluke
REVISION:              $Revision: 12369 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       52
NUMBER OF LINES:       713
CONFIGURATION:         Fluke 5730A
=============================================================================
#
#  Procedure Author:
#        DAC, DFM, VY
#
#  Model(s) Covered:
#        8845A & 8846A, Tektronix DMM4040 & DMM4050
#
#  Source:
#        Fluke 8845A/8846A Digital Multimeter Calibration Manual
#        January 2007, Rev. 1, 11/07
#
#        Fluke 8845A/8846A Digital Multimeter Calibration Manual Supplement
#        Revision/Date: 1, 11/07, Supplement Issue: 5, Issue Date: 4/10
#
#  Compatibility:
#        MET/CAL 8.2.3 or later
#
#  Additional Equipment Required:
#        None
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  SCPI         *RST;TRIG:SOUR BUS

  1.002  JMPL         4_WIRE_RESISTANCE            PSUBI("4W Ohms")
  1.003  JMPL         2_WIRE_RESISTANCE            PSUBI("2W Ohms")
  1.004  JMPL         OPTIONAL_TESTS               PSUBI("Opt")
  1.005  JMPL         DC_CURRENT                   PSUBI("DCI")
  1.006  JMPL         AC_CURRENT                   PSUBI("ACI")
  1.007  DISP         Subprocedure not found!
  1.008  END

  1.009  EVAL   Increment test number

# ====== Sub 8845A/46A,DMM4040/4050 (1 yr) 4W Ohms VER IEEE/5730 ============

# It is assumed that the 5720A/5725A are already properly connected to the
# UUT at this time.

  2.001  LABEL        4_WIRE_RESISTANCE
  2.002  RSLT         =
  2.003  HEAD         {4-WIRE RESISTANCE}

  2.004  MATH         L[1] = ZCMPI(@ModelNum, "8846A")
  2.005  MATH         L[1] = ZCMPI(@ModelNum, "DMM4040") || L[1]
  2.006  MATH         L[1] = ZCMPI(@ModelNum, "DMM4050") || L[1]

  2.007  IF           L[1]
  2.008  RSLT         =
  2.009  HEAD         -2{10 Ω Range}
  2.010  FMT          CPT = %.5f
  2.011  TARGET       -p
  2.012  SCPI         FUNC "FRES";:FRES:RANG 10 OHM;NPLC 100
  2.013  5730A        UUT_Current = 5 mA
  2.013  5730A        +Resistance =  0.00000 Ohms; ExternalSense = On
  2.014  WAIT         -t 5 System settling ...
  2.015  TARGET       -m
  2.016  SCPI         INIT;*TRG;FETCH?[I]
  2.017  MEMCX  10    Z              0.01% 0.03/

  3.001  5730A        UUT_Current = 5 mA
  3.001  5730A        +Resistance = 10.00000 Ohms; ExternalSense = On
  3.002  WAIT         -t 5 System settling ...
  3.003  TARGET       -m
  3.004  SCPI         INIT;*TRG;FETCH?[I]
  3.005  MEMCX  10    Z              0.01% 0.03/
  4.001  ENDIF

  4.002  RSLT         =
  4.003  HEAD         -2{100 Ω Range}
  4.004  TARGET       -p
  4.005  SCPI         FUNC "FRES";:FRES:RANG 100 OHM;NPLC 100
  4.006  5730A        UUT_Current = 1 mA
  4.006  5730A        +Resistance =   0.0000 Ohms; ExternalSense = On
  4.007  WAIT         -t 3 System settling ...
  4.008  TARGET       -m
  4.009  SCPI         INIT;*TRG;FETCH?[I]
  4.010  MEMCX  100   Z              0.01% 0.004/

  5.001  5730A        UUT_Current = 1 mA
  5.001  5730A        +Resistance = 100.0000 Ohms; ExternalSense = On
  5.002  WAIT         -t 3 System settling ...
  5.003  TARGET       -m
  5.004  SCPI         INIT;*TRG;FETCH?[I]
  5.005  MEMCX  100   Z              0.01% 0.004/

  6.001  RSLT         =
  6.002  HEAD         -2{1 kΩ Range}
  6.003  TARGET       -p
  6.004  SCPI         FUNC "FRES";:FRES:RANG 1 KOHM;NPLC 100
  6.005  5730A        UUT_Current = 1 mA
  6.005  5730A        +Resistance = 0.000000 kOhm; ExternalSense = On
  6.006  WAIT         -t 3 System settling ...
  6.007  TARGET       -m
  6.008  SCPI         INIT;*TRG;FETCH?[I]
  6.009  MATH         MEM = MEM / 1E+3
  6.010  MEMCX  1     kZ             0.01% 0.001/

  7.001  5730A        UUT_Current = 1 mA
  7.001  5730A        +Resistance = 1.000000 kOhm; ExternalSense = On
  7.002  WAIT         -t 3 System settling ...
  7.003  TARGET       -m
  7.004  SCPI         INIT;*TRG;FETCH?[I]
  7.005  MATH         MEM = MEM / 1E+3
  7.006  MEMCX  1     kZ             0.01% 0.001/

  8.001  RSLT         =
  8.002  HEAD         -2{10 kΩ Range}
  8.003  TARGET       -p
  8.004  SCPI         FUNC "FRES";:FRES:RANG 10 KOHM;NPLC 100
  8.005  5730A        UUT_Current = 100 uA
  8.005  5730A        +Resistance =  0.00000 kOhms; ExternalSense = On
  8.006  WAIT         -t 3 System settling ...
  8.007  TARGET       -m
  8.008  SCPI         INIT;*TRG;FETCH?[I]
  8.009  MATH         MEM = MEM / 1E+3
  8.010  MEMCX  10    kZ             0.01% 0.001/

  9.001  5730A        UUT_Current = 100 uA
  9.001  5730A        +Resistance = 10.00000 kOhms; ExternalSense = On
  9.002  WAIT         -t 3 System settling ...
  9.003  TARGET       -m
  9.004  SCPI         INIT;*TRG;FETCH?[I]
  9.005  MATH         MEM = MEM / 1E+3
  9.006  MEMCX  10    kZ             0.01% 0.001/

 10.001  RSLT         =
 10.002  HEAD         -2{100 kΩ Range}
 10.003  TARGET       -p
 10.004  SCPI         FUNC "FRES";:FRES:RANG 100 KOHM;NPLC 100
 10.005  5730A        UUT_Current = 100 uA
 10.005  5730A        +Resistance =   0.0000 kOhms; ExternalSense = On
 10.006  WAIT         -t 3 System settling ...
 10.007  TARGET       -m
 10.008  SCPI         INIT;*TRG;FETCH?[I]
 10.009  MATH         MEM = MEM / 1E+3
 10.010  MEMCX  100   kZ             0.01% 0.001/

 11.001  5730A        UUT_Current = 100 uA
 11.001  5730A        +Resistance = 100.0000 kOhms; ExternalSense = On
 11.002  WAIT         -t 3 System settling ...
 11.003  TARGET       -m
 11.004  SCPI         INIT;*TRG;FETCH?[I]
 11.005  MATH         MEM = MEM / 1E+3
 11.006  MEMCX  100   kZ             0.01% 0.001/

 12.001  HEAD         -2
 12.002  HEAD
 12.003  5730A        Standby
 12.004  END

 12.005  EVAL   Increment test number

# ====== Sub 8845A/46A,DMM4040/4050 (1 yr) 2W Ohms VER IEEE/5730 ============

 13.001  LABEL        2_WIRE_RESISTANCE
 13.002  RSLT         =
 13.003  HEAD         {2-WIRE RESISTANCE}
 13.004  RSLT         =
 13.005  HEAD         -2{1 kΩ Range}
 13.006  TARGET       -p
 13.007  DISP         Remove all connections.
 13.008  SCPI         FUNC "RES";:RES:RANG 1 KOHM;NPLC 100
 13.009  DISP         Connect the calibrator to the UUT as follows:
 13.009  DISP
 13.009  DISP         [32] Calibrator                    UUT
 13.009  DISP         [32] SENSE HI -------------------> INPUT HI
 13.009  DISP         [32] SENSE LO -------------------> INPUT LO
 13.009  DISP         [32] OUTPUT HI ------------------> INPUT HI
 13.009  DISP         [32] OUTPUT LO ------------------> INPUT LO

 13.010  DISP         The next routine operator intervention occurs
 13.010  DISP         in approximately 3½ minutes...
 13.011  5730A        LeadResistance = 0.1 Ohm; UUT_Current = 1 mA
 13.011  5730A        +Res = 0.000000 kOhms; ExtSense = On; LeadComp = 2Wire
 13.012  MATH         L[1] = REFACC()
 13.013  WAIT         -t 3 System settling ...
 13.014  SCPI         INIT;*TRG;CALC:FUNC NULL;STAT ON
 13.015  SCPI         INIT;*TRG;FETCH?[I!]
 13.016  5730A        LeadResistance = 0.1 Ohm; UUT_Current = 1 mA
 13.016  5730A        +Res = 0.000000 kOhms; ExtSense = On; LeadComp = 2Wire
 13.017  WAIT         -t 3 System settling ...
 13.018  MATH         L[3] = RSS2(L[1], L[1]) / 1E+3
 13.019  ACC          0.000000kZ     L3U
 13.020  TARGET       -m
 13.021  SCPI         INIT;*TRG;FETCH?[I]
 13.022  MATH         MEM = MEM / 1E+3
 13.023  MEMCX  1     0.000000kZ     0.01% 0.001/

 14.001  TSET         CPT = 1.000000 kOhm
 14.002  5730A        LeadResistance = 0.1 Ohm; UUT_Current = 1 mA
 14.002  5730A        +Res = 1.000000 kOhm;  ExtSense = On; LeadComp = 2Wire
 14.003  MATH         L[2] = REFACC()
 14.004  WAIT         -t 3 System settling ...
 14.005  MATH         MEM = MEM1; L[3] = RSS2(L[1], L[2]) / 1E+3
 14.006  ACC    1     kZ             L3U
 14.007  TARGET       -m
 14.008  SCPI         INIT;*TRG;FETCH?[I]
 14.009  MATH         MEM = MEM / 1E+3
 14.010  MEMCX  1     kZ             0.01% 0.001/

 15.001  RSLT         =
 15.002  HEAD         -2{10 kΩ Range}
 15.003  TARGET       -p
 15.004  SCPI         FUNC "RES";:RES:RANG 10 KOHM;NPLC 100
 15.005  5730A        LeadResistance = 0.1 Ohm; UUT_Current = 100 uA
 15.005  5730A        +Res = 0.00000 kOhms; ExtSense = On; LeadComp = 2Wire
 15.006  WAIT         -t 3 System settling ...
 15.007  MATH         L[1] = REFACC()
 15.008  WAIT         -t 3 System settling ...
 15.009  SCPI         INIT;*TRG;CALC:FUNC NULL;STAT ON
 15.010  SCPI         INIT;*TRG;FETCH?[I!]
 15.011  5730A        LeadResistance = 0.1 Ohm; UUT_Current = 100 uA
 15.011  5730A        +Res = 0.00000 kOhms; ExtSense = On; LeadComp = 2Wire
 15.012  WAIT         -t 3 System settling ...
 15.013  MATH         L[3] = RSS2(L[1], L[1]) / 1E+3
 15.014  ACC          0.00000kZ      L3U
 15.015  TARGET       -m
 15.016  SCPI         INIT;*TRG;FETCH?[I]
 15.017  MATH         MEM = MEM / 1E+3
 15.018  MEMCX  10    0.00000kZ      0.01% 0.001/

 16.001  TSET         CPT = 10.00000 kOhms
 16.002  5730A        LeadResistance = 0.1 Ohm; UUT_Current = 100 uA
 16.002  5730A        +Res = 10.00000 kOhms; ExtSense = On; LeadComp = 2Wire
 16.003  MATH         L[2] = REFACC()
 16.004  WAIT         -t 3 System settling ...
 16.005  MATH         MEM = MEM1; L[3] = RSS2(L[1], L[2]) / 1E+3
 16.006  ACC    10    kZ             L3U
 16.007  TARGET       -m
 16.008  SCPI         INIT;*TRG;FETCH?[I]
 16.009  MATH         MEM = MEM / 1E+3
 16.010  MEMCX  10    kZ             0.01% 0.001/

 17.001  RSLT         =
 17.002  HEAD         -2{100 kΩ Range}
 17.003  TARGET       -p
 17.004  5730A        LeadResistance = 0.1 Ohm; UUT_Current = 100 uA
 17.004  5730A        +Res = 0.0000 kOhms; ExtSense = On; LeadComp = 2Wire
 17.005  MATH         L[1] = REFACC()
 17.006  WAIT         -t 3 System settling ...
 17.007  SCPI         INIT;*TRG;CALC:FUNC NULL;STAT ON
 17.008  SCPI         INIT;*TRG;FETCH?[I!]
 17.009  SCPI         FUNC "RES";:RES:RANG 100 KOHM;NPLC 100
 17.010  5730A        LeadResistance = 0.1 Ohm; UUT_Current = 100 uA
 17.010  5730A        +Res = 0.0000 kOhms; ExtSense = On; LeadComp = 2Wire
 17.011  WAIT         -t 3 System settling ...
 17.012  MATH         L[3] = RSS2(L[1], L[1]) / 1E+3
 17.013  ACC          0.0000kZ       L3U
 17.014  TARGET       -m
 17.015  SCPI         INIT;*TRG;FETCH?[I]
 17.016  MATH         MEM = MEM / 1E+3
 17.017  MEMCX  100   0.0000kZ       0.01% 0.001/

 18.001  TSET         CPT = 100.0000 kOhms
 18.002  5730A        LeadResistance = 0.1 Ohm; UUT_Current = 100 uA
 18.002  5730A        +Resistance = 100.0000 kOhms
 18.003  MATH         L[2] = REFACC()
 18.004  WAIT         -t 3 System settling ...
 18.005  MATH         MEM = MEM1; L[3] = RSS2(L[1], L[2]) / 1E+3
 18.006  ACC    100   kZ             L3U
 18.007  TARGET       -m
 18.008  SCPI         INIT;*TRG;FETCH?[I]
 18.009  MATH         MEM = MEM / 1E+3
 18.010  MEMCX  100   kZ             0.01% 0.001/

 19.001  RSLT         =
 19.002  HEAD         -2{1 MΩ Range}
 19.003  TARGET       -p
 19.004  5730A        LeadResistance = 0.1 Ohm; UUT_Current = 10 uA
 19.004  5730A        +Res = 0.000000 MOhms; ExtSense = On; LeadComp = 2Wire
 19.005  MATH         L[1] = REFACC()
 19.006  WAIT         -t 3 System settling ...
 19.007  SCPI         INIT;*TRG;CALC:FUNC NULL;STAT ON
 19.008  SCPI         INIT;*TRG;FETCH?[I!]
 19.009  SCPI         FUNC "RES";:RES:RANG 1 MOHM;NPLC 100
 19.010  5730A        LeadResistance = 0.1 Ohm; UUT_Current = 10 uA
 19.010  5730A        +Res = 0.000000 MOhms; ExtSense = On; LeadComp = 2Wire
 19.011  WAIT         -t 3 System settling ...
 19.012  MATH         L[3] = RSS2(L[1], L[1]) / 1E+3
 19.013  ACC          0.000000MZ     L3U
 19.014  TARGET       -m
 19.015  SCPI         INIT;*TRG;FETCH?[I]
 19.016  MATH         MEM = MEM / 1E+6
 19.017  MEMCX  1     0.000000MZ     0.01% 0.001/

 20.001  TSET         CPT = 1.000000 MOhm
 20.002  5730A        LeadResistance = 0.1 Ohm; UUT_Current = 10 uA
 20.002  5730A        +Resistance = 1.000000 MOhm
 20.003  MATH         L[2] = REFACC()
 20.004  WAIT         -t 3 System settling ...
 20.005  MATH         MEM = MEM1; L[3] = RSS2(L[1], L[2]) / 1E+6
 20.006  ACC    1     MZ             L3U
 20.007  TARGET       -m
 20.008  SCPI         INIT;*TRG;FETCH?[I]
 20.009  MATH         MEM = MEM / 1E+6
 20.010  MEMCX  1     MZ             0.01% 0.001/

 21.001  RSLT         =
 21.002  HEAD         -2{10 MΩ Range}
 21.003  TARGET       -p
 21.004  SCPI         FUNC "RES";:RES:RANG 10 MOHM;NPLC 100
 21.005  5730A        LeadResistance = 0.1 Ohm; UUT_Current = 1 uA
 21.005  5730A        +Res = 0.00000 MOhms; ExtSense = On; LeadComp = 2Wire
 21.006  MATH         L[1] = REFACC()
 21.007  WAIT         -t 3 System settling ...
 21.008  SCPI         INIT;*TRG;CALC:FUNC NULL;STAT ON
 21.009  SCPI         INIT;*TRG;FETCH?[I!]
 21.010  5730A        LeadResistance = 0.1 Ohm; UUT_Current = 1 uA
 21.010  5730A        +Res = 0.00000 MOhms; ExtSense = On; LeadComp = 2Wire
 21.011  WAIT         -t 3 System settling ...
 21.012  MATH         L[3] = RSS2(L[1], L[1]) / 1E+3
 21.013  ACC          0.00000MZ      L3U
 21.014  TARGET       -m
 21.015  SCPI         INIT;*TRG;FETCH?[I]
 21.016  MATH         MEM = MEM / 1E+6
 21.017  MEMCX  10    0.00000MZ      0.04% 0.001/

 22.001  TSET         CPT = 10.00000 MOhms
 22.002  5730A        LeadResistance = 0.1 Ohm; UUT_Current = 1 uA
 22.002  5730A        +Resistance = 10.00000 MOhms
 22.003  MATH         L[2] = REFACC()
 22.004  WAIT         -t 5 System settling ...
 22.005  MATH         MEM = MEM1; L[3] = RSS2(L[1], L[2]) / 1E+6
 22.006  ACC    10    MZ             L3U
 22.007  TARGET       -m
 22.008  SCPI         INIT;*TRG;FETCH?[I]
 22.009  MATH         MEM = MEM / 1E+6
 22.010  MEMCX  10    MZ             0.04% 0.001/

 23.001  RSLT         =
 23.002  HEAD         -2{100 MΩ Range}
 23.003  TARGET       -p
 23.004  SCPI         FUNC "RES";:RES:RANG 100 MOHM;NPLC 100
 23.005  5730A        LeadResistance = 0.1 Ohm; UUT_Current = 1 uA
 23.005  5730A        +Res = 0.0000 MOhms; ExtSense = On; LeadComp = 2Wire
 23.006  MATH         L[1] = REFACC()
 23.007  WAIT         -t 5 System settling ...
 23.008  SCPI         INIT;*TRG;CALC:FUNC NULL;STAT ON
 23.009  SCPI         INIT;*TRG;FETCH?[I!]
 23.010  5730A        LeadResistance = 0.1 Ohm; UUT_Current = 1 uA
 23.010  5730A        +Res = 0.0000 MOhms; ExtSense = On; LeadComp = 2Wire
 23.011  WAIT         -t 5 System settling ...
 23.012  MATH         L[3] = RSS2(L[1], L[1]) / 1E+3
 23.013  ACC          0.0000MZ       L3U
 23.014  TARGET       -m
 23.015  SCPI         INIT;*TRG;FETCH?[I]
 23.016  MATH         MEM = MEM / 1E+6
 23.017  MEMCX  100   0.0000MZ       0.8% 0.01/

 24.001  TSET         CPT = 100.0000 MOhms
 24.002  5730A        LeadResistance = 0.1 Ohm; UUT_Current = 1 uA
 24.002  5730A        +Resistance = 100.0000 MOhms
 24.003  MATH         L[2] = REFACC()
 24.004  WAIT         -t 7 System settling ...
 24.005  MATH         MEM = MEM1; L[3] = RSS2(L[1], L[2]) / 1E+6
 24.006  ACC    100   MZ             L3U
 24.007  TARGET       -m
 24.008  SCPI         INIT;*TRG;FETCH?[I]
 24.009  MATH         MEM = MEM / 1E+6
 24.010  MEMCX  100   MZ             0.8% 0.01/

 25.001  HEAD         -2
 25.002  HEAD
 25.003  5730A        Standby
 25.004  END

 25.005  EVAL   Increment test number

# ====== Sub 8845A/46A,DMM4040/4050 (1 yr) Opt VER IEEE /5730 ===============

 26.001  LABEL        OPTIONAL_TESTS
 26.002  RSLT         =
 26.003  HEAD         {2X4 TEST LEADS}
 26.004  OPBR         -z Is a set of Fluke TL2X4W-PTII, 2 X 4 Wire Ohms
 26.004  OPBR         Test Leads available?

 26.005  IF           MEM1
 26.006  TARGET       -p
 26.007  PIC          884x_tl2_x_4w_zero.jpg
 26.008  SCPI         FUNC "RES";:RES:RANG 100 OHM;NPLC 100
 26.009  WAIT         -t 2 System settling ...
 26.010  SCPI         INIT;*TRG;CALC:FUNC NULL;STAT ON
 26.011  SCPI         INIT;*TRG;FETCH?[I!]
 26.012  DISP         Release the TL2X4W-PTII test lead probe tips
 26.012  DISP         (previously shorted) and connect them to the
 26.012  DISP         calibrator OUTPUT HI and LO terminals.
 26.013  5730A        LeadResistance = 0.1 Ohm; UUT_Current = 1 mA
 26.013  5730A        +Resistance = 100.0000 Ohms; LeadCompensation = 2Wire
 26.014  WAIT         -t 3 System settling ...
 26.015  TARGET       -m
 26.016  SCPI         INIT;*TRG;FETCH?[I]
 26.017  MEMCX  100   Z              0.0140U

 27.001  5730A        Standby
 27.002  DISP         Disconnect the TL2X4W-PTII, 2 X 4 Wire Ohms Test Leads
 27.002  DISP         from the UUT.

 27.003  ELSE
 27.004  RSLT         = Not Tested
 27.005  ENDIF

 27.006  RSLT         =
 27.007  HEAD         {REAR PANEL TERMINALS}
 27.008  MATH         @FrontRearSwitch = "Rear"
 27.009  RSLT         =
 27.010  HEAD         -2{DC VOLTAGE (10 V Range)}
 27.011  TARGET       -p
 27.012  CALL         Sub Fluke 8845A/46A Chk Front/Rear Switch IEEE

 27.013  IF           @NewSW
 27.014  DISP         Connect the calibrator to the UUT as follows:
 27.014  DISP
 27.014  DISP         [32] Calibrator                    UUT (rear)
 27.014  DISP         [32] OUTPUT HI ------------------> INPUT HI
 27.014  DISP         [32] OUTPUT LO ------------------> INPUT LO
 27.014  DISP         [32] SENSE HI -------------------> SENSE HI
 27.014  DISP         [32] SENSE LO -------------------> SENSE LO
 27.014  DISP         [32] AUX CURRENT OUTPUT HI ------> 400 mA
 27.015  ELSE
 27.016  DISP         Connect the calibrator to the UUT as follows:
 27.016  DISP
 27.016  DISP         [32] Calibrator                    UUT (rear)
 27.016  DISP         [32] OUTPUT HI ------------------> INPUT HI
 27.016  DISP         [32] OUTPUT LO ------------------> INPUT LO
 27.016  DISP         [32] SENSE HI -------------------> SENSE HI
 27.016  DISP         [32] SENSE LO -------------------> SENSE LO
 27.016  DISP         [32] AUX CURRENT OUTPUT HI ------> 100 mA
 27.017  ENDIF

 27.018  IF           ZCMPI(@ModelNum, "8845A") || ZCMPI(@ModelNum, "DMM4040")
 27.019  TOL          0.0035% 0.0005/
 27.020  ELSE
 27.021  TOL          0.0024% 0.0005/
 27.022  ENDIF

 27.023  SCPI         FUNC "VOLT:DC";:VOLT:DC:RANG 10V;NPLC 100;IMP:AUTO ON
 27.024  5730A        +Voltage = +10.00000 V
 27.025  WAIT         -t 10 System settling ...
 27.026  TARGET       -m
 27.027  SCPI         INIT;*TRG;FETCH?[I]
 27.028  MEMCX  10    +10.00000V     TOL

 28.001  RSLT         =
 28.002  HEAD         -2{4-WIRE OHMS (1 kΩ Range)}
 28.003  TARGET       -p
 28.004  SCPI         FUNC "FRES";:FRES:RANG 1 KOHM;NPLC 100
 28.005  5730A        +Resistance = 1.000000 kOhm; ExternalSense = On
 28.006  WAIT         -t 3 System settling ...
 28.007  TARGET       -m
 28.008  SCPI         INIT;*TRG;FETCH?[I]
 28.009  MATH         MEM = MEM / 1E+3
 28.010  MEMCX  1     1.000000kZ     0.01% 0.001/

 29.001  RSLT         =
 29.002  HEAD         -2{DC CURRENT (100 mA Range)}
 29.003  TARGET       -p
 29.004  SCPI         FUNC "CURR:DC";:CURR:DC:RANG 100mA;NPLC 100
 29.005  5730A        +Current = +100.0000 mA; CurrentTerminal = Aux
 29.006  WAIT         -t 2 System settling ...
 29.007  TARGET       -m
 29.008  SCPI         INIT;*TRG;FETCH?[I]
 29.009  MATH         MEM = MEM / 1E-3
 29.010  MEMCX  100   +100.0000mA    0.05% 0.005/

 30.001  HEAD         -2
 30.002  HEAD
 30.003  5730A        Standby
 30.004  END

 30.005  EVAL   Increment test number

#======  Sub 8845A/46A,DMM4040/4050 (1 yr) DCI VER IEEE /5730  ==============

 31.001  LABEL        DC_CURRENT
 31.002  RSLT         =
 31.003  HEAD         {DC CURRENT}
 31.004  RSLT         =
 31.005  HEAD         -2{100 µA Range}
 31.006  TARGET       -p
 31.007  SCPI         FUNC "CURR:DC";:CURR:DC:RANG 100uA;NPLC 100
 31.008  5730A        +Current = 0.0000 uA; CurrentTerminal = Aux
 31.009  WAIT         -t 5 System settling ...
 31.010  TARGET       -m
 31.011  SCPI         INIT;*TRG;FETCH?[I]
 31.012  MATH         MEM = MEM / 1E-6
 31.013  MEMCX  100   0.0000µA      0.05% 0.025/

 32.001  5730A        +Current = +100.0000 uA; CurrentTerminal = Aux
 32.002  WAIT         -t 5 System settling ...
 32.003  TARGET       -m
 32.004  SCPI         INIT;*TRG;FETCH?[I]
 32.005  MATH         MEM = MEM / 1E-6
 32.006  MEMCX  100   +100.0000µA   0.05% 0.025/

 33.001  5730A        +Current = -100.0000 uA; CurrentTerminal = Aux
 33.002  WAIT         -t 3 System settling ...
 33.003  TARGET       -m
 33.004  SCPI         INIT;*TRG;FETCH?[I]
 33.005  MATH         MEM = MEM / 1E-6
 33.006  MEMCX  100   -100.0000µA   0.05% 0.025/

 34.001  RSLT         =
 34.002  HEAD         -2{1 mA Range}
 34.003  TARGET       -p
 34.004  SCPI         FUNC "CURR:DC";:CURR:DC:RANG 1mA;NPLC 100
 34.005  5730A        +Current =  0.000000 mA; CurrentTerminal = Aux
 34.006  WAIT         -t 3 System settling ...
 34.007  TARGET       -m
 34.008  SCPI         INIT;*TRG;FETCH?[I]
 34.009  MATH         MEM = MEM / 1E-3
 34.010  MEMCX  1     0.000000mA     0.05% 0.005/

 35.001  5730A        +Current = +1.000000 mA; CurrentTerminal = Aux
 35.002  WAIT         -t 3 System settling ...
 35.003  TARGET       -m
 35.004  SCPI         INIT;*TRG;FETCH?[I]
 35.005  MATH         MEM = MEM / 1E-3
 35.006  MEMCX  1     +1.000000mA    0.05% 0.005/

 36.001  5730A        +Current = -1.000000 mA; CurrentTerminal = Aux
 36.002  WAIT         -t 3 System settling ...
 36.003  TARGET       -m
 36.004  SCPI         INIT;*TRG;FETCH?[I]
 36.005  MATH         MEM = MEM / 1E-3
 36.006  MEMCX  1     -1.000000mA    0.05% 0.005/

 37.001  RSLT         =
 37.002  HEAD         -2{10 mA Range}
 37.003  TARGET       -p
 37.004  SCPI         FUNC "CURR:DC";:CURR:DC:RANG 10mA;NPLC 100
 37.005  5730A        +Current =   0.00000 mA; CurrentTerminal = Aux
 37.006  WAIT         -t 2 System settling ...
 37.007  TARGET       -m
 37.008  SCPI         INIT;*TRG;FETCH?[I]
 37.009  MATH         MEM = MEM / 1E-3
 37.010  MEMCX  10    0.00000mA      0.05% 0.02/

 38.001  5730A        +Current = +10.00000 mA; CurrentTerminal = Aux
 38.002  WAIT         -t 2 System settling ...
 38.003  TARGET       -m
 38.004  SCPI         INIT;*TRG;FETCH?[I]
 38.005  MATH         MEM = MEM / 1E-3
 38.006  MEMCX  10    +10.00000mA    0.05% 0.02/

 39.001  5730A        +Current = -10.00000 mA; CurrentTerminal = Aux
 39.002  WAIT         -t 2 System settling ...
 39.003  TARGET       -m
 39.004  SCPI         INIT;*TRG;FETCH?[I]
 39.005  MATH         MEM = MEM / 1E-3
 39.006  MEMCX  10    -10.00000mA    0.05% 0.02/

 40.001  RSLT         =
 40.002  HEAD         -2{100 mA Range}
 40.003  TARGET       -p
 40.004  SCPI         FUNC "CURR:DC";:CURR:DC:RANG 100mA;NPLC 100
 40.005  5730A        +Current =    0.0000 mA; CurrentTerminal = Aux
 40.006  WAIT         -t 2 System settling ...
 40.007  TARGET       -m
 40.008  SCPI         INIT;*TRG;FETCH?[I]
 40.009  MATH         MEM = MEM / 1E-3
 40.010  MEMCX  100   0.0000mA       0.05% 0.005/

 41.001  5730A        +Current = +100.0000 mA; CurrentTerminal = Aux
 41.002  WAIT         -t 2 System settling ...
 41.003  TARGET       -m
 41.004  SCPI         INIT;*TRG;FETCH?[I]
 41.005  MATH         MEM = MEM / 1E-3
 41.006  MEMCX  100   +100.0000mA    0.05% 0.005/

 42.001  5730A        +Current = -100.0000 mA; CurrentTerminal = Aux
 42.002  WAIT         -t 2 System settling ...
 42.003  TARGET       -m
 42.004  SCPI         INIT;*TRG;FETCH?[I]
 42.005  MATH         MEM = MEM / 1E-3
 42.006  MEMCX  100   -100.0000mA    0.05% 0.005/

 43.001  IF           @NewSW
 43.002  RSLT         =
 43.003  HEAD         -2{400 mA Range}
 43.004  TARGET       -p
 43.005  SCPI         FUNC "CURR:DC";:CURR:DC:RANG 400mA;NPLC 100
 43.006  5730A        +Current =   0.000 mA; CurrentTerminal = Aux
 43.007  WAIT         -t 2 System settling ...
 43.008  TARGET       -m
 43.009  SCPI         INIT;*TRG;FETCH?[I]
 43.010  MATH         MEM = MEM / 1E-3
 43.011  MEMCX  400   0.000mA        0.05% 0.005/

 44.001  5730A        +Current = +400.000 mA; CurrentTerminal = Aux
 44.002  WAIT         -t 2 System settling ...
 44.003  TARGET       -m
 44.004  SCPI         INIT;*TRG;FETCH?[I]
 44.005  MATH         MEM = MEM / 1E-3
 44.006  MEMCX  400   +400.000mA     0.05% 0.005/

 45.001  5730A        +Current = -400.000 mA; CurrentTerminal = Aux
 45.002  WAIT         -t 2 System settling ...
 45.003  TARGET       -m
 45.004  SCPI         INIT;*TRG;FETCH?[I]
 45.005  MATH         MEM = MEM / 1E-3
 45.006  MEMCX  400   -400.000mA     0.05% 0.005/
 46.001  ENDIF

 46.002  HEAD         -2
 46.003  HEAD
 46.004  5730A        Standby
 46.005  END

 46.006  EVAL   Increment test number

#======  Sub 8845A/46A,DMM4040/4050 (1 yr) ACI VER IEEE /5730  ==============

 47.001  LABEL        AC_CURRENT
 47.002  RSLT         =
 47.003  HEAD         {AC CURRENT}

 47.004  MATH         L[1] = ZCMPI(@ModelNum, "8846A")
 47.005  MATH         L[1] = ZCMPI(@ModelNum, "DMM4040") || L[1]
 47.006  MATH         L[1] = ZCMPI(@ModelNum, "DMM4050") || L[1]

 47.007  IF           L[1]
 47.008  RSLT         =
 47.009  HEAD         -2{100 µA Range}
 47.010  TARGET       -p
 47.011  SCPI         FUNC "CURR:AC";:CURR:AC:RANG 100uA;BAND 3;RES MIN
 47.012  5730A        +Curr = 100.0000 uA; Freq = 1 kHz; CurrTerminal = Aux
 47.013  WAIT         -t 3 System settling ...
 47.014  TARGET       -m
 47.015  SCPI         INIT;*TRG;FETCH?[I]
 47.016  MATH         MEM = MEM / 1E-6
 47.017  MEMCX  100   100.0000µA    0.15% 0.06/   1kHz

 48.001  RSLT         =
 48.002  HEAD         -2{1 mA Range}
 48.003  TARGET       -p
 48.004  SCPI         FUNC "CURR:AC";:CURR:AC:RANG 1mA;BAND 3

 48.005  5730A        +Curr = 1.000000 mA; Freq = 1 kHz; CurrTerminal = Aux
 48.006  WAIT         -t 3 System settling ...
 48.007  TARGET       -m
 48.008  SCPI         INIT;*TRG;FETCH?[I]
 48.009  MATH         MEM = MEM / 1E-3
 48.010  MEMCX  1     1.000000mA     0.1% 0.04/    1kHz
 49.001  ENDIF

 49.002  RSLT         =
 49.003  HEAD         -2{10 mA Range}
 49.004  TARGET       -p
 49.005  SCPI         FUNC "CURR:AC";:CURR:AC:RANG 10mA;BAND 3;RES MIN
 49.006  5730A        +Curr = 10.00000 mA; Freq = 1 kHz; CurrTerminal = Aux
 49.007  WAIT         -t 3 System settling ...
 49.008  TARGET       -m
 49.009  SCPI         INIT;*TRG;FETCH?[I]
 49.010  MATH         MEM = MEM / 1E-3
 49.011  MEMCX  10    10.00000mA     0.15% 0.06/   1kHz

 50.001  RSLT         =
 50.002  HEAD         -2{100 mA Range}
 50.003  TARGET       -p
 50.004  SCPI         FUNC "CURR:AC";:CURR:AC:RANG 100mA;BAND 3;RES MIN
 50.005  5730A        +Curr = 100.0000 mA; Freq = 1 kHz; CurrTerminal = Aux
 50.006  WAIT         -t 3 System settling ...
 50.007  TARGET       -m
 50.008  SCPI         INIT;*TRG;FETCH?[I]
 50.009  MATH         MEM = MEM / 1E-3
 50.010  MEMCX  100   100.0000mA     0.1% 0.04/    1kHz

 51.001  IF           @NewSW
 51.002  RSLT         =
 51.003  HEAD         -2{400 mA Range}
 51.004  TARGET       -p
 51.005  SCPI         FUNC "CURR:AC";:CURR:AC:RANG 400mA;BAND 3;RES MIN
 51.006  5730A        +Curr = 400.000 mA; Freq = 1 kHz; CurrTerminal = Aux
 51.007  WAIT         -t 3 System settling ...
 51.008  TARGET       -m
 51.009  SCPI         INIT;*TRG;FETCH?[I]
 51.010  MATH         MEM = MEM / 1E-3
 51.011  MEMCX  400   400.000mA      0.1% 0.1/     1kHz
 52.001  ENDIF

 52.002  HEAD         -2
 52.003  HEAD
 52.004  5730A        Standby
 52.005  END
