﻿Fluke Calibration                                           MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Fluke 8845A/46A Setup IEEE
INSTRUMENT:            Sub Fluke 8845A/46A Chk Identification IEEE
INSTRUMENT:            Sub Fluke 8845A/46A Chk Front/Rear Switch IEEE
INSTRUMENT:            Sub Fluke 8845A/46A Check/Set Fluke 45 Emulation IEEE
DATE:                  2014-03-12 10:49:25
AUTHOR:                Fluke
REVISION:              $Revision: 8204 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       5
NUMBER OF LINES:       161
=============================================================================
#
#  Procedure Author:
#        DAC, VY, DFM
#
#  Model(s) Covered:
#        Fluke 8845A & 8846A, Tektronix DMM4040 & DMM4050
#
#  Compatibility:
#        MET/CAL 8.0 or later
#
#  Additional Equipment Required:
#        None
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  JMPL         SETUP                        PSUBI("Setup")
  1.002  JMPL         CHK_IDENTIFICATION           PSUBI("Identification")
  1.003  JMPL         CHK_FRONT_REAR_SWITCH        PSUBI("Front/Rear Switch")
  1.004  JMPL         CHECK_SET_45_EMULATION       PSUBI("45 Emulation")
  1.005  DISP         Subprocedure not found!
  1.006  END

  1.007  EVAL   Increment test number

# =====  Sub Fluke 8845A/46A Setup IEEE  ====================================

  2.001  LABEL        SETUP
  2.002  OPBR         -z On the UUT, press the INSTR SETUP button followed
  2.002  OPBR         by the "PORT IF" softkey.
  2.002  OPBR
  2.002  OPBR         Is "IEEE488" selected?
  2.003  MATH         @RS232 = NOT(MEM1)

  2.004  IF           @RS232
  2.005  DISP         Press "SELECT PORT" softkey, then press the "IEEE488"
  2.005  DISP         softkey.
  2.006  ENDIF

  2.007  CALL         Sub UUT Connection GPIB
  2.008  SCPI         *RST

  2.009  END

  2.010  EVAL   Increment test number

# =====  Sub Fluke 8845A/46A Chk Identification IEEE  =======================

  3.001  LABEL        CHK_IDENTIFICATION
  3.002  IEEE2        *IDN?[I$]

# Make sure this is not just a 8845A/46A in Fluke 45 emulation mode.
  3.003  MATH         @Fluke45Emulation = ZCMPI(SUB(MEM2, 1, 10),"FLUKE, 45,")

# Set to native 8845A/8846A SCPI Language.
  3.004  IF           @Fluke45Emulation
  3.005  SCPI         L1
  3.006  ENDIF

  3.007  CALL         Sub IEEE-488.2 Identification Query IEEE
  3.008  CALL         Sub IEEE-488.2 Identification Query Check Response

  3.009  IF           @Abort
  3.010  END
  3.011  ENDIF

# Parse date from *IDN? return string.
  3.012  MATH         FW_Date = SUB(FLD(@FirmwareRev, 1, "-"), 1, 8)
  3.013  MATH         @NewSW = (UGDATE(FW_Date) >= UGDATE("09/01/2007"))

  3.014  END

  3.015  EVAL   Increment test number

# =====  Sub Fluke 8845A/46A Chk Front/Rear Switch IEEE  ====================

  4.001  LABEL        CHK_FRONT_REAR_SWITCH
# Initialized loop exit flag to false.
  4.002  MATH         SwitchCorrect = 0

  4.003  DO
# Get the currently selected inputs.
  4.004  SCPI         ROUT:TERM?[I$]

# Select Front inputs.
  4.005  IF           ZCMPI(@FrontRearSwitch, "Front")

  4.006  IF           ZCMPI(MEM2, "REAR")
  4.007  DISP         Depress FRONT to select the UUT front inputs.
  4.007  DISP
  4.007  DISP         Verify that "REAR" does NOT appear in the upper
  4.007  DISP         left-hand corner of the display.
  4.008  ELSE
  4.009  MATH         SwitchCorrect = 1
  4.010  ENDIF

# Select Rear inputs inputs.
  4.011  ELSE

  4.012  IF           ZCMPI(MEM2, "FRON")
  4.013  DISP         Depress REAR to select the UUT rear inputs.
  4.013  DISP
  4.013  DISP         Verify that "REAR" appears in the upper left-hand
  4.013  DISP         corner of the display.
  4.014  ELSE
  4.015  MATH         SwitchCorrect = 1
  4.016  ENDIF

  4.017  ENDIF

  4.018  UNTIL        SwitchCorrect

  4.019  END

  4.020  EVAL   Increment test number

# =====  Sub Fluke 8845A/46A Check/Set Fluke 45 Emulation IEEE  =============

  5.001  LABEL        CHECK_SET_45_EMULATION

# Put UUT back in Fluke 45 emulation mode if it was received that way.
  5.002  IF           @Fluke45Emulation
  5.003  SCPI         L2
  5.004  ENDIF

  5.005  SCPI         *RST[GTL]

  5.006  IF           @RS232
  5.007  DISP         On the UUT, press the INSTR SETUP button followed
  5.007  DISP         by the "PORT IF" softkey.
  5.007  DISP
  5.007  DISP         Press "SELECT PORT" soft key, then press "RS-232C"
  5.007  DISP         soft key.
  5.008  ENDIF

  5.009  END
