﻿Fluke Calibration                                           MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub 8845A/DMM4040 (1 yr) DCV VER IEEE /5730
INSTRUMENT:            Sub 8845A/DMM4040 (1 yr) DC Ratio VER IEEE /5730
DATE:                  2014-03-07 12:01:41
AUTHOR:                Fluke
REVISION:              $Revision: 8204 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       21
NUMBER OF LINES:       276
CONFIGURATION:         Fluke 5730A
=============================================================================
#
#  Procedure Author:
#        DAC, DFM, VY
#
#  Model(s) Covered:
#        Fluke 8845A & Tektronix DMM4040
#
#  Source:
#        Fluke 8845A/8846A Digital Multimeter Calibration Manual
#        January 2007, Rev. 1, 11/07
#
#        Fluke 8845A/8846A Digital Multimeter Calibration Manual Supplement
#        Revision/Date: 1, 11/07, Supplement Issue: 5, Issue Date: 4/10
#
#  Compatibility:
#        MET/CAL 8.2.3 or later
#
#  Additional Equipment Required:
#        None
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  SCPI         *RST;TRIG:SOUR BUS

  1.002  JMPL         DC_VOLTAGE                   PSUBI("DCV")
  1.003  JMPL         DC_VOLTAGE_RATIO             PSUBI("Ratio")
  1.004  DISP         Subprocedure not found!
  1.005  END

  1.006  EVAL   Increment test number

# ====== Sub 8845A/DMM4040 (1 yr) DCV VER IEEE /5730 ========================

  2.001  LABEL        DC_VOLTAGE
  2.002  RSLT         =
  2.003  HEAD         {DC VOLTAGE}
  2.004  RSLT         =
  2.005  HEAD         -2{100 mV Range}
  2.006  TARGET       -p
  2.007  SCPI         FUNC "VOLT:DC";:VOLT:DC:RANG 100mV;NPLC 100;IMP:AUTO ON
  2.008  DISP         Short the UUT INPUT HI and LO together.
  2.009  WAIT         -t 30 System Settling...
  2.010  TARGET       -m
  2.011  SCPI         INIT;*TRG;FETCH?[I]
  2.012  MATH         MEM = MEM / 1E-3
  2.013  MEMCX  100   0.0000mV       .005% .0035/
  3.001  JMPL         1_V_RANGE

  3.002  LABEL        100_mV_RANGE_GAIN
  3.003  SCPI         VOLT:DC:RANG 100mV;NPLC 100;IMP:AUTO ON

  3.004  IF           @NewSW
  3.005  DISP         Connect the calibrator to the UUT as follows:
  3.005  DISP
  3.005  DISP         [32] Calibrator                    UUT
  3.005  DISP         [32] OUTPUT HI ------------------> INPUT HI
  3.005  DISP         [32] OUTPUT LO ------------------> INPUT LO
  3.005  DISP         [32] SENSE HI -------------------> SENSE HI
  3.005  DISP         [32] SENSE LO -------------------> SENSE LO
  3.005  DISP         [32] AUX CURRENT OUTPUT HI ------> 400 mA
  3.006  ELSE
  3.007  DISP         Connect the calibrator to the UUT as follows:
  3.007  DISP
  3.007  DISP         [32] Calibrator                    UUT
  3.007  DISP         [32] OUTPUT HI ------------------> INPUT HI
  3.007  DISP         [32] OUTPUT LO ------------------> INPUT LO
  3.007  DISP         [32] SENSE HI -------------------> SENSE HI
  3.007  DISP         [32] SENSE LO -------------------> SENSE LO
  3.007  DISP         [32] AUX CURRENT OUTPUT HI ------> 100 mA
  3.008  ENDIF

  3.009  DISP         Connect the 5725A to the UUT as follows:
  3.009  DISP
  3.009  DISP         [32] 5725A                        UUT
  3.009  DISP         [32] CURRENT OUTPUT HI ---------> 10A
  3.009  DISP         [32] CURRENT OUTPUT LO ---------> INPUT LO
  3.010  DISP         The next routine operator intervention occurs
  3.010  DISP         in approximately 37½ minutes...
  3.011  5730A        +Voltage = +100.0000 mV
  3.012  WAIT         -t 30 System Settling...
  3.013  TARGET       -m
  3.014  SCPI         INIT;*TRG;FETCH?[I]
  3.015  MATH         MEM = MEM / 1E-3
  3.016  MEMCX  100   +100.0000mV    .005% .0035/

  4.001  5730A        +Voltage = -100.0000 mV
  4.002  WAIT         -t 10 System settling...
  4.003  TARGET       -m
  4.004  SCPI         INIT;*TRG;FETCH?[I]
  4.005  MATH         MEM = MEM / 1E-3
  4.006  MEMCX  100   -100.0000mV    .005% .0035/
  5.001  JMPL         1_V_RANGE_GAIN

  5.002  LABEL        1_V_RANGE
  5.003  RSLT         =
  5.004  HEAD         -2{1 V Range}
  5.005  TARGET       -p
  5.006  SCPI         VOLT:DC:RANG 1V;NPLC 100;IMP:AUTO ON
  5.007  TARGET       -m
  5.008  SCPI         INIT;*TRG;FETCH?[I]
  5.009  MEMCX  1     0.000000V      .004% .0007/
  6.001  JMPL         10_V_RANGE

  6.002  LABEL        1_V_RANGE_GAIN
  6.003  HEAD         -2 1 V Range
  6.004  TARGET       -p
  6.005  SCPI         VOLT:DC:RANG 1V;NPLC 100;IMP:AUTO ON

  6.006  5730A        +Voltage = +1.000000 V
  6.007  WAIT         -t 3 System settling ...
  6.008  TARGET       -m
  6.009  SCPI         INIT;*TRG;FETCH?[I]
  6.010  MEMCX  1     +1.000000V     .004% .0007/

  7.001  5730A        +Voltage = -1.000000 V
  7.002  WAIT         -t 3 System settling ...
  7.003  TARGET       -m
  7.004  SCPI         INIT;*TRG;FETCH?[I]
  7.005  MEMCX  1     -1.000000V     .004% .0007/
  8.001  JMPL         10_V_RANGE_GAIN

  8.002  LABEL        10_V_RANGE
  8.003  RSLT         =
  8.004  HEAD         -2{10 V Range}
  8.005  TARGET       -p
  8.006  SCPI         VOLT:DC:RANG 10V;NPLC 100;IMP:AUTO ON
  8.007  TARGET       -m
  8.008  SCPI         INIT;*TRG;FETCH?[I]
  8.009  MEMCX  10    0.00000V       .0035% .0005/
  9.001  JMPL         100_V_RANGE

  9.002  LABEL        10_V_RANGE_GAIN
  9.003  HEAD         -2 10 V Range
  9.004  TARGET       -p
  9.005  SCPI         VOLT:DC:RANG 10V;NPLC 100;IMP:AUTO ON
  9.006  5730A        +Voltage =  +5.00000 V
  9.007  WAIT         -t 2 System settling ...
  9.008  TARGET       -m
  9.009  SCPI         INIT;*TRG;FETCH?[I]
  9.010  MEMCX  10    +5.00000V      .0035% .0005/

 10.001  5730A        +Voltage =  -5.00000 V
 10.002  WAIT         -t 2 System settling ...
 10.003  TARGET       -m
 10.004  SCPI         INIT;*TRG;FETCH?[I]
 10.005  MEMCX  10    -5.00000V      .0035% .0005/

 11.001  5730A        +Voltage = +10.00000 V
 11.002  WAIT         -t 2 System settling ...
 11.003  TARGET       -m
 11.004  SCPI         INIT;*TRG;FETCH?[I]
 11.005  MEMCX  10    +10.00000V     .0035% .0005/

 12.001  5730A        +Voltage = -10.00000 V
 12.002  WAIT         -t 2 System settling ...
 12.003  TARGET       -m
 12.004  SCPI         INIT;*TRG;FETCH?[I]
 12.005  MEMCX  10    -10.00000V     .0035% .0005/
 13.001  JMPL         100_V_RANGE_GAIN

 13.002  LABEL        100_V_RANGE
 13.003  RSLT         =
 13.004  HEAD         -2{100 V Range}
 13.005  TARGET       -p
 13.006  SCPI         VOLT:DC:RANG 100V;NPLC 100;IMP:AUTO ON
 13.007  TARGET       -m
 13.008  SCPI         INIT;*TRG;FETCH?[I]
 13.009  MEMCX  100   0.0000V        .0045% .0006/
 14.001  JMPL         1000_V_RANGE

 14.002  LABEL        100_V_RANGE_GAIN
 14.003  HEAD         -2 100 V Range
 14.004  TARGET       -p
 14.005  SCPI         VOLT:DC:RANG 100V;NPLC 100;IMP:AUTO ON

 14.006  5730A        +Voltage = +100.0000 V
 14.007  WAIT         -t 2 System settling ...
 14.008  TARGET       -m
 14.009  SCPI         INIT;*TRG;FETCH?[I]
 14.010  MEMCX  100   +100.0000V     .0045% .0006/

 15.001  5730A        +Voltage = -100.0000 V
 15.002  TARGET       -m
 15.003  SCPI         INIT;*TRG;FETCH?[I]
 15.004  MEMCX  100   -100.0000V     .0045% .0006/
 16.001  JMPL         1000_V_RANGE_GAIN

 16.002  LABEL        1000_V_RANGE
 16.003  RSLT         =
 16.004  HEAD         -2{1000 V Range}
 16.005  TARGET       -p
 16.006  SCPI         VOLT:DC:RANG 1000V;NPLC 100;IMP:AUTO ON
 16.007  TARGET       -m
 16.008  SCPI         INIT;*TRG;FETCH?[I]
 16.009  MEMCX  1000  0.000V         .0045% .001/

 17.001  DISP         Remove the short from the UUT input terminals.
 17.002  JMPL         100_mV_RANGE_GAIN

 17.003  LABEL        1000_V_RANGE_GAIN
 17.004  HEAD         -2 1000 V Range
 17.005  TARGET       -p
 17.006  SCPI         VOLT:DC:RANG 1000V;NPLC 100;IMP:AUTO ON
 17.007  5730A        +Voltage = +1000.000 V
 17.008  WAIT         -t 3 System settling ...
 17.009  TARGET       -m
 17.010  SCPI         INIT;*TRG;FETCH?[I]
 17.011  MEMCX  1000  +1000.000V     .0045% .001/

 18.001  5730A        +Voltage = -1000.000 V
 18.002  WAIT         -t 3 System settling ...
 18.003  TARGET       -m
 18.004  SCPI         INIT;*TRG;FETCH?[I]
 18.005  MEMCX  1000  -1000.000V     .0045% .001/

 19.001  HEAD         -2
 19.002  HEAD
 19.003  5730A        Reset
 19.004  END

 19.005  EVAL   Increment test number

# ====== Sub 8845A/DMM4040 (1 yr) DC Ratio VER IEEE /5730 ===================

 20.001  LABEL        DC_VOLTAGE_RATIO
 20.002  RSLT         =
 20.003  HEAD         {DC VOLTAGE RATIO}
 20.004  RSLT         =
 20.005  HEAD         -2{10 V Range}
 20.006  TARGET       -p
 20.007  SCPI         VOLT:DC:RANG 10V;NPLC 100;IMP:AUTO ON
 20.008  SCPI         FUNC "VOLT:DC:RATIO"
 20.009  DISP         Connect the calibrator to the UUT as follows:
 20.009  DISP
 20.009  DISP         [32] Calibrator                    UUT
 20.009  DISP         [32] OUTPUT HI ------------------> INPUT HI
 20.009  DISP         [32] OUTPUT LO ------------------> INPUT LO
 20.009  DISP         [32] OUTPUT HI ------------------> SENSE HI
 20.009  DISP         [32] OUTPUT LO ------------------> SENSE LO
 20.010  5730A        +Voltage = -10.00000 V
 20.011  WAIT         -t 2 System settling ...
 20.012  ACC          1.000000       0.000001U
 20.013  TARGET       -m
 20.014  SCPI         INIT;*TRG;FETCH?[I]
# Tolerance is ±(Input DC accuracy + Reference DC accuracy).
 20.015  MEMCX  10    1.000000       1.000080U

 21.001  HEAD         -2
 21.002  HEAD
 21.003  5730A        Standby
 21.004  END
