﻿© Fluke Calibration. All Rights Reserved.                  MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub IEEE-488.2 Identification Query Parse Response
INSTRUMENT:            Sub IEEE-488.2 Identification Query Check Response
DATE:                  2011-12-05 13:09:33
AUTHOR:                Fluke
REVISION:              $Revision: 2619 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       1
NUMBER OF LINES:       306
=============================================================================
#
#  Procedure Author:   DAC, DFM, CAD
#
#  Models covered:     All IEEE-488.2 compatible UUTs
#
#  Compatibility:      MET/CAL 7.20u or later
#
#  Subprocedures:      None
#
#  Required Files:     None
#
#  Required Equipment: None
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  JMPL         PARSE_RESPONSE               PSUBI("Parse Response")
  1.002  JMPL         CHECK_RESPONSE               PSUBI("Check Response")
  1.003  DISP         Subprocedure not found!
  1.004  MATH         @Abort = 1
  1.005  END

# =====  Sub IEEE-488.2 Identification Query Parse Response  ================
#
# The data is organized as four fields separated by commas.  The four fields
# are defined as follows:
#
#   Field 1 Manufacturer                           required
#   Field 2 Model                                  required
#   Field 3 Serial Number                          ASCII "0" if not available
#   Field 4 Firmware Level or equiv.               ASCII "0" if not available
#
# Note that the ASCII character 0 mentioned above is the character "0",
# decimal value 48 and NOT the "null" character, decimal value 0.
#
# The entire length of the response must be <= 72 characters.  The fields may
# not contain commas, semicolons, control characters (decimal 0-31), or
# DEL (127 decimal).  Otherwise, the fields may contain any ASCII encoded
# character.

  1.006  LABEL        PARSE_RESPONSE

  1.007  IF           0
#  1.007  MATH         MEM2 = "Agilent Technologies,E4419A,,A2.09.01"
#  1.007  MATH         MEM2 = "Agilent Technologies, E4419A, 0, 0"
  1.008  MATH         MEM2 = "Agilent Technologies,E4419A,0,A2.09.01"
  1.009  MATH         MEM2 = MEM2 & "," & MEM2
  1.010  ENDIF

  1.011  MATH         @Manufacturer = FLD(MEM2, 1, ",")
  1.012  MATH         @ModelNum     = FLD(MEM2, 2, ",")
  1.013  MATH         @SerialNum    = FLD(MEM2, 3, ",")
  1.014  MATH         @FirmwareRev  = FLD(MEM2, 4, ",")

# Check for field lengths.
  1.015  MATH         LEN_IDN   = LEN(MEM2)
  1.016  MATH         LEN_Manuf = LEN(@Manufacturer)
  1.017  MATH         LEN_Model = LEN(@ModelNum)
  1.018  MATH         LEN_SN    = LEN(@SerialNum)
  1.019  MATH         LEN_FW    = LEN(@FirmwareRev)

# Validate the response.

  1.020  IF           LEN_IDN > 72
  1.021  MATH         Part1 = SUB(MEM2, 1, 56)
  1.022  MATH         Part2 = SUB(MEM2, 57, LEN_IDN)
  1.023  DISP         The UUT Identification Query returned an invalid
  1.023  DISP         response.  The entire length of the response exceeds
  1.023  DISP         characters.
  1.023  DISP
  1.023  DISP         [V Part1]
  1.023  DISP         [V Part2]
  1.024  MATH         @Abort = 1
  1.025  END
  1.026  ENDIF

  1.027  IF           LEN_Manuf < 1
  1.028  DISP         The UUT Identification Query returned an invalid
  1.028  DISP         response for Manufacturer (Field 1):
  1.028  DISP
  1.028  DISP         [MEM2]
  1.029  MATH         @Abort = 1
  1.030  END
  1.031  ENDIF

  1.032  IF           LEN_Model < 1
  1.033  DISP         The UUT Identification Query returned an invalid
  1.033  DISP         response for Model (Field 2):
  1.033  DISP
  1.033  DISP         [MEM2]
  1.034  MATH         @Abort = 1
  1.035  END
  1.036  ENDIF

  1.037  IF           LEN_SN < 1
  1.038  DISP         The UUT Identification Query returned an invalid
  1.038  DISP         response for Serial Number (Field 3):
  1.038  DISP
  1.038  DISP         [MEM2]
  1.039  MATH         @Abort = 1
  1.040  END
  1.041  ENDIF

  1.042  IF           LEN_FW < 1
  1.043  DISP         The UUT Identification Query returned an invalid
  1.043  DISP         response for Firmware Revision (Field 4):
  1.043  DISP
  1.043  DISP         [MEM2]
  1.044  MATH         @Abort = 1
  1.045  END
  1.046  ENDIF

# Some manufacturers pad the fields with a space.  Example:
#     "Hewlett-Packard, E4401B, US39120213, A.06.00"

# Check for leading spaces.
  1.047  MATH         LS_Manuf = ZCMP(SUB(@Manufacturer, 1, 1), " ")
  1.048  MATH         LS_Model = ZCMP(SUB(@ModelNum,     1, 1), " ")
  1.049  MATH         LS_SN    = ZCMP(SUB(@SerialNum,    1, 1), " ")
  1.050  MATH         LS_FW    = ZCMP(SUB(@FirmwareRev,  1, 1), " ")

# Strip leading whitespace from fields where required.

# Check model field for leading whitespace.
  1.051  IF           LS_Model && (LEN_Model > 1)
  1.052  MATH         @ModelNum = STRIPL(@ModelNum)
  1.053  ENDIF

# Check serial number field for "0" or leading whitespace.
  1.054  IF           ZCMP(@SerialNum, "0") || ZCMP(@SerialNum, " 0")
  1.055  MATH         @SerialNum = "Not available"
  1.056  ELSEIF       LS_SN && (LEN_SN > 1)
  1.057  MATH         @SerialNum = STRIPL(@SerialNum)
  1.058  ENDIF

# Check firmware revision field for "0" or leading whitespace.
  1.059  IF           ZCMP(@FirmwareRev, "0") || ZCMP(@FirmwareRev, " 0")
  1.060  MATH         @FirmwareRev = "Not available"
  1.061  ELSEIF       LS_FW && (LEN_FW > 1)
  1.062  MATH         @FirmwareRev = STRIPL(@FirmwareRev)
  1.063  ENDIF

# Make sure firmware level string is not too big for DISP statement line.
  1.064  MATH         Max = 56 - LEN("Firmware Level:") - 2
  1.065  MATH         LenFirmwareRev = LEN(@FirmwareRev)

  1.066  IF           LenFirmwareRev > Max
  1.067  MATH         Part1 = SUB(@FirmwareRev, 1, Max)
  1.068  MATH         Part2 = SUB(@FirmwareRev, (Max + 1), LenFirmwareRev)
  1.069  DISP         Manufacturer:    [V @Manufacturer]
  1.069  DISP         Model:           [V @ModelNum]
  1.069  DISP         Serial Number:   [V @SerialNum]
  1.069  DISP         Firmware Level:  [V Part1]
  1.069  DISP         [32]                [V Part2]
# Write serial number and firmware revision to results file.
  1.070  RSLT         =
  1.071  RSLT         = Serial Number:   [V @SerialNum]
  1.072  RSLT         = Firmware Level:  [V Part1]
  1.073  RSLT         =[32]                 [V Part2]
  1.074  ELSE
  1.075  DISP         Manufacturer:    [V @Manufacturer]
  1.075  DISP         Model:           [V @ModelNum]
  1.075  DISP         Serial Number:   [V @SerialNum]
  1.075  DISP         Firmware Level:  [V @FirmwareRev]
# Write serial number and firmware revision to results file.
  1.076  RSLT         =
  1.077  RSLT         = Serial Number:   [V @SerialNum]
  1.078  RSLT         = Firmware Level:  [V @FirmwareRev]
  1.079  ENDIF

  1.080  MATH         @Abort = 0
  1.081  END

# =====  Sub IEEE-488.2 Identification Query Check Response  ================

# Example usage (IEEE-488):
#
#  1.001  MATH         @UUT_Manufacturer  = "Agilent Technologies"
#  1.002  MATH         @UUT_Manufacturer2 = "Hewlett-Packard"
#  1.003  MATH         @UUT_Model         = "E4443A"
#  1.004  MATH         @UUT_AssetNum      = UUT()
#
#  1.005  IF           NOT(EMPTY(@UUT_AssetNum))
#  1.006  MATH         @UUT_SerialNum = SN(@UUT_AssetNum)
#  1.007  ENDIF
#
#  1.008  CALL         Sub IEEE-488.2 Identification Query Check Response
#  1.009  CALL         Sub IEEE-488.2 Identification Query IEEE
#
#  1.010  IF           @Abort
#  1.011  END
#  1.012  ENDIF
#
# Example usage (RS-232):
#
#  1.001  PORT         [P9600,N,8,1,X][TERM LF][OTERM LF]
#
#  1.002  MATH         @UUT_Manufacturer  = "FLUKE"
#  1.003  MATH         @UUT_Model         = "45"
#  1.004  MATH         @UUT_AssetNum      = UUT()
#
#  1.005  IF           NOT(EMPTY(@UUT_AssetNum))
#  1.006  MATH         @UUT_SerialNum = SN(@UUT_AssetNum)
#  1.007  ENDIF
#
#  1.008  CALL         Sub IEEE-488.2 Identification Query RS-232 using OTERM
#  Read an discard acknowledge response.
#  1.009  PORT         [I!]
#  1.010  CALL         Sub IEEE-488.2 Identification Query Check Response
#
#  1.011  IF           @Abort
#  1.012  END
#  1.013  ENDIF

  1.082  LABEL        CHECK_RESPONSE
# Verify all required global variables are populated.
  1.083  MATH         @Abort = NOT(ISVAR("@Manufacturer"))

  1.084  IF           @Abort
  1.085  DISP         "@Manufacturer" must contain *IDN? response, field 1,
  1.085  DISP         returned from UUT.
  1.086  END
  1.087  ENDIF

  1.088  MATH         @Abort = NOT(ISVAR("@ModelNum"))

  1.089  IF           @Abort
  1.090  DISP         "@ModelNum" must contain *IDN? response, field 2,
  1.090  DISP         returned from UUT.
  1.091  END
  1.092  ENDIF

  1.093  MATH         @Abort = NOT(ISVAR("@UUT_Manufacturer"))

  1.094  IF           @Abort
  1.095  DISP         "@UUT_Manufacturer" must contain actual manufacturer
  1.095  DISP         name expected.
  1.096  END
  1.097  ENDIF

  1.098  MATH         @Abort = NOT(ISVAR("@UUT_Model"))

  1.099  IF           @Abort
  1.100  DISP         "@UUT_Model" must contain actual manufacturer model
  1.100  DISP         number expected.
  1.101  END
  1.102  ENDIF

  1.103  MATH         L[1] = ZCMPI(@ModelNum, @UUT_Model)
  1.104  MATH         L[2] = ZCMPI(@Manufacturer, @UUT_Manufacturer)

  1.105  IF           ISVAR("@UUT_Manufacturer2")
  1.106  MATH         L[3] = ZCMPI(@Manufacturer, @UUT_Manufacturer2)
  1.107  ELSE
  1.108  MATH         L[3] = 1
  1.109  ENDIF

  1.110  MATH         @Abort = NOT(L[1] && (L[2] || L[3]))

  1.111  IF           @Abort

  1.112  IF           ISVAR("@UUT_Manufacturer2")
  1.113  DISP         UUT is a [V @Manufacturer] [V @ModelNum],
  1.113  DISP         not a [V @UUT_Manufacturer] [V @UUT_Model]
  1.113  DISP         or [V @UUT_Manufacturer2] [V @UUT_Model]!
  1.114  ELSE
  1.115  DISP         UUT is a [V @Manufacturer] [V @ModelNum],
  1.115  DISP         not a [V @UUT_Manufacturer] [V @UUT_Model]!
  1.116  ENDIF

  1.117  END
  1.118  ENDIF

# Check the serial number if the calling procedure specified a
# serial number and the UUT returned a serial number.
  1.119  IF           ISVAR("@UUT_SerialNum")

  1.120  IF           NOT(ZCMPI(@SerialNum, "Not available"))
  1.121  MATH         @Abort = NOT(ZCMPI(@SerialNum, @UUT_SerialNum))

  1.122  IF           @Abort
  1.123  DISP         UUT serial number is [V @SerialNum].
  1.123  DISP         Expected serial number is [V @UUT_SerialNum]!
  1.124  ENDIF

  1.125  ENDIF

  1.126  ENDIF        ; ISVAR("@UUT_SerialNum")

  1.127  END