﻿© Fluke Corporation. All Rights Reserved.                   MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Send Command /FGEN
DATE:                  2007-12-13
AUTHOR:                Fluke
REVISION:              $Revision: 2619 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       1
NUMBER OF LINES:       78
CONFIGURATION:         Philips PM 5191
=============================================================================
#
#  Procedure Author:
#        DAC, DFM
#
#  Compatibility:
#        MET/CAL 7.20 or later
#
#  Subprocedures:
#        None
#
#  Required Files:
#        user_config_instr.ini
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  IF           ZCMPI(@FGEN_Cmd, "[SDC]")
  1.002  IEEE         [@FGEN][SDC]
  1.003  END
  1.004  ENDIF

  1.005  IF           ZCMPI(@FGEN_FSC, "SCPI")
  1.006  SCPI         [@FGEN][V @FGEN_Cmd]
  1.007  ELSEIF       ZCMPI(@FGEN_FSC, "IEEE2")
  1.008  IEEE2        [@FGEN][V @FGEN_Cmd]
  1.009  ELSE
  1.010  IEEE         [@FGEN][V @FGEN_Cmd]

# See if there is an output terminator.
  1.011  MATH         OutputTerm = RINF(@FGEN_ProgSecName, "OutputTerminator")

  1.012  IF           NOT(ZCMP(OutputTerm, ""))

  1.013  IF           ZCMPI(OutputTerm, "CR")
  1.014  IEEE         [@FGEN][13]
  1.015  ELSEIF       ZCMPI(OutputTerm, "LF")
  1.016  IEEE         [@FGEN][10]
  1.017  ELSEIF       ZCMPI(OutputTerm, "CRLF")
  1.018  IEEE         [@FGEN][13][10]
  1.019  ELSE
  1.020  DISP         Flexible driver "FGEN" does not
  1.020  DISP         support "OutputTerminator = [V OutputTerm]"
  1.020  DISP         in [91][V @FGEN_ProgSecName][93] section of
  1.020  DISP         "user_config_instr.ini".
  1.021  ENDIF

  1.022  ENDIF

  1.023  ENDIF

  1.024  END
