﻿Copyright (c) (2014) Fluke Corporation.                  All rights reserved.
=============================================================================
INSTRUMENT:            HP 33120A: (1 yr) VER IEEE /8845,5790,PSA,LFCTR
DATE:                  2014-11-10 13:30:19
AUTHOR:                Fluke
REVISION:              $Revision: 9434 $
ADJUSTMENT THRESHOLD:  95%
NUMBER OF TESTS:       2
NUMBER OF LINES:       172
CONFIGURATION:         Fluke 8845A
CONFIGURATION:         Fluke 5790A
CONFIGURATION:         Agilent PSA (6.7 GHz)
CONFIGURATION:         LF Counter
=============================================================================
#
#  Procedure Author:
#        DAC, DFM
#
#  This procedure contains the following tests whose Test Uncertainty Ratio
#  are less than 4:1.
#        AC AMPLITUDE (using 8845A)
#                     - 1.4 V, 1 kHz;  TUR 3.6458
#                     - 140 mV, 1 kHz; TUR 3.6458
#                     - 18 mV, 1 kHz;  TUR 3.5433
#
#  Source:
#        HP 33120A Function Generator / Arbitrary Waveform Generator Service
#          Guide, Part No. 33120-90017, EWdition 6, March 2002
#
#  Compatibility:
#        MET/CAL 8.0 or later
#
#  Additional Equipment Required:
#        Termination, feedthrough, BNC (f)-(m), 50 Ω ± 0.1 Ω, HP/Agilent
#          11048C or equivalent
#        Adapter, BNC (f) to double stacking banana plug, Pomona Model 1269
#          or equivalent
#        Adapter, Type N (m) to BNC (f), Pomona Model 3288 or equivalent
#        Attenuator, 20 dB, Type N (m)-(f), 50 Ω, Agilent 8491A or
#          equivalent (optional distortion tests only)
#
#  The Procedure was tested using:
#
#        Model No.    : HP 33120A
#        Serial No.   : US36008470
#        Options      : NA
#        Firmware Rev.: 7.0-5.0-1.0
#
#  The average run time during testing was 22 minutes. (in main only)
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright for this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

# The following statement are included to force the main procedure header
# to represent the configuration required by the subprocedures.
  1.001  IF           0
  1.002  8845         *                                                 S
  1.003  5790         *                                                 S
  1.004  IEEE         [@LFCTR]
  1.005  ENDIF


  1.007  IF           NOT(VERSIONCHECK("8.0"))
  1.008  END
  1.009  ENDIF

  1.010  CALL         Sub Display Copyright

  1.011  CALL         Sub UUT Connection GPIB

  1.012  MATH         @UUT_Manufacturer  = "HEWLETT-PACKARD"
  1.013  MATH         @UUT_Manufacturer2 = "Agilent Technologies"
  1.014  MATH         @UUT_Model         = "33120A"
  1.015  CALL         Sub IEEE-488.2 Identification Query IEEE
  1.016  CALL         Sub IEEE-488.2 Identification Query Check Response
  1.017  JMPL         END                          @Abort

  1.018  HEAD         PRELIMINARY INSTRUCTIONS
  1.019  DISP         Ensure a minimum UUT warm-up time of at least
  1.019  DISP         1 hour, in an environment of 18°C to 28°C and
  1.019  DISP         relative humidity of less than 80%, has been
  1.019  DISP         allowed to elapse, prior to proceeding.
  1.019  DISP
  1.019  DISP         Ensure specified warm-up time(s) for required
  1.019  DISP         reference devices has been satisfied.

  1.020  CALL         Sub Select Failed Test Mode
  1.021  CALL         Sub Select Guardbanding & Ver Method (No NTHROW)

  1.022  OPBR         -z Do you want to REVIEW the list of additional
  1.022  OPBR         equipment and/or accessories required?

  1.023  IF           MEM1
  1.024  DISP         Additional equipment/accessories required:
  1.024  DISP
  1.024  DISP         - Termination, feedthrough, BNC (f)-(m), 50 Ω
  1.024  DISP         [32] ± 0.1 Ω, Agilent 11048C or equivalent
  1.024  DISP         - Adapter, BNC (f) to double stacking banana plug,
  1.024  DISP         [32] Pomona Model 1269 or equivalent
  1.024  DISP         - Adapter, Type N (m) to BNC (f), Pomona Model 3288
  1.024  DISP         [32] or equivalent
  1.024  DISP
  1.024  DISP         The following is required ONLY if the optional
  1.024  DISP         distortion test is performed.
  1.024  DISP
  1.024  DISP         - Attenuator, 20 dB, Type N (m)-(f), 50 Ω, Agilent
  1.024  DISP         [32] 8491A or equivalent
  1.025  ENDIF

  1.026  PSA          Calibrate

# Establish UUT reset command.
  1.027  RESET        *RST;*CLS;*OPC?[I!][GTL]

  1.028  LABEL        SELF_TEST
  1.029  RSLT         =
  1.030  HEAD         SELF-TEST
  1.031  TARGET
  1.032  IEEE         *TST?[I]
  1.033  EVAL   -e MEM == 0 : SELF-TEST

  2.001  SCPI         *RST

  2.002  CALL         Sub HP 33120A (1 yr) Frequency VER IEEE /LFCTR
  2.003  CALL         Sub HP 33120A (1 yr) Gain & Linearity VER IEEE /8845
  2.004  CALL         Sub HP 33120A (1 yr) DC Offset VER IEEE /8845
  2.005  CALL         Sub HP 33120A (1 yr) AC Amplitude HiZ VER IEEE /8845
  2.006  JMPL         AM_MODULATION

  2.007  LABEL        AMPLITUDE_50_OHM
  2.008  CALL         Sub HP 33120A (1 yr) AC Amplitude LoZ VER IEEE /8845
  2.009  CALL         Sub HP 33120A (1 yr) Amplitude Flatness VER IEEE /5790
  2.010  JMPL         OPTIONAL_TESTS

  2.011  LABEL        AM_MODULATION
  2.012  CALL         Sub HP 33120A (1 yr) AM Modulation VER IEEE /8845
  2.013  JMPL         AMPLITUDE_50_OHM

  2.014  LABEL        OPTIONAL_TESTS
  2.015  OPBR         -z Do you wish to perform the following optional tests?
  2.015  OPBR
  2.015  OPBR         [32] Square Wave Duty Cycle Verification
  2.015  OPBR         [32] Distortion Verification

  2.016  IF           MEM1
  2.017  CALL         Sub HP 33120A (1 yr) Duty Cycle VER IEEE /8845
  2.018  CALL         Sub HP 33120A (1 yr) Distortion VER IEEE /PSA
  2.019  ELSE
  2.020  RSLT         =
  2.021  RSLT         =Optional Duty Cycle and Distortion tests not performed.
  2.022  ENDIF

  2.023  LABEL        END

  2.024  IF           @Abort
  2.025  HEAD         V E R I F I C A T I O N   A B O R T E D !
  2.026  ENDIF

  2.027  END
