﻿© 2006 Fluke Corporation, All rights reserved               MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Agilent PSA Get Attenuation IEEE
INSTRUMENT:            Sub Agilent PSA Get Model Number IEEE
INSTRUMENT:            Sub Agilent PSA Get Preamplifier IEEE
DATE:                  2006-11-29 11:15:49
AUTHOR:                Fluke
REVISION:              $Revision: 2605 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       4
NUMBER OF LINES:       78
=============================================================================
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON
  1.001  JMPL         GET_ATTENUATION              PSUBI("Attenuation")
  1.002  JMPL         GET_MODEL_NUMBER             PSUBI("Model Number")
  1.003  JMPL         GET_PREAMPLIFIER             PSUBI("Preamplifier")
  1.004  DISP         Subprocedure not found!
  1.005  END

  1.006  EVAL   Increment step number

# =====  Sub Agilent PSA Get Attenuation IEEE  ==============================

  2.001  LABEL        GET_ATTENUATION
  2.002  SCPI         [@PSA]POW:RF:ATT?[I]
  2.003  MATH         @PSAAtten = MEM
  2.004  END

  2.005  EVAL   Increment step number

# =====  Sub Agilent PSA Get Model Number IEEE  =============================

  3.001  LABEL        GET_MODEL_NUMBER
  3.002  SCPI         [@PSA]*IDN?[I$]

# Second comma delimited field is the model number.
  3.003  MATH         ModelNum = FLD(MEM2, 2, ",")

# If the first character is a space, skip it.
  3.004  IF           ZCMP(SUB(ModelNum, 1, 1), " ")
  3.005  MATH         @PSAModelNum = SUB(ModelNum, 2, LEN(ModelNum))
  3.006  ELSE
  3.007  MATH         @PSAModelNum = ModelNum
  3.008  ENDIF

  3.009  END

  3.010  EVAL   Increment step number

# =====  Sub Agilent PSA Get Preamplifier IEEE  =============================

  4.001  LABEL        GET_PREAMPLIFIER
  4.002  SCPI         [@PSA]*OPT?[I$]
  4.003  MATH         @PSAPreamp = ""; Preamp = ""; Field = 1

  4.004  DO
  4.005  MATH         Option = FLD(MEM2, Field, ",")

  4.006  IF           ZCMPI(Option, "110")
  4.007  MATH         Preamp = "110"
  4.008  ELSEIF       ZCMPI(Option, "1DS")
  4.009  MATH         Preamp = "1DS"
  4.010  ENDIF

  4.011  MATH         Field = Field + 1
  4.012  UNTIL        NOT(EMPTY(Preamp)) || EMPTY(Option)

# If a preamplifier is installed, see if it is on.
  4.013  IF           NOT(EMPTY(Preamp))
  4.014  SCPI         [@PSA]POW:GAIN?[I]

  4.015  IF           MEM
  4.016  MATH         @PSAPreamp = Preamp
  4.017  ENDIF

  4.018  ENDIF

  4.019  END
