﻿Copyright (c) (2014) Fluke Corporation.                  All rights reserved.
=============================================================================
INSTRUMENT:            Sub HP 33120A (1 yr) Amplitude Flatness VER IEEE /5790
DATE:                  2014-11-10 13:30:59
AUTHOR:                Fluke
REVISION:              $Revision: 9434 $
ADJUSTMENT THRESHOLD:  95%
NUMBER OF TESTS:       11
NUMBER OF LINES:       157
CONFIGURATION:         Fluke 5790A
=============================================================================
#
#  Procedure Author:
#        DAC, DFM
#
#  Compatibility:
#        MET/CAL 8.0 or later
#
#  Additional Equipment Required:
#        None
#
#  The copyright for this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  RSLT         =
  1.002  HEAD         {AMPLITUDE FLATNESS VERIFICATION (1 kHz Reference)}
  1.003  TARGET       -p
  1.004  SCPI         OUTP:LOAD 50;:VOLT:UNIT VRMS

  1.005  DISP         Connect the UUT OUTPUT to 5790A WIDEBAND input using
  1.005  DISP         a BNC cable and a Type N (m) to BNC (f) adapter.

  1.006  HEAD         -2 Reference Set: 1 kHz
  1.007  SCPI         FUNC:SHAP SIN;:VOLT 3.000;:FREQ 1kHz
  1.008  5790         3.000V                       1kH            W  F  N  2W
  1.009  MATH         RefLvl = MEM

  1.010  HEAD         -2 Test Frequency: 100 kHz
  1.011  TSET         TDESC = 100 kHz
  1.012  SCPI         FUNC:SHAP SIN;:VOLT 3;:FREQ 100kHz
  1.013  TARGET       -m
  1.014  5790         3.000V                       100kH          W  F  N  2W
  1.015  MATH         Model = "Fluke 5790A"; Mode = "Volts W Flat"
# 5790A Wideband flatness specifications returned in base units.
  1.016  MATH         FlatnessSpec = ACCV2(Model, Mode, MEM, 100E+3)
# Convert 5790A flatness specification to percent.
  1.017  MATH         L[1] = (FlatnessSpec / MEM) * 100
  1.018  ACC          0.00pct        L1U
  1.019  MATH         MEM = ((MEM - RefLvl) / RefLvl) * 100
  1.020  MEMC         0.00pct        1.00U
#! WARNING: Test Tol 0.03, Sys Tol 0.0095, TUR 3.1579 (<  4.00).

  2.001  HEAD         -2 Test Frequency: 500 kHz
  2.002  TSET         TDESC = 500 kHz
  2.003  SCPI         FUNC:SHAP SIN;:VOLT 3;:FREQ 500kHz
  2.004  TARGET       -m
  2.005  5790         3.000V                       500kH          W  F  N  2W
  2.006  MATH         FlatnessSpec = ACCV2(Model, Mode, MEM, 500E+3)
  2.007  MATH         L[1] = (FlatnessSpec / MEM) * 100
  2.008  ACC          0.00pct        L1U
  2.009  MATH         MEM = ((MEM - RefLvl) / RefLvl) * 100
  2.010  MEMC         0.00pct        1.50U

  3.001  HEAD         -2 Test Frequency: 1 MHz
  3.002  TSET         TDESC = 1 MHz
  3.003  SCPI         FUNC:SHAP SIN;:VOLT 3;:FREQ 1MHz
  3.004  TARGET       -m
  3.005  5790         3.000V                       1MH            W  F  N  2W
  3.006  MATH         FlatnessSpec = ACCV2(Model, Mode, MEM, 1E+6)
  3.007  MATH         L[1] = (FlatnessSpec / MEM) * 100
  3.008  ACC          0.00pct        L1U
  3.009  MATH         MEM = ((MEM - RefLvl) / RefLvl) * 100
  3.010  MEMC         0.00pct        1.50U

  4.001  HEAD         -2 Test Frequency: 3 MHz
  4.002  TSET         TDESC = 3 MHz
  4.003  SCPI         FUNC:SHAP SIN;:VOLT 3;:FREQ 3MHz
  4.004  TARGET       -m
  4.005  5790         3.000V                       3MH            W  F  N  2W
  4.006  MATH         FlatnessSpec = ACCV2(Model, Mode, MEM, 3E+6)
  4.007  MATH         L[1] = (FlatnessSpec / MEM) * 100
  4.008  ACC          0.00pct        L1U
  4.009  MATH         MEM = ((MEM - RefLvl) / RefLvl) * 100
  4.010  MEMC         0.00pct        2.00U

  5.001  HEAD         -2 Test Frequency: 5 MHz
  5.002  TSET         TDESC = 5 MHz
  5.003  SCPI         FUNC:SHAP SIN;:VOLT 3;:FREQ 5MHz
  5.004  TARGET       -m
  5.005  5790         3.000V                       5MH            W  F  N  2W
  5.006  MATH         FlatnessSpec = ACCV2(Model, Mode, MEM, 5E+6)
  5.007  MATH         L[1] = (FlatnessSpec / MEM) * 100
  5.008  ACC          0.00pct        L1U
  5.009  MATH         MEM = ((MEM - RefLvl) / RefLvl) * 100
  5.010  MEMC         0.00pct        2.00U

  6.001  HEAD         -2 Test Frequency: 7 MHz
  6.002  TSET         TDESC = 7 MHz
  6.003  SCPI         FUNC:SHAP SIN;:VOLT 3;:FREQ 7MHz
  6.004  TARGET       -m
  6.005  5790         3.000V                       7MH            W  F  N  2W
  6.006  MATH         FlatnessSpec = ACCV2(Model, Mode, MEM, 7E+6)
  6.007  MATH         L[1] = (FlatnessSpec / MEM) * 100
  6.008  ACC          0.00pct        L1U
  6.009  MATH         MEM = ((MEM - RefLvl) / RefLvl) * 100
  6.010  MEMC         0.00pct        2.00U

  7.001  HEAD         -2 Test Frequency: 9 MHz
  7.002  TSET         TDESC = 9 MHz
  7.003  SCPI         FUNC:SHAP SIN;:VOLT 3;:FREQ 9MHz
  7.004  TARGET       -m
  7.005  5790         3.000V                       9MH            W  F  N  2W
  7.006  MATH         FlatnessSpec = ACCV2(Model, Mode, MEM, 9E+6)
  7.007  MATH         L[1] = (FlatnessSpec / MEM) * 100
  7.008  ACC          0.00pct        L1U
  7.009  MATH         MEM = ((MEM - RefLvl) / RefLvl) * 100
  7.010  MEMC         0.00pct        2.00U

  8.001  HEAD         -2 Test Frequency: 11 MHz
  8.002  TSET         TDESC = 11 MHz
  8.003  SCPI         FUNC:SHAP SIN;:VOLT 3;:FREQ 11MHz
  8.004  TARGET       -m
  8.005  5790         3.000V                       11MH           W  F  N  2W
  8.006  MATH         FlatnessSpec = ACCV2(Model, Mode, MEM, 11E+6)
  8.007  MATH         L[1] = (FlatnessSpec / MEM) * 100
  8.008  ACC          0.00pct        L1U
  8.009  MATH         MEM = ((MEM - RefLvl) / RefLvl) * 100
  8.010  MEMC         0.00pct        2.00U

  9.001  HEAD         -2 Test Frequency: 13 MHz
  9.002  TSET         TDESC = 13 MHz
  9.003  SCPI         FUNC:SHAP SIN;:VOLT 3;:FREQ 13MHz
  9.004  TARGET       -m
  9.005  5790         3.000V                       13MH           W  F  N  2W
  9.006  MATH         FlatnessSpec = ACCV2(Model, Mode, MEM, 13E+6)
  9.007  MATH         L[1] = (FlatnessSpec / MEM) * 100
  9.008  ACC          0.00pct        L1U
  9.009  MATH         MEM = ((MEM - RefLvl) / RefLvl) * 100
  9.010  MEMC         0.00pct        2.00U

 10.001  HEAD         -2 Test Frequency: 15 MHz
 10.002  TSET         TDESC = 15 MHz
 10.003  SCPI         FUNC:SHAP SIN;:VOLT 3;:FREQ 15MHz
 10.004  TARGET       -m
 10.005  5790         3.000V                       15MH           W  F  N  2W
 10.006  MATH         FlatnessSpec = ACCV2(Model, Mode, MEM, 15E+6)
 10.007  MATH         L[1] = (FlatnessSpec / MEM) * 100
 10.008  ACC          0.00pct        L1U
 10.009  MATH         MEM = ((MEM - RefLvl) / RefLvl) * 100
 10.010  MEMC         0.00pct        2.00U

 11.001  HEAD         -2
 11.002  HEAD
 11.003  SCPI         *RST
 11.004  5790         *                                                 S
 11.005  END
