﻿Copyright (c) (2014) Fluke Corporation.                  All rights reserved.
=============================================================================
INSTRUMENT:            Sub HP 33120A (1 yr) Distortion VER IEEE /PSA
DATE:                  2014-11-10 13:31:18
AUTHOR:                Fluke
REVISION:              $Revision: 9434 $
ADJUSTMENT THRESHOLD:  95%
NUMBER OF TESTS:       17
NUMBER OF LINES:       328
CONFIGURATION:         Agilent PSA (6.7 GHz)
=============================================================================
#
#  Procedure Author:
#        DAC, DFM
#
#  Compatibility:
#        MET/CAL 8.0 or later
#
#  Additional Equipment Required:
#        None
#
#  The copyright for this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  RSLT         =
  1.002  HEAD         {DISTORTION VERIFICATION}
  1.003  RSLT         =
  1.004  RSLT         =20 kHz
  1.005  TARGET       -p
  1.006  SCPI         OUTP:LOAD 50;:VOLT:UNIT VRMS

  1.007  DISP         Connect the UUT OUTPUT to the PSA RF INPUT using
  1.007  DISP         a BNC cable, a 20 dB attenuator, and a Type N (m)
  1.007  DISP         to BNC (f) adapter.
  1.007  DISP
  1.007  DISP         [32]                 CAUTION
  1.007  DISP         Failure to use the specified 20 dB attenuator
  1.007  DISP         may cause input mixer damage to the spectrum
  1.007  DISP         analyzer or reduced measurement accuracy due
  1.007  DISP         to mixer overload.

  1.008  HEAD         -2 Fundamental: 20 kHz
  1.009  SCPI         FUNC:SHAP SIN;:VOLT 1.1;:FREQ 20kHz
  1.010  TARGET       -m
  1.011  PSA          RBW = 10 Hz; VBW = 30 Hz; RefLevel = -6 dBm
  1.011  PSA          CenterFreq = 20 kHz; FreqSpan = 1 kHz
  1.011  PSA          PeakSearch; MarkerToCenterFreq; RFCoupling = DC
  1.011  PSA          +Ampl = -6 dBm; InputAttenuation = 10 dB
# Retrieve uncertainty for above measurement and normalize.
  1.012  MATH         @Ampl = MEM; @Freq = 20E+3
  1.013  CALL         Sub Agilent PSA Get Amplitude Accuracy IEEE
  1.014  MATH         L[1] = @PSAAmplAcc / CONF("Agilent PSA")
  1.015  MATH         RefLvl = MEM
  1.016  HEAD         -2 2nd Harmonic: 40 kHz
  1.017  TSET         TDESC = 2nd Harmonic
# Measure amplitude of 2nd harmonic.
  1.018  PSA          RBW = 10 Hz; VBW = 30 Hz; RefLevel = -30 dBm
  1.018  PSA          CenterFreq = 40 kHz; FreqSpan = 1 kHz
  1.018  PSA          PeakSearch; MarkerToCenterFreq; RFCoupling = DC
  1.018  PSA          +Ampl = -76 dBm; InputAttenuation = 10 dB
  1.019  MATH         @Ampl = MEM; @Freq = 40E+3
  1.020  CALL         Sub Agilent PSA Get Amplitude Accuracy IEEE
  1.021  MATH         L[2] = @PSAAmplAcc / CONF("Agilent PSA")
# RSS all individual measurement uncertainty components and expand.
  1.022  MATH         L[3] = RSS2(L[1], L[2]) * 2
# Compute harmonic level (dBc).
  1.023  MATH         MEM = @Ampl - RefLvl
  1.024  ACC    -70   dBc            L3U                                   +DW
  1.025  MEMC         -70dBc         -0.0U +100.0U

  2.001  HEAD         -2 3rd Harmonic: 60 kHz
  2.002  TSET         TDESC = 3rd Harmonic
  2.003  PSA          RBW = 10 Hz; VBW = 30 Hz; RefLevel = -30 dBm
  2.003  PSA          CenterFreq = 60 kHz; FreqSpan = 1 kHz
  2.003  PSA          PeakSearch; MarkerToCenterFreq; RFCoupling = DC
  2.003  PSA          +Ampl = -76 dBm; InputAttenuation = 10 dB
  2.004  MATH         @Ampl = MEM; @Freq = 60E+3
  2.005  CALL         Sub Agilent PSA Get Amplitude Accuracy IEEE
  2.006  MATH         L[2] = @PSAAmplAcc / CONF("Agilent PSA")
  2.007  MATH         L[3] = RSS2(L[1], L[2]) * 2
  2.008  MATH         MEM = @Ampl - RefLvl
  2.009  ACC    -70   dBc            L3U                                   +DW
  2.010  MEMC         -70dBc         -0.0U +100.0U

  3.001  HEAD         -2 4th Harmonic: 80 kHz
  3.002  TSET         TDESC = 4th Harmonic
  3.003  PSA          RBW = 10 Hz; VBW = 30 Hz; RefLevel = -30 dBm
  3.003  PSA          CenterFreq = 80 kHz; FreqSpan = 1 kHz
  3.003  PSA          PeakSearch; MarkerToCenterFreq; RFCoupling = DC
  3.003  PSA          +Ampl = -76 dBm; InputAttenuation = 10 dB
  3.004  MATH         @Ampl = MEM; @Freq = 80E+3
  3.005  CALL         Sub Agilent PSA Get Amplitude Accuracy IEEE
  3.006  MATH         L[2] = @PSAAmplAcc / CONF("Agilent PSA")
  3.007  MATH         L[3] = RSS2(L[1], L[2]) * 2
  3.008  MATH         MEM = @Ampl - RefLvl
  3.009  ACC    -70   dBc            L3U                                   +DW
  3.010  MEMC         -70dBc         -0.0U +100.0U

  4.001  HEAD         -2 5th Harmonic: 100 kHz
  4.002  TSET         TDESC = 5th Harmonic
  4.003  PSA          RBW = 10 Hz; VBW = 30 Hz; RefLevel = -30 dBm
  4.003  PSA          CenterFreq = 100 kHz; FreqSpan = 1 kHz
  4.003  PSA          PeakSearch; MarkerToCenterFreq; RFCoupling = DC
  4.003  PSA          +Ampl = -76 dBm; InputAttenuation = 10 dB
  4.004  MATH         @Ampl = MEM; @Freq = 100E+3
  4.005  CALL         Sub Agilent PSA Get Amplitude Accuracy IEEE
  4.006  MATH         L[2] = @PSAAmplAcc / CONF("Agilent PSA")
  4.007  MATH         L[3] = RSS2(L[1], L[2]) * 2
  4.008  MATH         MEM = @Ampl - RefLvl
  4.009  ACC    -70   dBc            L3U                                   +DW
  4.010  MEMC         -70dBc         -0.0U +100.0U

  5.001  RSLT         =
  5.002  RSLT         =100 kHz
  5.003  TARGET       -p
  5.004  HEAD         -2 Fundamental: 100 kHz
  5.005  SCPI         FUNC:SHAP SIN;:VOLT 1.1;:FREQ 100kHz
  5.006  TARGET       -m
  5.007  PSA          RBW = 100 Hz; VBW = 300 Hz; RefLevel = -6 dBm
  5.007  PSA          CenterFreq = 100 kHz; FreqSpan = 5 kHz
  5.007  PSA          PeakSearch; MarkerToCenterFreq; RFCoupling = DC
  5.007  PSA          +Ampl = -6 dBm; InputAttenuation = 10 dB
  5.008  MATH         @Ampl = MEM; @Freq = 100E+3
  5.009  CALL         Sub Agilent PSA Get Amplitude Accuracy IEEE
  5.010  MATH         L[1] = @PSAAmplAcc / CONF("Agilent PSA")
  5.011  MATH         RefLvl = MEM
  5.012  HEAD         -2 2nd Harmonic: 200 kHz
  5.013  TSET         TDESC = 2nd Harmonic
  5.014  PSA          RBW = 100 Hz; VBW = 300 Hz; RefLevel = -30 dBm
  5.014  PSA          CenterFreq = 200 kHz; FreqSpan = 5 kHz
  5.014  PSA          PeakSearch; MarkerToCenterFreq; RFCoupling = DC
  5.014  PSA          +Ampl = -76 dBm; InputAttenuation = 10 dB
  5.015  MATH         @Ampl = MEM; @Freq = 200E+3
  5.016  CALL         Sub Agilent PSA Get Amplitude Accuracy IEEE
  5.017  MATH         L[2] = @PSAAmplAcc / CONF("Agilent PSA")
  5.018  MATH         L[3] = RSS2(L[1], L[2]) * 2
  5.019  MATH         MEM = @Ampl - RefLvl
  5.020  ACC    -60   dBc            L3U                                   +DW
  5.021  MEMC         -60dBc         -0.0U +100.0U

  6.001  HEAD         -2 3rd Harmonic: 300 kHz
  6.002  TSET         TDESC = 3rd Harmonic
  6.003  PSA          RBW = 100 Hz; VBW = 300 Hz; RefLevel = -30 dBm
  6.003  PSA          CenterFreq = 300 kHz; FreqSpan = 5 kHz
  6.003  PSA          PeakSearch; MarkerToCenterFreq; RFCoupling = DC
  6.003  PSA          +Ampl = -76 dBm; InputAttenuation = 10 dB
  6.004  MATH         @Ampl = MEM; @Freq = 300E+3
  6.005  CALL         Sub Agilent PSA Get Amplitude Accuracy IEEE
  6.006  MATH         L[2] = @PSAAmplAcc / CONF("Agilent PSA")
  6.007  MATH         L[3] = RSS2(L[1], L[2]) * 2
  6.008  MATH         MEM = @Ampl - RefLvl
  6.009  ACC    -60   dBc            L3U                                   +DW
  6.010  MEMC         -60dBc         -0.0U +100.0U

  7.001  HEAD         -2 4th Harmonic: 400 kHz
  7.002  TSET         TDESC = 4th Harmonic
  7.003  PSA          RBW = 100 Hz; VBW = 300 Hz; RefLevel = -30 dBm
  7.003  PSA          CenterFreq = 400 kHz; FreqSpan = 5 kHz
  7.003  PSA          PeakSearch; MarkerToCenterFreq; RFCoupling = DC
  7.003  PSA          +Ampl = -76 dBm; InputAttenuation = 10 dB
  7.004  MATH         @Ampl = MEM; @Freq = 400E+3
  7.005  CALL         Sub Agilent PSA Get Amplitude Accuracy IEEE
  7.006  MATH         L[2] = @PSAAmplAcc / CONF("Agilent PSA")
  7.007  MATH         L[3] = RSS2(L[1], L[2]) * 2
  7.008  MATH         MEM = @Ampl - RefLvl
  7.009  ACC    -60   dBc            L3U                                   +DW
  7.010  MEMC         -60dBc         -0.0U +100.0U

  8.001  HEAD         -2 5th Harmonic: 500 kHz
  8.002  TSET         TDESC = 5th Harmonic
  8.003  PSA          RBW = 100 Hz; VBW = 300 Hz; RefLevel = -30 dBm
  8.003  PSA          CenterFreq = 500 kHz; FreqSpan = 5 kHz
  8.003  PSA          PeakSearch; MarkerToCenterFreq; RFCoupling = DC
  8.003  PSA          +Ampl = -76 dBm; InputAttenuation = 10 dB
  8.004  MATH         @Ampl = MEM; @Freq = 500E+3
  8.005  CALL         Sub Agilent PSA Get Amplitude Accuracy IEEE
  8.006  MATH         L[2] = @PSAAmplAcc / CONF("Agilent PSA")
  8.007  MATH         L[3] = RSS2(L[1], L[2]) * 2
  8.008  MATH         MEM = @Ampl - RefLvl
  8.009  ACC    -60   dBc            L3U                                   +DW
  8.010  MEMC         -60dBc         -0.0U +100.0U

  9.001  RSLT         =
  9.002  RSLT         =1 MHz
  9.003  TARGET       -p
  9.004  HEAD         -2 Fundamental: 1 MHz
  9.005  SCPI         FUNC:SHAP SIN;:VOLT 1.1;:FREQ 1MHz
  9.006  TARGET       -m
  9.007  PSA          RBW = 10 kHz; VBW = 30 kHz; RefLevel = -6 dBm
  9.007  PSA          CenterFreq = 1 MHz; FreqSpan = 500 kHz
  9.007  PSA          PeakSearch; MarkerToCenterFreq; RFCoupling = DC
  9.007  PSA          +Ampl = -6 dBm; InputAttenuation = 10 dB
  9.008  MATH         @Ampl = MEM; @Freq = 1E+6
  9.009  CALL         Sub Agilent PSA Get Amplitude Accuracy IEEE
  9.010  MATH         L[1] = @PSAAmplAcc / CONF("Agilent PSA")
  9.011  MATH         RefLvl = MEM
  9.012  HEAD         -2 2nd Harmonic: 2 MHz
  9.013  TSET         TDESC = 2nd Harmonic
  9.014  PSA          RBW = 10 kHz; VBW = 30 kHz; RefLevel = -30 dBm
  9.014  PSA          CenterFreq = 2 MHz; FreqSpan = 500 kHz
  9.014  PSA          PeakSearch; MarkerToCenterFreq; RFCoupling = DC
  9.014  PSA          +Ampl = -76 dBm; InputAttenuation = 10 dB
  9.015  MATH         @Ampl = MEM; @Freq = 2E+6
  9.016  CALL         Sub Agilent PSA Get Amplitude Accuracy IEEE
  9.017  MATH         L[2] = @PSAAmplAcc / CONF("Agilent PSA")
  9.018  MATH         L[3] = RSS2(L[1], L[2]) * 2
  9.019  MATH         MEM = @Ampl - RefLvl
  9.020  ACC    -45   dBc            L3U                                   +DW
  9.021  MEMC         -45dBc         -0.0U +100.0U

 10.001  HEAD         -2 3rd Harmonic: 3 MHz
 10.002  TSET         TDESC = 3rd Harmonic
 10.003  PSA          RBW = 10 kHz; VBW = 30 kHz; RefLevel = -30 dBm
 10.003  PSA          CenterFreq = 3 MHz; FreqSpan = 500 kHz
 10.003  PSA          PeakSearch; MarkerToCenterFreq; RFCoupling = DC
 10.003  PSA          +Ampl = -76 dBm; InputAttenuation = 10 dB
 10.004  MATH         @Ampl = MEM; @Freq = 3E+6
 10.005  CALL         Sub Agilent PSA Get Amplitude Accuracy IEEE
 10.006  MATH         L[2] = @PSAAmplAcc / CONF("Agilent PSA")
 10.007  MATH         L[3] = RSS2(L[1], L[2]) * 2
 10.008  MATH         MEM = @Ampl - RefLvl
 10.009  ACC    -45   dBc            L3U                                   +DW
 10.010  MEMC         -45dBc         -0.0U +100.0U

 11.001  HEAD         -2 4th Harmonic: 4 MHz
 11.002  TSET         TDESC = 4th Harmonic
 11.003  PSA          RBW = 10 kHz; VBW = 30 kHz; RefLevel = -30 dBm
 11.003  PSA          CenterFreq = 4 MHz; FreqSpan = 500 kHz
 11.003  PSA          PeakSearch; MarkerToCenterFreq; RFCoupling = DC
 11.003  PSA          +Ampl = -76 dBm; InputAttenuation = 10 dB
 11.004  MATH         @Ampl = MEM; @Freq = 4E+6
 11.005  CALL         Sub Agilent PSA Get Amplitude Accuracy IEEE
 11.006  MATH         L[2] = @PSAAmplAcc / CONF("Agilent PSA")
 11.007  MATH         L[3] = RSS2(L[1], L[2]) * 2
 11.008  MATH         MEM = @Ampl - RefLvl
 11.009  ACC    -45   dBc            L3U                                   +DW
 11.010  MEMC         -45dBc         -0.0U +100.0U

 12.001  HEAD         -2 5th Harmonic: 5 MHz
 12.002  TSET         TDESC = 5th Harmonic
 12.003  PSA          RBW = 10 kHz; VBW = 30 kHz; RefLevel = -30 dBm
 12.003  PSA          CenterFreq = 5 MHz; FreqSpan = 500 kHz
 12.003  PSA          PeakSearch; MarkerToCenterFreq; RFCoupling = DC
 12.003  PSA          +Ampl = -76 dBm; InputAttenuation = 10 dB
 12.004  MATH         @Ampl = MEM; @Freq = 5E+6
 12.005  CALL         Sub Agilent PSA Get Amplitude Accuracy IEEE
 12.006  MATH         L[2] = @PSAAmplAcc / CONF("Agilent PSA")
 12.007  MATH         L[3] = RSS2(L[1], L[2]) * 2
 12.008  MATH         MEM = @Ampl - RefLvl
 12.009  ACC    -45   dBc            L3U                                   +DW
 12.010  MEMC         -45dBc         -0.0U +100.0U

 13.001  RSLT         =
 13.002  RSLT         =15 MHz
 13.003  TARGET       -p
 13.004  HEAD         -2 Fundamental Frequency: 15 MHz
 13.005  SCPI         FUNC:SHAP SIN;:VOLT 1.1;:FREQ 15MHz
 13.006  TARGET       -m
 13.007  PSA          RBW = 100 kHz; VBW = 300 kHz; RefLevel = -6 dBm
 13.007  PSA          CenterFreq = 15 MHz; FreqSpan = 5 MHz
 13.007  PSA          PeakSearch; MarkerToCenterFreq; RFCoupling = DC
 13.007  PSA          +Ampl = -6 dBm; InputAttenuation = 10 dB
 13.008  MATH         @Ampl = MEM; @Freq = 15E+6
 13.009  CALL         Sub Agilent PSA Get Amplitude Accuracy IEEE
 13.010  MATH         L[1] = @PSAAmplAcc / CONF("Agilent PSA")
 13.011  MATH         RefLvl = MEM
 13.012  HEAD         -2 2nd Harmonic: 30 MHz
 13.013  TSET         TDESC = 2nd Harmonic
 13.014  PSA          RBW = 100 kHz; VBW = 300 kHz; RefLevel = -30 dBm
 13.014  PSA          CenterFreq = 30 MHz; FreqSpan = 5 MHz
 13.014  PSA          PeakSearch; MarkerToCenterFreq; RFCoupling = DC
 13.014  PSA          +Ampl = -76 dBm; InputAttenuation = 10 dB
 13.015  MATH         @Ampl = MEM; @Freq = 30E+6
 13.016  CALL         Sub Agilent PSA Get Amplitude Accuracy IEEE
 13.017  MATH         L[2] = @PSAAmplAcc / CONF("Agilent PSA")
 13.018  MATH         L[3] = RSS2(L[1], L[2]) * 2
 13.019  MATH         MEM = @Ampl - RefLvl
 13.020  ACC    -35   dBc            L3U                                   +DW
 13.021  MEMC         -35dBc         -0.0U +100.0U

 14.001  HEAD         -2 3rd Harmonic: 45 MHz
 14.002  TSET         TDESC = 3rd Harmonic
 14.003  PSA          RBW = 100 kHz; VBW = 300 kHz; RefLevel = -30 dBm
 14.003  PSA          CenterFreq = 45 MHz; FreqSpan = 5 MHz
 14.003  PSA          PeakSearch; MarkerToCenterFreq; RFCoupling = DC
 14.003  PSA          +Ampl = -76 dBm; InputAttenuation = 10 dB
 14.004  MATH         @Ampl = MEM; @Freq = 45E+6
 14.005  CALL         Sub Agilent PSA Get Amplitude Accuracy IEEE
 14.006  MATH         L[2] = @PSAAmplAcc / CONF("Agilent PSA")
 14.007  MATH         L[3] = RSS2(L[1], L[2]) * 2
 14.008  MATH         MEM = @Ampl - RefLvl
 14.009  ACC    -35   dBc            L3U                                   +DW
 14.010  MEMC         -35dBc         -0.0U +100.0U

 15.001  HEAD         -2 4th Harmonic: 60 MHz
 15.002  TSET         TDESC = 4th Harmonic
 15.003  PSA          RBW = 100 kHz; VBW = 300 kHz; RefLevel = -30 dBm
 15.003  PSA          CenterFreq = 60 MHz; FreqSpan = 5 MHz
 15.003  PSA          PeakSearch; MarkerToCenterFreq; RFCoupling = DC
 15.003  PSA          +Ampl = -76 dBm; InputAttenuation = 10 dB
 15.004  MATH         @Ampl = MEM; @Freq = 60E+6
 15.005  CALL         Sub Agilent PSA Get Amplitude Accuracy IEEE
 15.006  MATH         L[2] = @PSAAmplAcc / CONF("Agilent PSA")
 15.007  MATH         L[3] = RSS2(L[1], L[2]) * 2
 15.008  MATH         MEM = @Ampl - RefLvl
 15.009  ACC    -35   dBc            L3U                                   +DW
 15.010  MEMC         -35dBc         -0.0U +100.0U

 16.001  HEAD         -2 5th Harmonic: 75 MHz
 16.002  TSET         TDESC = 5th Harmonic
 16.003  PSA          RBW = 100 kHz; VBW = 300 kHz; RefLevel = -30 dBm
 16.003  PSA          CenterFreq = 75 MHz; FreqSpan = 5 MHz
 16.003  PSA          PeakSearch; MarkerToCenterFreq; RFCoupling = DC
 16.003  PSA          +Ampl = -76 dBm; InputAttenuation = 10 dB
 16.004  MATH         @Ampl = MEM; @Freq = 75E+6
 16.005  CALL         Sub Agilent PSA Get Amplitude Accuracy IEEE
 16.006  MATH         L[2] = @PSAAmplAcc / CONF("Agilent PSA")
 16.007  MATH         L[3] = RSS2(L[1], L[2]) * 2
 16.008  MATH         MEM = @Ampl - RefLvl
 16.009  ACC    -35   dBc            L3U                                   +DW
 16.010  MEMC         -35dBc         -0.0U +100.0U

 17.001  HEAD         -2
 17.002  HEAD
 17.003  SCPI         *RST
 17.004  PSA          Reset
 17.005  END
