﻿Copyright (c) (2014) Fluke Corporation.                  All rights reserved.
=============================================================================
INSTRUMENT:            Sub HP 33120A (1 yr) Frequency VER IEEE /LFCTR
DATE:                  2014-11-10 13:32:27
AUTHOR:                Fluke
REVISION:              $Revision: 9434 $
ADJUSTMENT THRESHOLD:  95%
NUMBER OF TESTS:       3
NUMBER OF LINES:       72
CONFIGURATION:         LF Counter
=============================================================================
#
#  Procedure Author:
#        DAC, DFM
#
#  Compatibility:
#        MET/CAL 8.0 or later
#
#  Additional Equipment Required:
#        None
#
#  The copyright for this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  IF           0
  1.002  IEEE         [@LFCTR]
  1.003  ENDIF

  1.004  RSLT         =
  1.005  HEAD         {FREQUENCY VERIFICATION}
  1.006  HEAD         -2 Sine Wave: 1 kHz
  1.007  TARGET       -p
  1.008  CALL         Sub Initialize /LFCTR
  1.009  CALL         Sub Reset /LFCTR

  1.010  DISP         Make the following connections:
  1.010  DISP
  1.010  DISP         [32]   UUT      to    [V @LFCTR_DevName]
  1.010  DISP         [32]  OUTPUT  ------> [V @LFCTR_Ch1]

  1.011  TSET         TDESC = Sine Wave
  1.012  SCPI         OUTP:LOAD 50;:VOLT:UNIT VRMS
  1.013  SCPI         FUNC:SHAP SIN;:VOLT 3.5;:FREQ 1kHz
  1.014  MATH         @LFCTR_MeasTime = "2s"
  1.015  MATH         @LFCTR_Func = "FreqCh1"
  1.016  MATH         @LFCTR_Ch1Imp = "LoZ"
# Look up instrument name of external frequency reference.
  1.017  MATH         ExtFreqRef = INI("startup", "FreqRefDevName")
  1.018  TARGET       -m
  1.019  CALL         Sub Measure /LFCTR
# Retrieve accuracy for external frequency reference.
  1.020  MATH         L[1] = (ACCV(ExtFreqRef, "Timebase", MEM)) / 1E+3
  1.021  MATH         MEM = MEM / 1E+3
  1.022  ACC          kHz            L1U
  1.023  MEMC   1     1.00000kHz     20P%

  2.001  HEAD         -2 Square Wave: 500 Hz
  2.002  TSET         TDESC = Square Wave
  2.003  SCPI         FUNC:SHAP SQU;:VOLT 3.5;:FREQ 1kHz
  2.003  SCPI         BM:INT:RATE 500Hz;:BM:NCYC 1;:BM:STATE ON
  2.004  TARGET       -m
  2.005  CALL         Sub Measure /LFCTR
  2.006  MATH         L[1] = (ACCV(ExtFreqRef, "Timebase", MEM))
  2.007  ACC          Hz             L1U
  2.008  MEMC   10    500Hz          1%

  3.001  HEAD         -2
  3.002  HEAD
  3.003  SCPI         *RST
  3.004  CALL         Sub Reset /LFCTR
  3.005  END
