﻿Fluke Calibration                                           MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Fluke 6x00-2(AU) (1 yr) 240 V Mains VER RS-232 /DMM
INSTRUMENT:            Sub Fluke 6x00-2(DE) (1 yr) 230 V Mains VER RS-232 /DMM
INSTRUMENT:            Sub Fluke 6x00-2(NL) (1 yr) 230 V Mains VER RS-232 /DMM
INSTRUMENT:            Sub Fluke 6x00-2(UK) (1 yr) 240 V Mains VER RS-232 /DMM
DATE:                  2014-11-20 12:56:00
AUTHOR:                Fluke Corporation
REVISION:              $Revision: 9718 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       3
NUMBER OF LINES:       94
CONFIGURATION:         Digital Multimeter
=============================================================================
#
#  Procedure Author(s):
#        DAC
#
#  Source:
#        6x00-2 Performance Verification
#        Rev 27 June 2014
#
#  Compatibility:
#        MET/CAL 8.0 or later
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Precision Measurement
#  Limited.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  IF           0
  1.002  IEEE         [@DMM]
  1.003  ENDIF

  1.004  RSLT         =
  1.005  HEAD         {POWER UP, [V @MainsVoltage] MAINS VOLTAGE MEASUREMENT}
  1.006  MATH         @DMM_Func = "AC_Voltage"
  1.007  MATH         @DMM_Freq = "50 Hz"
  1.008  TARGET       -p
  1.009  TSET         CPT = [V @MainsVoltage]; MEAS = SA
  1.010  TSET         NTHROW = 0; NMEAS = 1
  1.011  CALL         Sub Reset /DMM
  1.012  CALL         Sub Setup /DMM
  1.013  DISP         Connect [V @MainsCable] mains cable adapter to
  1.013  DISP         the [V @DMM_DevName] as follows:
  1.013  DISP
  1.013  DISP         [32] Adapter              [V @DMM_DevName]
  1.013  DISP         [32] Red Lead <---------> [V @DMM_InputHi]
  1.013  DISP         [32] Blue Lead <--------> [V @DMM_InputLo]
  1.013  DISP
  1.013  DISP         Plug the cable adapter into same [V @MainsVoltage] mains
  1.013  DISP         that the UUT is plugged into.
  1.014  CALL         Sub Fluke 6x00-2 Stop Mains Meas Output RS-232
  1.015  TARGET       -m
  1.016  CALL         Sub Read /DMM
  1.017  CALL         Sub Get Accuracy /DMM
  1.018  MATH         L[1] = @DMM_Acc
  1.019  ACC          V              L1U
  1.020  PORT         [I!][I$]

  1.021  IF           FIND(MEM2, "Hz", 1)
  1.022  PORT         [I$]
  1.023  ENDIF

  1.024  MATH         MEM = MEM2
  1.025  MEMCX        V              2% 0.3U

  2.001  IF           ZCMP(@ModelNum, "6500-2")
  2.002  MATH         @DMM_Func = "Frequency"
  2.003  MATH         @DMM_Ampl = @DMM_Meas
  2.004  TARGET       -p
  2.005  TSET         CPT = 50.0 Hz; MEAS = SA; NTHROW = 0; NMEAS = 1
  2.006  CALL         Sub Setup /DMM
  2.007  TARGET       -m
  2.008  CALL         Sub Read /DMM
  2.009  CALL         Sub Get Accuracy /DMM
  2.010  MATH         L[1] = @DMM_Acc
  2.011  ACC          Hz             L1U
  2.012  PORT         [I]
  2.013  MEMCX        Hz             2.0U
  3.001  ENDIF

  3.002  HEAD
  3.003  END
