﻿Fluke Calibration                                           MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Fluke 6x00-2 Query Identification RS-232
DATE:                  2014-11-25 12:14:29
AUTHOR:                Fluke Corporation
REVISION:              $Revision: 9718 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       1
NUMBER OF LINES:       147
=============================================================================
#
#  Procedure Author(s):
#        DAC
#
#  Source:
#        Fluke 6200B, 6500B Final Test and Calibration Procedures, Rev O
#
#  Compatibility:
#        MET/CAL 8.0 or later
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Precision Measurement
#  Limited.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  CALL         Sub Fluke 6x00-2 Stop Mains Meas Output RS-232

  1.002  PORT         [V @GetModelNumber][I$]
  1.003  MATH         Line1 = MEM2
  1.004  PORT         [I$]
  1.005  MATH         Line2 = MEM2
  1.006  PORT         [I$]
  1.007  MATH         Line3 = MEM2

# Parse and validate line 1 => Get firmware revision
  1.008  MATH         ExpectedResp = "[YB] Fluke EuroPAT 6x00- V D.D.D"
  1.009  MATH         L[1] = LEN(ExpectedResp)
  1.010  MATH         @Error = (LEN(Line1) != L[1])

  1.011  IF           NOT(@Error)
  1.012  MATH         Prefix = "[YB] Fluke EuroPAT"
  1.013  MATH         @Error = NOT(ZCMP(SUB(Line1, 1, LEN(Prefix)), Prefix))
  1.014  ENDIF

  1.015  IF           NOT(@Error)
  1.016  MATH         i = FIND(Line1, "V", 1)

  1.017  IF           i > 0
  1.018  MATH         @FirmwareRev = SUB(Line1, i, LEN("V D.D.D"))
  1.019  ELSE
  1.020  MATH         @Error = 1
  1.021  ENDIF

  1.022  ENDIF

  1.023  IF           @Error
  1.024  DISP         First line of UUT model number query response is either
  1.024  DISP         not [L1] characters or not expected format.
  1.024  DISP
  1.024  DISP         Received:  "[V Line1]"
  1.024  DISP         Expected:  "[V ExpectedResp]"
  1.024  DISP
  1.024  DISP         Where "x" is "2" or "5",
  1.024  DISP         and "D.D.D" is the firmware revision.
  1.025  END
  1.026  ENDIF

# Parse and validate line 2 => Get model number
  1.027  MATH         ExpectedResp = "[6x]"
  1.028  MATH         L[2] = LEN(ExpectedResp)
  1.029  MATH         @Error = (LEN(Line2) != L[2])

  1.030  IF           NOT(@Error)

  1.031  IF           ZCMP(SUB(Line2, 3, 1), "2")
  1.032  MATH         @ModelNum = "6200-2"
  1.033  ELSEIF       ZCMP(SUB(Line2, 3, 1), "5")
  1.034  MATH         @ModelNum = "6500-2"
  1.035  ELSE
  1.036  MATH         @Error = 1
  1.037  ENDIF

  1.038  ENDIF

  1.039  IF           @Error
  1.040  DISP         Second line of UUT model number query response is either
  1.040  DISP         not [L2] characters or not expected format.
  1.040  DISP
  1.040  DISP         Received:  "[V Line2]"
  1.040  DISP         Expected:  "[V ExpectedResp]"
  1.040  DISP
  1.040  DISP         Where "x" is "2" or "5".
  1.041  END
  1.042  ENDIF

# Parse and validate line 3 => Get country code
  1.043  MATH         ExpectedResp1 = "CC[YY]"; ExpectedResp2 = "CC[YYY]"
  1.044  MATH         L[3] = LEN(ExpectedResp1); L[4] = LEN(ExpectedResp2)
  1.045  MATH         @Error = ((LEN(Line3) != L[3]) && (LEN(Line3) != L[4]))

  1.046  IF           NOT(@Error)

  1.047  IF           ZCMP(Line3, "CC[AUS]")
  1.048  MATH         @CountryCode = "AU"
  1.049  ELSEIF       ZCMP(Line3, "CC[GER]")
  1.050  MATH         @CountryCode = "DE"
  1.051  ELSEIF       ZCMP(Line3, "CC[NL]")
  1.052  MATH         @CountryCode = "NL"
  1.053  ELSEIF       ZCMP(Line3, "CC[UK]")
  1.054  MATH         @CountryCode = "UK"
  1.055  ELSE
  1.056  MATH         @Error = 1
  1.057  ENDIF

  1.058  ENDIF

  1.059  IF           @Error

  1.060  DISP         Third line of UUT model number query response is either
  1.060  DISP         not [L3] or [L4] characters or not expected format.
  1.060  DISP
  1.060  DISP         Received:  "[V Line3]"
  1.060  DISP         Expected:  "[V ExpectedResp1]" or "[V ExpectedResp2]"
  1.060  DISP
  1.060  DISP         Where "YY" is "NL" or "UK",
  1.060  DISP         and "YYY" is "AUS".
  1.061  END
  1.062  ENDIF

  1.063  DISP         Model:           [V @ModelNum]([V @CountryCode])
  1.063  DISP         Firmware Level:  [V @FirmwareRev]

  1.064  RSLT         =
  1.065  RSLT         =Firmware Level:  [V @FirmwareRev]

  1.066  END
