﻿Fluke Calibration                                           MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Fluke 6500-2 (1 yr) 110 V Mains VER RS-232 /DMM
DATE:                  2014-12-01 10:06:33
AUTHOR:                Fluke Corporation
REVISION:              $Revision: 9718 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       3
NUMBER OF LINES:       82
CONFIGURATION:         Digital Multimeter
=============================================================================
#
#  Procedure Author(s):
#        DAC
#
#  Source:
#        6x00-2 Performance Verification
#        Rev 27 June 2014
#
#  Compatibility:
#        MET/CAL 8.0 or later
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Precision Measurement
#  Limited.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  IF           0
  1.002  IEEE         [@DMM]
  1.003  ENDIF

  1.004  RSLT         =
  1.005  HEAD         {POWER UP, 110 V MAINS VOLTAGE MEASUREMENT}
  1.006  MATH         @DMM_Func = "AC_Voltage"
  1.007  MATH         @DMM_Freq = "50 Hz"
  1.008  TARGET       -p
  1.009  TSET         CPT = 110 V; MEAS = SA; NTHROW = 0; NMEAS = 1
  1.010  CALL         Sub Fluke 6x00-2 Stop Mains Meas Output RS-232
  1.011  CALL         Sub Reset /DMM
  1.012  CALL         Sub Setup /DMM
  1.013  TARGET       -m
  1.014  CALL         Sub Read /DMM
  1.015  MATH         @PowerStripV = @DMM_Meas
  1.016  CALL         Sub Get Accuracy /DMM
  1.017  MATH         L[1] = @DMM_Acc
  1.018  ACC          V              L1U
  1.019  PORT         [I!][I$]

  1.020  IF           FIND(MEM2, "Hz", 1)
  1.021  PORT         [I$]
  1.022  ENDIF

  1.023  MATH         MEM = MEM2
  1.024  MEMCX        V              2% 0.3U

  2.001  MATH         @DMM_Func = "Frequency"
  2.002  MATH         @DMM_Ampl = @DMM_Meas
  2.003  TARGET       -p
  2.004  TSET         CPT = 50.0 Hz; MEAS = SA; NTHROW = 0; NMEAS = 1
  2.005  CALL         Sub Setup /DMM
  2.006  TARGET       -m
  2.007  CALL         Sub Read /DMM
  2.008  MATH         @DMM_Meas = MEM
  2.009  CALL         Sub Get Accuracy /DMM
  2.010  MATH         L[1] = @DMM_Acc
  2.011  ACC          Hz             L1U
  2.012  PORT         [I]
  2.013  MEMCX        Hz             2.0U

  3.001  HEAD
  3.002  END
