﻿Fluke Calibration                                           MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub 6500-2(AU) (1 yr) 110V Sub Leak VER RS-232/5320,DMM
INSTRUMENT:            Sub 6500-2(NL) (1 yr) 110V Sub Leak VER RS-232/5320,DMM
INSTRUMENT:            Sub 6500-2(UK) (1 yr) 110V Sub Leak VER RS-232/5320,DMM
DATE:                  2014-11-20 12:56:19
AUTHOR:                Fluke
REVISION:              $Revision: 9642 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       4
NUMBER OF LINES:       99
CONFIGURATION:         Fluke 5320A
CONFIGURATION:         Digital Multimeter
=============================================================================
#
#  Procedure Author:
#        DAC
#
#  Source:
#        6x00-2 Performance Verification
#        Rev 27 June 2014
#
#  Compatibility:
#        MET/CAL 8.0 or later
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Precision Measurement
#  Limited.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  IF           0
  1.002  5320         Reset
  1.003  IEEE         [@DMM]
  1.004  ENDIF

  1.005  RSLT         =
  1.006  HEAD         {SUBSTITUTE LEAKAGE: [V @MainsVoltage] Mains}
  1.007  TARGET       -p
  1.008  PORT         [V @SubstituteLeakageTest][D1500]
  1.009  5320         Mode = IDS; UUTOutputResistance = 2000 Ohms
  1.009  5320         +LeakageCurrent = 0.25 mA
# Determine current "seen" by UUT at 110 V and reference accuracy.
  1.010  MATH         MEM = @PowerStripV / (@MainsV / (MEM1 * 1E-3))
  1.011  MATH         L[1] = ACCV("Fluke 5320A", "Amps IDS", MEM) / 1E-3
  1.012  MATH         MEM = MEM / 1E-3
  1.013  ACC          mA             L1U
  1.014  TARGET       -m
  1.015  PORT         [CLR][V @Go]
  1.016  MATH         SAFEON("UUT", @MainsVoltage, "Sine")
  1.017  WAIT         -t 5 Waiting for test to complete...
  1.018  MATH         SAFEOFF("UUT")
  1.019  PORT         [T5000][I]
  1.020  MEMCX  20    mA             5% 0.05U

  2.001  PORT         [V @SubstituteLeakageTest][D1500]
  2.002  5320         Mode = IDS; UUTOutputResistance = 2000 Ohms
  2.002  5320         +LeakageCurrent = 5.48 mA
  2.003  MATH         MEM = @PowerStripV / (@MainsV / (MEM1 * 1E-3))
  2.004  MATH         L[1] = ACCV("Fluke 5320A", "Amps IDS", MEM) / 1E-3
  2.005  MATH         MEM = MEM / 1E-3
  2.006  ACC          mA             L1U
  2.007  TARGET       -m
  2.008  PORT         [CLR][V @Go]
  2.009  MATH         SAFEON("UUT", @MainsVoltage, "Sine")
  2.010  WAIT         -t 5 Waiting for test to complete...
  2.011  MATH         SAFEOFF("UUT")
  2.012  PORT         [T5000][I]
  2.013  MEMCX  20    mA             5% 0.05U

  3.001  PORT         [V @SubstituteLeakageTest][D1500]
  3.002  5320         Mode = IDS; UUTOutputResistance = 2000 Ohms
  3.002  5320         +LeakageCurrent = 15.65 mA
  3.003  MATH         MEM = @PowerStripV / (@MainsV / (MEM1 * 1E-3))
  3.004  MATH         L[1] = ACCV("Fluke 5320A", "Amps IDS", MEM) / 1E-3
  3.005  MATH         MEM = MEM / 1E-3
  3.006  ACC          mA             L1U
  3.007  TARGET       -m
  3.008  PORT         [CLR][V @Go]
  3.009  MATH         SAFEON("UUT", @MainsVoltage, "Sine")
  3.010  WAIT         -t 5 Waiting for test to complete...
  3.011  MATH         SAFEOFF("UUT")
  3.012  PORT         [T5000][I]
  3.013  MEMCX  20    mA             5% 0.05U

  4.001  HEAD
  4.002  CALL         Sub Fluke 6x00-2 Stop Mains Meas Output RS-232
  4.003  5320         Reset
  4.004  END
