﻿Fluke Calibration                                           MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Fluke 6500-2(AU) (1 yr) Bond Test VER RS-232 /5320
INSTRUMENT:            Sub Fluke 6500-2(NL) (1 yr) Bond Test VER RS-232 /5320
INSTRUMENT:            Sub Fluke 6500-2(UK) (1 yr) Bond Test VER RS-232 /5320
DATE:                  2014-11-26 12:08:15
AUTHOR:                Fluke
REVISION:              $Revision: 9718 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       9
NUMBER OF LINES:       205
CONFIGURATION:         Fluke 5320A
=============================================================================
#
#  Procedure Author:
#        DAC
#
#  Source:
#        6x00-2 Performance Verification
#        Rev 27 June 2014
#
#  Compatibility:
#        MET/CAL 8.0 or later
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Precision Measurement
#  Limited.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  RSLT         =
  1.002  HEAD         {BOND TEST: [V @MainsVoltage] Mains}
  1.003  RSLT         =
  1.004  HEAD         -2{200 mA}
  1.005  TARGET       -p
  1.006  PORT         [V @Setup]

  1.007  DO

  1.008  IF           ZCMP(@MainsVoltage, "110 V")
  1.009  MATH         @MainsCable = "Fluke PN 2743368 (UK)"
  1.010  DISP         Connect [V @MainsCable] mains cable adapter to
  1.010  DISP         Line socket (UK) <=> 110 V line plug cable adapter.
  1.011  ENDIF

  1.012  DISP         Connect the green (GND) banana lead of the
  1.012  DISP         [V @MainsCable] mains cable adapter to the
  1.012  DISP         UUT BOND 25A/200mA (green) socket.

  1.013  IF           ZCMP(@MainsVoltage, "110 V")
  1.014  DISP         Connect one end of the single banana test lead to the
  1.014  DISP         110 V line plug GND prong using single banana
  1.014  DISP         crocodile clip.
  1.015  ELSE
  1.016  DISP         Connect one end of the single banana test lead to the
  1.016  DISP         mains cable adapter plug GND prong using single banana
  1.016  DISP         crocodile clip.
  1.016  DISP
  1.017  ENDIF

  1.018  DISP         Insert the other end of the single banana test lead in
  1.018  DISP         the UUT BOND ZERO socket.
  1.018  DISP
  1.018  DISP         Firmly hold the lead in the BOND ZERO socket until
  1.018  DISP         you are instructed to change the connections.
  1.019  PORT         [V @Go][D1500][V @Go]
  1.020  WAIT         -t 5 Waiting for zero to complete...
  1.021  OPBR         -z Is UUT displaying the following?
  1.021  OPBR
  1.021  OPBR         [32] Bond Zero
  1.021  OPBR
  1.021  OPBR         [32] PASS
  1.022  UNTIL        MEM1

# Clear Bond Null when procedure terminates.
  1.023  CLEAR        -c Sub Fluke 6500-2 Clear Bond Zero RS-232

  1.024  5320         Mode = GBR; +Resistance = 0.10 Ohm; Setup

  1.025  IF           ZCMP(@MainsVoltage, "110 V")
  1.026  DISP         Remove lead from UUT BOND ZERO socket.
  1.026  DISP
  1.026  DISP         Disconnect test lead from plug cable adapter GND prong.
  1.026  DISP
  1.026  DISP         Disconnect crocodile clip from test lead.
  1.026  DISP
  1.026  DISP         Disconnect [V @MainsCable] mains cable adapter from UUT.

  1.027  DISP         Connect test lead from UUT UUT BOND 25A/200mA (green)
  1.027  DISP         socket to 5320A Z GND N (blue) terminal.

  1.028  DISP         Connect cable adapters as follows:
  1.028  DISP
  1.028  DISP         1. Connect PAT 110 V cable adapter plug to
  1.028  DISP         [32]  UUT 110 V socket.
  1.028  DISP
  1.028  DISP         2. Connect 110 V cable adapter plug to
  1.028  DISP         [32]  PAT 110 V cable adapter socket.
  1.028  DISP
  1.028  DISP         3. [V @MainsCable] mains cable adapter plug to
  1.028  DISP         [32]  110 V cable adapter socket.
  1.028  DISP
  1.028  DISP         4. Connect the green (GND) banana lead of the
  1.028  DISP         [32]  [V @MainsCable] mains cable adapter to
  1.028  DISP         [32]  5320A Z GND PE (green) terminal.
  1.029  ELSE

  1.030  IF           ZCMPI(@CountryCode, "UK")
  1.031  PIC          5320_6500-2_UK_GBR
  1.032  ELSE
  1.033  PIC          5320_6500-2_EU_GBR
  1.034  ENDIF

  1.035  ENDIF

  1.036  PORT         [V @BondTest200mA][D1500]
  1.037  5320         Mode = GBR; +Resistance = 0.10 Ohm; Operate
  1.038  TARGET       -m
  1.039  PORT         [CLR][V @Go]
  1.040  WAIT         -t 5 Waiting for test to complete...
  1.041  PORT         [T5000][I]
  1.042  MEMCX  20    Z              5% 0.04U

  2.001  PORT         [V @BondTest200mA][D1500]
  2.002  5320         Mode = GBR; +Resistance = 1.00 Ohm
  2.003  TARGET       -m
  2.004  PORT         [CLR][V @Go]
  2.005  WAIT         -t 5 Waiting for test to complete...
  2.006  PORT         [T5000][I]
  2.007  MEMCX  20    Z              5% 0.04U

  3.001  PORT         [V @BondTest200mA][D1500]
  3.002  5320         Mode = GBR; +Resistance = 10.00 Ohm
  3.003  TARGET       -m
  3.004  PORT         [CLR][V @Go]
  3.005  WAIT         -t 5 Waiting for test to complete...
  3.006  PORT         [T5000][I]
  3.007  MEMCX  20    Z              5% 0.04U

  4.001  PORT         [V @BondTest200mA][D1500]
  4.002  5320         Mode = GBR; +Resistance = 18.00 Ohm
  4.003  TARGET       -m
  4.004  PORT         [CLR][V @Go]
  4.005  WAIT         -t 5 Waiting for test to complete...
  4.006  PORT         [T5000][I]
  4.007  MEMCX  20    Z              5% 0.04U

  5.001  5320         Standby
  5.002  CALL         Sub Fluke 6x00-2 Stop Mains Meas Output RS-232

  5.003  RSLT         =
  5.004  HEAD         -2{25 A}
  5.005  TARGET       -p
  5.006  PORT         [V @BondTest25A][D1500]
  5.007  5320         Mode = GBR; +Resistance = 0.10 Ohm
  5.008  TARGET       -m
  5.009  PORT         [CLR][V @Go]
  5.010  WAIT         -t 5 Waiting for test to complete...
  5.011  PORT         [T5000][I]
  5.012  MEMCX  20    Z              5% 0.04U

  6.001  PORT         [V @BondTest25A][D1500]
  6.002  5320         Mode = GBR; +Resistance = 1.00 Ohm
  6.003  TARGET       -m
  6.004  PORT         [CLR][V @Go]
  6.005  WAIT         -t 5 Waiting for test to complete...
  6.006  PORT         [T5000][I]
  6.007  MEMCX  20    Z              5% 0.04U

  7.001  PORT         [V @BondTest25A][D1500]
  7.002  5320         Mode = GBR; +Resistance = 10.00 Ohm
  7.003  TARGET       -m
  7.004  PORT         [CLR][V @Go]
  7.005  WAIT         -t 5 Waiting for test to complete...
  7.006  PORT         [T5000][I]
  7.007  MEMCX  20    Z              5% 0.04U

  8.001  PORT         [V @BondTest25A][D1500]
  8.002  5320         Mode = GBR; +Resistance = 18.00 Ohm
  8.003  TARGET       -m
  8.004  PORT         [CLR][V @Go]
  8.005  WAIT         -t 5 Waiting for test to complete...
  8.006  PORT         [T5000][I]
  8.007  MEMCX  20    Z              5% 0.04U

  9.001  HEAD         -2
  9.002  HEAD
  9.003  5320         Reset
  9.004  DISP         Disconnect all leads from the 5320A.
  9.004  DISP
  9.004  DISP         Disconnect the lead from the
  9.004  DISP         UUT BOND 25A/200mA socket.
  9.005  CALL         Sub Fluke 6500-2 Clear Bond Zero RS-232
  9.006  CLEAR        -c
  9.007  END
