﻿Fluke Calibration                                           MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Fluke 6500-2(AU) (1 yr) Insulation VER RS-232 /5320
INSTRUMENT:            Sub Fluke 6500-2(NL) (1 yr) Insulation VER RS-232 /5320
INSTRUMENT:            Sub Fluke 6500-2(UK) (1 yr) Insulation VER RS-232 /5320
DATE:                  2014-11-26 14:20:17
AUTHOR:                Fluke
REVISION:              $Revision: 9709 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       7
NUMBER OF LINES:       132
CONFIGURATION:         Fluke 5320A
=============================================================================
#
#  Procedure Author:
#        DAC
#
#  Source:
#        6x00-2 Performance Verification
#        Rev 27 June 2014
#
#  Compatibility:
#        MET/CAL 8.0 or later
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Precision Measurement
#  Limited.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  RSLT         =
  1.002  HEAD         {INSULATION TEST: [V @MainsVoltage] Mains}
  1.003  TARGET       -p
  1.004  TSET         TDESC = 0.10 MΩ @ 250 V
  1.005  5320         Mode = HR; +Res = 0.10 MOhm; TestVolt = 250 V; Setup

  1.006  IF           ZCMP(@MainsVoltage, "110 V")
  1.007  DISP         Connect [V @MainsCable] mains cable adapter to 5320A
  1.007  DISP         as follows:
  1.007  DISP
  1.007  DISP         [32] Cable Adapter          5320A
  1.007  DISP         [32] Red Lead <-------> OUTPUT HIΩ HI
  1.007  DISP         [32] Green Lead <-----> OUTPUT HIΩ LO
  1.008  ELSEIF       ZCMPI(@CountryCode, "UK")
  1.009  PIC          5320_6500-2_UK_Insulation
  1.010  ELSE
  1.011  PIC          5320_6500-2_EU_Insulation
  1.012  ENDIF

  1.013  PORT         [V @500VInsulationTest][D1500][V @Go][D1500]
# Note, pressing the righ arrow key selects 250 V.
  1.014  PORT         [V @Right][D1500]
  1.015  5320         Mode = HR; +Res = 0.10 MOhm; TestVolt = 250 V; Operate
  1.016  TARGET       -m
  1.017  PORT         [CLR][V @Go]
  1.018  MATH         SAFEON("UUT", "250 V", "")
  1.019  WAIT         -t 10 Waiting for test to complete...
  1.020  MATH         SAFEOFF("UUT")
  1.021  PORT         [T5000][I]
  1.022  MEMCX  300   0.10MZ         5% 0.02U

  2.001  TSET         TDESC = 0.01 MΩ @ 500 V
  2.002  PORT         [V @500VInsulationTest][D1500][V @Go][D1500]
  2.003  5320         Mode = HR; +Res = 0.10 MOhm; TestVolt = 500 V
  2.004  TARGET       -m
  2.005  PORT         [CLR][V @Go]
  2.006  MATH         SAFEON("UUT", "500 V", "")
  2.007  WAIT         -t 10 Waiting for test to complete...
  2.008  MATH         SAFEOFF("UUT")
  2.009  PORT         [T5000][I]
  2.010  MEMCX  300   0.10MZ         5% 0.02U

  3.001  TSET         TDESC = 46.00 MΩ @ 250 V
  3.002  PORT         [V @500VInsulationTest][D1500][V @Go][D1500]
  3.003  PORT         [V @Right][D1500]
  3.004  5320         Mode = HR; +Res = 46.00 MOhm; TestVolt = 250 V
  3.005  TARGET       -m
  3.006  PORT         [CLR][V @Go]
  3.007  MATH         SAFEON("UUT", "250 V", "")
  3.008  WAIT         -t 10 Waiting for test to complete...
  3.009  MATH         SAFEOFF("UUT")
  3.010  PORT         [T5000][I]
  3.011  MEMCX  300   46.00MZ        5% 0.02U

  4.001  TSET         TDESC = 46.00 MΩ @ 500 V
  4.002  PORT         [V @500VInsulationTest][D1500][V @Go][D1500]
  4.003  5320         Mode = HR; +Res = 46.00 MOhm; TestVolt = 500 V
  4.004  TARGET       -m
  4.005  PORT         [CLR][V @Go]
  4.006  MATH         SAFEON("UUT", "500 V", "")
  4.007  WAIT         -t 10 Waiting for test to complete...
  4.008  MATH         SAFEOFF("UUT")
  4.009  PORT         [T5000][I]
  4.010  MEMCX  300   46.00MZ        5% 0.02U

  5.001  TSET         TDESC = 270 MΩ @ 250 V
  5.002  PORT         [V @500VInsulationTest][D1500][V @Go][D1500]
  5.003  PORT         [V @Right][D1500]
  5.004  5320         Mode = HR; +Res = 270 MOhm; TestVolt = 250 V
  5.005  TARGET       -m
  5.006  PORT         [CLR][V @Go]
  5.007  MATH         SAFEON("UUT", "250 V", "")
  5.008  WAIT         -t 10 Waiting for test to complete...
  5.009  MATH         SAFEOFF("UUT")
  5.010  PORT         [T5000][I]
  5.011  MEMCX  300   270MZ          10% 2U

  6.001  TSET         TDESC = 270 MΩ @ 500 V
  6.002  PORT         [V @500VInsulationTest][D1500][V @Go][D1500]
  6.003  5320         Mode = HR; +Res = 270 MOhm; TestVolt = 500 V
  6.004  TARGET       -m
  6.005  PORT         [CLR][V @Go]
  6.006  MATH         SAFEON("UUT", "500 V", "")
  6.007  WAIT         -t 10 Waiting for test to complete...
  6.008  MATH         SAFEOFF("UUT")
  6.009  PORT         [T5000][I]
  6.010  MEMCX  300   270MZ          10% 2U

  7.001  HEAD
  7.002  5320         Reset
  7.003  CALL         Sub Fluke 6x00-2 Stop Mains Meas Output RS-232
  7.004  END
