﻿Fluke Calibration                                           MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Fluke 6500-2(AU) (1 yr) Leakage I VER RS-232 /5320
INSTRUMENT:            Sub Fluke 6500-2(NL) (1 yr) Leakage I VER RS-232 /5320
INSTRUMENT:            Sub Fluke 6500-2(UK) (1 yr) Leakage I VER RS-232 /5320
DATE:                  2014-11-24 08:20:25
AUTHOR:                Fluke
REVISION:              $Revision: 9705 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       3
NUMBER OF LINES:       76
CONFIGURATION:         Fluke 5320A
=============================================================================
#
#  Procedure Author:
#        DAC
#
#  Source:
#        6x00-2 Performance Verification
#        Rev 27 June 2014
#
#  Compatibility:
#        MET/CAL 8.0 or later
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Precision Measurement
#  Limited.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  RSLT         =
  1.002  HEAD         {LEAKAGE CURRENT: [V @MainsVoltage] Mains}
  1.003  TARGET       -p
  1.004  5320         Mode = IDD; +LeakageCurrent = 0.25 mA; Setup
  1.005  PORT         [V @LoadLeakageTest][D1500][V @Go][D1500]
  1.006  5320         Mode = IDD; +LeakageCurrent = 0.25 mA; Operate
  1.007  TARGET       -m
  1.008  PORT         [CLR][V @Go][D1500][V @Yes][D1500][V @Go]
  1.009  MATH         SAFEON("UUT", @MainsVoltage, "Sine")
  1.010  WAIT         -t 4 Waiting for test...
  1.011  MATH         SAFEOFF("UUT")
  1.012  5320         Mode = IDD; +LeakageCurrent = 0.25 mA; Read
  1.013  MATH         MEM1 = MEM
  1.014  WAIT         -t 1 Waiting for test complete...
  1.015  PORT         [T5000][I!][I!][I]
  1.016  MEMCX  20    mA             4% 0.05U

  2.001  5320         Mode = IDD; +LeakageCurrent = 10.45 mA; Setup
  2.002  PORT         [V @LoadLeakageTest][D1500][V @Go][D1500]
  2.003  5320         Mode = IDD; +LeakageCurrent = 10.45 mA; Operate
  2.004  TARGET       -m
  2.005  PORT         [CLR][V @Go][D1500][V @Yes][D1500][V @Go]
  2.006  MATH         SAFEON("UUT", @MainsVoltage, "Sine")
  2.007  WAIT         -t 4 Waiting for test...
  2.008  MATH         SAFEOFF("UUT")
  2.009  5320         Mode = IDD; +LeakageCurrent = 10.45 mA; Read
  2.010  MATH         MEM1 = MEM
  2.011  WAIT         -t 1 Waiting for test complete...
  2.012  PORT         [T5000][I!][I!][I]
  2.013  MEMCX  20    mA             4% 0.05U

  3.001  HEAD
  3.002  5320         Reset
  3.003  CALL         Sub Fluke 6x00-2 Stop Mains Meas Output RS-232
  3.004  DISP         Remove green adapter lead from 5320A OUTPUT LO.
  3.005  END
