﻿Fluke Calibration                                           MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Fluke 6500-2(AU) (1 yr) Touch Curr VER RS-232 /5320
INSTRUMENT:            Sub Fluke 6500-2(NL) (1 yr) Touch Curr VER RS-232 /5320
INSTRUMENT:            Sub Fluke 6500-2(UK) (1 yr) Touch Curr VER RS-232 /5320
DATE:                  2014-11-20 16:19:49
AUTHOR:                Fluke
REVISION:              $Revision: 9642 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       4
NUMBER OF LINES:       93
CONFIGURATION:         Fluke 5320A
=============================================================================
#
#  Procedure Author:
#        DAC
#
#  Source:
#        6x00-2 Performance Verification
#        Rev 27 June 2014
#
#  Compatibility:
#        MET/CAL 8.0 or later
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Precision Measurement
#  Limited.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  RSLT         =
  1.002  HEAD         {TOUCH CURRENT: [V @MainsVoltage] Mains}
  1.003  TARGET       -p
  1.004  5320         Mode = IDP; +LeakageCurrent = 0.10 mA; Setup

  1.005  IF           ZCMPI(@CountryCode, "UK")
  1.006  PIC          5320_6500-2_UK_TouchCurrent
  1.007  ELSE
  1.008  PIC          5320_6500-2_EU_TouchCurrent
  1.009  ENDIF

  1.010  PORT         [V @ContactCurrentTest][D1500]
  1.011  5320         Mode = IDP; +LeakageCurrent = 0.10 mA; Operate
  1.012  TARGET       -m
  1.013  PORT         [CLR][V @Go][D1500][V @Yes]
  1.014  MATH         SAFEON("UUT", @MainsVoltage, "Sine")
  1.015  WAIT         -t 5 Waiting for test to complete...
  1.016  MATH         SAFEOFF("UUT")
  1.017  5320         Mode = IDP; +LeakageCurrent = 0.10 mA; Read
  1.018  MATH         MEM1 = MEM
  1.019  PORT         [T5000][I]
  1.020  MEMCX  2     mA             4% 0.02U

  2.001  5320         Mode = IDP; +LeakageCurrent = 0.46 mA; Setup
  2.002  PORT         [V @ContactCurrentTest][D1500]
  2.003  5320         Mode = IDP; +LeakageCurrent = 0.46 mA; Operate
  2.004  TARGET       -m
  2.005  PORT         [CLR][V @Go][D1500][V @Yes]
  2.006  MATH         SAFEON("UUT", @MainsVoltage, "Sine")
  2.007  WAIT         -t 5 Waiting for test to complete...
  2.008  MATH         SAFEOFF("UUT")
  2.009  5320         Mode = IDP; +LeakageCurrent = 0.46 mA; Read
  2.010  MATH         MEM1 = MEM
  2.011  PORT         [T5000][I]
  2.012  MEMCX  2     mA             4% 0.02U

  3.001  5320         Mode = IDP; +LeakageCurrent = 1.50 mA; Setup
  3.002  PORT         [V @ContactCurrentTest][D1500]
  3.003  5320         Mode = IDP; +LeakageCurrent = 1.50 mA; Operate
  3.004  TARGET       -m
  3.005  PORT         [CLR][V @Go][D1500][V @Yes]
  3.006  MATH         SAFEON("UUT", @MainsVoltage, "Sine")
  3.007  WAIT         -t 5 Waiting for test to complete...
  3.008  MATH         SAFEOFF("UUT")
  3.009  5320         Mode = IDP; +LeakageCurrent = 1.50 mA; Read
  3.010  MATH         MEM1 = MEM
  3.011  PORT         [T5000][I]
  3.012  MEMCX  2     mA             4% 0.02U

  4.001  HEAD
  4.002  5320         Reset
  4.003  CALL         Sub Fluke 6x00-2 Stop Mains Meas Output RS-232
  4.004  END
