﻿Fluke Calibration                                           MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Fluke 6500-2 Get Mains Voltage /DMM
DATE:                  2014-10-13 08:17:42
AUTHOR:                Fluke
REVISION:              $Revision: 9718 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       1
NUMBER OF LINES:       66
CONFIGURATION:         Digital Multimeter
=============================================================================
#
#  Procedure Author:
#        DAC
#
#  Source:
#        6x00-2 Performance Verification
#        Rev 27 June 2014
#
#  Compatibility:
#        MET/CAL 8.0 or later
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Precision Measurement
#  Limited.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  IF           0
  1.002  IEEE         [@DMM]
  1.003  ENDIF

  1.004  IF           ZCMP(@UUT_CountryCode, "NL")
  1.005  MATH         Tap = "230 V"
  1.006  ELSE
  1.007  MATH         Tap = "240 V"
  1.008  ENDIF

  1.009  MATH         @DMM_Func = "AC_Voltage"
  1.010  MATH         @DMM_Freq = "50 Hz"
  1.011  TARGET
  1.012  CALL         Sub Reset /DMM
  1.013  CALL         Sub Setup /DMM
  1.014  DISP         Connect [V @MainsCable] mains cable adapter to
  1.014  DISP         the [V @DMM_DevName] as follows:
  1.014  DISP
  1.014  DISP         [32] Adapter              [V @DMM_DevName]
  1.014  DISP         [32] Red Lead <---------> [V @DMM_InputHi]
  1.014  DISP         [32] Blue Lead <--------> [V @DMM_InputLo]
  1.014  DISP
  1.014  DISP         Plug cable adapter into into same [V Tap] mains as
  1.014  DISP         5320A.
  1.015  CALL         Sub Read /DMM
  1.016  MATH         @MainsV = MEM

  1.017  END
