﻿Fluke Calibration                                           MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Fluke 6500-2(UK) (1 yr) Load VER RS-232 /5320,M192i
DATE:                  2014-11-24 12:36:27
AUTHOR:                Fluke
REVISION:              $Revision: 9680 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       7
NUMBER OF LINES:       189
CONFIGURATION:         Fluke 5320A
CONFIGURATION:         Meatest M192
=============================================================================
#
#  Procedure Author:
#        DAC
#
#  Source:
#        6x00-2 Performance Verification
#        Rev 27 June 2014
#        Fluke 6200B, 6500B Final Test and Calibration Procedures, Rev O
#
#  Compatibility:
#        MET/CAL 8.0 or later
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Precision Measurement
#  Limited.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  MATH         LoadDev  = INSTR("M192")
  1.002  MATH         ConfLoad = CONF(LoadDev)
  1.003  MATH         Conf5320 = CONF("Fluke 5320A")

  1.004  RESET        [@M192]OUTP OFF[D100]

  1.005  RSLT         =
  1.006  HEAD         {LOAD TEST}
  1.007  RSLT         =
  1.008  HEAD         -2{480 Ω}
  1.009  MATH         Res = 480
  1.010  TARGET       -p
# 240 V / 480 Ω = 0.5 A
  1.011  TSET         CPT = 0.5 A
  1.012  5320         Mode = Meter; +Current = 0.5 A; Freq = 50 Hz; Setup
  1.013  IEEE         [@M192]RES [V Res][D100]
  1.014  PIC          5320_6500-2_UK_Load_m192
  1.015  IEEE         [@M192]OUTP ON[D500]
  1.016  PORT         [V @LoadLeakageTest][D1500]
  1.017  TARGET       -m
  1.018  PORT         [CLR][D1500][V @Go][D1500][V @Go][D1500][V @Yes]
  1.019  MATH         SAFEON("UUT", @MainsVoltage, "Sine")
  1.020  WAIT         -t 5 Waiting for load resistor to warmup...
  1.021  5320         Mode = Meter; +Current = 0.5 A; Freq = 50 Hz; Read
  1.022  MATH         SAFEOFF("UUT")
  1.023  MATH         MEM1 = MEM
  1.024  PORT         [T5000][I]
  1.025  MEMCX  13    A              4% 0.2U

# Determine load accuracy in percent.
  2.001  MATH         L[2] = ACCV(LoadDev, "Resistance", Res) / ConfLoad
  2.002  MATH         L[2] = L[2] / Res * 100
  2.003  TARGET       -p
# 240 V x 0.5 A = 120 VA
  2.004  TSET         CPT = 120 VA
  2.005  5320         Mode = Meter; +Current = 0.5 A; Freq = 50 Hz; Setup
  2.006  IEEE         [@M192]RES [V Res][D100]
  2.007  IEEE         [@M192]OUTP ON[D500]
  2.008  PORT         [V @LoadLeakageTest][D1500]
  2.009  TARGET       -m
  2.010  PORT         [CLR][D1500][V @Go][D1500][V @Go][D1500][V @Yes]
  2.011  MATH         SAFEON("UUT", @MainsVoltage, "Sine")
  2.012  WAIT         -t 5 Waiting for load resistor to warmup...
  2.013  5320         Mode = Meter; +Current = 0.5 A; Freq = 50 Hz; Read
  2.014  MATH         L[1] = (REFACC() / Conf5320) / MEM * 100
  2.015  MATH         SAFEOFF("UUT")
  2.016  MATH         MEM = MEM^2 * Res
  2.017  MATH         L[3] = RSS_L(1, 2) * 2
  2.018  ACC    120   VA             L3%
  2.019  PORT         [T5000][I!][I]
  2.020  MEMCX  3200  VA             5% 3U

  3.001  RSLT         =
  3.002  HEAD         -2{50 Ω}
  3.003  MATH         Res = 50
  3.004  TARGET       -p
# 240 V / 50 Ω = 4.8 A
  3.005  TSET         CPT = 4.8 A
  3.006  5320         Mode = Meter; +Current = 4.8 A; Freq = 50 Hz; Setup
  3.007  IEEE         [@M192]RES [V Res][D100]
  3.008  IEEE         [@M192]OUTP ON[D500]
  3.009  PORT         [V @LoadLeakageTest][D1500]
  3.010  TARGET       -m
  3.011  PORT         [CLR][D1500][V @Go][D1500][V @Go][D1500][V @Yes]
  3.012  MATH         SAFEON("UUT", @MainsVoltage, "Sine")
  3.013  WAIT         -t 5 Waiting for load resistor to warmup...
  3.014  5320         Mode = Meter; +Current = 4.8 A; Freq = 50 Hz; Read
  3.015  MATH         SAFEOFF("UUT")
  3.016  MATH         MEM1 = MEM
  3.017  PORT         [T5000][I]
  3.018  MEMCX  13    A              4% 0.2U

  4.001  MATH         L[2] = ACCV(LoadDev, "Resistance", Res) / ConfLoad
  4.002  MATH         L[2] = L[2] / Res * 100
  4.003  TARGET       -p
# 240 V x 4.8 A = 1.152 kVA (rounded to UUT resolution)
  4.004  TSET         CPT = 1.2 kVA
  4.005  5320         Mode = Meter; +Current = 4.8 A; Freq = 50 Hz; Setup
  4.006  IEEE         [@M192]RES [V Res][D100]
  4.007  IEEE         [@M192]OUTP ON[D500]
  4.008  PORT         [V @LoadLeakageTest][D1500]
  4.009  TARGET       -m
  4.010  PORT         [CLR][D1500][V @Go][D1500][V @Go][D1500][V @Yes]
  4.011  MATH         SAFEON("UUT", @MainsVoltage, "Sine")
  4.012  WAIT         -t 5 Waiting for load resistor to warmup...
  4.013  5320         Mode = Meter; +Current = 4.8 A; Freq = 50 Hz; Read
  4.014  MATH         L[1] = (REFACC() / Conf5320) / MEM * 100
  4.015  MATH         SAFEOFF("UUT")
  4.016  MATH         MEM = MEM^2 * Res / 1E+3
  4.017  MATH         L[3] = RSS_L(1, 2) * 2
  4.018  ACC    1.2   kVA            L3%
  4.019  PORT         [T5000][I!][I]
  4.020  MATH         MEM = MEM / 1E+3
  4.021  MEMCX  3.2   kVA            5% 0.3U

  5.001  RSLT         =
  5.002  HEAD         -2{19 Ω}
  5.003  MATH         Res = 19
  5.004  TARGET       -p
# 240 V / 19 Ω = 12.632 A (rounded to UUT resolution)
  5.005  TSET         CPT = 12.6 A
  5.006  5320         Mode = Meter; +Current = 12.6 A; Freq = 50 Hz; Setup
  5.007  IEEE         [@M192]RES [V Res][D100]
  5.008  IEEE         [@M192]OUTP ON[D500]
  5.009  PORT         [V @LoadLeakageTest][D1500]
  5.010  TARGET       -m
  5.011  PORT         [CLR][D1500][V @Go][D1500][V @Go][D1500][V @Yes]
  5.012  MATH         SAFEON("UUT", @MainsVoltage, "Sine")
  5.013  WAIT         -t 5 Waiting for load resistor to warmup...
  5.014  5320         Mode = Meter; +Current = 12.6 A; Freq = 50 Hz; Read
  5.015  MATH         SAFEOFF("UUT")
  5.016  MATH         MEM1 = MEM
  5.017  PORT         [T5000][I]
  5.018  MEMCX  13    A              4% 0.2U

  6.001  MATH         L[2] = ACCV(LoadDev, "Resistance", Res) / ConfLoad
  6.002  MATH         L[2] = L[2] / Res * 100
  6.003  TARGET       -p
# 240 V x 12.6 A = 3.024 kVA (3.0 kV rounded to UUT resolution)
  6.004  TSET         CPT = 3.0 kVA
  6.005  5320         Mode = Meter; +Current = 12.6 A; Freq = 50 Hz; Setup
  6.006  IEEE         [@M192]RES [V Res][D100]
  6.007  IEEE         [@M192]OUTP ON[D500]
  6.008  PORT         [V @LoadLeakageTest][D1500]
  6.009  TARGET       -m
  6.010  PORT         [CLR][D1500][V @Go][D1500][V @Go][D1500][V @Yes]
  6.011  MATH         SAFEON("UUT", @MainsVoltage, "Sine")
  6.012  WAIT         -t 5 Waiting for load resistor to warmup...
  6.013  5320         Mode = Meter; +Current = 12.6 A; Freq = 50 Hz; Read
  6.014  MATH         L[1] = (REFACC() / Conf5320) / MEM * 100
  6.015  MATH         SAFEOFF("UUT")
  6.016  MATH         MEM = MEM^2 * Res / 1E+3
  6.017  MATH         L[3] = RSS_L(1, 2) * 2
  6.018  ACC    3.0   kVA            L3%
  6.019  PORT         [T5000][I!][I]
  6.020  MATH         MEM = MEM / 1E+3
  6.021  MEMCX  3.2   kVA            5% 0.3U

  7.001  HEAD         -2
  7.002  HEAD
  7.003  IEEE         [@M192]OUTP OFF[D100]
  7.004  5320         Reset
  7.005  CALL         Sub Fluke 6x00-2 Stop Mains Meas Output RS-232
  7.006  DISP         Disconnect M192 and [V @MainsCable] mains cable adapter
  7.006  DISP         from 5320A.
  7.006  DISP
  7.006  DISP         Leave [V @MainsCable] mains cable adapter connected to
  7.006  DISP         UUT.
  7.007  END
