﻿Copyright (c) (2015) Fluke Corporation                      MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub UUT RS-232 Connection Plug-n-Play
DATE:                  2015-08-13 12:24:48
AUTHOR:                Fluke
REVISION:              $Revision: 12775 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       1
NUMBER OF LINES:       150
=============================================================================
#
#  Procedure Author:
#        DAC, CAD, GMO
#
#  Compatibility:
#        5500/CAL or MET/CAL 7.20C or later
#
#  Subprocedures:
#        None
#
# Required Files:
#        None
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
# Example Usage:
#
#        CALL         Sub UUT RS-232 Connection Plug-n-Play
#
#        IF           @Error
#        END
#        ENDIF
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

# The Default Serial Port must be set to "None" for the VSET PORT parameter
# to function correctly.
  1.001  MATH         DefaultPort = INI("startup", "port")
  1.002  MATH         @Error = NOT(ZCMPI(DefaultPort, "none"))

  1.003  IF           @Error
  1.004  DISP         The Default Serial Port must be set to "None" so this
  1.004  DISP         procedure may communicate with the UUT as a
  1.004  DISP         USB Plug-n-Play device.
  1.004  DISP
  1.004  DISP         Follow these steps to change the Default Serial Port:
  1.004  DISP
  1.004  DISP         1. Select "Advance" to end this procedure.
  1.004  DISP         2. Select Tools, then Configure Default Serial Port.
  1.004  DISP         3. Select "None" as the Serial Port, and then click OK.
  1.004  DISP         4. Run this procedure.
  1.005  END
  1.006  ENDIF

  1.007  HEAD         IDENTIFY PLUG AND PLAY USB TO RS-232 ADAPTER

  1.008  IF           ISVAR("@InterfaceCable")
  1.009  MATH         InterfaceCable = @InterfaceCable
  1.010  ELSE
  1.011  MATH         InterfaceCable = "USB to RS-232 adapter"
  1.012  ENDIF

  1.013  IF           ISVAR("@USB_SerialTimeout")
  1.014  MATH         Timeout = @USB_SerialTimeout
  1.015  ELSE
  1.016  MATH         Timeout = 60
  1.017  ENDIF

  1.018  DISP         Disconnect [V InterfaceCable] from PC, if currently
  1.018  DISP         connected.

  1.019  WAIT         -t 5 Waiting for Windows Plug-n-Play to update...

# Get list of COM ports w/o Plug-n-Play adapter inserted.
  1.020  MATH         List1 = COMLIST()
  1.021  DISP         Plug the [V InterfaceCable] into the PC.

  1.022  DO
  1.023  MATH         ElapsedSec = 0

  1.024  DO
  1.025  WAIT         [D1000]
  1.026  MATH         ElapsedSec = ElapsedSec + 1

# Get list of COM ports w/Plug-n-Play adapter.
  1.027  MATH         List2 = COMLIST()

  1.028  IF           ISVAR("@PlugNPlayVerboseRS232")
  1.029  DISP         List1: [V List1]
  1.029  DISP         List2: [V List2]
  1.030  ENDIF

  1.031  MATH         Field = 1

  1.032  DO
  1.033  MATH         Port1 = FLD(List1, Field, ",")
  1.034  MATH         Port2 = FLD(List2, Field, ",")

  1.035  IF           ISVAR("PlugNPlayVerboseRS232")
  1.036  DISP         Port1: [V Port1]
  1.036  DISP         Port2: [V Port2]
  1.037  ENDIF

  1.038  MATH         FoundAdapter = NOT(ZCMPI(Port2, Port1))
  1.039  MATH         Field = Field + 1
  1.040  UNTIL        FoundAdapter || EMPTY(Port1)

  1.041  UNTIL        FoundAdapter || (ElapsedSec > Timeout)

  1.042  IF           FoundAdapter
  1.043  VSET         PORT = [V Port2]
  1.044  MATH         @Port = Port2
  1.045  ELSE

  1.046  DISP         No new COM port was found [V ElapsedSec] s after
  1.046  DISP         [V InterfaceCable] was plugged into PC.
  1.046  DISP
  1.046  DISP         MET/CAL only supports COM1 through COM16.
  1.046  DISP         Windows may have assigned a COM port in the range
  1.046  DISP         COM17 to COM256.
  1.046  DISP
  1.046  DISP         1. Open the Windows Device Manager.
  1.046  DISP         2. Expand the tree view for "Ports (COM & LPT)".
  1.046  DISP         3. Right click on the port assigned to the USB Serial
  1.046  DISP         [32]  adapter/cable just inserted.
  1.046  DISP         4. Select "Properties".
  1.046  DISP         5. Select "Port Settings".
  1.046  DISP         6. Select "Advanced".
  1.046  DISP         7. Set "COM Port Number" to a value less than COM17.
  1.046  DISP
  1.046  DISP         Select "Advance" to try again.

  1.047  MATH         @Port = ""
  1.048  ENDIF

  1.049  UNTIL        NOT(Empty(@Port))

  1.050  HEAD
  1.051  END
