﻿Copyright (c) (2015) Fluke Corporation                      MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub HP 8657B/D (1 yr) Spurious Signals VER IEEE /PSA
INSTRUMENT:            Sub HP 8657B/D (1 yr) Phase Noise VER IEEE /PSA
DATE:                  2016-06-28 11:13:32
AUTHOR:                Fluke
REVISION:              $Revision: 16396 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       30
NUMBER OF LINES:       315
CONFIGURATION:         Agilent PSA (6.7 GHz,226)
=============================================================================
#
#  Procedure Author:
#        DFM, DAC
#
#  Additional Equipment Required:
#        None
#
#  Note:
#  Test points based on those performed by Agilent TMO Support Operations.
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

# Force procedure to include maximum PSA frequency and option 226 required.
  1.001  IF           0
  1.002  PSA          CenterFreq = 1980 MHz; FreqSpan = 500 kHz
  1.002  PSA          +Ampl = +7 dBm; PeakSearch; MarkerToCenterFreq
  1.003  PSA          Mode = PhaseNoiseLogPlot
  1.003  PSA          CenterFreq = 1580 MHz; FreqSpan = 50 kHz
  1.003  PSA          FreqOffset = 20 kHz; RFCoupling = DC
  1.003  PSA          +PhaseNoise = -136 dBc/Hz
  1.004  ENDIF

# Turn measure only off.  The PSA must be setup for each iteration back
# to the TARGET -m statement because the center frequency changes.
  1.005  VSET         MEASURE_ONLY = No
  1.006  JMPL         PHASE_NOISE                  PSUBI("Phase")

# If UUT has OPT 003, select +4 dBm output level,
# otherwise select +7 dBm output level.

  1.007  IF           @Opt_003
  1.008  MATH         @Pwr = +4
  1.009  ELSE
  1.010  MATH         @Pwr = +7
  1.011  ENDIF

  1.012  JMPL         SPURIOUS                     PSUBI("Spurious")
  1.013  DISP         Subprocedure not found!
  1.014  END

  1.015  EVAL   Increment step number

# =====  Sub HP 8657B (1 yr) Spurious Signals VER IEEE /PSA  ================

  2.001  LABEL        SPURIOUS
  2.002  HEAD         SPECTRAL PURITY TESTS: SPURIOUS SIGNALS (Harmonics)
  2.003  RSLT         =
  2.004  RSLT         =Harmonics (Fundamental, Harmonic Number)
  2.005  MATH         @HarmNum = "2nd"; @dBc = -30

  2.006  MATH         @FreqMHz = 65.25; @HarmMHz = 130.5
  2.007  CALL         Sub HP 8657x (1 yr) Harmonic Test IEEE /PSA

  2.008  IF           0
  2.009  EVAL   Increment statement number
  3.001  ENDIF

  3.002  MATH         @FreqMHz = 167.333333; @HarmMHz = 334.666666
  3.003  CALL         Sub HP 8657x (1 yr) Harmonic Test IEEE /PSA

  3.004  IF           0
  3.005  EVAL   Increment statement number
  4.001  ENDIF

  4.002  MATH         @FreqMHz = 258.999999; @HarmMHz = 517.999998
  4.003  CALL         Sub HP 8657x (1 yr) Harmonic Test IEEE /PSA

  4.004  IF           0
  4.005  EVAL   Increment statement number
  5.001  ENDIF

  5.002  MATH         @FreqMHz = 399.999999; @HarmMHz = 799.999998
  5.003  CALL         Sub HP 8657x (1 yr) Harmonic Test IEEE /PSA

  5.004  IF           0
  5.005  EVAL   Increment statement number
  6.001  ENDIF

  6.002  MATH         @FreqMHz = 520; @HarmMHz = 1040
  6.003  CALL         Sub HP 8657x (1 yr) Harmonic Test IEEE /PSA

  6.004  IF           0
  6.005  EVAL   Increment statement number
  7.001  ENDIF

  7.002  MATH         @FreqMHz = 780; @HarmMHz = 1560
  7.003  CALL         Sub HP 8657x (1 yr) Harmonic Test IEEE /PSA

  7.004  IF           0
  7.005  EVAL   Increment statement number
  8.001  ENDIF

  8.002  MATH         @FreqMHz = 910; @HarmMHz = 1820
  8.003  CALL         Sub HP 8657x (1 yr) Harmonic Test IEEE /PSA

  8.004  IF           0
  8.005  EVAL   Increment statement number
  9.001  ENDIF

  9.002  MATH         @FreqMHz = 1030; @HarmMHz = 2060
  9.003  CALL         Sub HP 8657x (1 yr) Harmonic Test IEEE /PSA

  9.004  IF           0
  9.005  EVAL   Increment statement number
 10.001  ENDIF

 10.002  IF           ZCMPI(@ModelNum, "8657B")
 10.003  MATH         @dBc = -25
 10.004  MATH         @FreqMHz = 1300; @HarmMHz = 2600
 10.005  CALL         Sub HP 8657x (1 yr) Harmonic Test IEEE /PSA

 10.006  IF           0
 10.007  EVAL   Increment statement number
 11.001  ENDIF

 11.002  MATH         @FreqMHz = 1600; @HarmMHz = 3200
 11.003  CALL         Sub HP 8657x (1 yr) Harmonic Test IEEE /PSA

 11.004  IF           0
 11.005  EVAL   Increment statement number
 12.001  ENDIF

 12.002  MATH         @FreqMHz = 1980; @HarmMHz = 3360
 12.003  CALL         Sub HP 8657x (1 yr) Harmonic Test IEEE /PSA

 12.004  IF           0
 12.005  EVAL   Increment statement number
 13.001  ENDIF

 13.002  RSLT         =
 13.003  RSLT         =Sub-Harmonics (Fundamental, Harmonic Number)
 13.004  MATH         @HarmNum = "0.5"
 13.005  MATH         @FreqMHz = 1145.5; @HarmMHz = 572.75; @dBc = -40
 13.006  CALL         Sub HP 8657x (1 yr) Harmonic Test IEEE /PSA

 13.007  IF           0
 13.008  EVAL   Increment statement number
 14.001  ENDIF

 14.002  MATH         @FreqMHz = 1865; @HarmMHz = 932.5; @dBc = -35
 14.003  CALL         Sub HP 8657x (1 yr) Harmonic Test IEEE /PSA

 14.004  IF           0
 14.005  EVAL   Increment statement number
 15.001  ENDIF

 15.002  ENDIF

 15.003  IEEE         [SDC]R2
 15.004  PSA          Reset

 15.005  HEAD         SPECTRAL PURITY TESTS: SPURIOUS SIGNALS (Spurs)
 15.006  RSLT         =
 15.007  RSLT         =Spurious (Fundamental, Spurious)

 15.008  MATH         @dBc = -60

 15.009  MATH         @FreqMHz = 100; @SpurMHz = 800
 15.010  MATH         @StartMHz = 799.75; @StopMHz = 800.25
 15.011  CALL         Sub HP 8657x (1 yr) Spur Test IEEE /PSA

 15.012  IF           0
 15.013  EVAL   Increment statement number
 16.001  ENDIF

 16.002  MATH         @FreqMHz = 600; @SpurMHz = 800
 16.003  MATH         @StartMHz = 799.75; @StopMHz = 800.25
 16.004  CALL         Sub HP 8657x (1 yr) Spur Test IEEE /PSA

 16.005  IF           0
 16.006  EVAL   Increment statement number
 17.001  ENDIF

 17.002  MATH         @FreqMHz = 641.4; @SpurMHz = 691.4
 17.003  MATH         @StartMHz = 691.15; @StopMHz = 691.65
 17.004  CALL         Sub HP 8657x (1 yr) Spur Test IEEE /PSA

 17.005  IF           0
 17.006  EVAL   Increment statement number
 18.001  ENDIF

 18.002  MATH         @FreqMHz = 900; @SpurMHz = 400
 18.003  MATH         @StartMHz = 399.75; @StopMHz = 400.25
 18.004  CALL         Sub HP 8657x (1 yr) Spur Test IEEE /PSA

 18.005  IF           0
 18.006  EVAL   Increment statement number
 19.001  ENDIF

 19.002  MATH         @FreqMHz = 940.1; @SpurMHz = 690.1
 19.003  MATH         @StartMHz = 399.75; @StopMHz = 400.25
 19.004  CALL         Sub HP 8657x (1 yr) Spur Test IEEE /PSA

 19.005  IF           0
 19.006  EVAL   Increment statement number
 20.001  ENDIF

 20.002  IF           ZCMPI(@ModelNum, "8657B")
 20.003  MATH         @dBc = -54
 20.004  MATH         @FreqMHz = 1098; @SpurMHz = 1100
 20.005  MATH         @StartMHz = 1102.75; @StopMHz = 1103.25
 20.006  CALL         Sub HP 8657x (1 yr) Spur Test IEEE /PSA

 20.007  IF           0
 20.008  EVAL   Increment statement number
 21.001  ENDIF

 21.002  MATH         @FreqMHz = 1102; @SpurMHz = 1100
 21.003  MATH         @StartMHz = 1099.75; @StopMHz = 1100.25
 21.004  CALL         Sub HP 8657x (1 yr) Spur Test IEEE /PSA

 21.005  IF           0
 21.006  EVAL   Increment statement number
 22.001  ENDIF

 22.002  MATH         @FreqMHz = 1602; @SpurMHz = 1599
 22.003  MATH         @StartMHz = 1598.75; @StopMHz = 1599.25
 22.004  CALL         Sub HP 8657x (1 yr) Spur Test IEEE /PSA

 22.005  IF           0
 22.006  EVAL   Increment statement number
 23.001  ENDIF

 23.002  MATH         @FreqMHz = 1605; @SpurMHz = 1602.5
 23.003  MATH         @StartMHz = 1602.25; @StopMHz = 1602.75
 23.004  CALL         Sub HP 8657x (1 yr) Spur Test IEEE /PSA

 23.005  IF           0
 23.006  EVAL   Increment statement number
 24.001  ENDIF

 24.002  ENDIF

 24.003  IEEE         [SDC]R2
 24.004  PSA          Reset
 24.005  TSET         MEASURE_ONLY = Yes
 24.006  END

 24.007  EVAL   Increment Test Number

# =====  Sub HP 8657x (1 yr) Phase Noise VER IEEE /PSA  =====================

 25.001  LABEL        PHASE_NOISE
 25.002  HEAD         SPECTRAL PURITY TESTS: SPURIOUS SIGNALS (Phase Noise)

 25.003  RSLT         =
 25.004  RSLT         =Phase Noise

 25.005  MATH         @FreqMHz = 120; @dBc_Hz = -124
 25.006  CALL         Sub HP 8657x (1 yr) Phase Noise Test IEEE /PSA

 25.007  IF           0
 25.008  EVAL   Increment statement number
 26.001  ENDIF

 26.002  MATH         @FreqMHz = 250; @dBc_Hz = -136
 26.003  CALL         Sub HP 8657x (1 yr) Phase Noise Test IEEE /PSA

 26.004  IF           0
 26.005  EVAL   Increment statement number
 27.001  ENDIF

 27.002  MATH         @FreqMHz = 510; @dBc_Hz = -130
 27.003  CALL         Sub HP 8657x (1 yr) Phase Noise Test IEEE /PSA

 27.004  IF           0
 27.005  EVAL   Increment statement number
 28.001  ENDIF

 28.002  MATH         @FreqMHz = 980; @dBc_Hz = -124
 28.003  CALL         Sub HP 8657x (1 yr) Phase Noise Test IEEE /PSA

 28.004  IF           0
 28.005  EVAL   Increment statement number
 29.001  ENDIF

 29.002  IF           ZCMPI(@ModelNum, "8657B")
 29.003  MATH         @FreqMHz = 1580; @dBc_Hz = -118
 29.004  CALL         Sub HP 8657x (1 yr) Phase Noise Test IEEE /PSA

 29.005  IF           0
 29.006  EVAL   Increment statement number
 30.001  ENDIF

 30.002  ENDIF

 30.003  IEEE         [SDC]R2
 30.004  PSA          Reset

 30.005  END
