﻿Copyright (c) (2015) Fluke Corporation                      MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub HP 8657x (1 yr) AM Accuracy VER IEEE /N5531
INSTRUMENT:            Sub HP 8657x (1 yr) Incidental PM VER IEEE /N5531
INSTRUMENT:            Sub HP 8657x (1 yr) AM Distortion VER IEEE /N5531
INSTRUMENT:            Sub HP 8657x (1 yr) Residual AM VER IEEE /N5531
DATE:                  2016-06-28 11:14:39
AUTHOR:                Fluke
REVISION:              $Revision: 16396 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       79
NUMBER OF LINES:       774
CONFIGURATION:         Agilent PSA (6.7 GHz,233)
=============================================================================
#
#  Procedure Author:
#        DFM, DAC
#
#  Model(s) Covered:
#        8657A, 8657B, 8657D
#
#  Additional Equipment Required:
#        None
#
#  Note:
#  Test points based on those performed by Agilent TMO Support Operations.
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

# Note, Selected Device Clear [SDC] is sent prior to each command. If [SDC]
# is not sent, it has been found that sometimes the generator does not update
# its settings even it accepts the command without error.

  1.001  JMPL         RESIDUAL_AM                  PSUB("Residual AM")

# If UUT is an 8657A, select +7 dBm output level.
# If UUT is an 8657B with OPT 003, select +1 dBm output level.
# If UUT is an 8657B without OPT 003, select +4 dBm output level.

  1.002  IF           ZCMPI(@ModelNum, "8657A")
  1.003  MATH         @Pwr = 7
  1.004  ELSE

  1.005  IF           @Opt_003
  1.006  MATH         @Pwr = 1
  1.007  ELSE
  1.008  MATH         @Pwr = 4
  1.009  ENDIF

  1.010  ENDIF

  1.011  JMPL         INCIDENTAL_PM                PSUB("Incidental PM")
  1.012  JMPL         AM_DISTORTION                PSUB("AM Distortion")
  1.013  JMPL         AM_ACCURACY                  PSUB("AM Accuracy")
  1.014  DISP         Subprocedure not found!
  1.015  END

# ====== Sub HP 8657x AM Accuracy VER IEEE /N5531 ===========================

  1.016  LABEL        AM_ACCURACY
  1.017  RSLT         =
  1.018  HEAD         MODULATION TESTS: {AM INDICATOR ACCURACY}
  1.019  RSLT         = Carrier Level: [V @Pwr] dBm
  1.020  RSLT         =
  1.021  RSLT         =Modulation Source: INT 1 kHz

  1.022  MATH         @FreqMHz = 100
  1.023  CALL         Sub HP 8657x (1 yr) 1 kHz Internal AM Tests IEEE /N5531

  1.024  IF           0
  1.025  EVAL   Increment step number
  2.001  ENDIF

  2.002  MATH         @FreqMHz = 240
  2.003  CALL         Sub HP 8657x (1 yr) 1 kHz Internal AM Tests IEEE /N5531

  2.004  IF           0
  2.005  EVAL   Increment step number
  3.001  ENDIF

  3.002  MATH         @FreqMHz = 400
  3.003  CALL         Sub HP 8657x (1 yr) 1 kHz Internal AM Tests IEEE /N5531

  3.004  IF           0
  3.005  EVAL   Increment step number
  4.001  ENDIF

  4.002  MATH         @FreqMHz = 990
  4.003  CALL         Sub HP 8657x (1 yr) 1 kHz Internal AM Tests IEEE /N5531

  4.004  IF           0
  4.005  EVAL   Increment step number
  5.001  ENDIF

# Select additional test frequencies based on UUT model number.
  5.002  IF           ZCMPI(@ModelNum, "8657A")
  5.003  MATH         @FreqMHz = 1040
  5.004  CALL         Sub HP 8657x (1 yr) 1 kHz Internal AM Tests IEEE /N5531

  5.005  IF           0
  5.006  EVAL   Increment step number
  6.001  ENDIF

  6.002  ELSE
  6.003  MATH         @FreqMHz = 1030
  6.004  CALL         Sub HP 8657x (1 yr) 1 kHz Internal AM Tests IEEE /N5531

  6.005  IF           0
  6.006  EVAL   Increment step number
  7.001  ENDIF

  7.002  MATH         @FreqMHz = 1300
  7.003  CALL         Sub HP 8657x (1 yr) 1 kHz Internal AM Tests IEEE /N5531

  7.004  IF           0
  7.005  EVAL   Increment step number
  8.001  ENDIF

  8.002  ENDIF

  8.003  IEEE         [SDC]R2
  8.004  N5531        Reset

  8.005  RSLT         =
  8.006  RSLT         =Modulation Source: INT 400 Hz
  8.007  RSLT         =
  8.008  HEAD         AM INDICATOR ACCURACY ({100 MHz Carrier})
  8.009  TARGET       -p
  8.010  TSET         TDESC = 10% Depth
  8.011  N5531        Power = [V @Pwr] dBm; InputAttenuation = 20 dB
  8.011  N5531        +Freq = 100 MHz; Setup
  8.012  IEEE         [SDC]FR100MZAP[V @Pwr]DMAM10PCS2R3
  8.013  N5531        Power = [V @Pwr] dBm; InputAttenuation = 20 dB
  8.013  N5531        +Freq = 100 MHz; Read
  8.014  MATH         TunedFreq = MEM
  8.015  TARGET       -m
  8.016  N5531        LPF = 15 kHz; HPF = 300 Hz; Detector = Peak+-/2
  8.016  N5531        Power = [V @Pwr] dBm; InputAttenuation = 20 dB
  8.016  N5531        Freq = [V TunedFreq] MHz; ModFreq = 400 Hz
  8.016  N5531        +AMDepth = 10.0 %
  8.017  MEMC         10.0pct        2.4U          100MH

  9.001  TSET         TDESC = 30% Depth
  9.002  IEEE         [SDC]FR100MZAP[V @Pwr]DMAM30PCS2R3
  9.003  TARGET       -m
  9.004  N5531        LPF = 15 kHz; HPF = 300 Hz; Detector = Peak+-/2
  9.004  N5531        Power = [V @Pwr] dBm; InputAttenuation = 20 dB
  9.004  N5531        Freq = [V TunedFreq] MHz; ModFreq = 400 Hz
  9.004  N5531        +AMDepth = 30.0 %
  9.005  MEMC         30.0pct        3.2U          100MH

 10.001  TSET         TDESC = 70% Depth
 10.002  IEEE         [SDC]FR100MZAP[V @Pwr]DMAM70PCS2R3
 10.003  TARGET       -m
 10.004  N5531        LPF = 15 kHz; HPF = 300 Hz; Detector = Peak+-/2
 10.004  N5531        Power = [V @Pwr] dBm; InputAttenuation = 20 dB
 10.004  N5531        Freq = [V TunedFreq] MHz; ModFreq = 400 Hz
 10.004  N5531        +AMDepth = 70.0 %
 10.005  MEMC         70.0pct        4.8U          100MH

 11.001  TSET         TDESC = 90% Depth
 11.002  IEEE         [SDC]FR100MZAP[V @Pwr]DMAM90PCS2R3
 11.003  TARGET       -m
 11.004  N5531        LPF = 15 kHz; HPF = 300 Hz; Detector = Peak+-/2
 11.004  N5531        Power = [V @Pwr] dBm; InputAttenuation = 20 dB
 11.004  N5531        Freq = [V TunedFreq] MHz; ModFreq = 400 Hz
 11.004  N5531        +AMDepth = 90.0 %
 11.005  MEMC         90.0pct        5.6U          100MH

 12.001  IEEE         [SDC]R2
 12.002  N5531        Reset
 12.003  END

 12.004  EVAL   Increment Test Number

# ====== Sub HP 8657x (1 yr) Incidental PM VER /N5531 =======================

 13.001  LABEL        INCIDENTAL_PM
 13.002  RSLT         =
 13.003  HEAD         MODULATION TESTS: {INCIDENTAL PHASE MODULATION}
 13.004  RSLT         = Modulation Source: INT 1 kHz, 30% AM Depth
 13.005  RSLT         = Carrier Level: [V @Pwr] dBm
 13.006  RSLT         =
 13.007  MATH         @FreqkHz = 150; @Units = "kHz"
 13.008  CALL         Sub HP 8657x (1 yr) Incidental PM Test IEEE /N5531

 13.009  IF           0
 13.010  EVAL   Increment step number
 14.001  ENDIF

 14.002  MATH         @FreqkHz = 200; @Units = "kHz"
 14.003  CALL         Sub HP 8657x (1 yr) Incidental PM Test IEEE /N5531

 14.004  IF           0
 14.005  EVAL   Increment step number
 15.001  ENDIF

 15.002  MATH         @FreqkHz = 300; @Units = "kHz"
 15.003  CALL         Sub HP 8657x (1 yr) Incidental PM Test IEEE /N5531

 15.004  IF           0
 15.005  EVAL   Increment step number
 16.001  ENDIF

 16.002  MATH         @FreqkHz = 400; @Units = "kHz"
 16.003  CALL         Sub HP 8657x (1 yr) Incidental PM Test IEEE /N5531

 16.004  IF           0
 16.005  EVAL   Increment step number
 17.001  ENDIF

 17.002  MATH         @FreqkHz = 600; @Units = "kHz"
 17.003  CALL         Sub HP 8657x (1 yr) Incidental PM Test IEEE /N5531

 17.004  IF           0
 17.005  EVAL   Increment step number
 18.001  ENDIF

 18.002  MATH         @FreqkHz = 700; @Units = "kHz"
 18.003  CALL         Sub HP 8657x (1 yr) Incidental PM Test IEEE /N5531

 18.004  IF           0
 18.005  EVAL   Increment step number
 19.001  ENDIF

 19.002  MATH         @FreqkHz = 800; @Units = "kHz"
 19.003  CALL         Sub HP 8657x (1 yr) Incidental PM Test IEEE /N5531

 19.004  IF           0
 19.005  EVAL   Increment step number
 20.001  ENDIF

 20.002  MATH         @FreqkHz = 900; @Units = "kHz"
 20.003  CALL         Sub HP 8657x (1 yr) Incidental PM Test IEEE /N5531

 20.004  IF           0
 20.005  EVAL   Increment step number
 21.001  ENDIF

 21.002  MATH         @FreqMHz = 1; @Units = "MHz"
 21.003  CALL         Sub HP 8657x (1 yr) Incidental PM Test IEEE /N5531

 21.004  IF           0
 21.005  EVAL   Increment step number
 22.001  ENDIF

 22.002  MATH         @FreqMHz = 2; @Units = "MHz"
 22.003  CALL         Sub HP 8657x (1 yr) Incidental PM Test IEEE /N5531

 22.004  IF           0
 22.005  EVAL   Increment step number
 23.001  ENDIF

 23.002  MATH         @FreqMHz = 3; @Units = "MHz"
 23.003  CALL         Sub HP 8657x (1 yr) Incidental PM Test IEEE /N5531

 23.004  IF           0
 23.005  EVAL   Increment step number
 24.001  ENDIF

 24.002  MATH         @FreqMHz = 4; @Units = "MHz"
 24.003  CALL         Sub HP 8657x (1 yr) Incidental PM Test IEEE /N5531

 24.004  IF           0
 24.005  EVAL   Increment step number
 25.001  ENDIF

 25.002  MATH         @FreqMHz = 5; @Units = "MHz"
 25.003  CALL         Sub HP 8657x (1 yr) Incidental PM Test IEEE /N5531

 25.004  IF           0
 25.005  EVAL   Increment step number
 26.001  ENDIF

 26.002  MATH         @FreqMHz = 6; @Units = "MHz"
 26.003  CALL         Sub HP 8657x (1 yr) Incidental PM Test IEEE /N5531

 26.004  IF           0
 26.005  EVAL   Increment step number
 27.001  ENDIF

 27.002  MATH         @FreqMHz = 7; @Units = "MHz"
 27.003  CALL         Sub HP 8657x (1 yr) Incidental PM Test IEEE /N5531

 27.004  IF           0
 27.005  EVAL   Increment step number
 28.001  ENDIF

 28.002  MATH         @FreqMHz = 8; @Units = "MHz"
 28.003  CALL         Sub HP 8657x (1 yr) Incidental PM Test IEEE /N5531

 28.004  IF           0
 28.005  EVAL   Increment step number
 29.001  ENDIF

 29.002  MATH         @FreqMHz = 9; @Units = "MHz"
 29.003  CALL         Sub HP 8657x (1 yr) Incidental PM Test IEEE /N5531

 29.004  IF           0
 29.005  EVAL   Increment step number
 30.001  ENDIF

 30.002  MATH         @FreqMHz = 10; @Units = "MHz"
 30.003  CALL         Sub HP 8657x (1 yr) Incidental PM Test IEEE /N5531

 30.004  IF           0
 30.005  EVAL   Increment step number
 31.001  ENDIF

 31.002  MATH         @FreqMHz = 20; @Units = "MHz"
 31.003  CALL         Sub HP 8657x (1 yr) Incidental PM Test IEEE /N5531

 31.004  IF           0
 31.005  EVAL   Increment step number
 32.001  ENDIF

 32.002  MATH         @FreqMHz = 30; @Units = "MHz"
 32.003  CALL         Sub HP 8657x (1 yr) Incidental PM Test IEEE /N5531

 32.004  IF           0
 32.005  EVAL   Increment step number
 33.001  ENDIF

 33.002  MATH         @FreqMHz = 40; @Units = "MHz"
 33.003  CALL         Sub HP 8657x (1 yr) Incidental PM Test IEEE /N5531

 33.004  IF           0
 33.005  EVAL   Increment step number
 34.001  ENDIF

 34.002  MATH         @FreqMHz = 50; @Units = "MHz"
 34.003  CALL         Sub HP 8657x (1 yr) Incidental PM Test IEEE /N5531

 34.004  IF           0
 34.005  EVAL   Increment step number
 35.001  ENDIF

 35.002  MATH         @FreqMHz = 60; @Units = "MHz"
 35.003  CALL         Sub HP 8657x (1 yr) Incidental PM Test IEEE /N5531

 35.004  IF           0
 35.005  EVAL   Increment step number
 36.001  ENDIF

 36.002  MATH         @FreqMHz = 70; @Units = "MHz"
 36.003  CALL         Sub HP 8657x (1 yr) Incidental PM Test IEEE /N5531

 36.004  IF           0
 36.005  EVAL   Increment step number
 37.001  ENDIF

 37.002  MATH         @FreqMHz = 80; @Units = "MHz"
 37.003  CALL         Sub HP 8657x (1 yr) Incidental PM Test IEEE /N5531

 37.004  IF           0
 37.005  EVAL   Increment step number
 38.001  ENDIF

 38.002  MATH         @FreqMHz = 90; @Units = "MHz"
 38.003  CALL         Sub HP 8657x (1 yr) Incidental PM Test IEEE /N5531

 38.004  IF           0
 38.005  EVAL   Increment step number
 39.001  ENDIF

 39.002  MATH         @FreqMHz = 100; @Units = "MHz"
 39.003  CALL         Sub HP 8657x (1 yr) Incidental PM Test IEEE /N5531

 39.004  IF           0
 39.005  EVAL   Increment step number
 40.001  ENDIF

 40.002  MATH         @FreqMHz = 200; @Units = "MHz"
 40.003  CALL         Sub HP 8657x (1 yr) Incidental PM Test IEEE /N5531

 40.004  IF           0
 40.005  EVAL   Increment step number
 41.001  ENDIF

 41.002  MATH         @FreqMHz = 300; @Units = "MHz"
 41.003  CALL         Sub HP 8657x (1 yr) Incidental PM Test IEEE /N5531

 41.004  IF           0
 41.005  EVAL   Increment step number
 42.001  ENDIF

 42.002  MATH         @FreqMHz = 400; @Units = "MHz"
 42.003  CALL         Sub HP 8657x (1 yr) Incidental PM Test IEEE /N5531

 42.004  IF           0
 42.005  EVAL   Increment step number
 43.001  ENDIF

 43.002  MATH         @FreqMHz = 500; @Units = "MHz"
 43.003  CALL         Sub HP 8657x (1 yr) Incidental PM Test IEEE /N5531

 43.004  IF           0
 43.005  EVAL   Increment step number
 44.001  ENDIF

 44.002  MATH         @FreqMHz = 600; @Units = "MHz"
 44.003  CALL         Sub HP 8657x (1 yr) Incidental PM Test IEEE /N5531

 44.004  IF           0
 44.005  EVAL   Increment step number
 45.001  ENDIF

 45.002  MATH         @FreqMHz = 700; @Units = "MHz"
 45.003  CALL         Sub HP 8657x (1 yr) Incidental PM Test IEEE /N5531

 45.004  IF           0
 45.005  EVAL   Increment step number
 46.001  ENDIF

 46.002  MATH         @FreqMHz = 800; @Units = "MHz"
 46.003  CALL         Sub HP 8657x (1 yr) Incidental PM Test IEEE /N5531

 46.004  IF           0
 46.005  EVAL   Increment step number
 47.001  ENDIF

 47.002  MATH         @FreqMHz = 900; @Units = "MHz"
 47.003  CALL         Sub HP 8657x (1 yr) Incidental PM Test IEEE /N5531

 47.004  IF           0
 47.005  EVAL   Increment step number
 48.001  ENDIF

 48.002  MATH         @FreqMHz = 1000; @Units = "MHz"
 48.003  CALL         Sub HP 8657x (1 yr) Incidental PM Test IEEE /N5531

 48.004  IF           0
 48.005  EVAL   Increment step number
 49.001  ENDIF

# Select additional test frequencies based on UUT model number.
 49.002  IF           ZCMPI(@ModelNum, "8657A")
 49.003  MATH         @FreqMHz = 1040; @Units = "MHz"
 49.004  CALL         Sub HP 8657x (1 yr) Incidental PM Test IEEE /N5531

 49.005  IF           0
 49.006  EVAL   Increment step number
 50.001  ENDIF

 50.002  ELSE
 50.003  MATH         @FreqMHz = 1100; @Units = "MHz"
 50.004  CALL         Sub HP 8657x (1 yr) Incidental PM Test IEEE /N5531

 50.005  IF           0
 50.006  EVAL   Increment step number
 51.001  ENDIF

 51.002  MATH         @FreqMHz = 1200; @Units = "MHz"
 51.003  CALL         Sub HP 8657x (1 yr) Incidental PM Test IEEE /N5531

 51.004  IF           0
 51.005  EVAL   Increment step number
 52.001  ENDIF

 52.002  MATH         @FreqMHz = 1300; @Units = "MHz"
 52.003  CALL         Sub HP 8657x (1 yr) Incidental PM Test IEEE /N5531

 52.004  IF           0
 52.005  EVAL   Increment step number
 53.001  ENDIF

 53.002  ENDIF

 53.003  IEEE         [SDC]R2
 53.004  N5531        Reset
 53.005  END

 53.006  EVAL   Increment Test Number

# ====== Sub HP 8657x (1 yr) AM Distortion VER /N5531 =======================

 54.001  LABEL        AM_DISTORTION
 54.002  RSLT         =
 54.003  HEAD         MODULATION TESTS: {AM DISTORTION}
 54.004  RSLT         = Modulation Source: INT 1 kHz
 54.005  RSLT         = Carrier Level: [V @Pwr] dBm
 54.006  RSLT         =
 54.007  HEAD         AM DISTORTION TEST ({100 MHz Carrier})
 54.008  TARGET       -p
 54.009  TSET         TDESC = 30% Depth
 54.010  N5531        Power = [V @Pwr] dBm; InputAttenuation = 20 dB
 54.010  N5531        +Freq = 100 MHz; Setup
 54.011  IEEE         [SDC]FR100MZAP[V @Pwr]DMAM30PCS3R3
 54.012  N5531        Power = [V @Pwr] dBm; InputAttenuation = 20 dB
 54.012  N5531        +Freq = 100 MHz; Read
 54.013  MATH         TunedFreq = MEM
 54.014  TARGET       -m
 54.015  N5531        LPF = 15 kHz; HPF = 300 Hz; Detector = Peak+-/2
 54.015  N5531        Power = [V @Pwr] dBm; InputAttenuation = 20 dB
 54.015  N5531        Freq = [V TunedFreq] MHz; ModFreq = 1 kHz
 54.015  N5531        +ModDist = 0.00 %; AMDepth = 30 %
 54.016  MEMC   100   0.00pct        -1.50U

 55.001  TSET         TDESC = 70% Depth
 55.002  IEEE         [SDC]FR100MZAP[V @Pwr]DMAM70PCS3R3
 55.003  TARGET       -m
 55.004  N5531        LPF = 15 kHz; HPF = 300 Hz; Detector = Peak+-/2
 55.004  N5531        Power = [V @Pwr] dBm; InputAttenuation = 20 dB
 55.004  N5531        Freq = [V TunedFreq] MHz; ModFreq = 1 kHz
 55.004  N5531        +ModDist = 0.00 %; AMDepth = 70 %; Read
 55.005  MEMC   100   0.00pct        -3.00U

 56.001  TSET         TDESC = 90% Depth
 56.002  IEEE         [SDC]FR100MZAP[V @Pwr]DMAM90PCS3R3
 56.003  TARGET       -m
 56.004  N5531        LPF = 15 kHz; HPF = 300 Hz; Detector = Peak+-/2
 56.004  N5531        Power = [V @Pwr] dBm; InputAttenuation = 20 dB
 56.004  N5531        Freq = [V TunedFreq] MHz; ModFreq = 1 kHz
 56.004  N5531        +ModDist = 0.00 %; AMDepth = 90 %; Read
 56.005  MEMC   100   0.00pct        -4.00U

 57.001  RSLT         =
 57.002  HEAD         AM DISTORTION TEST ({240 MHz Carrier})
 57.003  TSET         TDESC = 30% Depth
 57.004  TARGET       -p
 57.005  N5531        Power = [V @Pwr] dBm; InputAttenuation = 20 dB
 57.005  N5531        +Freq = 240 MHz; Setup
 57.006  IEEE         [SDC]FR240MZAP[V @Pwr]DMAM30PCS3R3
 57.007  N5531        Power = [V @Pwr] dBm; InputAttenuation = 20 dB
 57.007  N5531        +Freq = 240 MHz; Read
 57.008  MATH         TunedFreq = MEM
 57.009  TARGET       -m
 57.010  N5531        LPF = 15 kHz; HPF = 300 Hz; Detector = Peak+-/2
 57.010  N5531        Power = [V @Pwr] dBm; InputAttenuation = 20 dB
 57.010  N5531        Freq = [V TunedFreq] MHz; ModFreq = 1 kHz
 57.010  N5531        +ModDist = 0.00 %; AMDepth = 30 %
 57.011  MEMC   100   0.00pct        -1.50U

 58.001  TSET         TDESC = 70% Depth
 58.002  IEEE         [SDC]FR240MZAP[V @Pwr]DMAM70PCS3R3
 58.003  TARGET       -m
 58.004  N5531        LPF = 15 kHz; HPF = 300 Hz; Detector = Peak+-/2
 58.004  N5531        Power = [V @Pwr] dBm; InputAttenuation = 20 dB
 58.004  N5531        Freq = [V TunedFreq] MHz; ModFreq = 1 kHz
 58.004  N5531        +ModDist = 0.00 %; AMDepth = 70 %; Read
 58.005  MEMC   100   0.00pct        -3.00U

 59.001  TSET         TDESC = 90% Depth
 59.002  IEEE         [SDC]FR240MZAP[V @Pwr]DMAM90PCS3R3
 59.003  TARGET       -m
 59.004  N5531        LPF = 15 kHz; HPF = 300 Hz; Detector = Peak+-/2
 59.004  N5531        Power = [V @Pwr] dBm; InputAttenuation = 20 dB
 59.004  N5531        Freq = [V TunedFreq] MHz; ModFreq = 1 kHz
 59.004  N5531        +ModDist = 0.00 %; AMDepth = 90 %; Read
 59.005  MEMC   100   0.00pct        -4.00U

 60.001  RSLT         =
 60.002  HEAD         AM DISTORTION TEST ({400 MHz Carrier})
 60.003  TSET         TDESC = 30% Depth
 60.004  TARGET       -p
 60.005  N5531        Power = [V @Pwr] dBm; InputAttenuation = 20 dB
 60.005  N5531        +Freq = 400 MHz; Setup
 60.006  IEEE         [SDC]FR400MZAP[V @Pwr]DMAM30PCS3R3
 60.007  N5531        Power = [V @Pwr] dBm; InputAttenuation = 20 dB
 60.007  N5531        +Freq = 400 MHz; Read
 60.008  MATH         TunedFreq = MEM
 60.009  TARGET       -m
 60.010  N5531        LPF = 15 kHz; HPF = 300 Hz; Detector = Peak+-/2
 60.010  N5531        Power = [V @Pwr] dBm; InputAttenuation = 20 dB
 60.010  N5531        Freq = [V TunedFreq] MHz; ModFreq = 1 kHz
 60.010  N5531        +ModDist = 0.00 %; AMDepth = 30 %
 60.011  MEMC   100   0.00pct        -1.50U

 61.001  TSET         TDESC = 70% Depth
 61.002  IEEE         [SDC]FR400MZAP[V @Pwr]DMAM70PCS3R3
 61.003  TARGET       -m
 61.004  N5531        LPF = 15 kHz; HPF = 300 Hz; Detector = Peak+-/2
 61.004  N5531        Power = [V @Pwr] dBm; InputAttenuation = 20 dB
 61.004  N5531        Freq = [V TunedFreq] MHz; ModFreq = 1 kHz
 61.004  N5531        +ModDist = 0.00 %; AMDepth = 70 %; Read
 61.005  MEMC   100   0.00pct        -3.00U

 62.001  TSET         TDESC = 90% Depth
 62.002  IEEE         [SDC]FR400MZAP[V @Pwr]DMAM90PCS3R3
 62.003  TARGET       -m
 62.004  N5531        LPF = 15 kHz; HPF = 300 Hz; Detector = Peak+-/2
 62.004  N5531        Power = [V @Pwr] dBm; InputAttenuation = 20 dB
 62.004  N5531        Freq = [V TunedFreq] MHz; ModFreq = 1 kHz
 62.004  N5531        +ModDist = 0.00 %; AMDepth = 90 %; Read
 62.005  MEMC   100   0.00pct        -4.00U

# Select additional test frequencies based on UUT model number.
 63.001  IF           ZCMPI(@ModelNum, "8657A")
 63.002  RSLT         =
 63.003  HEAD         AM DISTORTION TEST ({1040 MHz Carrier})
 63.004  TSET         TDESC = 30% Depth
 63.005  TARGET       -p
 63.006  N5531        Power = [V @Pwr] dBm; InputAttenuation = 20 dB
 63.006  N5531        +Freq = 1040 MHz; Setup
 63.007  IEEE         [SDC]FR1040MZAP[V @Pwr]DMAM30PCS3R3
 63.008  N5531        Power = [V @Pwr] dBm; InputAttenuation = 20 dB
 63.008  N5531        +Freq = 1040 MHz; Read
 63.009  MATH         TunedFreq = MEM
 63.010  TARGET       -m
 63.011  N5531        LPF = 15 kHz; HPF = 300 Hz; Detector = Peak+-/2
 63.011  N5531        Power = [V @Pwr] dBm; InputAttenuation = 20 dB
 63.011  N5531        Freq = [V TunedFreq] MHz; ModFreq = 1 kHz
 63.011  N5531        +ModDist = 0.00 %; AMDepth = 30 %
 63.012  MEMC   100   0.00pct        -4.00U

 64.001  TSET         TDESC = 70% Depth
 64.002  IEEE         [SDC]FR1040MZAP[V @Pwr]DMAM70PCS3R3
 64.003  TARGET       -m
 64.004  N5531        LPF = 15 kHz; HPF = 300 Hz; Detector = Peak+-/2
 64.004  N5531        Power = [V @Pwr] dBm; InputAttenuation = 20 dB
 64.004  N5531        Freq = [V TunedFreq] MHz; ModFreq = 1 kHz
 64.004  N5531        +ModDist = 0.00 %; AMDepth = 70 %; Read
 64.005  MEMC   100   0.00pct        -4.00U

 65.001  TSET         TDESC = 90% Depth
 65.002  IEEE         [SDC]FR1040MZAP[V @Pwr]DMAM90PCS3R3
 65.003  TARGET       -m
 65.004  N5531        LPF = 15 kHz; HPF = 300 Hz; Detector = Peak+-/2
 65.004  N5531        Power = [V @Pwr] dBm; InputAttenuation = 20 dB
 65.004  N5531        Freq = [V TunedFreq] MHz; ModFreq = 1 kHz
 65.004  N5531        +ModDist = 0.00 %; AMDepth = 90 %; Read
 65.005  MEMC   100   0.00pct        -7.00U

 66.001  ELSE

 66.002  RSLT         =
 66.003  HEAD         AM DISTORTION TEST ({1030 MHz Carrier})
 66.004  TSET         TDESC = 30% Depth
 66.005  TARGET       -p
 66.006  N5531        Power = [V @Pwr] dBm; InputAttenuation = 20 dB
 66.006  N5531        +Freq = 1030 MHz; Setup
 66.007  IEEE         [SDC]FR1030MZAP[V @Pwr]DMAM30PCS3R3
 66.008  N5531        Power = [V @Pwr] dBm; InputAttenuation = 20 dB
 66.008  N5531        +Freq = 1030 MHz; Read
 66.009  MATH         TunedFreq = MEM
 66.010  TARGET       -m
 66.011  N5531        LPF = 15 kHz; HPF = 300 Hz; Detector = Peak+-/2
 66.011  N5531        Power = [V @Pwr] dBm; InputAttenuation = 20 dB
 66.011  N5531        Freq = [V TunedFreq] MHz; ModFreq = 1 kHz
 66.011  N5531        +ModDist = 0.00 %; AMDepth = 30 %; Read
 66.012  MEMC   100   0.00pct        -4.00U

 67.001  TSET         TDESC = 70% Depth
 67.002  IEEE         [SDC]FR1030MZAP[V @Pwr]DMAM70PCS3R3
 67.003  TARGET       -m
 67.004  N5531        LPF = 15 kHz; HPF = 300 Hz; Detector = Peak+-/2
 67.004  N5531        Power = [V @Pwr] dBm; InputAttenuation = 20 dB
 67.004  N5531        Freq = [V TunedFreq] MHz; ModFreq = 1 kHz
 67.004  N5531        +ModDist = 0.00 %; AMDepth = 70 %; Read
 67.005  MEMC   100   0.00pct        -4.00U

 68.001  TSET         TDESC = 90% Depth
 68.002  IEEE         [SDC]FR1030MZAP[V @Pwr]DMAM90PCS3R3
 68.003  TARGET       -m
 68.004  N5531        LPF = 15 kHz; HPF = 300 Hz; Detector = Peak+-/2
 68.004  N5531        Power = [V @Pwr] dBm; InputAttenuation = 20 dB
 68.004  N5531        Freq = [V TunedFreq] MHz; ModFreq = 1 kHz
 68.004  N5531        +ModDist = 0.00 %; AMDepth = 90 %; Read
 68.005  MEMC   100   0.00pct        -7.00U

 69.001  RSLT         =
 69.002  HEAD         AM DISTORTION TEST ({1300 MHz Carrier})
 69.003  TSET         TDESC = 30% Depth
 69.004  TARGET       -p
 69.005  N5531        Power = [V @Pwr] dBm; InputAttenuation = 20 dB
 69.005  N5531        +Freq = 1300 MHz; Setup
 69.006  IEEE         [SDC]FR1300MZAP[V @Pwr]DMAM30PCS3R3
 69.007  N5531        Power = [V @Pwr] dBm; InputAttenuation = 20 dB
 69.007  N5531        +Freq = 1300 MHz; Read
 69.008  MATH         TunedFreq = MEM
 69.009  TARGET       -m
 69.010  N5531        LPF = 15 kHz; HPF = 300 Hz; Detector = Peak+-/2
 69.010  N5531        Power = [V @Pwr] dBm; InputAttenuation = 20 dB
 69.010  N5531        Freq = [V TunedFreq] MHz; ModFreq = 1 kHz
 69.010  N5531        +ModDist = 0.00 %; AMDepth = 30 %
 69.011  MEMC   100   0.00pct        -4.00U

 70.001  TSET         TDESC = 70% Depth
 70.002  IEEE         [SDC]FR1300MZAP[V @Pwr]DMAM70PCS3R3
 70.003  TARGET       -m
 70.004  N5531        LPF = 15 kHz; HPF = 300 Hz; Detector = Peak+-/2
 70.004  N5531        Power = [V @Pwr] dBm; InputAttenuation = 20 dB
 70.004  N5531        Freq = [V TunedFreq] MHz; ModFreq = 1 kHz
 70.004  N5531        +ModDist = 0.00 %; AMDepth = 70 %; Read
 70.005  MEMC   100   0.00pct        -4.00U

 71.001  TSET         TDESC = 90% Depth
 71.002  IEEE         [SDC]FR1300MZAP[V @Pwr]DMAM90PCS3R3
 71.003  TARGET       -m
 71.004  N5531        LPF = 15 kHz; HPF = 300 Hz; Detector = Peak+-/2
 71.004  N5531        Power = [V @Pwr] dBm; InputAttenuation = 20 dB
 71.004  N5531        Freq = [V TunedFreq] MHz; ModFreq = 1 kHz
 71.004  N5531        +ModDist = 0.00 %; AMDepth = 90 %; Read
 71.005  MEMC   100   0.00pct        -7.00U
 72.001  ENDIF

 72.002  IEEE         [SDC]R2
 72.003  N5531        Reset
 72.004  END

 72.005  EVAL   Increment Test Number

# ====== Sub HP 8657x (1 yr) Residual AM VER /N5531 =========================

 73.001  LABEL        RESIDUAL_AM
 73.002  RSLT         =
 73.003  HEAD         SPECTRAL PURITY TESTS: {RESIDUAL AM}
 73.004  RSLT         = Carrier Level: 0 dBm
 73.005  RSLT         =
 73.006  RSLT         =50 Hz to 15 kHz Bandwidth

 73.007  MATH         @FreqMHz = 100
 73.008  CALL         Sub HP 8657x (1 yr) Residual AM Test IEEE /N5531

 73.009  IF           0
 73.010  EVAL   Increment step number
 74.001  ENDIF

 74.002  MATH         @FreqMHz = 240
 74.003  CALL         Sub HP 8657x (1 yr) Residual AM Test IEEE /N5531

 74.004  IF           0
 74.005  EVAL   Increment step number
 75.001  ENDIF

 75.002  MATH         @FreqMHz = 400
 75.003  CALL         Sub HP 8657x (1 yr) Residual AM Test IEEE /N5531

 75.004  IF           0
 75.005  EVAL   Increment step number
 76.001  ENDIF

# Select additional test frequencies based on UUT model number.
 76.002  IF           ZCMPI(@ModelNum, "8657A")
 76.003  MATH         @FreqMHz = 1040
 76.004  CALL         Sub HP 8657x (1 yr) Residual AM Test IEEE /N5531

 76.005  IF           0
 76.006  EVAL   Increment step number
 77.001  ENDIF

 77.002  ELSE         ; 8657B
 77.003  MATH         @FreqMHz = 1030
 77.004  CALL         Sub HP 8657x (1 yr) Residual AM Test IEEE /N5531

 77.005  IF           0
 77.006  EVAL   Increment step number
 78.001  ENDIF

 78.002  MATH         @FreqMHz = 1300
 78.003  CALL         Sub HP 8657x (1 yr) Residual AM Test IEEE /N5531

 78.004  IF           0
 78.005  EVAL   Increment step number
 79.001  ENDIF

 79.002  ENDIF

 79.003  IEEE         [SDC]R2
 79.004  N5531        Reset
 79.005  END
