﻿Copyright (c) (2015) Fluke Corporation                      MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub HP 8657x (1 yr) 1 kHz Internal AM Tests IEEE /N5531
INSTRUMENT:            Sub HP 8657x (1 yr) Incidental PM Test IEEE /N5531
INSTRUMENT:            Sub HP 8657x (1 yr) Residual AM Test IEEE /N5531
DATE:                  2016-06-28 11:15:18
AUTHOR:                Fluke
REVISION:              $Revision: 16396 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       10
NUMBER OF LINES:       188
CONFIGURATION:         Agilent PSA (6.7 GHz,233)
=============================================================================
#
#  Procedure Author:
#        DFM, DAC
#
#  Model(s) Covered:
#        8657A, 8657B
#
#  Additional Equipment Required:
#        None
#
#  Note:
#  Test points based on those performed by Agilent TMO Support Operations.
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

# Dummy statement to force procedure to require the PSA.
  1.001  IF           0
  1.002  N5531        +Freq = 1300 MHz  Power = 0 dBm
  1.003  ENDIF

# Note, Selected Device Clear [SDC] is sent prior to each command. If [SDC]
# is not sent, it has been found that sometimes the generator does not update
# its settings even it accepts the command without error.

  1.004  JMPL         1kHz_INTERNAL_AM             PSUBI("1 kHz Internal AM")
  1.005  JMPL         INCIDENTAL_PM                PSUBI("Incidental PM")
  1.006  JMPL         RESIDUAL_AM                  PSUBI("Residual AM")
  1.007  DISP         Subprocedure not found!
  1.008  END

  1.009  EVAL   Increment step number.

# =====  Sub HP 8657x (1 yr) 1 kHz Internal AM Tests IEEE /N5531  ===========

  2.001  LABEL        1kHz_INTERNAL_AM
  2.002  RSLT         =
  2.003  HEAD         AM INDICATOR ACCURACY ({[V @FreqMHz] MHz Carrier})
  2.004  TSET         TDESC = 10% Depth
  2.005  TARGET       -p
  2.006  N5531        ExtRefFreq = 10 MHz; TimebaseAccOff
  2.006  N5531        Power = [V @Pwr] dBm; InputAttenuation = 20 dB
  2.006  N5531        +Freq = [V @FreqMHz] MHz; Setup
  2.007  IEEE         [SDC]FR100MZAP[V @Pwr]DMAM10PCS3R3
  2.008  N5531        ExtRefFreq = 10 MHz; TimebaseAccOff
  2.008  N5531        Power = [V @Pwr] dBm; InputAttenuation = 20 dB
  2.008  N5531        +Freq = [V @FreqMHz] MHz; Read
  2.009  MATH         TunedFreq = MEM
  2.010  TARGET       -m
  2.011  N5531        ExtRefFreq = 10 MHz; TimebaseAccOff
  2.011  N5531        LPF = 15 kHz; HPF = 300 Hz; Detector = Peak+-/2
  2.011  N5531        Freq = [V TunedFreq] MHz; ModFreq = 1 kHz
  2.011  N5531        Power = [V @Pwr] dBm; InputAttenuation = 20 dB
  2.011  N5531        +AMDepth = 10.0 %
  2.012  MEMC         10.0pct        2.6U

  3.001  TSET         TDESC = 30% Depth
  3.002  IEEE         [SDC]FR100MZAP[V @Pwr]DMAM30PCS3R3
  3.003  TARGET       -m
  3.004  N5531        ExtRefFreq = 10 MHz; TimebaseAccOff
  3.004  N5531        LPF = 15 kHz; HPF = 300 Hz; Detector = Peak+-/2
  3.004  N5531        Freq = [V TunedFreq] MHz; ModFreq = 1 kHz
  3.004  N5531        Power = [V @Pwr] dBm; InputAttenuation = 20 dB
  3.004  N5531        +AMDepth = 30.0 %;  Read
  3.005  MEMC         30.0pct        3.8U

  4.001  TSET         TDESC = 70% Depth
  4.002  IEEE         [SDC]FR100MZAP[V @Pwr]DMAM70PCS3R3
  4.003  TARGET       -m
  4.004  N5531        ExtRefFreq = 10 MHz; TimebaseAccOff
  4.004  N5531        LPF = 15 kHz; HPF = 300 Hz; Detector = Peak+-/2
  4.004  N5531        Freq = [V TunedFreq] MHz; ModFreq = 1 kHz
  4.004  N5531        Power = [V @Pwr] dBm; InputAttenuation = 20 dB
  4.004  N5531        +AMDepth = 70.0 %;  Read
  4.005  MEMC         70.0pct        6.2U

  5.001  TSET         TDESC = 90% Depth
  5.002  IEEE         [SDC]FR100MZAP[V @Pwr]DMAM90PCS3R3
  5.003  TARGET       -m
  5.004  N5531        ExtRefFreq = 10 MHz; TimebaseAccOff
  5.004  N5531        LPF = 15 kHz; HPF = 300 Hz; Detector = Peak+-/2
  5.004  N5531        Freq = [V TunedFreq] MHz; ModFreq = 1 kHz
  5.004  N5531        Power = [V @Pwr] dBm; InputAttenuation = 20 dB
  5.004  N5531        +AMDepth = 90.0 %; Read
  5.005  MEMC         90.0pct        7.4U

  6.001  IEEE         [SDC]R2
  6.002  N5531        Reset
  6.003  END

  6.004  EVAL   Increment step number

# =====  Sub HP 8657x (1 yr) Incidental PM Test IEEE /N5531  ================

  7.001  LABEL        INCIDENTAL_PM
  7.002  IF           ZCMP(@Units, "kHz")
  7.003  HEAD         INCIDENTAL PHASE MODULATION: [V @FreqkHz] kHz
  7.004  TSET         TDESC = [V @FreqkHz] kHz
  7.005  N5531        ExtRefFreq = 10 MHz; TimebaseAccOff
  7.005  N5531        Power = [V @Pwr] dBm; InputAttenuation = 20 dB
  7.005  N5531        +Freq = [V @FreqkHz] kHz; Setup
# Delay for 200 ms to allow 8657() to respond prior to N5531S taking reading.
  7.006  IEEE         [SDC]FR[V @FreqkHz]KZAP[V @Pwr]DMAM30PCS3R3[D200]
  7.007  N5531        ExtRefFreq = 10 MHz; TimebaseAccOff
  7.007  N5531        Power = [V @Pwr] dBm; InputAttenuation = 20 dB
  7.007  N5531        +Freq = [V @FreqkHz] kHz; Read
  7.008  MATH         TunedFreq = MEM
  7.009  TARGET       -m
  7.010  N5531        ExtRefFreq = 10 MHz; TimebaseAccOff
  7.010  N5531        LPF = 15 kHz; HPF = 300 Hz; Detector = Peak+
  7.010  N5531        Power = [V @Pwr] dBm; InputAttenuation = 20 dB
  7.010  N5531        Freq = [V TunedFreq] kHz; ModFreq = 1 kHz
  7.010  N5531        +PMDev = 0.000 rad
  7.011  MEMC         0.000rad       -.300U +.000U

  8.001  ELSE         ; MHz
  8.002  HEAD         INCIDENTAL PHASE MODULATION: [V @FreqMHz] MHz
  8.003  TSET         TDESC = [V @FreqMHz] MHz
  8.004  N5531        ExtRefFreq = 10 MHz; TimebaseAccOff
  8.004  N5531        Power = [V @Pwr] dBm; InputAttenuation = 20 dB
  8.004  N5531        +Freq = [V @FreqMHz] MHz; Setup
  8.005  IEEE         [SDC]FR[V @FreqMHz]MZAP[V @Pwr]DMAM30PCS3R3[D200]
  8.006  N5531        ExtRefFreq = 10 MHz; TimebaseAccOff
  8.006  N5531        Power = [V @Pwr] dBm; InputAttenuation = 20 dB
  8.006  N5531        +Freq = [V @FreqMHz] MHz; Read
  8.007  MATH         TunedFreq = MEM
  8.008  TARGET       -m
  8.009  N5531        ExtRefFreq = 10 MHz; TimebaseAccOff
  8.009  N5531        LPF = 15 kHz; HPF = 300 Hz; Detector = Peak+
  8.009  N5531        InputAttenuation = 20 dB; Power = [V @Pwr] dBm
  8.009  N5531        Freq = [V TunedFreq] MHz; ModFreq = 1 kHz
  8.009  N5531        +PMDev = 0.000 rad
  8.010  MEMC         0.000rad       -.300U +.000U
  9.001  ENDIF

  9.002  IEEE         [SDC]R2
  9.003  N5531        Reset
  9.004  END

# =====  Sub HP 8657x (1 yr) Residual AM Test IEEE /N5531  ==================

  9.005  LABEL        RESIDUAL_AM
  9.006  TARGET       -p
  9.007  TSET         TDESC = [V @FreqMHz] MHz
  9.008  N5531        ExtRefFreq = 10 MHz; TimebaseAccOff
  9.008  N5531        Power = 0 dBm; InputAttenuation = 10 dB
  9.008  N5531        +Freq = [V @FreqMHz] MHz; Setup
  9.009  IEEE         [SDC]FR[V @FreqMHz]MZAP0DMR3
  9.010  N5531        ExtRefFreq = 10 MHz; TimebaseAccOff
  9.010  N5531        Power = 0 dBm; InputAttenuation = 10 dB
  9.010  N5531        +Freq = [V @FreqMHz] MHz; Read
  9.011  MATH         TunedFreq = MEM
  9.012  TARGET       -m
  9.013  N5531        ExtRefFreq = 10 MHz; TimebaseAccOff
  9.013  N5531        LPF = 15 kHz; HPF = 50 Hz; Detector = RMS
  9.013  N5531        InputAttenuation = 10 dB; Power = 0 dBm
  9.013  N5531        Freq = [V TunedFreq] MHz; ModFreq = 1 kHz
  9.013  N5531        +ResidualAM = 0.000 %
  9.014  MEMC         0.000pct       +.000U -.040U

 10.001  IEEE         [SDC]R2
 10.002  N5531        Reset
 10.003  END
