﻿Copyright (c) (2015) Fluke Corporation                      MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub HP 8657x (1 yr) FM Accuracy VER IEEE /N5531
INSTRUMENT:            Sub HP 8657x (1 yr) Incidental AM VER IEEE /N5531
INSTRUMENT:            Sub HP 8657x (1 yr) FM Distortion VER IEEE /N5531
INSTRUMENT:            Sub HP 8657x (1 yr) Residual FM VER IEEE /N5531
INSTRUMENT:            Sub HP 8657x (1 yr) DC FM Freq Error VER IEEE /N5531
DATE:                  2016-06-28 11:15:45
AUTHOR:                Fluke
REVISION:              $Revision: 16396 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       90
NUMBER OF LINES:       891
CONFIGURATION:         Agilent PSA (6.7 GHz,233)
=============================================================================
#
#  Procedure Author:
#        DFM, DAC
#
#  Model(s) Covered:
#        8657A, 8657B, 8657D
#
#  Additional Equipment Required:
#        None
#
#  Note:
#  Test points based on those performed by Agilent TMO Support Operations.
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

# Note, Selected Device Clear [SDC] is sent prior to each command. If [SDC]
# is not sent, it has been found that sometimes the generator does not update
# its settings even it accepts the command without error.

  1.001  JMPL         DC_FM_ACCURACY               PSUBI("DC FM")
  1.002  JMPL         RESIDUAL_FM                  PSUBI("Residual FM")
  1.003  JMPL         FM_DISTORTION                PSUBI("FM Distortion")

# If UUT is an 8657A, select +7 dBm output level.
# If UUT is an 8657B with OPT 003, select +1 dBm output level.
# If UUT is an 8657B without OPT 003, select +4 dBm output level.

  1.004  IF           ZCMPI(@ModelNum, "8657A")
  1.005  MATH         @Pwr = 7
  1.006  ELSE

  1.007  IF           @Opt_003
  1.008  MATH         @Pwr = 1
  1.009  ELSE
  1.010  MATH         @Pwr = 4
  1.011  ENDIF

  1.012  ENDIF

  1.013  JMPL         INCIDENTAL_AM                PSUBI("Incidental AM")
  1.014  JMPL         FM_ACCURACY                  PSUBI("FM Accuracy")
  1.015  DISP         Subprocedure not found!
  1.016  END

# =====  Sub HP 8657x (1 yr) FM Accuracy VER IEEE /N5531  ===================

  1.017  LABEL        FM_ACCURACY
  1.018  RSLT         =
  1.019  RSLT         =FM INDICATOR ACCURACY
  1.020  RSLT         = Carrier Level: [V @Pwr] dBm
  1.021  RSLT         = Modulation Source: INT 1 kHz
  1.022  RSLT         =
  1.023  HEAD         FM INDICATOR ACCURACY ({100 MHz Carrier})
  1.024  TARGET       -p
  1.025  TSET         TDESC = 5 kHz Deviation
  1.026  N5531        ExtRefFreq = 10 MHz; TimebaseAccOff
  1.026  N5531        Power = [V @Pwr] dBm; InputAttenuation = 20 dB
  1.026  N5531        +Freq = 100 MHz; Setup
  1.027  IEEE         [SDC]FR100MZAP[V @Pwr]DMFM5KZS3R3
  1.028  N5531        ExtRefFreq = 10 MHz; TimebaseAccOff
  1.028  N5531        Power = [V @Pwr] dBm; InputAttenuation = 20 dB
  1.028  N5531        +Freq = 100 MHz; Read
  1.029  MATH         TunedFreq = MEM
  1.030  TARGET       -m
  1.031  N5531        ExtRefFreq = 10 MHz; TimebaseAccOff
  1.031  N5531        LPF = 3 kHz; HPF = 300 Hz; Detector = Peak+
  1.031  N5531        Power = [V @Pwr] dBm; InputAttenuation = 20 dB
  1.031  N5531        Freq = [V TunedFreq] MHz; ModFreq = 1 kHz
  1.031  N5531        +FMDev = 5.00 kHz
  1.032  MEMC         5.00kH         0.25U         100MH

  2.001  TSET         TDESC = 30 kHz Deviation
  2.002  IEEE         [SDC]FR100MZAP[V @Pwr]DMFM30KZS3R3
  2.003  TARGET       -m
  2.004  N5531        ExtRefFreq = 10 MHz; TimebaseAccOff
  2.004  N5531        LPF = 3 kHz; HPF = 300 Hz; Detector = Peak+
  2.004  N5531        Power = [V @Pwr] dBm; InputAttenuation = 20 dB
  2.004  N5531        Freq = [V TunedFreq] MHz; ModFreq = 1 kHz
  2.004  N5531        +FMDev = 30.00 kHz; Read
  2.005  MEMC         30.00kH        1.50U         100MH

  3.001  TSET         TDESC = 70 kHz Deviation
  3.002  IEEE         [SDC]FR100MZAP[V @Pwr]DMFM70KZS3R3
  3.003  TARGET       -m
  3.004  N5531        ExtRefFreq = 10 MHz; TimebaseAccOff
  3.004  N5531        LPF = 3 kHz; HPF = 300 Hz; Detector = Peak+
  3.004  N5531        Power = [V @Pwr] dBm; InputAttenuation = 20 dB
  3.004  N5531        Freq = [V TunedFreq] MHz; ModFreq = 1 kHz
  3.004  N5531        +FMDev = 70.00 kHz; Read
  3.005  MEMC         70.00kH        3.50U         100MH

  4.001  TSET         TDESC = 99 kHz Deviation
  4.002  IEEE         [SDC]FR100MZAP[V @Pwr]DMFM99KZS3R3
  4.003  TARGET       -m
  4.004  N5531        ExtRefFreq = 10 MHz; TimebaseAccOff
  4.004  N5531        LPF = 3 kHz; HPF = 300 Hz; Detector = Peak+
  4.004  N5531        Power = [V @Pwr] dBm; InputAttenuation = 20 dB
  4.004  N5531        Freq = [V TunedFreq] MHz; ModFreq = 1 kHz
  4.004  N5531        +FMDev = 99.00 kHz ; Read
  4.005  MEMC         99.00kH        3.95U         100MH

  5.001  IEEE         [SDC]R2
  5.002  N5531        Reset
  5.003  END

  5.004  EVAL   Increment Test Number

# =====  Sub HP 8657x (1 yr) Incidental AM VER IEEE /N5531  =================

  6.001  LABEL        INCIDENTAL_AM
  6.002  RSLT         =
  6.003  HEAD         MODULATION TESTS: {INCIDENTAL AM (20 kHz FM Deviation)}
  6.004  RSLT         = Modulation Source: INT 1 kHz
  6.005  RSLT         = Carrier Level: [V @Pwr] dBm
  6.006  RSLT         = Bandwidth: 300 Hz - 3 kHz
  6.007  RSLT         =

  6.008  MATH         @FreqMHz = 100
  6.009  TOL          -0.10U
  6.010  CALL         Sub HP 8657x (1 yr) Incidental AM Test IEEE /N5531

  6.011  IF           0
  6.012  EVAL   Increment step number
  7.001  ENDIF

  7.002  MATH         @FreqMHz = 240
  7.003  TOL          -0.10U
  7.004  CALL         Sub HP 8657x (1 yr) Incidental AM Test IEEE /N5531

  7.005  IF           0
  7.006  EVAL   Increment step number
  8.001  ENDIF

  8.002  MATH         @FreqMHz = 400
  8.003  TOL          -0.10U
  8.004  CALL         Sub HP 8657x (1 yr) Incidental AM Test IEEE /N5531

  8.005  IF           0
  8.006  EVAL   Increment step number
  9.001  ENDIF

  9.002  MATH         @FreqMHz = 520
  9.003  TOL          -0.10U
  9.004  CALL         Sub HP 8657x (1 yr) Incidental AM Test IEEE /N5531

  9.005  IF           0
  9.006  EVAL   Increment step number
 10.001  ENDIF

# Select additional test frequencies based on UUT model number.
 10.002  IF           ZCMPI(@ModelNum, "8657A")
 10.003  MATH         @FreqMHz = 1040
 10.004  TOL          -0.10U
 10.005  CALL         Sub HP 8657x (1 yr) Incidental AM Test IEEE /N5531

 10.006  IF           0
 10.007  EVAL   Increment step number
 11.001  ENDIF

 11.002  ELSE         ; 8657B
 11.003  MATH         @FreqMHz = 1030
 11.004  TOL          -0.10U
 11.005  CALL         Sub HP 8657x (1 yr) Incidental AM Test IEEE /N5531

 11.006  IF           0
 11.007  EVAL   Increment step number
 12.001  ENDIF

 12.002  MATH         @FreqMHz = 1075
 12.003  TOL          -0.50U
 12.004  CALL         Sub HP 8657x (1 yr) Incidental AM Test IEEE /N5531

 12.005  IF           0
 12.006  EVAL   Increment step number
 13.001  ENDIF

 13.002  MATH         @FreqMHz = 1120
 13.003  TOL          -0.50U
 13.004  CALL         Sub HP 8657x (1 yr) Incidental AM Test IEEE /N5531

 13.005  IF           0
 13.006  EVAL   Increment step number
 14.001  ENDIF

 14.002  MATH         @FreqMHz = 1165
 14.003  TOL          -0.50U
 14.004  CALL         Sub HP 8657x (1 yr) Incidental AM Test IEEE /N5531

 14.005  IF           0
 14.006  EVAL   Increment step number
 15.001  ENDIF

 15.002  MATH         @FreqMHz = 1210
 15.003  TOL          -0.50U
 15.004  CALL         Sub HP 8657x (1 yr) Incidental AM Test IEEE /N5531

 15.005  IF           0
 15.006  EVAL   Increment step number
 16.001  ENDIF

 16.002  MATH         @FreqMHz = 1255
 16.003  TOL          -0.50U
 16.004  CALL         Sub HP 8657x (1 yr) Incidental AM Test IEEE /N5531

 16.005  IF           0
 16.006  EVAL   Increment step number
 17.001  ENDIF

 17.002  MATH         @FreqMHz = 1300
 17.003  TOL          -0.50U
 17.004  CALL         Sub HP 8657x (1 yr) Incidental AM Test IEEE /N5531

 17.005  IF           0
 17.006  EVAL   Increment step number
 18.001  ENDIF

 18.002  ENDIF

 18.003  IEEE         [SDC]R2
 18.004  N5531        Reset
 18.005  END

 18.006  EVAL   Increment Test Number

# =====  Sub HP 8657x (1 yr) FM Distortion VER IEEE /N5531  =================

 19.001  LABEL        FM_DISTORTION
 19.002  RSLT         =
 19.003  RSLT         =FM DISTORTION
 19.004  RSLT         = Modulation Source: INT 1 kHz
 19.005  RSLT         = Carrier Level: +4 dBm
 19.006  RSLT         = Bandwidth: 300 Hz - 3 kHz
 19.007  RSLT         =
 19.008  HEAD         FM DISTORTION TEST ({150 MHz Carrier})
 19.009  MATH         @FMDevkHz = 3
 19.010  CALL         Sub HP 8657x (1 yr) FM Distortion Test IEEE /N5531

 19.011  IF           0
 19.012  EVAL   Increment step number
 20.001  ENDIF

# Select additional test frequencies based on UUT model number.
 20.002  IF           ZCMPI(@ModelNum, "8657B")
 20.003  MATH         @FMDevkHz = 6
 20.004  CALL         Sub HP 8657x (1 yr) FM Distortion Test IEEE /N5531

 20.005  IF           0
 20.006  EVAL   Increment step number
 21.001  ENDIF

 21.002  MATH         @FMDevkHz = 10
 21.003  CALL         Sub HP 8657x (1 yr) FM Distortion Test IEEE /N5531

 21.004  IF           0
 21.005  EVAL   Increment step number
 22.001  ENDIF

 22.002  MATH         @FMDevkHz = 20
 22.003  CALL         Sub HP 8657x (1 yr) FM Distortion Test IEEE /N5531

 22.004  IF           0
 22.005  EVAL   Increment step number
 23.001  ENDIF

 23.002  MATH         @FMDevkHz = 30
 23.003  CALL         Sub HP 8657x (1 yr) FM Distortion Test IEEE /N5531

 23.004  IF           0
 23.005  EVAL   Increment step number
 24.001  ENDIF

 24.002  MATH         @FMDevkHz = 40
 24.003  CALL         Sub HP 8657x (1 yr) FM Distortion Test IEEE /N5531

 24.004  IF           0
 24.005  EVAL   Increment step number
 25.001  ENDIF

 25.002  MATH         @FMDevkHz = 50
 25.003  CALL         Sub HP 8657x (1 yr) FM Distortion Test IEEE /N5531

 25.004  IF           0
 25.005  EVAL   Increment step number
 26.001  ENDIF

 26.002  MATH         @FMDevkHz = 60
 26.003  CALL         Sub HP 8657x (1 yr) FM Distortion Test IEEE /N5531

 26.004  IF           0
 26.005  EVAL   Increment step number
 27.001  ENDIF

 27.002  MATH         @FMDevkHz = 70
 27.003  CALL         Sub HP 8657x (1 yr) FM Distortion Test IEEE /N5531

 27.004  IF           0
 27.005  EVAL   Increment step number
 28.001  ENDIF

 28.002  MATH         @FMDevkHz = 80
 28.003  CALL         Sub HP 8657x (1 yr) FM Distortion Test IEEE /N5531

 28.004  IF           0
 28.005  EVAL   Increment step number
 29.001  ENDIF

 29.002  MATH         @FMDevkHz = 90
 29.003  CALL         Sub HP 8657x (1 yr) FM Distortion Test IEEE /N5531

 29.004  IF           0
 29.005  EVAL   Increment step number
 30.001  ENDIF

 30.002  MATH         @FMDevkHz = 99
 30.003  CALL         Sub HP 8657x (1 yr) FM Distortion Test IEEE /N5531

 30.004  IF           0
 30.005  EVAL   Increment step number
 31.001  ENDIF

 31.002  ENDIF

 31.003  IEEE         [SDC]R2
 31.004  N5531        Reset
 31.005  END

 31.006  EVAL   Increment Test Number

# =====  Sub HP 8657x (1 yr) Residual FM VER IEEE /N5531  ===================

 32.001  LABEL        RESIDUAL_FM
 32.002  RSLT         =
 32.003  HEAD         SPECTRAL PURITY TESTS: {RESIDUAL FM}
 32.004  RSLT         = Carrier Level: 0 dBm
 32.005  RSLT         =
 32.006  RSLT         =300 Hz to 3 kHz Bandwidth
 32.007  MATH         @HPF = "300 Hz";  @LPF = "3 kHz"

# These frequencies are only tested on the 8657B!
 32.008  IF           ZCMPI(@ModelNum, "8657B")
 32.009  MATH         @FreqMHz = 39.8
 32.010  TOL          -6.0U
 32.011  CALL         Sub HP 8657x (1 yr) Residual FM Test IEEE /N5531

 32.012  IF           0
 32.013  EVAL   Increment step number
 33.001  ENDIF

 33.002  MATH         @FreqMHz = 40.2
 33.003  TOL          -6.0U
 33.004  CALL         Sub HP 8657x (1 yr) Residual FM Test IEEE /N5531

 33.005  IF           0
 33.006  EVAL   Increment step number
 34.001  ENDIF

 34.002  MATH         @FreqMHz = 50.001
 34.003  TOL          -6.0U
 34.004  CALL         Sub HP 8657x (1 yr) Residual FM Test IEEE /N5531

 34.005  IF           0
 34.006  EVAL   Increment step number
 35.001  ENDIF

 35.002  MATH         @FreqMHz = 100
 35.003  TOL          -6.0U
 35.004  CALL         Sub HP 8657x (1 yr) Residual FM Test IEEE /N5531

 35.005  IF           0
 35.006  EVAL   Increment step number
 36.001  ENDIF

 36.002  ENDIF

 36.003  MATH         @FreqMHz = 120
 36.004  TOL          -6.0U
 36.005  CALL         Sub HP 8657x (1 yr) Residual FM Test IEEE /N5531

 36.006  IF           0
 36.007  EVAL   Increment step number
 37.001  ENDIF

 37.002  MATH         @FreqMHz = 150
 37.003  TOL          -1.5U
 37.004  CALL         Sub HP 8657x (1 yr) Residual FM Test IEEE /N5531

 37.005  IF           0
 37.006  EVAL   Increment step number
 38.001  ENDIF

 38.002  MATH         @FreqMHz = 300
 38.003  TOL          -3.0U
 38.004  CALL         Sub HP 8657x (1 yr) Residual FM Test IEEE /N5531

 38.005  IF           0
 38.006  EVAL   Increment step number
 39.001  ENDIF

 39.002  MATH         @FreqMHz = 600

 39.003  IF           ZCMPI(@ModelNum, "8657A")
 39.004  TOL          -4.0U
 39.005  ELSE         ; 8657B
 39.006  TOL          -3.0U
 39.007  ENDIF

 39.008  CALL         Sub HP 8657x (1 yr) Residual FM Test IEEE /N5531

 39.009  IF           0
 39.010  EVAL   Increment step number
 40.001  ENDIF

# Select additional test frequencies based on UUT model number.
 40.002  IF           ZCMPI(@ModelNum, "8657B")
 40.003  MATH         @FreqMHz = 1300
 40.004  TOL          -6.0U
 40.005  CALL         Sub HP 8657x (1 yr) Residual FM Test IEEE /N5531

 40.006  IF           0
 40.007  EVAL   Increment step number
 41.001  ENDIF

 41.002  ENDIF

 41.003  RSLT         =
 41.004  RSLT         =50 Hz to 15 kHz Bandwidth
 41.005  MATH         @HPF = "50 Hz";  @LPF = "15 kHz"

# These frequencies are only tested on the 8657B!
 41.006  IF           ZCMPI(@ModelNum, "8657B")
 41.007  MATH         @FreqMHz = 39.8
 41.008  TOL          -6.0U
 41.009  CALL         Sub HP 8657x (1 yr) Residual FM Test IEEE /N5531

 41.010  IF           0
 41.011  EVAL   Increment step number
 42.001  ENDIF

 42.002  MATH         @FreqMHz = 40.2
 42.003  TOL          -6.0U
 42.004  CALL         Sub HP 8657x (1 yr) Residual FM Test IEEE /N5531

 42.005  IF           0
 42.006  EVAL   Increment step number
 43.001  ENDIF

 43.002  MATH         @FreqMHz = 50.001
 43.003  TOL          -6.0U
 43.004  CALL         Sub HP 8657x (1 yr) Residual FM Test IEEE /N5531

 43.005  IF           0
 43.006  EVAL   Increment step number
 44.001  ENDIF

 44.002  MATH         @FreqMHz = 100
 44.003  TOL          -6.0U
 44.004  CALL         Sub HP 8657x (1 yr) Residual FM Test IEEE /N5531

 44.005  IF           0
 44.006  EVAL   Increment step number
 45.001  ENDIF

 45.002  ENDIF

 45.003  MATH         @FreqMHz = 120
 45.004  TOL          -6.0U
 45.005  CALL         Sub HP 8657x (1 yr) Residual FM Test IEEE /N5531

 45.006  IF           0
 45.007  EVAL   Increment step number
 46.001  ENDIF

 46.002  MATH         @FreqMHz = 150
 46.003  TOL          -1.5U
 46.004  CALL         Sub HP 8657x (1 yr) Residual FM Test IEEE /N5531

 46.005  IF           0
 46.006  EVAL   Increment step number
 47.001  ENDIF

 47.002  MATH         @FreqMHz = 300
 47.003  TOL          -3.0U
 47.004  CALL         Sub HP 8657x (1 yr) Residual FM Test IEEE /N5531

 47.005  IF           0
 47.006  EVAL   Increment step number
 48.001  ENDIF

 48.002  MATH         @FreqMHz = 600

 48.003  IF           ZCMPI(@ModelNum, "8657A")
 48.004  TOL          -6.0U
 48.005  ELSE         ; 8657B
 48.006  TOL          -4.0U
 48.007  ENDIF

 48.008  CALL         Sub HP 8657x (1 yr) Residual FM Test IEEE /N5531

 48.009  IF           0
 48.010  EVAL   Increment step number
 49.001  ENDIF

# Select additional test frequencies based on UUT model number.
 49.002  IF           ZCMPI(@ModelNum, "8657B")
 49.003  MATH         @FreqMHz = 1300
 49.004  TOL          -8.0U
 49.005  CALL         Sub HP 8657x (1 yr) Residual FM Test IEEE /N5531

 49.006  IF           0
 49.007  EVAL   Increment step number
 50.001  ENDIF
 50.002  ENDIF

 50.003  IEEE         [SDC]R2
 50.004  N5531        Reset
 50.005  END

 50.006  EVAL   Increment Test Number

# =====  Sub HP 8657x (1 yr) DC FM Freq Error VER IEEE /M5531  ==============

 51.001  LABEL        DC_FM_ACCURACY
 51.002  RSLT         =
 51.003  RSLT         =DC FM CENTER FREQUENCY ACCURACY
 51.004  RSLT         =
 51.005  HEAD         DC FM CENTER FREQUENCY ACCURACY ({100 MHz Carrier})
 51.006  MATH         @FreqMHz = 100; @FMDevkHz = 0
 51.007  TOL          500U
 51.008  CALL         Sub HP 8657x (1 yr) DC FM Freq Error Test IEEE /N5531

 51.009  IF           0
 51.010  EVAL   Increment step number
 52.001  ENDIF

 52.002  MATH         @FreqMHz = 100; @FMDevkHz = 20
 52.003  TOL          500U
 52.004  CALL         Sub HP 8657x (1 yr) DC FM Freq Error Test IEEE /N5531

 52.005  IF           0
 52.006  EVAL   Increment step number
 53.001  ENDIF

 53.002  MATH         @FreqMHz = 100; @FMDevkHz = 21
 53.003  TOL          500U
 53.004  CALL         Sub HP 8657x (1 yr) DC FM Freq Error Test IEEE /N5531

 53.005  IF           0
 53.006  EVAL   Increment step number
 54.001  ENDIF

 54.002  MATH         @FreqMHz = 100; @FMDevkHz = 200
 54.003  TOL          500U
 54.004  CALL         Sub HP 8657x (1 yr) DC FM Freq Error Test IEEE /N5531

 54.005  IF           0
 54.006  EVAL   Increment step number
 55.001  ENDIF

 55.002  RSLT         =
 55.003  HEAD         DC FM CENTER FREQUENCY ACCURACY ({200 MHz Carrier})
 55.004  MATH         @FreqMHz = 200; @FMDevkHz = 0
 55.005  TOL          125U
 55.006  CALL         Sub HP 8657x (1 yr) DC FM Freq Error Test IEEE /N5531

 55.007  IF           0
 55.008  EVAL   Increment step number
 56.001  ENDIF

 56.002  MATH         @FreqMHz = 200; @FMDevkHz = 20
 56.003  TOL          125U
 56.004  CALL         Sub HP 8657x (1 yr) DC FM Freq Error Test IEEE /N5531

 56.005  IF           0
 56.006  EVAL   Increment step number
 57.001  ENDIF

 57.002  MATH         @FreqMHz = 200; @FMDevkHz = 21
 57.003  TOL          125U
 57.004  CALL         Sub HP 8657x (1 yr) DC FM Freq Error Test IEEE /N5531

 57.005  IF           0
 57.006  EVAL   Increment step number
 58.001  ENDIF

 58.002  MATH         @FreqMHz = 200; @FMDevkHz = 50
 58.003  TOL          125U
 58.004  CALL         Sub HP 8657x (1 yr) DC FM Freq Error Test IEEE /N5531

 58.005  IF           0
 58.006  EVAL   Increment step number
 59.001  ENDIF

 59.002  RSLT         =
 59.003  HEAD         DC FM CENTER FREQUENCY ACCURACY ({400 MHz Carrier})
 59.004  MATH         @FreqMHz = 400; @FMDevkHz = 0
 59.005  TOL          250U
 59.006  CALL         Sub HP 8657x (1 yr) DC FM Freq Error Test IEEE /N5531

 59.007  IF           0
 59.008  EVAL   Increment step number
 60.001  ENDIF

 60.002  MATH         @FreqMHz = 400; @FMDevkHz = 20
 60.003  TOL          250U
 60.004  CALL         Sub HP 8657x (1 yr) DC FM Freq Error Test IEEE /N5531

 60.005  IF           0
 60.006  EVAL   Increment step number
 61.001  ENDIF

 61.002  MATH         @FreqMHz = 400; @FMDevkHz = 21
 61.003  TOL          250U
 61.004  CALL         Sub HP 8657x (1 yr) DC FM Freq Error Test IEEE /N5531

 61.005  IF           0
 61.006  EVAL   Increment step number
 62.001  ENDIF

 62.002  MATH         @FreqMHz = 400; @FMDevkHz = 100
 62.003  TOL          250U
 62.004  CALL         Sub HP 8657x (1 yr) DC FM Freq Error Test IEEE /N5531

 62.005  IF           0
 62.006  EVAL   Increment step number
 63.001  ENDIF

 63.002  RSLT         =
 63.003  HEAD         DC FM CENTER FREQUENCY ACCURACY ({800 MHz Carrier})
 63.004  MATH         @FreqMHz = 800; @FMDevkHz = 0
 63.005  TOL          500U
 63.006  CALL         Sub HP 8657x (1 yr) DC FM Freq Error Test IEEE /N5531

 63.007  IF           0
 63.008  EVAL   Increment step number
 64.001  ENDIF

 64.002  MATH         @FreqMHz = 800; @FMDevkHz = 20
 64.003  TOL          500U
 64.004  CALL         Sub HP 8657x (1 yr) DC FM Freq Error Test IEEE /N5531

 64.005  IF           0
 64.006  EVAL   Increment step number
 65.001  ENDIF

 65.002  MATH         @FreqMHz = 800; @FMDevkHz = 21
 65.003  TOL          500U
 65.004  CALL         Sub HP 8657x (1 yr) DC FM Freq Error Test IEEE /N5531

 65.005  IF           0
 65.006  EVAL   Increment step number
 66.001  ENDIF

 66.002  MATH         @FreqMHz = 800; @FMDevkHz = 200
 66.003  TOL          500U
 66.004  CALL         Sub HP 8657x (1 yr) DC FM Freq Error Test IEEE /N5531

 66.005  IF           0
 66.006  EVAL   Increment step number
 67.001  ENDIF

# Select additional test frequencies based on UUT model number.
 67.002  IF           ZCMPI(@ModelNum, "8657B")
 67.003  RSLT         =
 67.004  HEAD         DC FM CENTER FREQUENCY ACCURACY ({1100 MHz Carrier})
 67.005  MATH         @FreqMHz = 1000; @FMDevkHz = 0
 67.006  TOL          1000U
 67.007  CALL         Sub HP 8657x (1 yr) DC FM Freq Error Test IEEE /N5531

 67.008  IF           0
 67.009  EVAL   Increment step number
 68.001  ENDIF

 68.002  MATH         @FreqMHz = 1000; @FMDevkHz = 40
 68.003  TOL          1000U
 68.004  CALL         Sub HP 8657x (1 yr) DC FM Freq Error Test IEEE /N5531

 68.005  IF           0
 68.006  EVAL   Increment step number
 69.001  ENDIF

 69.002  MATH         @FreqMHz = 1000; @FMDevkHz = 41
 69.003  TOL          1000U
 69.004  CALL         Sub HP 8657x (1 yr) DC FM Freq Error Test IEEE /N5531

 69.005  IF           0
 69.006  EVAL   Increment step number
 70.001  ENDIF

 70.002  MATH         @FreqMHz = 1000; @FMDevkHz = 400
 70.003  TOL          1000U
 70.004  CALL         Sub HP 8657x (1 yr) DC FM Freq Error Test IEEE /N5531

 70.005  IF           0
 70.006  EVAL   Increment step number
 71.001  ENDIF

 71.002  RSLT         =
 71.003  HEAD         DC FM CENTER FREQUENCY ACCURACY ({100 MHz Carrier})
 71.004  MATH         @FreqMHz = 100; @FMDevkHz = 1
 71.005  TOL          500U
 71.006  CALL         Sub HP 8657x (1 yr) DC FM Freq Error Test IEEE /N5531

 71.007  IF           0
 71.008  EVAL   Increment step number
 72.001  ENDIF

 72.002  MATH         @FreqMHz = 100; @FMDevkHz = 10
 72.003  TOL          500U
 72.004  CALL         Sub HP 8657x (1 yr) DC FM Freq Error Test IEEE /N5531

 72.005  IF           0
 72.006  EVAL   Increment step number
 73.001  ENDIF

 73.002  MATH         @FreqMHz = 100; @FMDevkHz = 50
 73.003  TOL          500U
 73.004  CALL         Sub HP 8657x (1 yr) DC FM Freq Error Test IEEE /N5531

 73.005  IF           0
 73.006  EVAL   Increment step number
 74.001  ENDIF

 74.002  MATH         @FreqMHz = 100; @FMDevkHz = 99
 74.003  TOL          500U
 74.004  CALL         Sub HP 8657x (1 yr) DC FM Freq Error Test IEEE /N5531

 74.005  IF           0
 74.006  EVAL   Increment step number
 75.001  ENDIF

 75.002  RSLT         =
 75.003  HEAD         DC FM CENTER FREQUENCY ACCURACY ({240 MHz Carrier})
 75.004  MATH         @FreqMHz = 240; @FMDevkHz = 1
 75.005  TOL          500U
 75.006  CALL         Sub HP 8657x (1 yr) DC FM Freq Error Test IEEE /N5531

 75.007  IF           0
 75.008  EVAL   Increment step number
 76.001  ENDIF

 76.002  MATH         @FreqMHz = 240; @FMDevkHz = 10
 76.003  TOL          500U
 76.004  CALL         Sub HP 8657x (1 yr) DC FM Freq Error Test IEEE /N5531

 76.005  IF           0
 76.006  EVAL   Increment step number
 77.001  ENDIF

 77.002  MATH         @FreqMHz = 240; @FMDevkHz = 50
 77.003  TOL          500U
 77.004  CALL         Sub HP 8657x (1 yr) DC FM Freq Error Test IEEE /N5531

 77.005  IF           0
 77.006  EVAL   Increment step number
 78.001  ENDIF

 78.002  RSLT         =
 78.003  HEAD         DC FM CENTER FREQUENCY ACCURACY ({400 MHz Carrier})
 78.004  MATH         @FreqMHz = 400; @FMDevkHz = 1
 78.005  TOL          250U
 78.006  CALL         Sub HP 8657x (1 yr) DC FM Freq Error Test IEEE /N5531

 78.007  IF           0
 78.008  EVAL   Increment step number
 79.001  ENDIF

 79.002  MATH         @FreqMHz = 400; @FMDevkHz = 10
 79.003  TOL          250U
 79.004  CALL         Sub HP 8657x (1 yr) DC FM Freq Error Test IEEE /N5531

 79.005  IF           0
 79.006  EVAL   Increment step number
 80.001  ENDIF

 80.002  MATH         @FreqMHz = 400; @FMDevkHz = 50
 80.003  TOL          250U
 80.004  CALL         Sub HP 8657x (1 yr) DC FM Freq Error Test IEEE /N5531

 80.005  IF           0
 80.006  EVAL   Increment step number
 81.001  ENDIF

 81.002  MATH         @FreqMHz = 400; @FMDevkHz = 99
 81.003  TOL          250U
 81.004  CALL         Sub HP 8657x (1 yr) DC FM Freq Error Test IEEE /N5531

 81.005  IF           0
 81.006  EVAL   Increment step number
 82.001  ENDIF

 82.002  RSLT         =
 82.003  HEAD         DC FM CENTER FREQUENCY ACCURACY ({1030 MHz Carrier})
 82.004  MATH         @FreqMHz = 1030; @FMDevkHz = 1
 82.005  TOL          500U
 82.006  CALL         Sub HP 8657x (1 yr) DC FM Freq Error Test IEEE /N5531

 82.007  IF           0
 82.008  EVAL   Increment step number
 83.001  ENDIF

 83.002  MATH         @FreqMHz = 1030; @FMDevkHz = 10
 83.003  TOL          500U
 83.004  CALL         Sub HP 8657x (1 yr) DC FM Freq Error Test IEEE /N5531

 83.005  IF           0
 83.006  EVAL   Increment step number
 84.001  ENDIF

 84.002  MATH         @FreqMHz = 1030; @FMDevkHz = 50
 84.003  TOL          500U
 84.004  CALL         Sub HP 8657x (1 yr) DC FM Freq Error Test IEEE /N5531

 84.005  IF           0
 84.006  EVAL   Increment step number
 85.001  ENDIF

 85.002  MATH         @FreqMHz = 1030; @FMDevkHz = 99
 85.003  TOL          500U
 85.004  CALL         Sub HP 8657x (1 yr) DC FM Freq Error Test IEEE /N5531

 85.005  IF           0
 85.006  EVAL   Increment step number
 86.001  ENDIF

 86.002  RSLT         =
 86.003  HEAD         DC FM CENTER FREQUENCY ACCURACY ({1200 MHz Carrier})
 86.004  MATH         @FreqMHz = 1200; @FMDevkHz = 1
 86.005  TOL          1000U
 86.006  CALL         Sub HP 8657x (1 yr) DC FM Freq Error Test IEEE /N5531

 86.007  IF           0
 86.008  EVAL   Increment step number
 87.001  ENDIF

 87.002  MATH         @FreqMHz = 1200; @FMDevkHz = 10
 87.003  TOL          1000U
 87.004  CALL         Sub HP 8657x (1 yr) DC FM Freq Error Test IEEE /N5531

 87.005  IF           0
 87.006  EVAL   Increment step number
 88.001  ENDIF

 88.002  MATH         @FreqMHz = 1200; @FMDevkHz = 50
 88.003  TOL          1000U
 88.004  CALL         Sub HP 8657x (1 yr) DC FM Freq Error Test IEEE /N5531

 88.005  IF           0
 88.006  EVAL   Increment step number
 89.001  ENDIF

 89.002  MATH         @FreqMHz = 1200; @FMDevkHz = 99
 89.003  TOL          1000U
 89.004  CALL         Sub HP 8657x (1 yr) DC FM Freq Error Test IEEE /N5531

 89.005  IF           0
 89.006  EVAL   Increment step number
 90.001  ENDIF

 90.002  ENDIF

 90.003  IEEE         [SDC]R2
 90.004  N5531        Reset
 90.005  END
