﻿Copyright (c) (2015) Fluke Corporation                      MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub HP 8657x (1 yr) Incidental AM Test IEEE /N5531
INSTRUMENT:            Sub HP 8657x (1 yr) FM Distortion Test IEEE /N5531
INSTRUMENT:            Sub HP 8657x (1 yr) Residual FM Test IEEE /N5531
INSTRUMENT:            Sub HP 8657x (1 yr) DC FM Freq Error Test IEEE /N5531
DATE:                  2016-06-28 11:16:21
AUTHOR:                Fluke
REVISION:              $Revision: 16396 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       9
NUMBER OF LINES:       180
CONFIGURATION:         Agilent PSA (6.7 GHz,233)
=============================================================================
#
#  Procedure Author:
#        DFM
#
#  Model(s) Covered:
#        8657A, 8657B
#
#  Additional Equipment Required:
#        None
#
#  Note:
#  Test points based on those performed by Agilent TMO Support Operations.
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

# Note, Selected Device Clear [SDC] is sent prior to each command. If [SDC]
# is not sent, it has been found that sometimes the generator does not update
# its settings even it accepts the command without error.

  1.001  JMPL         INCIDENTAL_AM                PSUBI("Incidental AM")
  1.002  JMPL         FM_DISTORTION                PSUBI("FM Distortion")
  1.003  JMPL         RESIDUAL_FM                  PSUBI("Residual FM")
  1.004  JMPL         DC_FM@Freq_ERROR             PSUBI("DC FM Freq Error")
  1.005  DISP         Subprocedure not found!
  1.006  END

  1.007  EVAL   Increment step number

# =====  Sub HP 8657x (1 yr) Incidental AM Test IEEE /N5531  ================

  2.001  LABEL        INCIDENTAL_AM
  2.002  TSET         TDESC = [V @FreqMHz] MHz
  2.003  N5531        ExtRefFreq = 10 MHz; TimebaseAccOff
  2.003  N5531        Power = [V @Pwr] dBm; InputAttenuation = 20 dB
  2.003  N5531        +Freq = [V @FreqMHz] MHz; Setup
  2.004  IEEE         [SDC]FR[V @FreqMHz]MZAP[V @Pwr]DMFM20KZS3R3
  2.005  N5531        ExtRefFreq = 10 MHz; TimebaseAccOff
  2.005  N5531        Power = [V @Pwr] dBm; InputAttenuation = 20 dB
  2.005  N5531        +Freq = [V @FreqMHz] MHz; Read
  2.006  MATH         TunedFreq = MEM
  2.007  TARGET       -m
  2.008  N5531        ExtRefFreq = 10 MHz; TimebaseAccOff
  2.008  N5531        LPF = 3 kHz; HPF = 300 Hz; Detector = Peak+
  2.008  N5531        Power = [V @Pwr] dBm; InputAttenuation = 20 dB
  2.008  N5531        Freq = [V TunedFreq] MHz; ModFreq = 1 kHz
  2.008  N5531        +ResidualAM = 0.00 %
  2.009  MEMC         0.00pct        TOL

  3.001  IEEE         [SDC]R2
  3.002  N5531        Reset
  3.003  END

  3.004  EVAL   Increment step number

# =====  Sub HP 8657x (1 yr) FM Distortion Test IEEE /N5531  ================

  4.001  LABEL        FM_DISTORTION
  4.002  TSET         TDESC = [V @FMDevkHz] kHz Deviation

# Only tune if first time through (FM Deviation is 3 kHz).
  4.003  IF           @FMDevkHz == 3
  4.004  N5531        ExtRefFreq = 10 MHz; TimebaseAccOff
  4.004  N5531        Power = +4 dBm; InputAttenuation = 20 dB
  4.004  N5531        +Freq = 150 MHz; Setup
  4.005  IEEE         [SDC]FR150MZAP+4DMFM[V @FMDevkHz]KZS3R3
  4.006  N5531        ExtRefFreq = 10 MHz; TimebaseAccOff
  4.006  N5531        Power = +4 dBm; InputAttenuation = 20 dB
  4.006  N5531        +Freq = 150 MHz; Read
  4.007  MATH         @TunedFreq = MEM
  4.008  ELSE
  4.009  IEEE         [SDC]FR150MZAP+4DMFM[V @FMDevkHz]KZS3R3
  4.010  ENDIF

  4.011  JMPL         FM_DISTORTION_TEST

# Establish target for post test Repeat and Cancel.
  4.012  TARGET       -p
  4.013  IEEE         [SDC]FR150MZAP+4DMFM[V @FMDevkHz]KZS3R3
  4.014  N5531        ExtRefFreq = 10 MHz; TimebaseAccOff
  4.014  N5531        Power = +4 dBm; InputAttenuation = 20 dB
  4.014  N5531        +Freq = 150 MHz
  4.015  MATH         @TunedFreq = MEM

  4.016  LABEL        FM_DISTORTION_TEST
  4.017  TARGET       -m
  4.018  N5531        ExtRefFreq = 10 MHz; TimebaseAccOff
  4.018  N5531        LPF = 3 kHz; HPF = 300 Hz; Detector = Peak+
  4.018  N5531        Power = +4 dBm  InputAttenuation = 20 dB
  4.018  N5531        Freq = [V @TunedFreq] MHz; ModFreq = 1 kHz
  4.018  N5531        +ModDist = 0.00 %; FMDev = [V @FMDevkHz] kHz
  4.019  MEMC   100   0.00pct        -0.50U

  5.001  IEEE         [SDC]R2
  5.002  N5531        Reset
  5.003  END

  5.004  EVAL   Increment step number

# =====  Sub HP 8657x (1 yr) Residual FM Test IEEE /N5531  =================

  6.001  LABEL        RESIDUAL_FM
  6.002  TSET         TDESC = [V @FreqMHz] MHz
  6.003  TARGET       -p
  6.004  N5531        ExtRefFreq = 10 MHz; TimebaseAccOff
  6.004  N5531        Power = 0 dBm; InputAttenuation = 10 dB
  6.004  N5531        +Freq = [V @FreqMHz] MHz; Setup
  6.005  IEEE         [SDC]FR[V @FreqMHz]MZAP0DMR3
  6.006  N5531        ExtRefFreq = 10 MHz; TimebaseAccOff
  6.006  N5531        Power = 0 dBm; InputAttenuation = 10 dB
  6.006  N5531        +Freq = [V @FreqMHz] MHz; Read
  6.007  MATH         TunedFreq = MEM
  6.008  TARGET       -m
  6.009  N5531        ExtRefFreq = 10 MHz; TimebaseAccOff
  6.009  N5531        HPF = [V @HPF]; LPF = [V @LPF]; Detector = RMS
  6.009  N5531        Power = 0 dBm; InputAttenuation = 10 dB
  6.009  N5531        Freq = [V TunedFreq] MHz; ModFreq = 1 kHz
  6.009  N5531        +ResidualFM = 0.0 Hz
  6.010  MEMC         0.0H           TOL

  7.001  IEEE         [SDC]R2
  7.002  N5531        Reset
  7.003  END

  7.004  EVAL   Increment step number

# =====  Sub HP 8657x (1 yr) DC FM Freq Error Test IEEE /N5531  ============

  8.001  LABEL        DC_FM@Freq_ERROR
  8.002  TSET         TDESC = [V @FMDevkHz] kHz deviation
  8.003  TARGET       -p
  8.004  N5531        ExtRefFreq = 10 MHz; TimebaseAccOff
  8.004  N5531        Power = 0 dBm; InputAttenuation = 10 dB
  8.004  N5531        +Freq = [V @FreqMHz] MHz; Setup
  8.005  IEEE         [SDC]FR[V @FreqMHz]MZAP0DMR3
  8.006  TARGET       -m
# Take initial measurement.
  8.007  N5531        ExtRefFreq = 10 MHz; TimebaseAccOff
  8.007  N5531        Power = 0 dBm; InputAttenuation = 10 dB
  8.007  N5531        +Freq = [V @FreqMHz] MHz; Read
# Store measured value (in Hz) with EXT FM off.
  8.008  MATH         NomFreq = MEM * 1E+6
# Turn on EXT FM, 0 kHz deviation.
  8.009  IEEE         S5[V @FMDevkHz]KZ
# Take measurement with EXT DC FM turned on (nothing applied).
  8.010  N5531        ExtRefFreq = 10 MHz; TimebaseAccOff
  8.010  N5531        Power = 0 dBm; InputAttenuation = 10 dB
  8.010  N5531        +Freq = [V @FreqMHz] MHz; Read
  8.011  MATH         MEM = NomFreq - (MEM * 1E+6)
  8.012  MEMC         0H             500U

  9.001  IEEE         [SDC]R2
  9.002  N5531        Reset
  9.003  END
