﻿Copyright (c) (2015) Fluke Corporation                      MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub HP 8657x (1 yr) Level Flatness VER IEEE /N5531
DATE:                  2016-06-28 11:17:06
AUTHOR:                Fluke
REVISION:              $Revision: 16396 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       11
NUMBER OF LINES:       154
CONFIGURATION:         Agilent PSA (6.7 GHz,233)
CONFIGURATION:         Agilent EPM
CONFIGURATION:         Agilent N5532A (100.0 kHz - 4.2 GHz)
=============================================================================
#
#  Procedure Author:
#        DFM, DAC
#
#  Model(s) Covered:
#        8657A, 8657B, 8657D
#
#  Additional Equipment Required:
#        None
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  IF           0
  1.002  N5531        +Power = 0.0 dBm; Freq = 100 kHz; SensorModule = N5532A
  1.003  N5531        +Power = 0.0 dBm; Freq = 2060 MHz; SensorModule = N5532A
  1.004  ENDIF

# Note, Selected Device Clear [SDC] is sent prior to each command. If [SDC]
# is not sent, it has been found that sometimes the generator does not update
# its settings even it accepts the command without error.

  1.005  RSLT         =
  1.006  RSLT         = Flatness Test (Peak to Peak)

# Set ask flags to not allow "List" and to "Repeat" to current step only
# in Post Test dialog.
  1.007  ASK-                                                        L
  1.008  ASK+                        P

  1.009  IF           ZCMP(@ModelNum, "8656B")
  1.010  MATH         MaxFreq = 990E+6
  1.011  ELSEIF       ZCMP(@ModelNum, "8656B")
  1.012  MATH         MaxFreq = 1040E+6
  1.013  ELSE         ; 8657B
  1.014  MATH         MaxFreq = 2060E+6
  1.015  ENDIF

# Set initial frequency to 0 Hz so first measurement occurs at 100 kHz.
# Initialize maximum and minimum power.
  1.016  MATH         Freq = 100E+3; MaxPwr = -100; MinPwr = +100

# Setup the N5531 before applying RF signal to prevent "Final IF Overload".
  1.017  N5531        ExtRefFreq = 10 MHz; TimebaseAccOff
  1.017  N5531        Power = 0 dBm; InputAttenuation = 20 dB
  1.017  N5531        +Freq = [V Freq] Hz; SensorModule = N5532A; Setup

  1.018  DO
  1.019  MATH         FreqMHz = Freq / 1E+6
  1.020  HEAD         OUTPUT LEVEL FLATNESS: [V FreqMHz] MHz
# Take a power reading at current UUT output frequency setting.
# Delay for 200 ms to allow 8657() to settle prior to N5531S taking reading.
  1.021  IEEE         [SDC]FR[V Freq]HZAP0DMR3[D200]
# Take a frequency measurement to set the frequency for the subsequent
# RF power measurement.
  1.022  N5531        ExtRefFreq = 10 MHz; TimebaseAccOff
  1.022  N5531        Power = 0 dBm; InputAttenuation = 20 dB
  1.022  N5531        +Freq = [V Freq] Hz; SensorModule = Same; Read
  1.023  N5531        ExtRefFreq = 10 MHz; TimebaseAccOff
  1.023  N5531        Freq = [MEM] Hz; SensorModule = Same
  1.023  N5531        +Power = 0.0 dBm; InputAttenuation = 20 dB

# Update maximum and minimum power values.
  1.024  IF           MEM > MaxPwr
  1.025  MATH         MaxPwr = MEM; FreqMaxPwr = FreqMHz
  1.026  ENDIF

  1.027  IF           MEM < MinPwr
  1.028  MATH         MinPwr = MEM; FreqMinPwr = FreqMHz
  1.029  ENDIF

  1.030  MATH         Flatness = FMT((MaxPwr - MinPwr), "%4.2f")

  1.031  IF           ZCMP(@ModelNum, "8657A")

  1.032  IF           Freq ==   1E+6
  1.033  EVAL   -e MEM <= 1.0 :[32]0.1 MHz to 1 MHz : [V Flatness] dB
  2.001  ELSEIF       Freq ==  10E+6
  2.002  EVAL   -e MEM <= 1.0 :[32]0.1 MHz to 10 MHz : [V Flatness] dB
  3.001  ELSEIF       Freq ==  100E+6
  3.002  EVAL   -e MEM <= 1.0 :[32]0.1 MHz to 100 MHz : [V Flatness] dB
  4.001  ELSEIF       Freq == 1000E+6
  4.002  EVAL   -e MEM <= 1.0 :[32]0.1 MHz to 1000 MHz : [V Flatness] dB
  5.001  ELSEIF       Freq == 1040E+6
  5.002  EVAL   -e MEM <= 1.0 :[32]0.1 MHz to 1040 MHz : [V Flatness] dB
  6.001  ENDIF

  6.002  ELSE         ; 8657B

  6.003  IF           Freq ==   1E+6
  6.004  EVAL   -e MEM <= 1.0 :[32]0.1 MHz to 1 MHz : [V Flatness] dB
  7.001  ELSEIF       Freq ==  10E+6
  7.002  EVAL   -e MEM <= 1.0 :[32]0.1 MHz to 10 MHz : [V Flatness] dB
  8.001  ELSEIF       Freq ==  100E+6
  8.002  EVAL   -e MEM <= 1.0 :[32]0.1 MHz to 100 MHz : [V Flatness] dB
  9.001  ELSEIF       Freq == 2000E+6
  9.002  EVAL   -e MEM <= 1.0 :[32]0.1 MHz to 2000 MHz : [V Flatness] dB
 10.001  ELSEIF       Freq == 2060E+6
 10.002  EVAL   -e MEM <= 1.0 :[32]0.1 MHz to 2060 MHz : [V Flatness] dB
 11.001  ENDIF

 11.002  ENDIF

# Determine frequency increment and formatting.
 11.003  IF           Freq < 1E+6
 11.004  MATH         FreqIncr = 100E+3; FreqFmt = "%3.1f"
 11.005  ELSEIF       Freq < 10E+6
 11.006  MATH         FreqIncr =   1E+6; FreqFmt = "%3.0f"
 11.007  ELSEIF       Freq < 100E+6
 11.008  MATH         FreqIncr =  10E+6; FreqFmt = "%4.0f"
 11.009  ELSEIF       Freq < 2000E+6
 11.010  MATH         FreqIncr = 100E+6; FreqFmt = "%5.0f"
 11.011  ELSE
 11.012  MATH         FreqIncr =  60E+6; FreqFmt = "%5.0f"
 11.013  ENDIF

 11.014  MATH         Freq = Freq + FreqIncr; F = Freq / 1E+6
 11.015  UNTIL        Freq >= MaxFreq

 11.016  MATH         Max = FMT(MaxPwr, FreqFmt); Min = FMT(MinPwr, FreqFmt)
 11.017  RSLT         = +Peak Level: [V Max] dBm @ [V FreqMaxPwr] MHz
 11.018  RSLT         = -Peak Level: [V Min] dBm @ [V FreqMinPwr] MHz

# Reset ASK+ and ASK- to initial settings when exiting subprocedure.
 11.019  ASK+                                                        L
 11.020  ASK-                        P
 11.021  IEEE         [SDC]R2
 11.022  N5531        Reset
 11.023  END
