﻿Copyright (c) (2015) Fluke Corporation                      MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub HP 8657x (1 yr) Harmonic Test IEEE /PSA
INSTRUMENT:            Sub HP 8657x (1 yr) Spur Test IEEE /PSA
INSTRUMENT:            Sub HP 8657x (1 yr) Phase Noise Test IEEE /PSA
DATE:                  2016-06-28 11:17:56
AUTHOR:                Fluke
REVISION:              $Revision: 16396 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       7
NUMBER OF LINES:       155
CONFIGURATION:         Agilent PSA (6.7 GHz,226)
=============================================================================
#
#  Procedure Author:
#        DFM, DAC
#
#  Model(s) Covered:
#        8657A, 8657B, 8657D
#
#  Additional Equipment Required:
#        None
#
#  Note:
#  Test points based on those performed by Agilent TMO Support Operations.
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

# Note, Selected Device Clear [SDC] is sent prior to each command. If [SDC]
# is not sent, it has been found that sometimes the generator does not update
# its settings even it accepts the command without error.

# Store PSA "System Instrument" name for MATH FSC functions.
  1.001  MATH         PSA = "Agilent PSA"

  1.002  JMPL         HARMONIC                     PSUBI("Harmonic")
  1.003  JMPL         SPUR                         PSUBI("Spur")
  1.004  JMPL         PHASE_NOISE                  PSUBI("Phase")
  1.005  DISP         Subprocedure not found!
  1.006  END

  1.007  EVAL   Increment step number

# =====  Sub HP 8657x (1 yr) Harmonic Test IEEE /PSA  =======================

  2.001  LABEL        HARMONIC
  2.002  TSET         TDESC = [V @FreqMHz] MHz, [V @HarmNum]
  2.003  TARGET       -p
  2.004  PSA          ExtRefFreq = 10 MHz; TimebaseAccOff
  2.004  PSA          RBW = 10 kHz; VBW = 30 kHz; RefLevel = 10 dBm
  2.004  PSA          CenterFreq = [V @FreqMHz] MHz; FreqSpan = 500 kHz
  2.004  PSA          PeakSearch; MarkerToCenterFreq
  2.004  PSA          +Ampl = [V @Pwr] dBm; InputAttenuation = 30 dB; Setup
  2.005  IEEE         [SDC]FR[V @FreqMHz]MZAP[V @Pwr]DMR3
  2.006  TARGET       -m
# Measure amplitude of fundamental.
  2.007  PSA          ExtRefFreq = 10 MHz; TimebaseAccOff
  2.007  PSA          RBW = 10 kHz; VBW = 30 kHz; RefLevel = 10 dBm
  2.007  PSA          CenterFreq = [V @FreqMHz] MHz; FreqSpan = 500 kHz
  2.007  PSA          PeakSearch; MarkerToCenterFreq
  2.007  PSA          +Ampl = [V @Pwr] dBm; InputAttenuation = 30 dB
# Retrieve uncertainty for above measurement and normalize.
  2.008  MATH         @Ampl = MEM; @Freq = @FreqMHz * 1E+6
  2.009  CALL         Sub Agilent PSA Get Amplitude Accuracy IEEE
  2.010  MATH         L[1] = @PSAAmplAcc / CONF("Agilent PSA")
  2.011  MATH         RefLvl = MEM
# Measure amplitude of harmonic.
  2.012  PSA          ExtRefFreq = 10 MHz; TimebaseAccOff
  2.012  PSA          RBW = 10 kHz; VBW = 30 kHz; RefLevel = 10 dBm
  2.012  PSA          CenterFreq = [V @HarmMHz] MHz; FreqSpan = 500 kHz
  2.012  PSA          PeakSearch; MarkerToCenterFreq
  2.012  PSA          +Ampl = -23 dBm; InputAttenuation = 30 dB
  2.013  MATH         @Ampl = MEM; @Freq = @HarmMHz * 1E+6
  2.014  CALL         Sub Agilent PSA Get Amplitude Accuracy IEEE
  2.015  MATH         L[2] = @PSAAmplAcc / CONF("Agilent PSA")
# RSS all individual measurement uncertainty components and expand.
  2.016  MATH         L[3] = RSS2(L[1], L[2]) * 2
# Compute harmonic level (dBc).
  2.017  MATH         MEM = @Ampl - RefLvl
  2.018  ACC    -30   dBc            L3U
  2.019  MATH         MEM1 = @dBc
  2.020  MEMC         dBc            -0.0U +100.0U

  3.001  END

  3.002  EVAL   Increment step number

# =====  Sub HP 8657x (1 yr) Spur Test IEEE /PSA  ===========================

  4.001  LABEL        SPUR
  4.002  TSET         TDESC = [V @FreqMHz] MHz, [V @SpurMHz] MHz
  4.003  TARGET       -p
# Set UUT output parameters.
  4.004  IEEE         [SDC]FR[V @FreqMHz]MZAP[V @Pwr]DMR3
  4.005  TARGET       -m
# Measure amplitude of fundamental.
  4.006  PSA          ExtRefFreq = 10 MHz; TimebaseAccOff
  4.006  PSA          RBW = 1 kHz; VBW = 1 kHz; RefLevel = 10 dBm
  4.006  PSA          CenterFreq = [V @FreqMHz] MHz; FreqSpan = 500 kHz
  4.006  PSA          PeakSearch; MarkerToCenterFreq
  4.006  PSA          +Ampl = [V @Pwr] dBm; InputAttenuation = 30 dB
# Retrieve uncertainty for above measurement and normalize.
  4.007  MATH         @Ampl = MEM; @Freq = @FreqMHz * 1E+6
  4.008  CALL         Sub Agilent PSA Get Amplitude Accuracy IEEE
  4.009  MATH         L[1] = @PSAAmplAcc / CONF("Agilent PSA")
  4.010  MATH         RefLvl = MEM
  4.011  PSA          ExtRefFreq = 10 MHz; TimebaseAccOff
  4.011  PSA          RBW = 300 Hz; VBW = 300 Hz; RefLevel = 10 dBm
  4.011  PSA          StartFreq = [V @StartMHz] MHz
  4.011  PSA          StopFreq = [V @StopMHz] MHz
  4.011  PSA          PeakSearch; MarkerToCenterFreq
  4.011  PSA          +Ampl = -53 dBm; InputAttenuation = 30 dB
  4.012  MATH         @Ampl = MEM; @Freq = @SpurMHz * 1E+6
  4.013  CALL         Sub Agilent PSA Get Amplitude Accuracy IEEE
  4.014  MATH         L[2] = @PSAAmplAcc / CONF("Agilent PSA")
# RSS all individual measurement uncertainty components and expand.
  4.015  MATH         L[3] = RSS2(L[1], L[2]) * 2
  4.016  MATH         MEM = @Ampl - RefLvl
  4.017  ACC          dBc            L3U
  4.018  MATH         MEM1 = @dBc
  4.019  MEMC         dBc            -0.0U +75.0U

  5.001  END

  5.002  EVAL   Increment Test Number

# =====  Sub HP 8657x (1 yr) Phase Noise Test IEEE /PSA  ====================

  6.001  LABEL        PHASE_NOISE
  6.002  TSET         TDESC = [V @FreqMHz] MHz
  6.003  TARGET       -p
  6.004  IEEE         [SDC]FR[V @FreqMHz]MZAP0DMR3
  6.005  TARGET       -m
  6.006  PSA          Mode = PhaseNoiseLogPlot
  6.006  PSA          ExtRefFreq = 10 MHz; TimebaseAccOff
  6.006  PSA          CenterFreq = [V @FreqMHz] MHz; FreqSpan = 50 kHz
  6.006  PSA          FreqOffset = 20 kHz; RFCoupling = DC
  6.006  PSA          +PhaseNoise = [V @dBc_Hz] dBc/Hz
  6.007  MATH         MEM1 = @dBc_Hz
  6.008  MEMC         dBc/Hz         -0U +1000%

  7.001  END
