﻿© 2006 Fluke Corporation, All rights reserved               MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Agilent PSA Get Amplitude Accuracy IEEE
DATE:                  2006-11-29 11:16:22
AUTHOR:                Fluke
REVISION:              $Revision: 2619 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       1
NUMBER OF LINES:       97
=============================================================================
#
#  Procedure Author:
#        DAC
#
#  Compatibility:
#        MET/CAL 7.2 or later
#
#  Subprocedures:
#        Sub Agilent PSA Get Attenuation IEEE
#        Sub Agilent PSA Get Model Number IEEE
#        Sub Agilent PSA Get Preamplifier IEEE
#
#  Required Files:
#        psa.acc
#
#  Additional Equipment Required:
#        None
#
#  The procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to
#  this procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright for this procedure is owned by Fluke Corporation.
#
#  Usage:
#
#  The calling procedures must set the following global variables values:
#
#    @Ampl = <amplitude in dBm>
#    @Freq = <frequency in hertz (base units)>
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  CALL         Sub Agilent PSA Get Attenuation IEEE
  1.002  CALL         Sub Agilent PSA Get Preamplifier IEEE

# Determine mode strings for absolute amplitude accuracy and
# frequency response lookup.
  1.003  IF           ZCMPI(@PSAPreamp, "110")
  1.004  MATH         AmplMode = "Ampl 110"
  1.005  CALL         Sub Agilent PSA Get Model Number IEEE

  1.006  IF           ZCMPI(@PSAModelNum, "E4440A")
  1.007  MATH         FreqRespMode = "FreqResp 110 E4443A/45A/40A"
  1.008  ELSEIF       ZCMPI(@PSAModelNum, "E4443A")
  1.009  MATH         FreqRespMode = "FreqResp 110 E4443A/45A/40A"
  1.010  ELSEIF       ZCMPI(@PSAModelNum, "E4445A")
  1.011  MATH         FreqRespMode = "FreqResp 110 E4443A/45A/40A"
  1.012  ELSEIF       ZCMPI(@PSAModelNum, "E4446A")
  1.013  MATH         FreqRespMode = "FreqResp 110 E4447A/46A/48A"
  1.014  ELSEIF       ZCMPI(@PSAModelNum, "E4447A")
  1.015  MATH         FreqRespMode = "FreqResp 110 E4447A/46A/48A"
  1.016  ELSEIF       ZCMPI(@PSAModelNum, "E4448A")
  1.017  MATH         FreqRespMode = "FreqResp 110 E4447A/46A/48A"
  1.018  ENDIF

  1.019  ELSEIF       ZCMPI(@PSAPreamp, "1DS")
  1.020  MATH         AmplMode = "Ampl 1DS"; FreqRespMode = "FreqResp 1DS"

  1.021  ELSE
  1.022  MATH         AmplMode = "Ampl"; FreqRespMode = "FreqResp"
  1.023  ENDIF

  1.024  MATH         Device   = "Agilent PSA"

  1.025  IF           ZCMPI(@PSAPreamp, "110") || ZCMPI(@PSAPreamp, "1DS")
  1.026  MATH         AmplAcc = ACCV2(Device, AmplMode, @Ampl, @Freq)
  1.027  ELSE
# With preamp off, absolute accuracy is only spec'd at 50 MHz.
  1.028  MATH         AmplAcc = ACCV2(Device, AmplMode, @Ampl, 50.0E+6)
  1.029  ENDIF

  1.030  MATH         FreqResp = ACCV2(Device, FreqRespMode, @PSAAtten, @Freq)
  1.031  MATH         @PSAAmplAcc = AmplAcc + FreqResp

  1.032  END
