﻿Copyright (c) (2015) Fluke Corporation                      MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Fluke 80 Series V (1 yr) Freq Sensitivity VER /5502
INSTRUMENT:            Sub Fluke 80 Series V (1 yr) Trigger Level VER /5502
INSTRUMENT:            Sub Fluke 80 Series V (1 yr) Duty Cycle VER /5502
INSTRUMENT:            Sub Fluke 80 Series V (1 yr) Conductance VER /5502
INSTRUMENT:            Sub Fluke 80 Series V (1 yr) Diode Test VER /5502
INSTRUMENT:            Sub Fluke 80 Series V (1 yr) Capacitance VER /5502
DATE:                  2015-04-14 13:23:11
AUTHOR:                Fluke Calibration
REVISION:              $Revision: 10765 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       18
NUMBER OF LINES:       279
CONFIGURATION:         Fluke 5502E
=============================================================================
#
#  Procedure Author(s):
#        DFM, VY, GMO, PS, ND, DAC
#
#  Model(s) Covered:
#        Fluke 80 Series V
#
#  Source(s):
#        Fluke 80 Series V Calibration Manual *
#        PN 2102915, September 2004, Rev.1, 2/05
#
#        Fluke 80 Series V Calibration Manual Supplement
#        Supplement Issue: 6, Issue Date: 8/12
#
#        * The tolerances used by this procedure were taken from the published
#          specifications table.
#
#  Compatibility:
#        MET/CAL version 8.1.4 or later
#
#  Additional Equipment and/or Accessories Required:
#        None
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  JMPL         FREQUENCY_SENSITIVITY        PSUBI("Freq Sensitivity")
  1.002  JMPL         TRIGGER_LEVEL                PSUBI("Trigger Level")
  1.003  JMPL         DUTY_CYCLE                   PSUBI("Duty Cycle")
  1.004  JMPL         CONDUCTANCE                  PSUBI("Conductance")
  1.005  JMPL         DIODE_TEST                   PSUBI("Diode Test")
  1.006  JMPL         CAPACITANCE                  PSUBI("Capacitance")
  1.007  DISP         Subprocedure not found!
  1.008  END

  1.009  EVAL   Increment Test Number

# =====  Sub Fluke 80 Series V (1 yr) Freq Sensitivity VER /5502  ===========

  2.001  LABEL        FREQUENCY_SENSITIVITY
  2.002  RSLT         =
  2.003  HEAD         {FREQUENCY SENSITIVITY}
  2.004  RSLT         =
  2.005  HEAD         -2{6 V AC Range}
  2.006  TARGET       -p
  2.007  DISP         Press "RANGE" button to lock the 6 V range, if
  2.007  DISP         necessary.
  2.008  5502E        +Frequency = 99.95 kHz; Voltage = 0.7 V
  2.009  TARGET       -m
  2.010  MEMI         Enter UUT reading in kilohertz:
  2.011  MEMCX        99.95kH        0.01% 0.01U   0.7V

  3.001  RSLT         =
  3.002  HEAD         -2{60 V AC Range}
  3.003  TARGET       -p
  3.004  DISP         Press "RANGE" button to lock the 60 V range, if
  3.004  DISP         necessary.
  3.005  5502E        +Frequency = 99.95 kHz; Voltage = 7 V
  3.006  TARGET       -m
  3.007  MEMI         Enter UUT reading in kilohertz:
  3.008  MEMCX        99.95kHz       0.01% 0.01U   7V

  4.001  HEAD         -2
  4.002  5502E        Standby
  4.003  HEAD
  4.004  END

  4.005  EVAL   Increment Test Number

# =====  Sub Fluke 80 Series V (1 yr) Trigger Level VER /5502  ===============

  5.001  LABEL        TRIGGER_LEVEL
  5.002  RSLT         =
  5.003  HEAD         {TRIGGER LEVEL}
  5.004  RSLT         =
  5.005  HEAD         -2{6 V DC Range}
  5.006  TARGET       -p
  5.007  DISP         Press "Hz %" button to select Frequency, if necessary.
  5.008  5502E        Waveform = Square; DutyCycle = 50%
  5.008  5502E        +Frequency = 1000.0 Hz; Voltage = 3.4 V
  5.009  TARGET       -m
  5.010  MEMI         Enter UUT reading in hertz:
  5.011  MEMCX        1000.0H        0.01% 0.1U    3.4V

  6.001  HEAD         -2
  6.002  5502E        Standby
  6.003  HEAD
  6.004  END

  6.005  EVAL   Increment Test Number

# =====  Sub Fluke 80 Series V (1 yr) Duty Cycle VER /5502  ==================

  7.001  LABEL        DUTY_CYCLE
  7.002  RSLT         =
  7.003  HEAD         {DUTY CYCLE}
  7.004  RSLT         =
  7.005  HEAD         -2{6 V DC Range}
# Retrieve Calibrator duty cycle accuracy (in sec.) relative to period
# of signal.
  7.006  MATH         L[1] = ACCV2(@CalDev, "Duty", 1E-3, 50)
# Convert accuracy in seconds to a percent of the nominal period.
  7.007  MATH         L[2] = (L[1] / 1E-3) * 100
  7.008  TARGET       -p
  7.009  DISP         Press "Hz %" button to select Duty Cycle, if necessary.
  7.010  5502E        Waveform = Square; Volt = 5Vpp; Offset = 2.5V
  7.010  5502E        +DutyCycle = 50.0 %; Frequency = 1 kHz
  7.011  ACC          50.0pct        L2%
  7.012  TARGET       -m
  7.013  MEMI         Enter UUT duty cycle reading in percent:
  7.014  MEMCX        50.0pct        0.3U          1kHz

  8.001  HEAD         -2
  8.002  5502E        Standby
  8.003  HEAD
  8.004  END

  8.005  EVAL   Increment Test Number

# =====  Sub Fluke 80 Series V (1 yr) Conductance VER /5502  =================

  9.001  LABEL        CONDUCTANCE
  9.002  RSLT         =
  9.003  HEAD         {CONDUCTANCE}
  9.004  RSLT         =
  9.005  HEAD         -2{60 nS Range}

  9.006  IF           ZCMPI(@ModelNum, "87 V/AN")
  9.007  MATH         L[1] = 0.10
  9.008  ELSE
  9.009  MATH         L[1] = 0.30
  9.010  ENDIF

  9.011  TARGET       -p
  9.012  DISP         Press "RANGE" button to lock 60 nS range, if necessary.
  9.013  TARGET       -m
  9.014  MEMI         Enter UUT reading in nanosiemens:
  9.015  MEMCX  60    0.00nS         1% L1U

 10.001  5502E        +Conductance = 10.00 nS
 10.002  TARGET       -m
 10.003  MEMI         Enter UUT reading in nanosiemens:
 10.004  MEMCX  60    10.00nS        1% L1U

 11.001  HEAD         -2
 11.002  5502E        Standby
 11.003  HEAD
 11.004  END

 11.005  EVAL   Increment Test Number

# =====  Sub Fluke 80 Series V (1 yr) Diode Test VER /5502  ==================

 12.001  LABEL        DIODE_TEST
 12.002  RSLT         =
 12.003  HEAD         {DIODE TEST}
 12.004  TARGET       -p
 12.005  DISP         Rotate UUT function switch to Diode Test.
 12.006  5502E        +Voltage = 3.000 V
 12.007  TARGET       -m
 12.008  MEMI         Enter UUT reading in volts DC:
 12.009  MEMCX        3.000V         2% 0.001U

 13.001  5502E        Standby
 13.002  HEAD
 13.003  END

 13.004  EVAL   Increment Test Number

# =====  Sub Fluke 80 Series V (1 yr) Capacitance VER /5502  =================

 14.001  LABEL        CAPACITANCE
 14.002  RSLT         =
 14.003  HEAD         {CAPACITANCE}
 14.004  RSLT         =
 14.005  HEAD         -2{10 nF Range}
 14.006  MATH         FirstTime = 1
 14.007  TARGET       -p
 14.008  DISP         Rotate UUT function switch to Ω.
 14.008  DISP
 14.008  DISP         Press yellow button to select Capacitance, if necessary.

 14.009  IF           ZCMPI(@ModelNum, "87 V Ex")

 14.010  IF           FirstTime
 14.011  MATH         FirstTime = 0
 14.012  ELSE
 14.013  DISP         Press "REL Δ" button to de-select Relative mode
 14.013  DISP         (Δ symbol does not appear on leftside of display).
 14.014  ENDIF

 14.015  PIC          8x_cap_2w.png
 14.016  DISP         Press "REL Δ" button to select Relative mode
 14.016  DISP         (Δ symbol appears on leftside of display).
 14.017  PIC          55xx_8x_2w.png
 14.018  5502E        +Capacitance = 4.00 nF
 14.019  TARGET       -m
 14.020  MEMI         Enter UUT reading in nanofarads:
 14.021  MEMCX  10    4.00nF         1% 0.02U
#! WARNING: Test Tol 6e-011, Sys Tol 2e-011 V, TUR 3.0000 (< 4.00).

 15.001  DISP         Press "REL Δ" button to de-select Relative mode
 15.001  DISP         (Δ symbol is removed from leftside of display.

 15.002  ELSE         ; 83 V, 87 V, 87 V C, 87 V Si, 87 V/AN, 88 V
 15.003  DISP         Nothing should be connected to the UUT at this time.
 15.004  TARGET       -m
 15.005  MEMI         Enter UUT reading in nanofarads:
 15.006  MEMCX  10    0.26nF         0.05U
 16.001  ENDIF

 16.002  RSLT         =
 16.003  HEAD         -2{100 nF Range}
 16.004  MATH         FirstTime = 1
 16.005  TARGET       -p
 16.006  DISP         Press "RANGE" button to lock the 100 nF range, if
 16.006  DISP         necessary.

 16.007  IF           FirstTime
 16.008  MATH         FirstTime = 0
 16.009  ELSE
 16.010  DISP         Press "REL Δ" button to de-select Relative mode
 16.010  DISP         (Δ symbol is removed from leftside of display.
 16.011  ENDIF

 16.012  PIC          8x_cap_2w.png
 16.013  DISP         Press "REL Δ" button to select Relative mode
 16.013  DISP         (Δ symbol appears on leftside of display).
 16.014  PIC          55xx_8x_2w.png
 16.015  5502E        +Capacitance = 5.0 nF
 16.016  TARGET       -m
 16.017  MEMI         Enter UUT reading in nanofarads:
 16.018  MEMCX  100   5.0nF          1% 0.2U

 17.001  DISP         Press "REL Δ" button to de-select Relative mode
 17.001  DISP         (Δ symbol is removed from leftside of display.

 17.002  RSLT         =
 17.003  HEAD         -2{100 µF Range}
 17.004  TARGET       -p
 17.005  DISP         Press "RANGE" button to lock the 100 µF range, if
 17.005  DISP         necessary.
 17.006  5502E        +Capacitance = 9.5 uF
 17.007  TARGET       -m
 17.008  MEMI         Enter UUT reading in microfarads:
 17.009  MEMCX  100   9.5uF          1% 0.2U

 18.001  HEAD         -2
 18.002  5502E        Standby
 18.003  HEAD
 18.004  END
