﻿Copyright (c) (2015) Fluke Corporation                      MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Fluke 80 Series V Basic Operability Tests
INSTRUMENT:            Sub Fluke 80 Series V Backlight Test
DATE:                  2015-04-14 12:26:10
AUTHOR:                Fluke Calibration
REVISION:              $Revision: 10803 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       9
NUMBER OF LINES:       166
=============================================================================
#
#  Procedure Author(s):
#        DFM, VY, PS, ND, DAC
#
#  Model(s) Covered:
#         Fluke 83 V, 87 V, 87 V/AN, 87 V EX, 88 V
#
#  Source(s):
#        Fluke 80 Series V Calibration Manual *
#        PN 2102915, September 2004, Rev.1, 2/05
#
#        Fluke 80 Series V Calibration Manual Supplement
#        Supplement Issue: 6, Issue Date: 8/12
#
#        * The tolerances used by this procedure were taken from the published
#          specifications table.
#
#  Compatibility:
#        MET/CAL version 8.1.4 or later
#
#  Additional Equipment and/or Accessories Required:
#		 None
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  JMPL         BASIC_OPERABILITY            PSUBI("Basic Operability")
  1.002  JMPL         BACKLIGHT_TEST               PSUBI("Backlight")
  1.003  DISP         Subprocedure not found!
  1.004  END

  1.005  EVAL   Increment Test Number

# =====  Sub Fluke 80 Series V Basic Operability Tests  =====================

  2.001  LABEL        BASIC_OPERABILITY
  2.002  MATH         @Abort = 0
  2.003  HEAD         BASIC OPERABILITY
  2.004  RSLT         =
  2.005  HEAD         -2 A (AMPS) FUSE TEST
  2.006  TARGET
  2.007  DISP         Turn UUT rotary switch to Ω.
  2.007  DISP
  2.007  DISP         Connect a test probe (plug end) to the UUT V-Ω-Diode
  2.007  DISP         input. Using the probe tip, touch the upper half
  2.007  DISP         (nearest the LCD) of the A input contact.
  2.007  DISP
  2.007  DISP         [32]                       NOTE
  2.007  DISP         Substituting a test lead for the test probe during the
  2.007  DISP         following tests will yield unpredictable/invalid test
  2.007  DISP         results because the input terminals contain split
  2.007  DISP         contacts.
  2.008  OPBR         -z Is UUT beeping and alternately displaying "LEAd" and
  2.008  OPBR         a resistance reading?
  2.009  EVAL   -e MEM1 : F2 A INPUT FUSE

  3.001  RSLT         =
  3.002  HEAD         -2 mA µA FUSE TEST
  3.003  TARGET
  3.004  DISP         -z Leaving the UUT rotary switch set to Ω, move the
  3.004  DISP         test probe (plug end) from the A input to the mA µA
  3.004  DISP         input.
  3.005  OPBR         -z Is UUT beeping and alternately displaying "LEAd" and
  3.005  OPBR         a resistance reading?
  3.006  EVAL   -e MEM1 : F1 mA µA INPUT FUSE

  4.001  IF           MEM1
  4.002  RSLT         =
  4.003  TARGET
  4.004  MEMI         Enter UUT reading in kilohms:
  4.005  EVAL   -e (MEM >= 0.995) || (MEM <= 1.005) : 1 kΩ INPUT RESISTOR

  5.001  IF           FAIL()
  5.002  DISP         -z The UUT input resistor is not 1.000 ±0.005 kΩ.
  5.002  DISP
  5.002  DISP         This may have an effect on the measuring ability of the
  5.003  OPBR         UUT.
  5.003  OPBR
  5.003  OPBR         Do you wish to continue with the verification?
  5.004  MATH         @Abort = NOT(MEM1)

  5.005  IF           @Abort
  5.006  END
  5.007  ENDIF

  5.008  ENDIF        ; FAIL()

  5.009  ENDIF        ; MEM1

  5.010  DISP         Remove the test probe from the UUT mA µA input.
  5.010  DISP
  5.011  DISP         Turn the UUT rotary function switch to OFF.

  5.012  RSLT         =
  5.013  HEAD         DISPLAY TEST
  5.014  TARGET
  5.015  MESS         While pressing and continuing to hold the "AutoHOLD"
  5.015  MESS         button, rotate function switch to V AC to enter
  5.015  MESS         Display Test.
  5.015  MESS
  5.016  EVAL   -s "DISPLAY TEST" : Are all display segments illuminated?

  6.001  MESS
  6.002  DISP         Release the "AutoHOLD" button.

  6.003  RSLT         =
  6.004  HEAD         PUSHBUTTON SWITCH TEST
  6.005  TARGET
  6.006  MESS         Press each keypad push button, verifying that the UUT
  6.006  MESS         responds with a 'beep' for each button press.
  6.006  MESS
  6.007  EVAL   -s "PUSHBUTTON SWITCH TEST" : Do all buttons beep?

  7.001  HEAD
  7.002  MESS
  7.003  DISP         Rotate UUT function switch to OFF.
  7.004  END

  7.005  EVAL   Increment Test Number

# =====  Sub Fluke 80 Series V Backlight Test  ===============================

  8.001  LABEL        BACKLIGHT_TEST

  8.002  RSLT         =
  8.003  HEAD         BACKLIGHT TEST
  8.004  TARGET
  8.005  OPBR         -z Press the backlight button once.
  8.005  OPBR
  8.005  OPBR         Does the backlight illuminate?
  8.006  MATH         L[1] = MEM1
  8.007  OPBR         -z Press the backlight button once again.
  8.007  OPBR
  8.007  OPBR         Does the backlight illumination intensify?
  8.008  MATH         L[2] = MEM1
  8.009  OPBR         -z Press the backlight button once more.
  8.009  OPBR
  8.009  OPBR         Does the backlight extinguish?
  8.010  MATH         L[3] = MEM1
  8.011  EVAL   -e (L[1] && L[2] && L[3]) : BACKLIGHT TEST

  9.001  HEAD
  9.002  END
