﻿Copyright (c) (2015) Fluke Corporation                      MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Fluke 87,88 V Peak Min/Max VER /5502
INSTRUMENT:            Sub Fluke 87,88 V Temperature VER /5502
DATE:                  2015-04-14 15:18:58
AUTHOR:                Fluke Calibration
REVISION:              $Revision: 10812 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       5
NUMBER OF LINES:       136
CONFIGURATION:         Fluke 5502E
=============================================================================
#
#  Procedure Author(s):
#        DFM, VY, GMO, PS, ND, DAC
#
#  Model(s) Covered:
#         Fluke 87 V, 87 V/AN, 87 V EX, 88 V
#
#  Source(s):
#        Fluke 80 Series V Calibration Manual
#        PN 2102915, September 2004, Rev.1, 2/05
#
#        Fluke 80 Series V Calibration Manual Supplement
#        Supplement Issue: 6, Issue Date: 8/12
#
#        * The tolerances used by this procedure were taken from the published
#          specifications table.
#
#  Compatibility:
#        MET/CAL version 8.1.4 or later
#
#  Additional Equipment and/or Accessories Required:
#		 None
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  JMPL         PEAK                         PSUBI("Peak")
  1.002  JMPL         TEMPERATURE                  PSUBI("Temperature")
  1.003  DISP         Subprocedure not found!
  1.004  END

# =====  Sub Fluke 87,88 V Peak Min/Max VER /5502  =======================

# The nominal values for the PEAK MIN MAX test, and the PEAK MIN MAX MIN
# test were changed per a communication from the Service Engineer to eliminate
# low TSR. The tolerance limit for the PEAK MIN/MAX is set using the TOL
# FSC and is set in the main procedure prior to calling this sub-procedure.

  1.005  LABEL        PEAK
  1.006  RSLT         =
  1.007  HEAD         {PEAK MIN/MAX: 6 Vpp, 2 kHz Square Wave, DC offset 1 V}
  1.008  TARGET       -p

  1.009  LABEL        PEAK_MAX
  1.010  TSET         TDESC = +4.000 Vp (Max)
  1.011  DISP         Press "RANGE" button to lock the 6 V range, if
  1.011  DISP         necessary.

# Apply signal prior to engaging Min/Max mode to avoid reading overshoot!
  1.012  5502E        Waveform = Square; Offset = 1 V
  1.012  5502E        +Voltage = 6 Vpp; Frequency = 2 kHz
  1.013  MATH         L[1] = REFACC() / MEM1 * 100

  1.014  HEAD         -2 Max
  1.015  DISP         Press "MIN MAX" button to select Min/Max, if necesary.
  1.015  DISP
  1.015  DISP         Press "PEAK MIN MAX" (beeper) button until the PEAK
  1.015  DISP         display annunciator appears.  This indicates that the
  1.015  DISP         PEAK MIN MAX 250 µs response time mode is selected.
  1.016  ACC          4.000Vp        L1%
  1.017  TARGET       -m
  1.018  MEMI         Enter UUT MAX reading in volts:
  1.019  MEMCX        4.000Vp        0.05% 0.101U

  2.001  HEAD         -2 Min
  2.002  JMPL         PEAK_MIN

  2.003  TARGET       -p
  2.004  JMPL         PEAK_MAX

  2.005  LABEL        PEAK_MIN
  2.006  TSET         TDESC = -2.000 Vp (Min)
  2.007  DISP         Press "MIN MAX" button to select PEAK MIN MAX MIN.
  2.008  ACC          -2.000Vp       L1%
  2.009  TARGET       -m
  2.010  MEMI         Enter UUT MIN reading in volts:
  2.011  MEMCX        -2.000Vp       0.05% 0.101U

  3.001  HEAD         -2
  3.002  5502E        Standby
  3.003  DISP         Press "MIN MAX" for 2 s to turn off Min/Max.
  3.004  HEAD
  3.005  END

# =====  Sub Fluke 87,88 V Temperature VER /5502  ========================

  3.006  LABEL        TEMPERATURE
  3.007  RSLT         =
  3.008  HEAD         {TEMPERATURE}
  3.009  TARGET       -p
  3.010  DISP         Rotate UUT function switch to mV DC.
  3.010  DISP
  3.010  DISP         Press yellow button to select Temperature, if necessary.
  3.010  DISP
  3.010  DISP         Press "RANGE" button to select °C, if necessary.
  3.011  PIC          55xx_8x_tc.png
  3.012  5502E        +Temperature = 0.0 degC; TC_Type = K
  3.013  WAIT         -t 3:00 Thermocouple thermal emfs dissipating...
  3.014  5502E        +Temperature = 0.0 degC; TC_Type = K
  3.015  TARGET       -m
  3.016  MEMI         Enter UUT reading in degrees Celsius:
  3.017  MEMCX  100   0.0degC        1% 1.0U

  4.001  5502E        +Temperature = 100.0 degC; TC_Type = K
  4.002  TARGET       -m
  4.003  MEMI         Enter UUT reading in degrees Celsius:
  4.004  MEMCX  100   100.0degC      1% 1.0U

  5.001  HEAD         -2
  5.002  5502E        Standby
  5.003  HEAD
  5.004  END
