﻿Copyright (c) (2015) Fluke Corporation                      MET/CAL Procedure
=============================================================================
INSTRUMENT:            Sub Fluke 87 V (1 yr) AC Amps VER /5502
INSTRUMENT:            Sub Fluke 87 V (1 yr) DC Amps VER /5502
INSTRUMENT:            Sub Fluke 87 V (1 yr) AC Milliamps VER /5502
INSTRUMENT:            Sub Fluke 87 V (1 yr) DC Milliamps VER /5502
INSTRUMENT:            Sub Fluke 87 V (1 yr) AC Microamps VER /5502
INSTRUMENT:            Sub Fluke 87 V (1 yr) DC Microamps VER /5502
DATE:                  2015-04-16 14:41:42
AUTHOR:                Fluke Calibration
REVISION:              $Revision: 10861 $
ADJUSTMENT THRESHOLD:  70%
NUMBER OF TESTS:       18
NUMBER OF LINES:       250
CONFIGURATION:         Fluke 5502E
=============================================================================
#
#  Procedure Author(s):
#        DFM, VY, GMO, PS, ND
#
#  This procedure contains tests whose Test Specification Ratios are less
#  than 4:1, based on 5502E (1 year) specifications.
#
# 		 FREQUENCY
#          Fluke 87 V, 87 V/AN, 87 V EX Only
# 			   - 199.5 kHz;TUR 3.9980
#
#  Model(s) Covered:
#        Fluke 87 V, 87 V/AN, 87 V EX
#
#  Source(s):
#        Fluke 80 Series V Calibration Manual *
#        PN 2102915, September 2004, Rev.1, 2/05
#
#        Fluke 80 Series V Calibration Manual Supplement
#        Supplement Issue: 6, Issue Date: 8/12
#
#        * The tolerances used by this procedure were taken from the published
#          specifications table.
#
#  Compatibility:
#        MET/CAL version 8.1.4 or later
#
#  Additional Equipment and/or Accessories Required:
#        None
#
#  This procedure is intended for use with MET/CAL® calibration software;
#  the terms and conditions set forth in your MET/CAL license apply to this
#  procedure.
#
#  Due to Fluke's policy of continuously updating our products, this procedure
#  may contain minor differences in methods used and/or specifications to
#  those found in the manual or other documentation. While every effort has
#  been made to ensure that this procedure is accurate, Fluke cannot be held
#  responsible for the consequences of error or omissions found within this
#  procedure.
#
#  The copyright in this procedure is owned by Fluke Corporation.
#
 STEP    FSC    RANGE NOMINAL        TOLERANCE     MOD1        MOD2  3  4 CON

  1.001  JMPL         AC_AMPS                      PSUBI("AC Amps")
  1.002  JMPL         DC_AMPS                      PSUBI("DC Amps")
  1.003  JMPL         AC_MILLIAMPS                 PSUBI("AC Milliamps")
  1.004  JMPL         DC_MILLIAMPS                 PSUBI("DC Milliamps")
  1.005  JMPL         AC_MICROAMPS                 PSUBI("AC Microamps")
  1.006  JMPL         DC_MICROAMPS                 PSUBI("DC Microamps")
  1.007  DISP         Subprocedure not found!
  1.008  END

  1.009  EVAL   Increment Test Number

# =====  Sub Fluke 87 V (1 yr) AC Amps VER /5502  ===========================

  2.001  LABEL        AC_AMPS
  2.002  RSLT         =
  2.003  HEAD         {AC AMPS}
  2.004  RSLT         =
  2.005  HEAD         -2{6 A Range}
  2.006  TARGET       -p
  2.007  DISP         Rotate UUT function switch to mA AC.
  2.008  PIC          55xx_8x_high_amps.png
  2.009  5502E        CurrentTerminal = 20A
  2.009  5502E        +Current = 3.000 A; Frequency = 60 Hz
  2.010  TARGET       -m
  2.011  MEMI         Enter UUT reading in amps AC:
  2.012  MEMCX  6     3.000A         1% 0.002U     60Hz

  3.001  HEAD         -2
  3.002  5502E        Standby
  3.003  HEAD
  3.004  END

  3.005  EVAL   Increment Test Number

# =====  Sub Fluke 87 V (1 yr) DC Amps VER /5502  ===========================

  4.001  LABEL        DC_AMPS
  4.002  RSLT         =
  4.003  HEAD         {DC AMPS}
  4.004  RSLT         =
  4.005  HEAD         -2{6 A Range}
  4.006  TARGET       -p
  4.007  DISP         Press yellow button to select A DC.
  4.008  5502E        +Current = 3.000 A; CurrentTerminal = 20A
  4.009  TARGET       -m
  4.010  MEMI         Enter UUT reading in amps DC:
  4.011  MEMCX  6     3.000A         0.2% 0.004U

  5.001  MATH         L[1] = ZCMPI(@ModelNum, "87 V")
  5.002  MATH         L[1] = ZCMPI(@ModelNum, "87 V C")  || L[1]
  5.003  MATH         L[1] = ZCMPI(@ModelNum, "87 V Si") || L[1]
  5.004  MATH         L[1] = ZCMPI(@ModelNum, "87 V Ex") || L[1]

  5.005  IF           L[1]
  5.006  RSLT         =
  5.007  HEAD         -2{10 A Range}
  5.008  TARGET       -p
  5.009  5502E        +Current = 10.00 A; CurrentTerminal = 20A
  5.010  TARGET       -m
  5.011  MEMI         Enter UUT reading in amps DC:
  5.012  MEMCX  10    10.00A         0.2% 0.02U
  6.001  ENDIF

  6.002  HEAD         -2
  6.003  5502E        Standby
  6.004  HEAD
  6.005  END

  6.006  EVAL   Increment Test Number

# =====  Sub Fluke 87 V (1 yr) AC Milliamps VER /5502  =======================

  7.001  LABEL        AC_MILLIAMPS
  7.002  RSLT         =
  7.003  HEAD         {AC MILLIAMPS}
  7.004  RSLT         =
  7.005  HEAD         -2{60 mA Range}
  7.006  TARGET       -p
  7.007  PIC          55xx_8x_low_amps.png
  7.008  DISP         Press the yellow button to select mA/A AC.
  7.009  5502E        CurrentTerminal = Aux
  7.009  5502E        +Current = 33.00 mA; Frequency = 60 Hz
  7.010  TARGET       -m
  7.011  MEMI         Enter UUT reading in Milliamps AC:
  7.012  MEMCX  60    33.00mA        1% 0.02U      60Hz

  8.001  RSLT         =
  8.002  HEAD         -2{400 mA Range}
  8.003  TARGET       -p
  8.004  5502E        CurrentTerminal = Aux
  8.004  5502E        +Current = 330.0 mA; Frequency = 60 Hz
  8.005  TARGET       -m
  8.006  MEMI         Enter UUT reading in Milliamps AC:
  8.007  MEMCX  400   330.0mA        1% 0.2U       60Hz

  9.001  HEAD         -2
  9.002  5502E        Standby
  9.003  HEAD
  9.004  END

  9.005  EVAL   Increment Test Number

# =====  Sub Fluke 87 V (1 yr) DC Milliamps VER /5502  =======================

 10.001  LABEL        DC_MILLIAMPS
 10.002  RSLT         =
 10.003  HEAD         {DC MILLIAMPS}
 10.004  RSLT         =
 10.005  HEAD         -2{60 mA Range}
 10.006  TARGET       -p
 10.007  DISP         Press yellow button to select mA DC.
 10.008  5502E        +Current = 33.00 mA; CurrentTerminal = Aux
 10.009  TARGET       -m
 10.010  MEMI         Enter UUT reading in Milliamps DC:
 10.011  MEMCX  60    33.00mA        0.2% 0.04U

 11.001  RSLT         =
 11.002  HEAD         -2{400 mA Range}
 11.003  TARGET       -p
 11.004  5502E        +Current = 330.0 mA; CurrentTerminal = Aux
 11.005  TARGET       -m
 11.006  MEMI         Enter UUT reading in Milliamps DC:
 11.007  MEMCX  400   330.0mA        0.2% 0.2U

 12.001  HEAD         -2
 12.002  5502E        Standby
 12.003  HEAD
 12.004  END

 12.005  EVAL   Increment Test Number

# =====  Sub Fluke 87 V (1 yr) AC Microamps VER /5502  =======================

 13.001  LABEL        AC_MICROAMPS
 13.002  RSLT         =
 13.003  HEAD         {AC MICROAMPS}
 13.004  RSLT         =
 13.005  HEAD         -2{600 µA Range}
 13.006  TARGET       -p
 13.007  DISP         Rotate UUT function switch to µA AC.
 13.008  5502E        CurrentTerminal = Aux
 13.008  5502E        +Current = 330.0 uA; Frequency = 60 Hz
 13.009  TARGET       -m
 13.010  MEMI         Enter UUT reading in microamps AC:
 13.011  MEMCX  600   330.0uA        1% 0.2U       60Hz

 14.001  RSLT         =
 14.002  HEAD         -2{6000 µA Range}
 14.003  TARGET       -p
 14.004  5502E        CurrentTerminal = Aux
 14.004  5502E        +Current = 3300 uA; Frequency = 60 Hz
 14.005  TARGET       -m
 14.006  MEMI         Enter UUT reading in microamps AC:
 14.007  MEMCX  6000  3300uA         1% 2U         60Hz

 15.001  HEAD         -2
 15.002  5502E        Standby
 15.003  HEAD
 15.004  END

 15.005  EVAL   Increment Test Number

# =====  Sub Fluke 87 V (1 yr) DC Microamps VER /5502  =======================

 16.001  LABEL        DC_MICROAMPS
 16.002  RSLT         =
 16.003  HEAD         {DC MICROAMPS}
 16.004  RSLT         =
 16.005  HEAD         -2{600 µA Range}
 16.006  TARGET       -p
 16.007  DISP         Press yellow button to select µA DC.
 16.008  5502E        +Current = 330.0 uA; CurrentTerminal = Aux
 16.009  TARGET       -m
 16.010  MEMI         Enter UUT reading in microamps DC:
 16.011  MEMCX  600   330.0uA        0.2% 0.4U

 17.001  RSLT         =
 17.002  HEAD         -2{6000 µA Range}
 17.003  TARGET       -p
 17.004  5502E        +Current = 3300 uA; CurrentTerminal = Aux
 17.005  TARGET       -m
 17.006  MEMI         Enter UUT reading in microamps DC:
 17.007  MEMCX  6000  3300uA         0.2% 2U

 18.001  HEAD         -2
 18.002  5502E        Standby
 18.003  DISP         Remove all connections.
 18.004  HEAD
 18.005  END
